/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.autocompleter.ContentSelectorSuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.SimpleEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.JabRefPreferences;

public class SimpleEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private final SimpleEditorViewModel viewModel;

    public SimpleEditor(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, JabRefPreferences preferences) {
        this.viewModel = new SimpleEditorViewModel(fieldName, suggestionProvider, fieldCheckers);
        EditorTextArea textArea = new EditorTextArea();
        HBox.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        textArea.textProperty().bindBidirectional((Property)this.viewModel.textProperty());
        textArea.addToContextMenu(EditorMenus.getDefaultMenu(textArea));
        this.getChildren().add((Object)textArea);
        AutoCompletionTextInputBinding autoCompleter = AutoCompletionTextInputBinding.autoComplete((TextInputControl)textArea, this.viewModel::complete, this.viewModel.getAutoCompletionStrategy());
        if (suggestionProvider instanceof ContentSelectorSuggestionProvider) {
            autoCompleter.setShowOnFocus(true);
        }
        new EditorValidator(preferences).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), textArea);
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

