/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic;

import java.util.Objects;
import java.util.Optional;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;
import org.jabref.model.strings.StringUtil;

public class TypedBibEntry {
    private final BibEntry entry;
    private final Optional<BibDatabase> database;
    private final BibDatabaseMode mode;

    public TypedBibEntry(BibEntry entry, BibDatabaseMode mode) {
        this(entry, Optional.empty(), mode);
    }

    private TypedBibEntry(BibEntry entry, Optional<BibDatabase> database, BibDatabaseMode mode) {
        this.entry = Objects.requireNonNull(entry);
        this.database = Objects.requireNonNull(database);
        this.mode = mode;
    }

    public TypedBibEntry(BibEntry entry, BibDatabaseContext databaseContext) {
        this(entry, Optional.of(databaseContext.getDatabase()), databaseContext.getMode());
    }

    public boolean hasAllRequiredFields() {
        Optional<EntryType> type = EntryTypes.getType(this.entry.getType(), this.mode);
        if (type.isPresent()) {
            return this.entry.allFieldsPresent(type.get().getRequiredFields(), this.database.orElse(null));
        }
        return true;
    }

    public String getTypeForDisplay() {
        Optional<EntryType> entryType = EntryTypes.getType(this.entry.getType(), this.mode);
        if (entryType.isPresent()) {
            return entryType.get().getName();
        }
        return StringUtil.capitalizeFirst(this.entry.getType());
    }
}

