/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.bibtex.DuplicateCheck;
import org.jabref.logic.bibtex.comparator.BibEntryDiff;
import org.jabref.logic.bibtex.comparator.BibStringDiff;
import org.jabref.logic.bibtex.comparator.EntryComparator;
import org.jabref.logic.bibtex.comparator.MetaDataDiff;
import org.jabref.logic.bibtex.comparator.PreambleDiff;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public class BibDatabaseDiff {
    private static final double MATCH_THRESHOLD = 0.4;
    private final Optional<MetaDataDiff> metaDataDiff;
    private final Optional<PreambleDiff> preambleDiff;
    private final List<BibStringDiff> bibStringDiffs;
    private final List<BibEntryDiff> entryDiffs;

    private BibDatabaseDiff(BibDatabaseContext originalDatabase, BibDatabaseContext newDatabase) {
        this.metaDataDiff = MetaDataDiff.compare(originalDatabase.getMetaData(), newDatabase.getMetaData());
        this.preambleDiff = PreambleDiff.compare(originalDatabase, newDatabase);
        this.bibStringDiffs = BibStringDiff.compare(originalDatabase.getDatabase(), newDatabase.getDatabase());
        EntryComparator comparator = BibDatabaseDiff.getEntryComparator();
        List<BibEntry> originalEntriesSorted = originalDatabase.getDatabase().getEntriesSorted(comparator);
        List<BibEntry> newEntriesSorted = newDatabase.getDatabase().getEntriesSorted(comparator);
        this.entryDiffs = BibDatabaseDiff.compareEntries(originalEntriesSorted, newEntriesSorted);
    }

    private static EntryComparator getEntryComparator() {
        EntryComparator comparator = new EntryComparator(false, true, "title");
        comparator = new EntryComparator(false, true, "author", comparator);
        comparator = new EntryComparator(false, true, "year", comparator);
        return comparator;
    }

    private static List<BibEntryDiff> compareEntries(List<BibEntry> originalEntries, List<BibEntry> newEntries) {
        ArrayList<BibEntryDiff> differences = new ArrayList<BibEntryDiff>();
        int positionNew = 0;
        HashSet<Integer> used = new HashSet<Integer>(newEntries.size());
        HashSet<BibEntry> notMatched = new HashSet<BibEntry>(originalEntries.size());
        block0: for (BibEntry originalEntry : originalEntries) {
            double score;
            if (!used.contains(positionNew) && positionNew < newEntries.size() && (score = DuplicateCheck.compareEntriesStrictly(originalEntry, newEntries.get(positionNew))) > 1.0) {
                used.add(positionNew);
                ++positionNew;
                continue;
            }
            for (int i = positionNew + 1; i < newEntries.size(); ++i) {
                double score2;
                if (used.contains(i) || !((score2 = DuplicateCheck.compareEntriesStrictly(originalEntry, newEntries.get(i))) > 1.0)) continue;
                used.add(i);
                continue block0;
            }
            notMatched.add(originalEntry);
        }
        Iterator iteratorNotMatched = notMatched.iterator();
        while (iteratorNotMatched.hasNext()) {
            BibEntry originalEntry;
            originalEntry = (BibEntry)iteratorNotMatched.next();
            double bestMatch = 0.0;
            int bestMatchIndex = -1;
            if (positionNew < newEntries.size() - 1) {
                for (int i = positionNew; i < newEntries.size(); ++i) {
                    double score;
                    if (used.contains(i) || !((score = DuplicateCheck.compareEntriesStrictly(originalEntry, newEntries.get(i))) > bestMatch)) continue;
                    bestMatch = score;
                    bestMatchIndex = i;
                }
            }
            if (bestMatch > 0.4) {
                used.add(bestMatchIndex);
                iteratorNotMatched.remove();
                differences.add(new BibEntryDiff(originalEntry, newEntries.get(bestMatchIndex)));
                continue;
            }
            differences.add(new BibEntryDiff(originalEntry, null));
        }
        for (int i = 0; i < newEntries.size(); ++i) {
            if (used.contains(i)) continue;
            differences.add(new BibEntryDiff(null, newEntries.get(i)));
        }
        return differences;
    }

    public static BibDatabaseDiff compare(BibDatabaseContext base, BibDatabaseContext changed) {
        return new BibDatabaseDiff(base, changed);
    }

    public Optional<MetaDataDiff> getMetaDataDifferences() {
        return this.metaDataDiff;
    }

    public Optional<PreambleDiff> getPreambleDifferences() {
        return this.preambleDiff;
    }

    public List<BibStringDiff> getBibStringDifferences() {
        return this.bibStringDiffs;
    }

    public List<BibEntryDiff> getEntryDifferences() {
        return this.entryDiffs;
    }
}

