/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.FileSaveSession;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.VerifyingWriter;
import org.jabref.logic.msbib.MSBibDatabase;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

class MSBibExporter
extends Exporter {
    public MSBibExporter() {
        super("MSBib", "MS Office 2007", StandardFileType.XML);
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, Charset encoding, List<BibEntry> entries) throws SaveException {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        FileSaveSession session = new FileSaveSession(StandardCharsets.UTF_8, false);
        MSBibDatabase msBibDatabase = new MSBibDatabase(databaseContext.getDatabase(), entries);
        try (VerifyingWriter ps = session.getWriter();){
            try {
                DOMSource source = new DOMSource(msBibDatabase.getDomForExport());
                StreamResult result = new StreamResult(ps);
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.transform(source, result);
            }
            catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError e) {
                throw new SaveException(e);
            }
            session.finalize(file);
        }
        catch (IOException ex) {
            throw new SaveException(ex);
        }
    }
}

