/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.model.entry.BibEntry;
import org.jsoup.helper.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IdBasedParserFetcher
extends IdBasedFetcher {
    public static final Logger LOGGER = LoggerFactory.getLogger(IdBasedParserFetcher.class);

    public URL getURLForID(String var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    default public void doPostCleanup(BibEntry entry) {
    }

    @Override
    default public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        if (StringUtil.isBlank(identifier)) {
            return Optional.empty();
        }
        try {
            HttpResponse<String> response = Unirest.get(this.getURLForID(identifier).toString()).asString();
            List<BibEntry> fetchedEntries = this.getParser().parseEntries(new ByteArrayInputStream(response.getBody().getBytes(StandardCharsets.UTF_8)));
            if (fetchedEntries.isEmpty()) {
                return Optional.empty();
            }
            if (fetchedEntries.size() > 1) {
                LOGGER.info("Fetcher " + this.getName() + "found more than one result for identifier " + identifier + ". We will use the first entry.");
            }
            BibEntry entry = fetchedEntries.get(0);
            this.doPostCleanup(entry);
            return Optional.of(entry);
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("An I/O exception occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
        catch (UnirestException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

