/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.DOI;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACS
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACS.class);
    private static final String SOURCE = "https://pubs.acs.org/doi/abs/%s";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String source;
        Document html;
        Element link;
        Objects.requireNonNull(entry);
        Optional<URL> pdfLink = Optional.empty();
        Optional doi = entry.getField("doi").flatMap(DOI::parse);
        if (doi.isPresent() && (link = (html = Jsoup.connect(source = String.format(SOURCE, ((DOI)doi.get()).getDOI())).ignoreHttpErrors(true).get()).select(".pdf-high-res a").first()) != null) {
            LOGGER.info("Fulltext PDF found @ ACS.");
            pdfLink = Optional.of(new URL(source.replaceFirst("/abs/", "/pdf/")));
        }
        return pdfLink;
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }
}

