/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class ASCIICharacterChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        for (Map.Entry<String, String> field2 : entry.getFieldMap().entrySet()) {
            boolean asciiOnly = CharMatcher.ascii().matchesAllOf(field2.getValue());
            if (asciiOnly) continue;
            results.add(new IntegrityMessage(Localization.lang("Non-ASCII encoded character found", new String[0]), entry, field2.getKey()));
        }
        return results;
    }
}

