/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.l10n;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class Languages {
    public static final Map<String, String> LANGUAGES = new TreeMap<String, String>();

    private Languages() {
    }

    public static Optional<Locale> convertToSupportedLocale(String language2) {
        Objects.requireNonNull(language2);
        if (!LANGUAGES.values().contains(language2)) {
            return Optional.empty();
        }
        String[] languageParts = language2.split("_");
        Locale locale = languageParts.length == 1 ? new Locale(languageParts[0]) : (languageParts.length == 2 ? new Locale(languageParts[0], languageParts[1]) : Locale.ENGLISH);
        return Optional.of(locale);
    }

    static {
        LANGUAGES.put("Bahasa Indonesia", "in");
        LANGUAGES.put("Brazilian Portuguese", "pt_BR");
        LANGUAGES.put("Dansk", "da");
        LANGUAGES.put("Deutsch", "de");
        LANGUAGES.put("English", "en");
        LANGUAGES.put("Espa\u00f1ol", "es");
        LANGUAGES.put("Fran\u00e7ais", "fr");
        LANGUAGES.put("Italiano", "it");
        LANGUAGES.put("Japanese", "ja");
        LANGUAGES.put("Nederlands", "nl");
        LANGUAGES.put("Norsk", "no");
        LANGUAGES.put("Persian (\u0641\u0627\u0631\u0633\u06cc)", "fa");
        LANGUAGES.put("Russian", "ru");
        LANGUAGES.put("Simplified Chinese", "zh");
        LANGUAGES.put("Svenska", "sv");
        LANGUAGES.put("Turkish", "tr");
        LANGUAGES.put("Vietnamese", "vi");
        LANGUAGES.put("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "el");
        LANGUAGES.put("Tagalog/Filipino", "tl");
    }
}

