/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.util.Map;
import java.util.Objects;
import org.jabref.gui.search.SearchDisplayMode;
import org.jabref.preferences.JabRefPreferences;

public class SearchPreferences {
    private static final String SEARCH_GLOBAL = "searchGlobal";
    private static final String SEARCH_DISPLAY_MODE = "searchDisplayMode";
    private static final String SEARCH_CASE_SENSITIVE = "caseSensitiveSearch";
    private static final String SEARCH_REG_EXP = "regExpSearch";
    private static final String SEARCH_DIALOG_HEIGHT = "searchDialogHeight";
    private static final String SEARCH_DIALOG_WIDTH = "searchDialogWidth";
    private static final String SEARCH_DIALOG_POS_X = "searchDialogPosX";
    private static final String SEARCH_DIALOG_POS_Y = "searchDialogPosY";
    private final JabRefPreferences preferences;

    public SearchPreferences(JabRefPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    public static void putDefaults(Map<String, Object> defaults) {
        defaults.put(SEARCH_GLOBAL, Boolean.FALSE);
        defaults.put(SEARCH_DISPLAY_MODE, SearchDisplayMode.FILTER.toString());
        defaults.put(SEARCH_CASE_SENSITIVE, Boolean.FALSE);
        defaults.put(SEARCH_REG_EXP, Boolean.FALSE);
        defaults.put(SEARCH_DIALOG_WIDTH, 650);
        defaults.put(SEARCH_DIALOG_HEIGHT, 500);
        defaults.put(SEARCH_DIALOG_POS_X, 0);
        defaults.put(SEARCH_DIALOG_POS_Y, 0);
    }

    public boolean isGlobalSearch() {
        return this.preferences.getBoolean(SEARCH_GLOBAL);
    }

    public SearchPreferences setGlobalSearch(boolean isGlobalSearch) {
        this.preferences.putBoolean(SEARCH_GLOBAL, isGlobalSearch);
        return this;
    }

    public SearchDisplayMode getSearchMode() {
        try {
            return SearchDisplayMode.valueOf(this.preferences.get(SEARCH_DISPLAY_MODE));
        }
        catch (IllegalArgumentException ex) {
            return SearchDisplayMode.valueOf((String)this.preferences.defaults.get(SEARCH_DISPLAY_MODE));
        }
    }

    public SearchPreferences setSearchMode(SearchDisplayMode searchDisplayMode) {
        this.preferences.put(SEARCH_DISPLAY_MODE, Objects.requireNonNull(searchDisplayMode).toString());
        return this;
    }

    public boolean isCaseSensitive() {
        return this.preferences.getBoolean(SEARCH_CASE_SENSITIVE);
    }

    public SearchPreferences setCaseSensitive(boolean isCaseSensitive) {
        this.preferences.putBoolean(SEARCH_CASE_SENSITIVE, isCaseSensitive);
        return this;
    }

    public boolean isRegularExpression() {
        return this.preferences.getBoolean(SEARCH_REG_EXP);
    }

    public SearchPreferences setRegularExpression(boolean isRegularExpression) {
        this.preferences.putBoolean(SEARCH_REG_EXP, isRegularExpression);
        return this;
    }

    public int getSeachDialogWidth() {
        return this.preferences.getInt(SEARCH_DIALOG_WIDTH);
    }

    public SearchPreferences setSearchDialogWidth(int width) {
        this.preferences.putInt(SEARCH_DIALOG_WIDTH, width);
        return this;
    }

    public int getSeachDialogHeight() {
        return this.preferences.getInt(SEARCH_DIALOG_HEIGHT);
    }

    public SearchPreferences setSearchDialogHeight(int height) {
        this.preferences.putInt(SEARCH_DIALOG_HEIGHT, height);
        return this;
    }

    public int getSearchDialogPosX() {
        return this.preferences.getInt(SEARCH_DIALOG_POS_X);
    }

    public SearchPreferences setSearchDialogPosX(int x) {
        this.preferences.putInt(SEARCH_DIALOG_POS_X, x);
        return this;
    }

    public int getSearchDialogPosY() {
        return this.preferences.getInt(SEARCH_DIALOG_POS_Y);
    }

    public SearchPreferences setSearchDialogPosY(int y) {
        this.preferences.putInt(SEARCH_DIALOG_POS_Y, y);
        return this;
    }
}

