/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.Collections;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAssert
extends GroupAssert<Collection<?>> {
    protected CollectionAssert(Collection<?> actual) {
        super(actual);
    }

    public CollectionAssert contains(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Collection<Object> notFound = this.notFoundInActual(objects);
        if (notFound.isEmpty()) {
            return this;
        }
        throw this.failureIfExpectedElementsNotFound(notFound);
    }

    private Collection<Object> notFoundInActual(Object ... objects) {
        return Collections.notFound((Collection)this.actual, objects);
    }

    public CollectionAssert containsOnly(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        ArrayList<Object> copy = new ArrayList<Object>((Collection)this.actual);
        List<Object> notFound = this.notFoundInCopy(copy, objects);
        if (!notFound.isEmpty()) {
            throw this.failureIfExpectedElementsNotFound(notFound);
        }
        if (copy.isEmpty()) {
            return this;
        }
        throw this.failureIfUnexpectedElementsFound(copy);
    }

    private List<Object> notFoundInCopy(List<Object> copy, Object ... objects) {
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object o : objects) {
            if (!copy.contains(o)) {
                notFound.add(o);
                continue;
            }
            copy.remove(o);
        }
        return notFound;
    }

    private AssertionError failureIfExpectedElementsNotFound(Collection<Object> notFound) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat((Object[])new Object[]{"collection:", this.format((Collection)this.actual), " does not contain element(s):", this.format(notFound)}));
    }

    private AssertionError failureIfUnexpectedElementsFound(List<Object> unexpected) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat((Object[])new Object[]{"unexpected element(s):", this.format(unexpected), " in collection:", this.format((Collection)this.actual)}));
    }

    public CollectionAssert excludes(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Collection<Object> found = Collections.found((Collection)this.actual, objects);
        if (found.isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"collection:", this.format((Collection)this.actual), " does not exclude element(s):", this.format(found)}));
    }

    private void validateIsNotNull(Object[] objects) {
        if (objects == null) {
            throw new NullPointerException(this.formattedErrorMessage("the given array of objects should not be null"));
        }
    }

    public CollectionAssert doesNotHaveDuplicates() {
        this.isNotNull();
        Collection duplicates = org.fest.util.Collections.duplicatesFrom((Collection)((Collection)this.actual));
        if (duplicates.isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"collection:", this.format((Collection)this.actual), " contains duplicate(s):", this.format(duplicates)}));
    }

    private String format(Collection<?> c) {
        return Formatting.inBrackets(c);
    }

    public CollectionAssert as(String description) {
        this.description(description);
        return this;
    }

    public CollectionAssert describedAs(String description) {
        return this.as(description);
    }

    public CollectionAssert as(Description description) {
        this.description(description);
        return this;
    }

    public CollectionAssert describedAs(Description description) {
        return this.as(description);
    }

    public CollectionAssert satisfies(Condition<Collection<?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public CollectionAssert doesNotSatisfy(Condition<Collection<?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public CollectionAssert is(Condition<Collection<?>> condition) {
        this.assertIs(condition);
        return this;
    }

    public CollectionAssert isNot(Condition<Collection<?>> condition) {
        this.assertIsNot(condition);
        return this;
    }

    @Override
    public void isNullOrEmpty() {
        if (org.fest.util.Collections.isEmpty((Collection)((Collection)this.actual))) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty collection, but was:", this.format((Collection)this.actual)}));
    }

    public CollectionAssert isNotNull() {
        if (this.actual != null) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure("expecting a non-null collection, but it was null");
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (org.fest.util.Collections.isEmpty((Collection)((Collection)this.actual))) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting empty collection, but was:", this.format((Collection)this.actual)}));
    }

    public CollectionAssert isNotEmpty() {
        this.isNotNull();
        if (!((Collection)this.actual).isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure("expecting a non-empty collection, but it was empty");
    }

    public CollectionAssert hasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for collection:", this.format((Collection)this.actual)}));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Collection)this.actual).size();
    }

    public CollectionAssert isEqualTo(Collection<?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public CollectionAssert isNotEqualTo(Collection<?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public CollectionAssert isSameAs(Collection<?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public CollectionAssert isNotSameAs(Collection<?> other) {
        this.assertNotSameAs(other);
        return this;
    }

    public CollectionAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

