// Copyright (C) 2024, The Duplicati Team
// https://duplicati.com, hello@duplicati.com
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in 
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
namespace Duplicati.WebserverCore.Abstractions;

/// <summary>
/// Interface for remote control support
/// </summary>
public interface IRemoteController
{
    /// <summary>
    /// If the remote controller is enabled
    /// </summary>
    public bool IsEnabled { get; }
    /// <summary>
    /// If the remote controller can be enabled
    /// </summary>
    public bool CanEnable { get; }
    /// <summary>
    /// If the remote controller is connected
    /// </summary>
    public bool Connected { get; }

    /// <summary>
    /// Enable the remote controller
    /// </summary>
    public void Enable();

    /// <summary>
    /// Disable the remote controller
    /// </summary>
    public void Disable();

    /// <summary>
    /// Fully removes the remote registration information
    /// </summary>
    public void DeleteRegistration();

}
