/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.JavapPrinter;
import fpc.tools.javapp.MethodData;
import java.io.DataInputStream;
import java.io.IOException;

class StackMapData {
    final int offset;
    final int[] locals;
    final int[] stack;

    StackMapData(int offset, int[] locals, int[] stack) {
        this.offset = offset;
        this.locals = locals;
        this.stack = stack;
    }

    StackMapData(DataInputStream in, MethodData method) throws IOException {
        this.offset = in.readUnsignedShort();
        int local_size = in.readUnsignedShort();
        this.locals = StackMapData.readTypeArray(in, local_size, method);
        int stack_size = in.readUnsignedShort();
        this.stack = StackMapData.readTypeArray(in, stack_size, method);
    }

    static final int[] readTypeArray(DataInputStream in, int length, MethodData method) throws IOException {
        int[] types = new int[length];
        int i = 0;
        while (i < length) {
            types[i] = StackMapData.readType(in, method);
            ++i;
        }
        return types;
    }

    static final int readType(DataInputStream in, MethodData method) throws IOException {
        int type = in.readUnsignedByte();
        if (type == 7 || type == 8) {
            type |= in.readUnsignedShort() << 8;
        }
        return type;
    }

    void print(JavapPrinter p) {
        p.out.println("   " + this.offset + ":");
        p.printMap("    locals = [", this.locals);
        p.printMap("    stack = [", this.stack);
    }
}

