/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.autoupdate.ui.wizards.CustomHandleStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallableIteratorBase;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionStep;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class UninstallUnitWizardIterator
extends InstallableIteratorBase
implements ChangeListener {
    private UninstallUnitWizardModel uninstallModel;
    private OperationDescriptionStep descStep;
    private boolean installAdded;

    public UninstallUnitWizardIterator(UninstallUnitWizardModel uninstallUnitWizardModel) {
        super(uninstallUnitWizardModel.createInstallModel(), false, false, false);
        this.uninstallModel = uninstallUnitWizardModel;
        this.createPanels();
        this.index = 0;
    }

    private void createPanels() {
        assert (this.panels != null && this.panels.isEmpty()) : "Panels are still empty";
        this.descStep = new OperationDescriptionStep(this.uninstallModel);
        this.panels.add(this.descStep);
        if (this.uninstallModel.hasCustomComponents()) {
            this.panels.add(new CustomHandleStep(this.uninstallModel));
        }
        this.panels.add(new UninstallStep(this.uninstallModel));
        this.descStep.addChangeListener(this);
    }

    @Override
    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return (WizardDescriptor.Panel)this.panels.get(this.index);
    }

    @Override
    public void nextPanel() {
        if (this.current() instanceof InstallStep) {
            this.index = 0;
            this.descStep.reset();
            this.removeInstallPanels();
        } else {
            super.nextPanel();
        }
    }

    public String name() {
        return NbBundle.getMessage(UninstallUnitWizard.class, (String)"UninstallUnitWizard_Title");
    }

    @Override
    public boolean hasPrevious() {
        if (this.current() instanceof UninstallStep) {
            return false;
        }
        if (this.current() instanceof InstallStep) {
            return false;
        }
        return super.hasPrevious();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() != this.descStep) {
            return;
        }
        if (this.uninstallModel.hasComponentsToInstall() && !this.installAdded) {
            this.installAdded = true;
            this.insertPanels(1);
        }
    }

    @Override
    protected void compactPanels() {
        if (this.index == 0) {
            super.compactPanels();
        }
    }
}

