/*
    icddump.c ver 0.2, Copyright 2001 (c) Geir Thomassen, geirt@powertech.no

    This program was written to reverse engineer the protocol used by
    the Microchip ICD.


    USAGE:
        Connect /dev/ttyS0 to the ICD, and /dev/ttyS1 a windows PC with MPLAB
	icd software running trough a null cable.

	do a "setserial /dev/ttyS0 low_latency" and ditto on /dev/ttyS1 before
	running this program.

        The program polls the control lines (RTS/CTS and DTR/DSR) continuously,
	making the load rice to 100% when running.
 
	This program is written as a quick hack, and was never intended to be a
	production quality program.

	I learned a lot about the linux serial driver by writing this ...
 */

#include <stdlib.h>
#include <sys/ioctl.h>

#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>

#define DEVICE1 "/dev/ttyS0"
#define DEVICE2 "/dev/ttyS1"

#define BAUDRATE B57600 /* B19200 is also ok .... */
#define BUF_SIZE 15

void icd_decode(char *data, int n, int dir)
{

/*
     This function is crap, but the rest of the program is, well ok ..
 */

	static char cmd[1000], resp[1000];
	static int n_cmd=0, n_resp=0;
	static int last_dir=1;
	int cmd_no;
	char *p;

	if((last_dir==0) && (dir==1)) {
		n_cmd = n_resp = 0;
		printf("--------------------------------------\n");
	}

	if(dir) {
		while(n--) {
			cmd[n_cmd++] = *data++;
		}
		cmd[n_cmd] = 0;
	} else {
		while(n--) {
			resp[n_resp++] = *data++;
		}
		resp[n_resp] = 0;
	}

	if(dir) {
		if(n_cmd) {
			if(cmd[0] == 'U') {
				printf("Speed negotiation\n");
			} else {
				p = cmd;
				while(*p == '$')
					p++;
				
				if(sscanf(p,"%04X",&cmd_no)==1) {
					switch(cmd_no) {
					case 0x7000:
						printf("Start memory read (0x7000), enable Vpp ???\n");
						break;
					case 0x7001:
						printf("Reset device (0x7001), disable Vpp ????\n");
						break;
					case 0x7002:
						printf("Read and increment (0x7002)\n");
						break;
					case 0x7003:
						printf("Increment address (0x7003)\n");
						break;
					case 0x7005:
						printf("Set start address for flash memory (0x7005) ???\n");
						break;
					case 0x7006:
						printf("Set start address for EEPROM(0x7006) ???\n");
						break;
					case 0x7007:
						printf("Erase (0x7007)\n");
						break;
					case 0x7F00:
						printf("Get sw version (0x7F00)\n");
						break;
					case 0x7021:
						printf("Get sw version, minor (0x7021)\n");
						break;
					case 0x701C:
						printf("Get Vdd (0x701C), Vdd = resp / 40 \n");
						break;
					case 0x701D:
						printf("Get Vpp (0x701D), Vpp = resp / 11.25\n");
						break;
					case 0x7020:
						printf("Read device ID word ... (0x7020)\n");
						printf("0x3ff=none, 0x9a4=16F877, 0x964=16F873\n");
						break;
					default:

						if(cmd_no & 0x8000) {
							printf("Word to program ....\n");
						} else if(cmd_no & 0x4000) {
							printf("Command no %04X\n",cmd_no);
						} else {
							printf("DATA ...\n");
						}
						break;
					}
				}
			}
		}
	}

	last_dir = dir;
}

void print_data(char *data, int n, int dir)
{
/*
        data = pointer to data on serial line
	n = number of char in data
	dir = direction (0 or 1)
 */

	int i;


	icd_decode(data, n, dir);

	fputs((dir) ? "-> " : "<- ", stdout);
	
	for (i = 0; i < n; i++) {
		printf("%02X ", data[i] & 0xFF);
	}
	
	for (; i < BUF_SIZE + 2; i++) {
		fputs("   ",stdout);
	}
	
	for (i = 0; i < n; i++) {
		printf("%c", isprint(data[i]) ? data[i] : '.');
	}
       
	putchar('\n');
}

int main()
{
	int fd1, fd2;
	struct termios oldtio1, newtio1, oldtio2, newtio2;
	int mcr, mcr1, mcr2;
	int n_read;
	char buffer[BUF_SIZE];

	printf("icddump ver 0.2\n");

	printf("line 1: %s - connected to the ICD\n", DEVICE1);
	printf("line 2: %s - connected to a Windows PC with MPLAB with a null modem cable\n", DEVICE2);

	fd1 = open(DEVICE1, O_RDWR | O_NOCTTY | O_NONBLOCK);
	fd2 = open(DEVICE2, O_RDWR | O_NOCTTY | O_NONBLOCK);

	if ((fd1 < 0) || (fd2 < 0)) {
		perror("open:");
		exit(-1);
	}

	tcgetattr(fd1, &oldtio1);
	tcgetattr(fd2, &oldtio2);

	bzero(&newtio1, sizeof(newtio1));
	bzero(&newtio2, sizeof(newtio2));

	newtio1.c_cflag = newtio2.c_cflag = BAUDRATE | CS8 | CLOCAL | CREAD;
	newtio1.c_iflag = newtio2.c_iflag = IGNPAR;
	newtio1.c_oflag = newtio2.c_oflag = 0;
	newtio1.c_lflag = newtio2.c_lflag = 0;
	newtio1.c_cc[VTIME] = newtio2.c_cc[VTIME] = 0;
	newtio1.c_cc[VMIN] = newtio2.c_cc[VMIN] = 0;

	tcflush(fd1, TCIFLUSH);
	tcflush(fd2, TCIFLUSH);

	tcsetattr(fd1, TCSANOW, &newtio1);
	tcsetattr(fd2, TCSANOW, &newtio2);

	/* now the ports are configured, do the interesting stuff ...  */

	mcr1 = mcr2 = -1;

	while (1) {  /* cpu hog ... */
		/* read the mcr (modem control register), we need the status of cts and dsr */
		ioctl(fd1, TIOCMGET,  &mcr);

		if(mcr != mcr1) {  /* has cts or dsr  changed ? */
			mcr1 = mcr;
#if 0                   /* for some obscure reason (timing ?) I can't get this code to work .... */
			mcr &= ~(TIOCM_RTS | TIOCM_DSR);
			mcr |= ((mcr1 & TIOCM_CTS) ? TIOCM_RTS : 0) | ((mcr1 & TIOCM_DSR) ? TIOCM_DTR : 0);
			ioctl(fd2, TIOCMSET, &mcr);
#else			/* .... doing it with two ioctls instead */

			/* set rts = cts */
			mcr = TIOCM_RTS;
			ioctl(fd2, (mcr1 & TIOCM_CTS) ? TIOCMBIS : TIOCMBIC, &mcr);

			/* ... and dtr = dsr */
			mcr = TIOCM_DTR;
			ioctl(fd2, (mcr1 & TIOCM_DSR) ? TIOCMBIS : TIOCMBIC, &mcr);
#endif
		}

		/* now copy the data */
		if ((n_read = read(fd1, buffer, sizeof(buffer))) > 0) {
			write(fd2, buffer, n_read);
			print_data(buffer, n_read, 0);
		}

		/*
		  That was one direction, now do the same thing, but for ttyS1 -> ttyS0
		  Xeroxing the above code, but swapping fd1/fd2 and mcr1/mcr2
		*/

		ioctl(fd2, TIOCMGET,  &mcr);
		
		if(mcr != mcr2) {
			mcr2 = mcr;
			
			mcr = TIOCM_RTS;
			ioctl(fd1, (mcr2 & TIOCM_CTS) ? TIOCMBIS : TIOCMBIC, &mcr);
			
			mcr = TIOCM_DTR;
			ioctl(fd1, (mcr2 & TIOCM_DSR) ? TIOCMBIS : TIOCMBIC, &mcr);
		}
		
		if ((n_read = read(fd2, buffer, sizeof(buffer))) > 0) {
			write(fd1, buffer, n_read);
			print_data(buffer, n_read, 1);
		}
	}
	
	/* Restore ttys, never gets here (yes, this is a quick hack) */
	tcsetattr(fd1, TCSANOW, &oldtio1);
	tcsetattr(fd2, TCSANOW, &oldtio2);
	close(fd1);
	close(fd2);
	return 0;
}
