/***************************************************************************
                          igmp.h  -  For IGMP
                             -------------------
    begin                : Wed Dec 19 2001
    copyright            : (C) 2001 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _IGMP_H
#define _IGMP_H

#ifndef _NETINET_IN_H
#include <netinet/in.h>
#endif

#include "wand.h"

 /* IGMP types */
#define IGMP_MEM_QUERY              0x11	/* membership query         */
#define IGMP_V1_MEM_REP  	    0x12	/* Ver. 1 membership report */
#define IGMP_MRESP                  0x1e        /* membership response */
#define IGMP_MTRACE                 0x1f        /* member trace */
#define IGMP_V1_PIM                 0x14  /* protocol independant multicast */
#define IGMP_DVMRP                  0x13  /* Distance Vector Multicast routing protocol */
#define IGMP_V2_MEM_REP	            0x16	/* Ver. 2 membership report */
/*
   on a leave group if last host, v2, should send to group add. 224.0.0.2
   all routers multicast group
*/
#define IGMP_V2_LEAVE_GROUP         0x17	/* Leave-group message	    */
#define IGMP_V3_MEM_REP             0x22        /* Ver. 3 membership report */

#define IGMP_ROUTER_ADV             0x24  /* router advertisement */
#define IGMP_ROUTER_SOL             0x25  /* router solicitation */
#define IGMP_ROUTER_TER             0x26  /* router termination */


/* IGMP Subcodes */
/* DVRMP */
#define D_PROBE        1
#define D_REPORT       2
#define D_ASK_NEIGH    3
#define D_NEIGH        4
#define D_ASK_NEIGH2   5
#define D_NEIGH_V1     6
#define D_PRUNE        7
#define D_GRAFT        8
#define D_GRAFT_ACK    9

/* PIM(Protocol Independant Multicast */
#define P_REG          1
#define P_REG_STOP     2
#define P_JOIN         3
#define P_REACH        4
#define P_ASSERT       5
#define P_GRAFT        6
#define P_GRAFT_ACK    7
#define P_MODE         8


/* for IGMP packets */
struct igmp{


/*
   IGMP Version 1

                  32bits
                  |
    --------------------------------
    4b   4b     8bits       16bits
    |    |      |           |
   ++++ ++++ ++++++++ ++++++++++++++++
   |*V | *T | unused |  Checksum      |
     ++++++++++++++++++++++++++++++++
   |          Group Address           |
   ------------------------------------

   *V - Version set to 1
   *T - Type


   IGMP Version 2 is backwards compatible with version 1
   IP Header should have Router Alert Set in options and TTL set to 1(RFC 2236)
   is not required but Also Type-Of-Service is set to Internetwork Traffic 0xc0 - 1100b
   IGMP V2 Header
                  32bits
                   |
    --------------------------------
        8bits   8bits       16bits
        |       |            |
   |++++++++ ++++++++ ++++++++++++++++|
   |Type    |  *MRT  | Checksum       |
     ++++++++++++++++++++++++++++++++
   |          Group Address           |
    --------------------------------

   *MRT = Max Response Time
*/


  unsigned char type; /* type */
  union {
     unsigned char mrt; /* max response time only for queries */
     unsigned char code; /* routing code for PIM & DVRMP */
  }multi;
  unsigned short cksum; /* checksum */
  struct in_addr group; /* group address */

};

/* IGMP header size */
#define S_IGMP    sizeof(struct igmp)

#ifdef  _CON_

int get_igmp_arg(char *arg, char *next_arg, struct igmp *eyeg);

#endif /* _CON_ */

#ifdef _GTK_
void igmp_spell(void);
void igmp_defaults(void);
void clear_igmp(void);
#endif /* _GTK_ */

#endif /* _IGMP_H */
