/*
 * Decompiled with CFR 0.152.
 */
import org.w3c.dom.Node;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDump {
    private static final String FEATURE_URI = "http://xml.org/sax/features/";
    private static final String PROPERTY_URI = "http://xml.org/sax/properties/";

    private SAXDump() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"com.jclark.xml.sax.SAX2Driver", "gnu.xml.aelfred2.SAXDriver", "gnu.xml.aelfred2.XmlReader", "gnu.xml.util.DomParser", "oracle.xml.parser.v2.SAXParser", "org.apache.crimson.parser.XMLReaderImpl", "org.apache.xerces.parsers.SAXParser"};
        }
        int n = 0;
        while (n < stringArray.length) {
            SAXDump.checkParser(stringArray[n]);
            ++n;
        }
    }

    private static void checkFeature(String string, XMLReader xMLReader) {
        block10: {
            int n = 0;
            try {
                int n2 = 35 - string.length();
                while (n2 > 0) {
                    System.out.print(' ');
                    --n2;
                }
                System.out.print(string);
                System.out.print(":  ");
                string = FEATURE_URI + string;
                boolean bl = xMLReader.getFeature(string);
                System.out.print(bl);
                System.out.print(", ");
                n = 1;
                xMLReader.setFeature(string, bl);
                n = 2;
                xMLReader.setFeature(string, !bl);
                System.out.println("read and write");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                switch (n) {
                    case 0: {
                        System.out.println("(can't read now)");
                        break;
                    }
                    case 1: {
                        System.out.println("bogus_1");
                        break;
                    }
                    case 2: {
                        System.out.println("readonly");
                    }
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (n == 0) {
                    System.out.println("(unrecognized)");
                    break block10;
                }
                System.out.println("bogus_2");
            }
        }
    }

    private static void showFeatures(XMLReader xMLReader) {
        System.out.println("FEATURES for " + xMLReader.getClass().getName());
        SAXDump.checkFeature("namespace-prefixes", xMLReader);
        SAXDump.checkFeature("namespaces", xMLReader);
        SAXDump.checkFeature("external-general-entities", xMLReader);
        SAXDump.checkFeature("external-parameter-entities", xMLReader);
        SAXDump.checkFeature("is-standalone", xMLReader);
        SAXDump.checkFeature("lexical-handler/parameter-entities", xMLReader);
        SAXDump.checkFeature("resolve-dtd-uris", xMLReader);
        SAXDump.checkFeature("string-interning", xMLReader);
        SAXDump.checkFeature("use-attributes2", xMLReader);
        SAXDump.checkFeature("use-locator2", xMLReader);
        SAXDump.checkFeature("validation", xMLReader);
    }

    private static void checkProperty(String string, XMLReader xMLReader, Object object) {
        block10: {
            int n = 0;
            try {
                int n2 = 20 - string.length();
                while (n2 > 0) {
                    System.out.print(' ');
                    --n2;
                }
                System.out.print(string);
                System.out.print(":  ");
                string = PROPERTY_URI + string;
                Object object2 = xMLReader.getProperty(string);
                System.out.print(object2);
                System.out.print(", ");
                n = 1;
                xMLReader.setProperty(string, object2);
                n = 2;
                xMLReader.setProperty(string, object);
                System.out.println("read and write");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                switch (n) {
                    case 0: {
                        System.out.println("(can't read now)");
                        break;
                    }
                    case 1: {
                        System.out.println("bogus_1");
                        break;
                    }
                    case 2: {
                        System.out.println("readonly");
                    }
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (n == 0) {
                    System.out.println("(unrecognized)");
                    break block10;
                }
                System.out.println("bogus_2");
            }
        }
    }

    private static void showProperties(XMLReader xMLReader) {
        System.out.println("PROPERTIES for " + xMLReader.getClass().getName());
        DefaultHandler2 defaultHandler2 = new DefaultHandler2();
        SAXDump.checkProperty("declaration-handler", xMLReader, defaultHandler2);
        String[] stringArray = new String[]{"org.apache.crimson.tree.XmlDocument", "org.apache.xerces.dom.DocumentImpl", "gnu.xml.dom.DomDocument", "oracle.xml.parser.v2.XMLDocument"};
        Node node = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                Class<?> clazz = Class.forName(stringArray[n]);
                node = (Node)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n;
        }
        if (node != null) {
            SAXDump.checkProperty("dom-node", xMLReader, node);
        }
        SAXDump.checkProperty("lexical-handler", xMLReader, defaultHandler2);
        SAXDump.checkProperty("xml-string", xMLReader, "<root/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkParser(String string) {
        XMLReader xMLReader = null;
        try {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(string);
                SAXDump.showFeatures(xMLReader);
                System.out.println("");
                SAXDump.showProperties(xMLReader);
            }
            catch (Exception exception) {
                if (xMLReader == null) {
                    System.err.println("(can't create " + string + ")");
                } else {
                    exception.printStackTrace();
                }
                Object var4_3 = null;
                System.out.println("");
            }
            Object var4_2 = null;
            System.out.println("");
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            System.out.println("");
            throw throwable;
        }
    }
}

