/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.wav;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jcodec.audio.AudioSource;
import org.jcodec.codecs.wav.WavHeader;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.AudioUtil;
import org.jcodec.common.NIOUtils;

public class WavInput
implements Closeable {
    protected WavHeader header;
    protected byte[] prevBuf;
    protected ReadableByteChannel in;
    protected AudioFormat format;

    public WavInput(ReadableByteChannel in) throws IOException {
        this.header = WavHeader.read(in);
        this.format = this.header.getFormat();
        this.in = in;
    }

    public int read(ByteBuffer buf) throws IOException {
        int maxRead = this.format.framesToBytes(this.format.bytesToFrames(buf.remaining()));
        return NIOUtils.read(this.in, buf, maxRead);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public WavHeader getHeader() {
        return this.header;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public static class Source
    implements AudioSource,
    Closeable {
        private WavInput src;
        private AudioFormat format;
        private int pos;

        public Source(WavInput src) {
            this.src = src;
            this.format = src.getFormat();
        }

        public Source(ReadableByteChannel ch) throws IOException {
            this(new WavInput(ch));
        }

        public Source(java.io.File file) throws IOException {
            this(new File(file));
        }

        @Override
        public AudioFormat getFormat() {
            return this.src.getFormat();
        }

        @Override
        public void close() throws IOException {
            this.src.close();
        }

        public int read(int[] samples, int max) throws IOException {
            max = Math.min(max, samples.length);
            ByteBuffer bb = ByteBuffer.allocate(this.format.samplesToBytes(max));
            int read = this.src.read(bb);
            bb.flip();
            AudioUtil.toInt(this.format, bb, samples);
            return this.format.bytesToFrames(read);
        }

        @Override
        public int read(FloatBuffer samples) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(this.format.samplesToBytes(samples.remaining()));
            int i = this.src.read(bb);
            if (i == -1) {
                return -1;
            }
            bb.flip();
            AudioUtil.toFloat(this.format, bb, samples);
            int read = this.format.bytesToFrames(i);
            this.pos += read;
            return read;
        }
    }

    public static class File
    extends WavInput {
        public File(java.io.File f) throws IOException {
            super(NIOUtils.readableFileChannel(f));
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.in.close();
        }
    }
}

