/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.primitives;

import java.util.ArrayList;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.Dump$;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Reporter;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.core.SyntaxJ$;
import org.nlogo.extensions.time.Exact$;
import org.nlogo.extensions.time.LinearInterp$;
import org.nlogo.extensions.time.Nearest$;
import org.nlogo.extensions.time.TimeUtils$;
import org.nlogo.extensions.time.datatypes.LogoTime;
import org.nlogo.extensions.time.datatypes.LogoTimeSeries;
import org.nlogo.nvm.ExtensionContext;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005s!B\u0014)\u0011\u0003\u0019d!B\u001b)\u0011\u00031\u0004\"B\u001f\u0002\t\u0003qd\u0001B \u0002\u0001\u0001CQ!P\u0002\u0005\u0002\u001dCQAS\u0002\u0005\u0002-CQAU\u0002\u0005\u0002M3A\u0001Z\u0001\u0001K\")Qh\u0002C\u0001S\")!j\u0002C\u0001\u0017\")1n\u0002C\u0001Y\u001a!q.\u0001\u0001q\u0011\u0015i4\u0002\"\u0001r\u0011\u0015Q5\u0002\"\u0001L\u0011\u0015Y7\u0002\"\u0001t\r\u00111\u0018\u0001A<\t\u000buzA\u0011\u0001=\t\u000b){A\u0011A&\t\u000b-|A\u0011\u0001>\u0007\tu\f\u0001A \u0005\u0006{M!\ta \u0005\u0006\u0015N!\ta\u0013\u0005\u0007WN!\t!a\u0001\u0007\r\u0005%\u0011\u0001AA\u0006\u0011\u0019it\u0003\"\u0001\u0002\u000e!)!j\u0006C\u0001\u0017\"11n\u0006C\u0001\u0003#1a!a\u0006\u0002\u0001\u0005e\u0001BB\u001f\u001c\t\u0003\tY\u0002C\u0003K7\u0011\u00051\n\u0003\u0004l7\u0011\u0005\u0011q\u0004\u0004\u0007\u0003K\t\u0001!a\n\t\ruzB\u0011AA\u0015\u0011\u0015Qu\u0004\"\u0001L\u0011\u0019Yw\u0004\"\u0001\u0002.\u00191\u00111G\u0001\u0001\u0003kAa!P\u0012\u0005\u0002\u0005]\u0002\"\u0002&$\t\u0003Y\u0005B\u0002*$\t\u0003\tY$\u0001\u000bUS6,7+\u001a:jKN\u0004&/[7ji&4Xm\u001d\u0006\u0003S)\n!\u0002\u001d:j[&$\u0018N^3t\u0015\tYC&\u0001\u0003uS6,'BA\u0017/\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0003_A\nQA\u001c7pO>T\u0011!M\u0001\u0004_J<7\u0001\u0001\t\u0003i\u0005i\u0011\u0001\u000b\u0002\u0015)&lWmU3sS\u0016\u001c\bK]5nSRLg/Z:\u0014\u0005\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002g\t\u0001B+[7f'\u0016\u0014\u0018.Z:BI\u0012\u0014vn^\n\u0004\u0007]\n\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#/\u0003\r\t\u0007/[\u0005\u0003\r\u000e\u0013qaQ8n[\u0006tG\rF\u0001I!\tI5!D\u0001\u0002\u0003%9W\r^*z]R\f\u0007\u0010F\u0001M!\ti\u0005+D\u0001O\u0015\tye&\u0001\u0003d_J,\u0017BA)O\u0005\u0019\u0019\u0016P\u001c;bq\u00069\u0001/\u001a:g_JlGc\u0001+X?B\u0011\u0001(V\u0005\u0003-f\u0012A!\u00168ji\")\u0001L\u0002a\u00013\u0006!\u0011M]4t!\rA$\fX\u0005\u00037f\u0012Q!\u0011:sCf\u0004\"AQ/\n\u0005y\u001b%\u0001C!sOVlWM\u001c;\t\u000b\u00014\u0001\u0019A1\u0002\u000f\r|g\u000e^3yiB\u0011!IY\u0005\u0003G\u000e\u0013qaQ8oi\u0016DHO\u0001\tUS6,7+\u001a:jKN\u001c%/Z1uKN\u0019qa\u000e4\u0011\u0005\t;\u0017B\u00015D\u0005!\u0011V\r]8si\u0016\u0014H#\u00016\u0011\u0005%;\u0011A\u0002:fa>\u0014H\u000fF\u00028[:DQ\u0001\u0017\u0006A\u0002eCQ\u0001\u0019\u0006A\u0002\u0005\u0014Q\u0002V5nKN+'/[3t\u000f\u0016$8cA\u00068MR\t!\u000f\u0005\u0002J\u0017Q\u0019q\u0007^;\t\u000bas\u0001\u0019A-\t\u000b\u0001t\u0001\u0019A1\u0003%QKW.Z*fe&,7oR3u\u000bb\f7\r^\n\u0004\u001f]2G#A=\u0011\u0005%{AcA\u001c|y\")\u0001L\u0005a\u00013\")\u0001M\u0005a\u0001C\n\u0019B+[7f'\u0016\u0014\u0018.Z:HKRLe\u000e^3saN\u00191c\u000e4\u0015\u0005\u0005\u0005\u0001CA%\u0014)\u00159\u0014QAA\u0004\u0011\u0015Af\u00031\u0001Z\u0011\u0015\u0001g\u00031\u0001b\u0005I!\u0016.\\3TKJLWm]$fiJ\u000bgnZ3\u0014\u0007]9d\r\u0006\u0002\u0002\u0010A\u0011\u0011j\u0006\u000b\u0006o\u0005M\u0011Q\u0003\u0005\u00061j\u0001\r!\u0017\u0005\u0006Aj\u0001\r!\u0019\u0002\u000f)&lWmU3sS\u0016\u001cHj\\1e'\rYrG\u001a\u000b\u0003\u0003;\u0001\"!S\u000e\u0015\u000b]\n\t#a\t\t\u000bas\u0002\u0019A-\t\u000b\u0001t\u0002\u0019A1\u00031QKW.Z*fe&,7\u000fT8bI^KG\u000f\u001b$pe6\fGoE\u0002 o\u0019$\"!a\u000b\u0011\u0005%{B#B\u001c\u00020\u0005E\u0002\"\u0002-#\u0001\u0004I\u0006\"\u00021#\u0001\u0004\t'a\u0004+j[\u0016\u001cVM]5fg^\u0013\u0018\u000e^3\u0014\u0007\r:\u0014\t\u0006\u0002\u0002:A\u0011\u0011j\t\u000b\u0006)\u0006u\u0012q\b\u0005\u00061\u001a\u0002\r!\u0017\u0005\u0006A\u001a\u0002\r!\u0019")
public final class TimeSeriesPrimitives {

    public static class TimeSeriesAddRow
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.commandSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType()});
        }

        public void perform(Argument[] args, Context context) {
            LogoTimeSeries ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
            LogoList list = TimeUtils$.MODULE$.getListFromArgument(args, Predef$.MODULE$.int2Integer(1));
            Object timeObj = list.get(0);
            LogoTime time = null;
            Object object = timeObj;
            if (object instanceof String) {
                String string = (String)object;
                time = new LogoTime(string);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof LogoTime) {
                LogoTime logoTime = (LogoTime)object;
                time = new LogoTime(logoTime);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new ExtensionException(new StringBuilder(110).append("time: was expecting a LogoTime object as the first item in the list passed as argument 2, found this instead: ").append(Dump$.MODULE$.logoObject(object)).toString());
            }
            if (list.size() != Predef$.MODULE$.Integer2int(ts.getNumColumns()) + 1) {
                throw new ExtensionException(new StringBuilder(56).append("time: cannot add ").append(list.size() - 1).append(" values to a time series with ").append(ts.getNumColumns()).append(" columns.").toString());
            }
            ts.add(time, list.logoSublist(1, list.size()));
        }
    }

    public static class TimeSeriesCreate
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            LogoList columnList = null;
            try {
                columnList = TimeUtils$.MODULE$.getListFromArgument(args, Predef$.MODULE$.int2Integer(0));
            }
            catch (ExtensionException e) {
                ArrayList<String> cols = new ArrayList<String>();
                String colName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0));
                cols.add(colName);
                columnList = LogoList$.MODULE$.fromJava(cols);
            }
            return new LogoTimeSeries(columnList);
        }
    }

    public static class TimeSeriesGet
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime time;
            LogoTimeSeries ts;
            block1: {
                block0: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(time);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    String string2 = "ALL";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                    String string3 = columnName;
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block1;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getByTime(time, columnName, Nearest$.MODULE$);
        }
    }

    public static class TimeSeriesGetExact
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime time;
            LogoTimeSeries ts;
            block1: {
                block0: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(time);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    String string2 = "ALL";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                    String string3 = columnName;
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block1;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getByTime(time, columnName, Exact$.MODULE$);
        }
    }

    public static class TimeSeriesGetInterp
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime time;
            LogoTimeSeries ts;
            block1: {
                block0: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    time = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(time);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    String string2 = "ALL";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
                    String string3 = columnName;
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block1;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getByTime(time, columnName, LinearInterp$.MODULE$);
        }
    }

    public static class TimeSeriesGetRange
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            String columnName;
            LogoTime timeB;
            LogoTime timeA;
            LogoTimeSeries ts;
            block2: {
                block1: {
                    ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
                    timeA = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(1));
                    ts.ensureDateTypeConsistent(timeA);
                    timeB = TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(2));
                    ts.ensureDateTypeConsistent(timeB);
                    String string = columnName = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(3));
                    String string2 = "logotime";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        columnName = "LOGOTIME";
                    }
                    String string3 = columnName;
                    String string4 = "ALL";
                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block1;
                    String string5 = columnName;
                    String string6 = "all";
                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block2;
                }
                columnName = "ALL_-_COLUMNS";
            }
            return ts.getRangeByTime(timeA, timeB, columnName);
        }
    }

    public static class TimeSeriesLoad
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            String filename = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0));
            return new LogoTimeSeries(filename, (ExtensionContext)context);
        }
    }

    public static class TimeSeriesLoadWithFormat
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.reporterSyntax(new int[]{Syntax$.MODULE$.StringType(), Syntax$.MODULE$.StringType()}, Syntax$.MODULE$.WildcardType());
        }

        public Object report(Argument[] args, Context context) {
            String filename = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(0));
            String string = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(1));
            Object object = string == null ? None$.MODULE$ : new Some((Object)string);
            None$ format = object;
            return new LogoTimeSeries(filename, (Option<String>)format, (ExtensionContext)context);
        }
    }

    public static class TimeSeriesWrite
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ$.MODULE$.commandSyntax(new int[]{Syntax$.MODULE$.WildcardType(), Syntax$.MODULE$.StringType()});
        }

        public void perform(Argument[] args, Context context) {
            LogoTimeSeries ts = TimeUtils$.MODULE$.getTimeSeriesFromArgument(args, Predef$.MODULE$.int2Integer(0));
            String filename = TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(1));
            ts.write(filename, (ExtensionContext)context);
        }
    }
}

