/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.nlogo.api.ExtensionException;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualIncrementalTin;
import org.tinfour.utils.TriangleCollector;

public class TriangulationUtil {
    private static Coordinate tinfourVertexToJTSCoordinate(Vertex vert) {
        return new Coordinate(vert.x, vert.y);
    }

    private static Polygon tinfourVertsToJTSPolygon(Vertex[] verts, GeometryFactory factory) {
        Coordinate[] coords = new Coordinate[4];
        for (int i = 0; i < 3; ++i) {
            coords[i] = TriangulationUtil.tinfourVertexToJTSCoordinate(verts[i]);
        }
        coords[3] = TriangulationUtil.tinfourVertexToJTSCoordinate(verts[0]);
        return factory.createPolygon(coords);
    }

    public static PolygonConstraint constraintFromLineString(LineString lineString) {
        CoordinateSequence seq = lineString.getCoordinateSequence();
        Vertex[] exteriorVertices = new Vertex[seq.size() - 1];
        for (int i = 0; i < exteriorVertices.length; ++i) {
            Coordinate c = seq.getCoordinate(i);
            exteriorVertices[exteriorVertices.length - i - 1] = new Vertex(c.x, c.y, 0.0);
        }
        PolygonConstraint polygonConstraint = new PolygonConstraint(Arrays.asList(exteriorVertices));
        polygonConstraint.complete();
        return polygonConstraint;
    }

    public static Geometry triangulate(Geometry geom) throws ExtensionException {
        int triangulationAttempts;
        ArrayList<PolygonConstraint> constraints = new ArrayList<PolygonConstraint>();
        double nominalPointSpacing = geom.getEnvelopeInternal().maxExtent();
        for (int n = 0; n < geom.getNumGeometries(); ++n) {
            Polygon thisPolygon = (Polygon)geom.getGeometryN(n);
            PolygonConstraint outerConstraint = TriangulationUtil.constraintFromLineString(thisPolygon.getExteriorRing());
            constraints.add(outerConstraint);
            nominalPointSpacing = Math.min(nominalPointSpacing, outerConstraint.getNominalPointSpacing());
            for (int interiorRing = 0; interiorRing < thisPolygon.getNumInteriorRing(); ++interiorRing) {
                PolygonConstraint thisHoleConstraint = TriangulationUtil.constraintFromLineString(thisPolygon.getInteriorRingN(interiorRing));
                constraints.add(thisHoleConstraint);
                nominalPointSpacing = Math.min(nominalPointSpacing, thisHoleConstraint.getNominalPointSpacing());
            }
        }
        SemiVirtualIncrementalTin tin = new SemiVirtualIncrementalTin(nominalPointSpacing /= 1000.0);
        for (triangulationAttempts = 0; triangulationAttempts < 5; ++triangulationAttempts) {
            try {
                tin.addConstraints(constraints, true);
                break;
            }
            catch (Exception e) {
                tin.dispose();
                tin = new SemiVirtualIncrementalTin(nominalPointSpacing /= 1000.0);
                continue;
            }
        }
        if (triangulationAttempts >= 5) {
            throw new ExtensionException("This polygon is too dense and/or complex to generate a point within it. Try simplifying the vector dataset with a tool like QGIS/GRASS v.generalize: https://docs.qgis.org/latest/en/docs/training_manual/processing/generalize.html");
        }
        GeometryCollectionBuilder geometryCollectionBuilder = new GeometryCollectionBuilder(geom);
        TriangleCollector.visitTrianglesConstrained((IIncrementalTin)tin, (Consumer)geometryCollectionBuilder);
        tin.dispose();
        return geometryCollectionBuilder.getCollection();
    }

    private static class GeometryCollectionBuilder
    implements Consumer<Vertex[]> {
        GeometryFactory factory;
        Geometry geom;
        List<Geometry> geometries;

        GeometryCollectionBuilder(Geometry _geom) {
            this.geom = _geom;
            this.factory = this.geom.getFactory();
            this.geometries = new ArrayList<Geometry>();
        }

        public GeometryCollection getCollection() {
            Geometry[] geometriesArr = new Geometry[this.geometries.size()];
            geometriesArr = this.geometries.toArray(geometriesArr);
            return new GeometryCollection(geometriesArr, this.factory);
        }

        @Override
        public void accept(Vertex[] verts) {
            Polygon poly = TriangulationUtil.tinfourVertsToJTSPolygon(verts, this.factory);
            this.geometries.add((Geometry)poly);
        }
    }
}

