/*
 * Decompiled with CFR 0.152.
 */
package gogoHID.daemon;

import java.io.IOException;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class HIDGogoDaemon
implements HidServicesListener {
    private HidServices hidServices;
    private HidDevice gogoBoard;

    private void loadUpHIDServices() throws HidException {
        this.hidServices = HidManager.getHidServices();
        this.hidServices.addHidServicesListener((HidServicesListener)this);
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            System.err.println(hidDevice);
            if (hidDevice.getVendorId() != 1121 || hidDevice.getProductId() != 32) continue;
            this.gogoBoard = this.hidServices.getHidDevice(1121, 32, null);
            System.err.println("GoGo board found, using this one: " + this.gogoBoard);
        }
    }

    public void boot() {
        try {
            this.loadUpHIDServices();
        }
        catch (Exception e) {
            System.err.println("HID EXCEPTION");
            e.printStackTrace();
            throw new RuntimeException("Error in loading HID services");
        }
    }

    private void write(byte[] message) {
        if (this.gogoBoard != null) {
            this.gogoBoard.write(message, message.length, (byte)0);
        }
    }

    private void read(byte[] message) {
        if (this.gogoBoard != null) {
            this.gogoBoard.read(message, 200);
        }
    }

    private int getNumDevices() {
        int numDevices = 0;
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            if (hidDevice.getVendorId() != 1121 || hidDevice.getProductId() != 32) continue;
            ++numDevices;
        }
        return numDevices;
    }

    public void hidDeviceAttached(HidServicesEvent event) {
        System.err.println("Device attached: " + event);
        if (event.getHidDevice().getVendorId() == 1121 && event.getHidDevice().getProductId() == 32) {
            this.gogoBoard = this.hidServices.getHidDevice(1121, 32, null);
        }
    }

    public void hidDeviceDetached(HidServicesEvent event) {
        System.err.println("device detached");
        System.err.println(event.getHidDevice().toString());
        System.err.println(event.toString());
        if (event.getHidDevice().getVendorId() == 1121 && event.getHidDevice().getProductId() == 32) {
            this.gogoBoard = null;
        }
    }

    public void hidFailure(HidServicesEvent arg0) {
        System.err.println("HID failure");
    }

    public static void main(String[] args) throws IOException {
        System.err.println("HID daemon started!");
        HIDGogoDaemon d = new HIDGogoDaemon();
        d.boot();
        boolean quit = false;
        while (!quit) {
            byte[] message;
            int numBytes;
            int c = System.in.read();
            if (c == 83) {
                numBytes = System.in.read();
                message = new byte[numBytes];
                System.in.read(message);
                d.write(message);
                continue;
            }
            if (c == 82) {
                numBytes = System.in.read();
                message = new byte[numBytes];
                d.read(message);
                System.out.write(message);
                System.out.flush();
                continue;
            }
            if (c == 78) {
                System.out.write(d.getNumDevices());
                System.out.flush();
                continue;
            }
            if (c != 88) continue;
            System.err.println("HID daemon quit code received.");
            quit = true;
        }
        if (d != null && d.gogoBoard != null) {
            d.gogoBoard.close();
        }
        System.err.println("HID daemon run complete.");
    }
}

