/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Dump$;
import org.nlogo.core.Breed;
import org.nlogo.core.Nobody$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001U3Qa\u0003\u0007\u0001\u0019IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\t?\u0001\u0011\t\u0011)A\u0005A!)\u0001\u0006\u0001C\u0001S!)Q\u0006\u0001C\u0001]!)q\u0007\u0001C\u0005q!)\u0011\b\u0001C\u0005q!)!\b\u0001C\tq!)1\b\u0001C\tq!)A\b\u0001C\u0005q!)Q\b\u0001C\t}\tAQ\t\u001f9peR,'O\u0003\u0002\u000e\u001d\u0005)\u0011mZ3oi*\u0011q\u0002E\u0001\u0006]2|wm\u001c\u0006\u0002#\u0005\u0019qN]4\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-A\u0003x_JdGm\u0001\u0001\u0011\u0005qiR\"\u0001\u0007\n\u0005ya!!B,pe2$\u0017AB<sSR,'\u000f\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#EA\u0006Qe&tGo\u0016:ji\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"\u0001\b\u0001\t\u000be\u0019\u0001\u0019A\u000e\t\u000b}\u0019\u0001\u0019\u0001\u0011\u0002\u0017\u0015D\bo\u001c:u/>\u0014H\u000e\u001a\u000b\u0003_I\u0002\"\u0001\u0006\u0019\n\u0005E*\"\u0001B+oSRDQa\r\u0003A\u0002Q\nAAZ;mYB\u0011A#N\u0005\u0003mU\u0011qAQ8pY\u0016\fg.A\u0006fqB|'\u000f\u001e'j].\u001cH#A\u0018\u0002#\u0015D\bo\u001c:u%\u0006tGm\\7Ti\u0006$X-A\u0007fqB|'\u000f^$m_\n\fGn]\u0001\u000eKb\u0004xN\u001d;UkJ$H.Z:\u0002\u001b\u0015D\bo\u001c:u!\u0006$8\r[3t\u0003I\u0019xN\u001d;J]\u0012L7-Z:B]\u00124\u0016M]:\u0015\u0007=zt\nC\u0003A\u0015\u0001\u0007\u0011)\u0001\u0003wCJ\u001c\bc\u0001\u000bC\t&\u00111)\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d+R\"\u0001%\u000b\u0005%S\u0012A\u0002\u001fs_>$h(\u0003\u0002L+\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tYU\u0003C\u0003Q\u0015\u0001\u0007\u0011+A\u0004j]\u0012L7-Z:\u0011\u0007Q\u0011%\u000b\u0005\u0002\u0015'&\u0011A+\u0006\u0002\u0004\u0013:$\b")
public class Exporter {
    private final World world;
    private final PrintWriter writer;

    public void exportWorld(boolean full) {
        this.exportRandomState();
        this.exportGlobals();
        if (full) {
            this.exportTurtles();
            this.exportPatches();
            this.exportLinks();
        }
    }

    private void exportLinks() {
        this.writer.println(Dump$.MODULE$.csv().encode("LINKS"));
        ArrayList<String> allLinkVars = new ArrayList<String>();
        this.world.program().linksOwn().foreach((Function1<String, Object> & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean(allLinkVars.add(v)));
        int linkVarSize = this.world.program().linksOwn().size();
        Map breedVarIndices = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.world.program().linkBreeds().values().foreach((Function1<Breed, Object> & Serializable & scala.Serializable)current -> {
            Exporter.$anonfun$exportLinks$2(breedVarIndices, allLinkVars, current);
            return BoxedUnit.UNIT;
        });
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(allLinkVars));
        AgentIterator it = this.world.links().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            AgentSet breed = (AgentSet)link.getLinkVariable(Link.VAR_BREED);
            String key = breed.printName();
            ObjectRef<Object> breedOwns = ObjectRef.create(null);
            ObjectRef<Object> thisBreedVarIndices = ObjectRef.create(null);
            ObjectRef<Object> sortedBreedOwns = ObjectRef.create(null);
            String string2 = key;
            String string3 = "LINKS";
            if (string2 == null || !string2.equals(string3)) {
                breedOwns.elem = ((Breed)this.world.program().linkBreeds().apply(key)).owns();
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), (JFunction0$mcI$sp & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
                sortedBreedOwns.elem = (String[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), (Function0<String> & Serializable & scala.Serializable)() -> null, ClassTag$.MODULE$.apply(String.class));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((Seq)breedOwns.elem).size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                    ((String[])sortedBreedOwns$1.elem)[j] = (String)((Seq)breedOwns$1.elem).apply(j);
                    ((int[])thisBreedVarIndices$1.elem)[j] = BoxesRunTime.unboxToInt(breedVarIndices.apply(((Seq)breedOwns$1.elem).apply(j)));
                });
                this.sortIndicesAndVars((String[])sortedBreedOwns.elem, (int[])thisBreedVarIndices.elem);
            } else {
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int());
            }
            IntRef index = IntRef.create(0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), allLinkVars.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                if (j > 0) {
                    $this.writer.print(",");
                }
                if (j < linkVarSize) {
                    $this.writer.print(Dump$.MODULE$.csv().data(link.getLinkVariable(j)));
                    return;
                }
                if (index$1.elem < ((int[])thisBreedVarIndices$1.elem).length && j == ((int[])thisBreedVarIndices$1.elem)[index$1.elem]) {
                    $this.writer.print(Dump$.MODULE$.csv().data(link.getLinkVariable($this.world.linkBreedsOwnIndexOf(breed, ((String[])sortedBreedOwns$1.elem)[index$1.elem]))));
                    ++index$1.elem;
                }
            });
            this.writer.println();
        }
        this.writer.println();
    }

    private void exportRandomState() {
        this.writer.println(Dump$.MODULE$.csv().encode("RANDOM STATE"));
        this.writer.println(Dump$.MODULE$.csv().encode(this.world.mainRNG().save()));
        this.writer.println();
    }

    public void exportGlobals() {
        this.writer.println(Dump$.MODULE$.csv().encode("GLOBALS"));
        this.writer.print(new StringBuilder(8).append(Dump$.MODULE$.csv().encode("min-pxcor")).append(",").append(Dump$.MODULE$.csv().encode("max-pxcor")).append(",").append(Dump$.MODULE$.csv().encode("min-pycor")).append(",").append(Dump$.MODULE$.csv().encode("max-pycor")).append(",").append(Dump$.MODULE$.csv().encode("perspective")).append(",").append(Dump$.MODULE$.csv().encode("subject")).append(",").append(Dump$.MODULE$.csv().encode("nextIndex")).append(",").append(Dump$.MODULE$.csv().encode("directed-links")).append(",").append(Dump$.MODULE$.csv().encode("ticks")).toString());
        Seq<String> globals = this.world.program().globals();
        ArrayList<String> sortedGlobals = new ArrayList<String>(globals.size());
        Map globalVarIndices = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ((TraversableLike)globals.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$1 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(Exporter.$anonfun$exportGlobals$2(globalVarIndices, sortedGlobals, x$1)));
        Collections.sort(sortedGlobals);
        Object subject = Option$.MODULE$.apply(this.world.observer().targetAgent()).getOrElse((Function0<Nobody$> & Serializable & scala.Serializable)() -> Nobody$.MODULE$);
        if (!sortedGlobals.isEmpty()) {
            this.writer.print(new StringBuilder(1).append(",").append(Dump$.MODULE$.csv().variableNameRow(sortedGlobals)).toString());
        }
        this.writer.println();
        this.writer.print(new StringBuilder(8).append(Dump$.MODULE$.csv().encode(Integer.toString(this.world.minPxcor()))).append(",").append(Dump$.MODULE$.csv().encode(Integer.toString(this.world.maxPxcor()))).append(",").append(Dump$.MODULE$.csv().encode(Integer.toString(this.world.minPycor()))).append(",").append(Dump$.MODULE$.csv().encode(Integer.toString(this.world.maxPycor()))).append(",").append(Dump$.MODULE$.csv().encode(Integer.toString(this.world.observer().perspective().export()))).append(",").append(Dump$.MODULE$.csv().data(subject)).append(",").append(Dump$.MODULE$.csv().encode(Long.toString(this.world.nextTurtleIndex()))).append(",").append(Dump$.MODULE$.csv().data(this.world.links().isDirected() ? "DIRECTED" : (this.world.links().isUndirected() ? "UNDIRECTED" : "NEITHER"))).append(",").append(Dump$.MODULE$.csv().encode(Dump$.MODULE$.number(this.world.tickCounter().ticks()))).toString());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sortedGlobals).asScala()).foreach((Function1<String, Object> & Serializable & scala.Serializable)g -> {
            Exporter.$anonfun$exportGlobals$4(this, globalVarIndices, g);
            return BoxedUnit.UNIT;
        });
        this.writer.println();
        this.writer.println();
    }

    public void exportTurtles() {
        this.writer.println(Dump$.MODULE$.csv().encode("TURTLES"));
        ArrayList<String> allTurtleVars = new ArrayList<String>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.world.program().turtlesOwn()).asJava());
        int turtlesVarSize = this.world.program().turtlesOwn().size();
        Map breedVarIndices = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.world.program().breeds().values().foreach((Function1<Breed, Object> & Serializable & scala.Serializable)current -> {
            Exporter.$anonfun$exportTurtles$1(breedVarIndices, allTurtleVars, current);
            return BoxedUnit.UNIT;
        });
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(allTurtleVars));
        AgentIterator it = this.world.turtles().iterator();
        while (it.hasNext()) {
            Turtle turtle = (Turtle)it.next();
            this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(Turtle.VAR_WHO)));
            AgentSet breed = (AgentSet)turtle.getTurtleVariable(Turtle.VAR_BREED);
            String key = breed.printName();
            ObjectRef<Object> breedOwns = ObjectRef.create(null);
            ObjectRef<Object> thisBreedVarIndices = ObjectRef.create(null);
            ObjectRef<Object> sortedBreedOwns = ObjectRef.create(null);
            String string2 = key;
            String string3 = "TURTLES";
            if (string2 == null || !string2.equals(string3)) {
                breedOwns.elem = ((Breed)this.world.program().breeds().apply(key)).owns();
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), (JFunction0$mcI$sp & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
                sortedBreedOwns.elem = (String[])Array$.MODULE$.fill(((Seq)breedOwns.elem).size(), (Function0<String> & Serializable & scala.Serializable)() -> null, ClassTag$.MODULE$.apply(String.class));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((Seq)breedOwns.elem).size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                    ((String[])sortedBreedOwns$2.elem)[j] = (String)((Seq)breedOwns$2.elem).apply(j);
                    ((int[])thisBreedVarIndices$2.elem)[j] = BoxesRunTime.unboxToInt(breedVarIndices.apply(((Seq)breedOwns$2.elem).apply(j)));
                });
                this.sortIndicesAndVars((String[])sortedBreedOwns.elem, (int[])thisBreedVarIndices.elem);
            } else {
                thisBreedVarIndices.elem = (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int());
            }
            IntRef index = IntRef.create(0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allTurtleVars.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                $this.writer.print(",");
                if (j < turtlesVarSize) {
                    $this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable(j)));
                    return;
                }
                if (index$2.elem < ((int[])thisBreedVarIndices$2.elem).length && j == ((int[])thisBreedVarIndices$2.elem)[index$2.elem]) {
                    $this.writer.print(Dump$.MODULE$.csv().data(turtle.getTurtleVariable($this.world.breedsOwnIndexOf(breed, ((String[])sortedBreedOwns$2.elem)[index$2.elem]))));
                    ++index$2.elem;
                }
            });
            this.writer.println();
        }
        this.writer.println();
    }

    private void exportPatches() {
        this.writer.println(Dump$.MODULE$.csv().encode("PATCHES"));
        Seq<String> vars = this.world.program().patchesOwn();
        this.writer.println(Dump$.MODULE$.csv().variableNameRow(vars));
        AgentIterator it = this.world.patches().iterator();
        while (it.hasNext()) {
            Patch patch = (Patch)it.next();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), vars.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                if (j > 0) {
                    $this.writer.print(",");
                }
                $this.writer.print(Dump$.MODULE$.csv().data(patch.getPatchVariable(j)));
            });
            this.writer.println();
        }
        this.writer.println();
    }

    /*
     * WARNING - void declaration
     */
    public void sortIndicesAndVars(String[] vars, int[] indices) {
        void var5_5;
        void var4_4;
        Tuple2<Object, Object> tuple2 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])vars)).zip(Predef$.MODULE$.wrapIntArray(indices), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2._2$mcI$sp()), (Ordering)Ordering$Int$.MODULE$))).unzip(Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        String[] sortedVars = (String[])tuple2._1();
        int[] sortedIndices = (int[])tuple2._2();
        void sortedVars2 = var4_4;
        void sortedIndices2 = var5_5;
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sortedVars2)).copyToArray(vars);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])sortedIndices2)).copyToArray(indices);
    }

    public static final /* synthetic */ void $anonfun$exportLinks$3(Map breedVarIndices$1, ArrayList allLinkVars$1, String breedVarName) {
        if (!breedVarIndices$1.contains(breedVarName)) {
            allLinkVars$1.add(breedVarName);
            breedVarIndices$1.update(breedVarName, BoxesRunTime.boxToInteger(allLinkVars$1.size() - 1));
        }
    }

    public static final /* synthetic */ void $anonfun$exportLinks$2(Map breedVarIndices$1, ArrayList allLinkVars$1, Breed current) {
        current.owns().foreach((Function1<String, Object> & Serializable & scala.Serializable)breedVarName -> {
            Exporter.$anonfun$exportLinks$3(breedVarIndices$1, allLinkVars$1, breedVarName);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$exportGlobals$2(Map globalVarIndices$1, ArrayList sortedGlobals$1, Tuple2 x$1) {
        if (x$1 == null) {
            throw new MatchError((Object)null);
        }
        String g = (String)x$1._1();
        int i = x$1._2$mcI$sp();
        globalVarIndices$1.update(g, BoxesRunTime.boxToInteger(i));
        boolean bl = sortedGlobals$1.add(g);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$exportGlobals$4(Exporter $this, Map globalVarIndices$1, String g) {
        $this.writer.print(",");
        $this.writer.print(Dump$.MODULE$.csv().data($this.world.observer().getVariable(BoxesRunTime.unboxToInt(globalVarIndices$1.apply(g)))));
    }

    public static final /* synthetic */ void $anonfun$exportTurtles$2(Map breedVarIndices$2, ArrayList allTurtleVars$1, String breedVarName) {
        if (!breedVarIndices$2.contains(breedVarName)) {
            allTurtleVars$1.add(breedVarName);
            breedVarIndices$2.update(breedVarName, BoxesRunTime.boxToInteger(allTurtleVars$1.size() - 1));
        }
    }

    public static final /* synthetic */ void $anonfun$exportTurtles$1(Map breedVarIndices$2, ArrayList allTurtleVars$1, Breed current) {
        current.owns().foreach((Function1<String, Object> & Serializable & scala.Serializable)breedVarName -> {
            Exporter.$anonfun$exportTurtles$2(breedVarIndices$2, allTurtleVars$1, breedVarName);
            return BoxedUnit.UNIT;
        });
    }

    public Exporter(World world, PrintWriter writer) {
        this.world = world;
        this.writer = writer;
    }
}

