/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.dense;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.dense.AbstractBasicMatrix;
import org.la4j.matrix.dense.DenseMatrix;
import org.la4j.matrix.source.MatrixSource;
import org.la4j.vector.Vector;
import org.la4j.vector.dense.BasicVector;

public class Basic2DMatrix
extends AbstractBasicMatrix
implements DenseMatrix {
    private static final long serialVersionUID = 4071505L;
    private double[][] self;

    public Basic2DMatrix() {
        this(0, 0);
    }

    public Basic2DMatrix(Matrix matrix) {
        this(Matrices.asUnsafeSource(matrix));
    }

    public Basic2DMatrix(MatrixSource source) {
        this(source.rows(), source.columns());
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.self[i][j] = source.get(i, j);
            }
        }
    }

    public Basic2DMatrix(int rows, int columns) {
        this(new double[rows][columns]);
    }

    public Basic2DMatrix(double[][] array) {
        super(Matrices.BASIC2D_FACTORY, array.length, array.length == 0 ? 0 : array[0].length);
        this.self = array;
    }

    @Override
    public double get(int i, int j) {
        return this.self[i][j];
    }

    @Override
    public void set(int i, int j, double value) {
        this.self[i][j] = value;
    }

    @Override
    public void swapRows(int i, int j) {
        if (i != j) {
            double[] tmp = this.self[i];
            this.self[i] = this.self[j];
            this.self[j] = tmp;
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i != j) {
            for (int ii = 0; ii < this.rows; ++ii) {
                double tmp = this.self[ii][i];
                this.self[ii][i] = this.self[ii][j];
                this.self[ii][j] = tmp;
            }
        }
    }

    @Override
    public Vector getRow(int i) {
        double[] result = new double[this.columns];
        System.arraycopy(this.self[i], 0, result, 0, this.columns);
        return new BasicVector(result);
    }

    @Override
    public Matrix copy() {
        return new Basic2DMatrix(this.toArray());
    }

    @Override
    public Matrix resize(int rows, int columns) {
        this.ensureDimensionsAreNotNegative(rows, columns);
        if (this.rows == rows && this.columns == columns) {
            return this.copy();
        }
        double[][] $self = new double[rows][columns];
        for (int i = 0; i < Math.min(this.rows, rows); ++i) {
            System.arraycopy(this.self[i], 0, $self[i], 0, Math.min(this.columns, columns));
        }
        return new Basic2DMatrix($self);
    }

    @Override
    public double[][] toArray() {
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.self[i], 0, result[i], 0, this.columns);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                out.writeDouble(this.self[i][j]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.self = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.self[i][j] = in.readDouble();
            }
        }
    }
}

