#!/usr/bin/env perl
use strict;
use warnings;

my @tags=("TAG_MINOR_RESET");
open IN, "<tag-version.h" or die "Can't open tag-version.h\n";
while (<IN>)
{
    push @tags, $1 if /^\s*((?:NUM_)?TAG_MINOR[A-Z_0-9]+),/;
}
die "Didn't find any TAG_MINOR enums.\n" unless @tags;

open OUT, ">dat/dlua/tags.lua" or die;
print OUT <<END;
-- Autogenerated by util/gen-luatags.pl, do not edit.

------------------------------------------------------------------------------
-- tags.lua:
-- Tag and version compatibility functions and info.
------------------------------------------------------------------------------
tags = {}

------------------------------------------------------------------------------
-- simpler access to tag_major_version
------------------------------------------------------------------------------

function tags.major_version ()
  return file.major_version()
end

END
my $num = 0;
printf OUT "tags.%s = %d\n", $_, $num++ for @tags;
print OUT "tags.TAG_MINOR_VERSION = tags.NUM_TAG_MINORS - 1\n";
