/*************************************************************************
*  MPEG SYSTEMS MULTIPLEXER                                              *
*  Erzeugen einer MPEG/SYSTEMS                           		 *
*  MULTIPLEXED VIDEO/AUDIO DATEI					 *
*  aus zwei MPEG Basis Streams						 *
*  Christoph Moar							 *
*  SIEMENS ZFE ST SN 11 / T SN 6					 *
*  (C) 1994 1995    							 *
**************************************************************************
*  Generating a MPEG/SYSTEMS						 *
*  MULTIPLEXED VIDEO/AUDIO STREAM					 *
*  from two MPEG source streams						 *
*  Christoph Moar							 *
*  SIEMENS CORPORATE RESEARCH AND DEVELOPMENT ST SN 11 / T SN 6		 *
*  (C) 1994 1995							 *
**************************************************************************
*  Einschraenkungen vorhanden. Unterstuetzt nicht gesamten MPEG/SYSTEMS  *
*  Standard. Haelt sich i.d.R. an den CSPF-Werten, zusaetzlich (noch)    *
*  nur fuer ein Audio- und/oder ein Video- Stream. Evtl. erweiterbar.    *
**************************************************************************
*  Restrictions apply. Will not support the whole MPEG/SYSTEM Standard.  *
*  Basically, will generate Constrained System Parameter Files.		 *
*  Mixes only one audio and/or one video stream. Might be expanded.	 *
*************************************************************************/

/*************************************************************************
*  mplex - MPEG/SYSTEMS multiplexer					 *
*  Copyright (C) 1994 1995 Christoph Moar				 *
*  Siemens ZFE ST SN 11 / T SN 6					 *
*									 *
*  moar@informatik.tu-muenchen.de 					 *
*       (Christoph Moar)			 			 *
*  klee@heaven.zfe.siemens.de						 *
*       (Christian Kleegrewe, Siemens only requests)			 *
*									 *
*  This program is free software; you can redistribute it and/or modify	 *
*  it under the terms of the GNU General Public License as published by	 *	
*  the Free Software Foundation; either version 2 of the License, or	 *
*  (at your option) any later version.					 *
*									 *
*  This program is distributed in the hope that it will be useful,	 *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of	 *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	 *
*  GNU General Public License for more details.				 *
*									 *
*  You should have received a copy of the GNU General Public License	 *
*  along with this program; if not, write to the Free Software		 *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		 *
*************************************************************************/

/*************************************************************************
*  Notwendige Systemmittel:						 *
*  Festplattenspeicher fuer Quell- und Zielstreams, pro Minute 		 *
*  MPEG/SYSTEMS Stream noch zusaetzlich 50-100 kByte tmp Plattenspeicher *
**************************************************************************
*  Necessary resources:							 *
*  Hard Disk space for source and destination streams, per Minute	 *
*  MPEG/SYSTEM stream an additional 50-100 kByte tmp Diskspace		 *
*************************************************************************/

#define MPEGMAIN 1
#include "main.h"
#include "consts.h"


//======================
//== Display-Routines ==
//======================
static int need_new_line = 0;

void DisplayError(char *txt)
{
  fprintf(stderr, "\nERROR: %s", txt);
  need_new_line = 1;
}
void DisplayWarning(char *txt)
{
  fprintf(stderr, "\nWARNING: %s", txt);
  need_new_line = 1;
}
void DisplayInfo(char *txt)
{
  fprintf(stderr, "\nINFO: %s", txt);
  need_new_line = 1;
}

void DisplayProgress(char *txt, int percent)
{
  if (need_new_line) 
  {  
    fprintf(stderr, "\n"); 
    need_new_line = 0;
  }   
  fprintf(stderr, "*** %s %d%%\r", txt, percent);
}

//===============
//== domplex() ==
//===============

static char temp_filename_v[]  = "./tmp_vXXXXXX";
static char temp_filename_a[]  = "./tmp_a0XXXXXX";
static char temp_filename_a1[] = "./tmp_a1XXXXXX";
static char temp_filename_a2[] = "./tmp_a2XXXXXX";
static char temp_filename_a3[] = "./tmp_a3XXXXXX";
static char temp_filename_a4[] = "./tmp_a4XXXXXX";
static char temp_filename_a5[] = "./tmp_a5XXXXXX";
static char temp_filename_a6[] = "./tmp_a6XXXXXX";
static char temp_filename_a7[] = "./tmp_a7XXXXXX";

int domplex(int mplex_video, int mplex_audio)
{
  char	*video_units = NULL;
  char	*audio_units = NULL;
  char  *audio1_units = NULL;
  char  *audio2_units = NULL;
  char  *audio3_units = NULL;
  char  *audio4_units = NULL;
  char  *audio5_units = NULL;
  char  *audio6_units = NULL;
  char  *audio7_units = NULL;

  Video_struc video_info;
  Audio_struc audio_info;
  Audio_struc audio1_info;
  Audio_struc audio2_info;
  Audio_struc audio3_info;
  Audio_struc audio4_info;
  Audio_struc audio5_info;
  Audio_struc audio6_info;
  Audio_struc audio7_info;

  off_t video_total;
  unsigned int audio_total;
  unsigned int audio1_total, audio2_total, audio3_total, audio4_total;
  unsigned int audio5_total, audio6_total, audio7_total;
  off_t audio_bytes, video_bytes;
  off_t audio1_bytes, audio2_bytes, audio3_bytes, audio4_bytes;
  off_t audio5_bytes, audio6_bytes, audio7_bytes;
  unsigned int which_streams=0;
  double startup_delay=0;

  if (mplex_video)
    which_streams |= STREAMS_VIDEO;

  if (mplex_audio && strlen(AudioFilename))
    which_streams |= STREAMS_AUDIO;

  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio1Filename))
    which_streams |= STREAMS_AUDIO1;
  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio2Filename))
    which_streams |= STREAMS_AUDIO2;
  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio3Filename))
    which_streams |= STREAMS_AUDIO3;
  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio4Filename))
    which_streams |= STREAMS_AUDIO4;
  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio5Filename))
    which_streams |= STREAMS_AUDIO5;
  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio6Filename))
    which_streams |= STREAMS_AUDIO6;
  if (mplex_audio && (mplex_type != MPEG_VCD) && strlen(Audio7Filename))
    which_streams |= STREAMS_AUDIO7;

  if (!check_files(&audio_bytes, &audio1_bytes, &audio2_bytes, &audio3_bytes, &audio4_bytes, &audio5_bytes,\
	&audio6_bytes, &audio7_bytes, &video_bytes, which_streams))
    return FALSE;

  empty_video_struc(&video_info);
  empty_audio_struc(&audio_info);
  empty_audio_struc(&audio1_info);
  empty_audio_struc(&audio2_info);
  empty_audio_struc(&audio3_info);
  empty_audio_struc(&audio4_info);
  empty_audio_struc(&audio5_info);
  empty_audio_struc(&audio6_info);
  empty_audio_struc(&audio7_info);

  if (which_streams & STREAMS_VIDEO)
  {
      mkstemp(temp_filename_v);    
      video_units = temp_filename_v;
      
      if (!get_info_video (\
		VideoFilename, video_units, &video_info, &startup_delay, &video_total, video_bytes))
		  return FALSE;
      //DisplayProgress("", 0);
  }
  else
      video_total = 0;
  
  if (which_streams & STREAMS_AUDIO)
  {
      mkstemp(temp_filename_a);
      audio_units = temp_filename_a;
      if (!get_info_audio(\
		AudioFilename, audio_units, &audio_info, &startup_delay, &audio_total, audio_bytes))
		  return FALSE;

//      DisplayProgress("", 0);
  }
  else
      audio_total = 0;
  
  if (which_streams & STREAMS_AUDIO1)
  {
      mkstemp(temp_filename_a1);
     audio1_units = temp_filename_a1;
      if (!get_info_audio (\
		Audio1Filename, audio1_units, &audio1_info, &startup_delay, &audio1_total, audio1_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio1_total = 0;
  if (which_streams & STREAMS_AUDIO2)
  {
      mkstemp(temp_filename_a2);
      audio2_units = temp_filename_a2;
      if (!get_info_audio (\
		Audio2Filename, audio2_units, &audio2_info, &startup_delay, &audio2_total, audio2_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio2_total = 0;
  
  if (which_streams & STREAMS_AUDIO3)
  {
      mkstemp(temp_filename_a3);
      audio3_units = temp_filename_a3;
      if (!get_info_audio (\
		Audio3Filename, audio3_units, &audio3_info, &startup_delay, &audio3_total, audio3_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio3_total = 0;
  
  if (which_streams & STREAMS_AUDIO4)
  {
      mkstemp(temp_filename_a4);
      audio4_units = temp_filename_a4;
      if (!get_info_audio (\
		Audio4Filename, audio4_units, &audio4_info, &startup_delay, &audio4_total, audio4_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio4_total = 0;
  
  if (which_streams & STREAMS_AUDIO5)
  {
      mkstemp(temp_filename_a5);
      audio5_units = temp_filename_a5;
      if (!get_info_audio (\
		Audio5Filename, audio5_units, &audio5_info, &startup_delay, &audio5_total, audio5_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio5_total = 0;
  
  if (which_streams & STREAMS_AUDIO6)
  {
      mkstemp(temp_filename_a6);
      audio6_units = temp_filename_a6;
      if (!get_info_audio (\
		Audio6Filename, audio6_units, &audio6_info, &startup_delay, &audio6_total, audio6_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio6_total = 0;
  
  if (which_streams & STREAMS_AUDIO7)
  {
      mkstemp(temp_filename_a7);
      audio7_units = temp_filename_a7;
      if (!get_info_audio (\
		Audio7Filename, audio7_units, &audio7_info, &startup_delay, &audio7_total, audio7_bytes))
		  return FALSE;
//      DisplayProgress("", 0);
  }
  else
      audio7_total = 0;

/*
fprintf(stderr,\
"audio_units=%s audio1_units=%s audio2_units=%s audio3_units=%s audio4_units=%s\n",\
audio_units, audio1_units, audio2_units, audio3_units, audio4_units);

fprintf(stderr,\
"audio5_units=%s audio6_units=%s audio7_units=%s\n",\
audio5_units, audio6_units, audio7_units);

fprintf(stdout, "video_total=%d\n",  video_total );
fprintf(stdout, "audio_total=%d\n",  audio_total );
fprintf(stdout, "audio1_total=%d\n", audio1_total);
fprintf(stdout, "audio2_total=%d\n", audio2_total);
fprintf(stdout, "audio3_total=%d\n", audio3_total);
fprintf(stdout, "audio4_total=%d\n", audio4_total);
fprintf(stdout, "audio5_total=%d\n", audio5_total);
fprintf(stdout, "audio6_total=%d\n", audio6_total);
fprintf(stdout, "audio7_total=%d\n", audio7_total);

if(which_streams & STREAMS_AUDIO) fprintf(stderr, "have audio\n");
if(which_streams & STREAMS_AUDIO1) fprintf(stderr, "have audio1\n");
if(which_streams & STREAMS_AUDIO2) fprintf(stderr, "have audio2\n");
if(which_streams & STREAMS_AUDIO3) fprintf(stderr, "have audio3\n");
if(which_streams & STREAMS_AUDIO4) fprintf(stderr, "have audio4\n");
if(which_streams & STREAMS_AUDIO5) fprintf(stderr, "have audio5\n");
if(which_streams & STREAMS_AUDIO6) fprintf(stderr, "have audio6\n");
if(which_streams & STREAMS_AUDIO7) fprintf(stderr, "have audio7\n");
*/

//exit(1);

  //-- GMO: erster Prameter ist file pointer fuer outfile ! --
  return outputstream (NULL, video_units, &video_info, 
		       audio_units, &audio_info, 
		       audio1_units, &audio1_info, 
		       audio2_units, &audio2_info, 
		       audio3_units, &audio3_info, 
		       audio4_units, &audio4_info, 
		       audio5_units, &audio5_info, 
		       audio6_units, &audio6_info, 
		       audio7_units, &audio7_info, 
				video_total,
				audio_total,
				audio1_total,
				audio2_total,
				audio3_total,
				audio4_total,
				audio5_total,
				audio6_total,
				audio7_total,
				which_streams);
}

