package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeInternal ...
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeInternal}
}

// ConnectionType enumerates the values for connection type.
type ConnectionType string

const (
	// ConnectionTypeNone ...
	ConnectionTypeNone ConnectionType = "None"
	// ConnectionTypePrivate ...
	ConnectionTypePrivate ConnectionType = "Private"
	// ConnectionTypePublic ...
	ConnectionTypePublic ConnectionType = "Public"
)

// PossibleConnectionTypeValues returns an array of possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{ConnectionTypeNone, ConnectionTypePrivate, ConnectionTypePublic}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// CreateOption enumerates the values for create option.
type CreateOption string

const (
	// CreateOptionImage An image is used to create all lab user virtual machines. When this option is set, no
	// template VM will be created.
	CreateOptionImage CreateOption = "Image"
	// CreateOptionTemplateVM A template VM will be used to create all lab user virtual machines.
	CreateOptionTemplateVM CreateOption = "TemplateVM"
)

// PossibleCreateOptionValues returns an array of possible values for the CreateOption const type.
func PossibleCreateOptionValues() []CreateOption {
	return []CreateOption{CreateOptionImage, CreateOptionTemplateVM}
}

// EnableState enumerates the values for enable state.
type EnableState string

const (
	// EnableStateDisabled ...
	EnableStateDisabled EnableState = "Disabled"
	// EnableStateEnabled ...
	EnableStateEnabled EnableState = "Enabled"
)

// PossibleEnableStateValues returns an array of possible values for the EnableState const type.
func PossibleEnableStateValues() []EnableState {
	return []EnableState{EnableStateDisabled, EnableStateEnabled}
}

// InvitationState enumerates the values for invitation state.
type InvitationState string

const (
	// InvitationStateFailed There was an error while sending the invitation.
	InvitationStateFailed InvitationState = "Failed"
	// InvitationStateNotSent The invitation has not been sent.
	InvitationStateNotSent InvitationState = "NotSent"
	// InvitationStateSending Currently sending the invitation.
	InvitationStateSending InvitationState = "Sending"
	// InvitationStateSent The invitation has been successfully sent.
	InvitationStateSent InvitationState = "Sent"
)

// PossibleInvitationStateValues returns an array of possible values for the InvitationState const type.
func PossibleInvitationStateValues() []InvitationState {
	return []InvitationState{InvitationStateFailed, InvitationStateNotSent, InvitationStateSending, InvitationStateSent}
}

// LabState enumerates the values for lab state.
type LabState string

const (
	// LabStateDraft The lab is currently in draft (has not been published).
	LabStateDraft LabState = "Draft"
	// LabStatePublished The lab has been published.
	LabStatePublished LabState = "Published"
	// LabStatePublishing The lab is publishing.
	LabStatePublishing LabState = "Publishing"
	// LabStateScaling The lab is scaling.
	LabStateScaling LabState = "Scaling"
	// LabStateSyncing The lab is syncing users.
	LabStateSyncing LabState = "Syncing"
)

// PossibleLabStateValues returns an array of possible values for the LabState const type.
func PossibleLabStateValues() []LabState {
	return []LabState{LabStateDraft, LabStatePublished, LabStatePublishing, LabStateScaling, LabStateSyncing}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCanceled Not supported yet
	OperationStatusCanceled OperationStatus = "Canceled"
	// OperationStatusFailed The operation failed
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress The operation is running
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusNotStarted The operation has been accepted but hasn't started.
	OperationStatusNotStarted OperationStatus = "NotStarted"
	// OperationStatusSucceeded The operation Succeeded
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCanceled, OperationStatusFailed, OperationStatusInProgress, OperationStatusNotStarted, OperationStatusSucceeded}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginSystem ...
	OriginSystem Origin = "system"
	// OriginUser ...
	OriginUser Origin = "user"
	// OriginUsersystem ...
	OriginUsersystem Origin = "user,system"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginSystem, OriginUser, OriginUsersystem}
}

// OsState enumerates the values for os state.
type OsState string

const (
	// OsStateGeneralized Image does not contain any machine and user specific information.
	OsStateGeneralized OsState = "Generalized"
	// OsStateSpecialized Image contains machine and user specific information.
	OsStateSpecialized OsState = "Specialized"
)

// PossibleOsStateValues returns an array of possible values for the OsState const type.
func PossibleOsStateValues() []OsState {
	return []OsState{OsStateGeneralized, OsStateSpecialized}
}

// OsType enumerates the values for os type.
type OsType string

const (
	// OsTypeLinux ...
	OsTypeLinux OsType = "Linux"
	// OsTypeWindows ...
	OsTypeWindows OsType = "Windows"
)

// PossibleOsTypeValues returns an array of possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{OsTypeLinux, OsTypeWindows}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating Resource is in the process of being created.
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting Resource is in the process of being deleted.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed Previous operation on the resource has failed leaving resource in unhealthy
	// state.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateLocked The resource is locked and changes are currently blocked. This could be due to
	// maintenance or a scheduled operation. The state will go back to succeeded once the locking operation has
	// finished.
	ProvisioningStateLocked ProvisioningState = "Locked"
	// ProvisioningStateSucceeded Resource is in healthy state after creation or update operation.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating New property values are being applied to the resource.
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateLocked, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDaily Schedule will run every days.
	RecurrenceFrequencyDaily RecurrenceFrequency = "Daily"
	// RecurrenceFrequencyWeekly Schedule will run every week on days specified in weekDays.
	RecurrenceFrequencyWeekly RecurrenceFrequency = "Weekly"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDaily, RecurrenceFrequencyWeekly}
}

// RegistrationState enumerates the values for registration state.
type RegistrationState string

const (
	// RegistrationStateNotRegistered User has registered with the lab.
	RegistrationStateNotRegistered RegistrationState = "NotRegistered"
	// RegistrationStateRegistered User has not yet registered with the lab.
	RegistrationStateRegistered RegistrationState = "Registered"
)

// PossibleRegistrationStateValues returns an array of possible values for the RegistrationState const type.
func PossibleRegistrationStateValues() []RegistrationState {
	return []RegistrationState{RegistrationStateNotRegistered, RegistrationStateRegistered}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeSystemAssigned}
}

// RestrictionReasonCode enumerates the values for restriction reason code.
type RestrictionReasonCode string

const (
	// RestrictionReasonCodeNotAvailableForSubscription ...
	RestrictionReasonCodeNotAvailableForSubscription RestrictionReasonCode = "NotAvailableForSubscription"
	// RestrictionReasonCodeQuotaID ...
	RestrictionReasonCodeQuotaID RestrictionReasonCode = "QuotaId"
)

// PossibleRestrictionReasonCodeValues returns an array of possible values for the RestrictionReasonCode const type.
func PossibleRestrictionReasonCodeValues() []RestrictionReasonCode {
	return []RestrictionReasonCode{RestrictionReasonCodeNotAvailableForSubscription, RestrictionReasonCodeQuotaID}
}

// RestrictionType enumerates the values for restriction type.
type RestrictionType string

const (
	// RestrictionTypeLocation ...
	RestrictionTypeLocation RestrictionType = "Location"
)

// PossibleRestrictionTypeValues returns an array of possible values for the RestrictionType const type.
func PossibleRestrictionTypeValues() []RestrictionType {
	return []RestrictionType{RestrictionTypeLocation}
}

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ScaleTypeAutomatic The user is permitted to scale this SKU in and out.
	ScaleTypeAutomatic ScaleType = "Automatic"
	// ScaleTypeManual The user must manually scale this SKU in and out.
	ScaleTypeManual ScaleType = "Manual"
	// ScaleTypeNone The capacity is not adjustable in any way.
	ScaleTypeNone ScaleType = "None"
)

// PossibleScaleTypeValues returns an array of possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{ScaleTypeAutomatic, ScaleTypeManual, ScaleTypeNone}
}

// ShutdownOnIdleMode enumerates the values for shutdown on idle mode.
type ShutdownOnIdleMode string

const (
	// ShutdownOnIdleModeLowUsage The VM will be considered as idle when user is absent and the resource (CPU
	// and disk) consumption is low.
	ShutdownOnIdleModeLowUsage ShutdownOnIdleMode = "LowUsage"
	// ShutdownOnIdleModeNone The VM won't be shut down when it is idle.
	ShutdownOnIdleModeNone ShutdownOnIdleMode = "None"
	// ShutdownOnIdleModeUserAbsence The VM will be considered as idle when there is no keyboard or mouse
	// input.
	ShutdownOnIdleModeUserAbsence ShutdownOnIdleMode = "UserAbsence"
)

// PossibleShutdownOnIdleModeValues returns an array of possible values for the ShutdownOnIdleMode const type.
func PossibleShutdownOnIdleModeValues() []ShutdownOnIdleMode {
	return []ShutdownOnIdleMode{ShutdownOnIdleModeLowUsage, ShutdownOnIdleModeNone, ShutdownOnIdleModeUserAbsence}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierFree ...
	SkuTierFree SkuTier = "Free"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierFree, SkuTierPremium, SkuTierStandard}
}

// SkuTierEnum enumerates the values for sku tier enum.
type SkuTierEnum string

const (
	// SkuTierEnumPremium ...
	SkuTierEnumPremium SkuTierEnum = "Premium"
	// SkuTierEnumStandard ...
	SkuTierEnumStandard SkuTierEnum = "Standard"
)

// PossibleSkuTierEnumValues returns an array of possible values for the SkuTierEnum const type.
func PossibleSkuTierEnumValues() []SkuTierEnum {
	return []SkuTierEnum{SkuTierEnumPremium, SkuTierEnumStandard}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// UsageUnitCount ...
	UsageUnitCount UsageUnit = "Count"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{UsageUnitCount}
}

// VirtualMachineState enumerates the values for virtual machine state.
type VirtualMachineState string

const (
	// VirtualMachineStateRedeploying The VM is being redeployed.
	VirtualMachineStateRedeploying VirtualMachineState = "Redeploying"
	// VirtualMachineStateReimaging The VM is being reimaged.
	VirtualMachineStateReimaging VirtualMachineState = "Reimaging"
	// VirtualMachineStateResettingPassword The VM password is being reset.
	VirtualMachineStateResettingPassword VirtualMachineState = "ResettingPassword"
	// VirtualMachineStateRunning The VM is running.
	VirtualMachineStateRunning VirtualMachineState = "Running"
	// VirtualMachineStateStarting The VM is starting.
	VirtualMachineStateStarting VirtualMachineState = "Starting"
	// VirtualMachineStateStopped The VM is currently stopped.
	VirtualMachineStateStopped VirtualMachineState = "Stopped"
	// VirtualMachineStateStopping The VM is stopping.
	VirtualMachineStateStopping VirtualMachineState = "Stopping"
)

// PossibleVirtualMachineStateValues returns an array of possible values for the VirtualMachineState const type.
func PossibleVirtualMachineStateValues() []VirtualMachineState {
	return []VirtualMachineState{VirtualMachineStateRedeploying, VirtualMachineStateReimaging, VirtualMachineStateResettingPassword, VirtualMachineStateRunning, VirtualMachineStateStarting, VirtualMachineStateStopped, VirtualMachineStateStopping}
}

// VirtualMachineType enumerates the values for virtual machine type.
type VirtualMachineType string

const (
	// VirtualMachineTypeTemplate A template VM
	VirtualMachineTypeTemplate VirtualMachineType = "Template"
	// VirtualMachineTypeUser A user VM
	VirtualMachineTypeUser VirtualMachineType = "User"
)

// PossibleVirtualMachineTypeValues returns an array of possible values for the VirtualMachineType const type.
func PossibleVirtualMachineTypeValues() []VirtualMachineType {
	return []VirtualMachineType{VirtualMachineTypeTemplate, VirtualMachineTypeUser}
}

// WeekDay enumerates the values for week day.
type WeekDay string

const (
	// WeekDayFriday Schedule will run on Friday
	WeekDayFriday WeekDay = "Friday"
	// WeekDayMonday Schedule will run on Monday
	WeekDayMonday WeekDay = "Monday"
	// WeekDaySaturday Schedule will run on Saturday
	WeekDaySaturday WeekDay = "Saturday"
	// WeekDaySunday Schedule will run on Sunday
	WeekDaySunday WeekDay = "Sunday"
	// WeekDayThursday Schedule will run on Thursday
	WeekDayThursday WeekDay = "Thursday"
	// WeekDayTuesday Schedule will run on Tuesday
	WeekDayTuesday WeekDay = "Tuesday"
	// WeekDayWednesday Schedule will run on Wednesday
	WeekDayWednesday WeekDay = "Wednesday"
)

// PossibleWeekDayValues returns an array of possible values for the WeekDay const type.
func PossibleWeekDayValues() []WeekDay {
	return []WeekDay{WeekDayFriday, WeekDayMonday, WeekDaySaturday, WeekDaySunday, WeekDayThursday, WeekDayTuesday, WeekDayWednesday}
}
