// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package chimesdkmeetingsiface provides an interface to enable mocking the Amazon Chime SDK Meetings service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package chimesdkmeetingsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/chimesdkmeetings"
)

// ChimeSDKMeetingsAPI provides an interface to enable mocking the
// chimesdkmeetings.ChimeSDKMeetings service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Chime SDK Meetings.
//    func myFunc(svc chimesdkmeetingsiface.ChimeSDKMeetingsAPI) bool {
//        // Make svc.BatchCreateAttendee request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := chimesdkmeetings.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockChimeSDKMeetingsClient struct {
//        chimesdkmeetingsiface.ChimeSDKMeetingsAPI
//    }
//    func (m *mockChimeSDKMeetingsClient) BatchCreateAttendee(input *chimesdkmeetings.BatchCreateAttendeeInput) (*chimesdkmeetings.BatchCreateAttendeeOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockChimeSDKMeetingsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ChimeSDKMeetingsAPI interface {
	BatchCreateAttendee(*chimesdkmeetings.BatchCreateAttendeeInput) (*chimesdkmeetings.BatchCreateAttendeeOutput, error)
	BatchCreateAttendeeWithContext(aws.Context, *chimesdkmeetings.BatchCreateAttendeeInput, ...request.Option) (*chimesdkmeetings.BatchCreateAttendeeOutput, error)
	BatchCreateAttendeeRequest(*chimesdkmeetings.BatchCreateAttendeeInput) (*request.Request, *chimesdkmeetings.BatchCreateAttendeeOutput)

	CreateAttendee(*chimesdkmeetings.CreateAttendeeInput) (*chimesdkmeetings.CreateAttendeeOutput, error)
	CreateAttendeeWithContext(aws.Context, *chimesdkmeetings.CreateAttendeeInput, ...request.Option) (*chimesdkmeetings.CreateAttendeeOutput, error)
	CreateAttendeeRequest(*chimesdkmeetings.CreateAttendeeInput) (*request.Request, *chimesdkmeetings.CreateAttendeeOutput)

	CreateMeeting(*chimesdkmeetings.CreateMeetingInput) (*chimesdkmeetings.CreateMeetingOutput, error)
	CreateMeetingWithContext(aws.Context, *chimesdkmeetings.CreateMeetingInput, ...request.Option) (*chimesdkmeetings.CreateMeetingOutput, error)
	CreateMeetingRequest(*chimesdkmeetings.CreateMeetingInput) (*request.Request, *chimesdkmeetings.CreateMeetingOutput)

	CreateMeetingWithAttendees(*chimesdkmeetings.CreateMeetingWithAttendeesInput) (*chimesdkmeetings.CreateMeetingWithAttendeesOutput, error)
	CreateMeetingWithAttendeesWithContext(aws.Context, *chimesdkmeetings.CreateMeetingWithAttendeesInput, ...request.Option) (*chimesdkmeetings.CreateMeetingWithAttendeesOutput, error)
	CreateMeetingWithAttendeesRequest(*chimesdkmeetings.CreateMeetingWithAttendeesInput) (*request.Request, *chimesdkmeetings.CreateMeetingWithAttendeesOutput)

	DeleteAttendee(*chimesdkmeetings.DeleteAttendeeInput) (*chimesdkmeetings.DeleteAttendeeOutput, error)
	DeleteAttendeeWithContext(aws.Context, *chimesdkmeetings.DeleteAttendeeInput, ...request.Option) (*chimesdkmeetings.DeleteAttendeeOutput, error)
	DeleteAttendeeRequest(*chimesdkmeetings.DeleteAttendeeInput) (*request.Request, *chimesdkmeetings.DeleteAttendeeOutput)

	DeleteMeeting(*chimesdkmeetings.DeleteMeetingInput) (*chimesdkmeetings.DeleteMeetingOutput, error)
	DeleteMeetingWithContext(aws.Context, *chimesdkmeetings.DeleteMeetingInput, ...request.Option) (*chimesdkmeetings.DeleteMeetingOutput, error)
	DeleteMeetingRequest(*chimesdkmeetings.DeleteMeetingInput) (*request.Request, *chimesdkmeetings.DeleteMeetingOutput)

	GetAttendee(*chimesdkmeetings.GetAttendeeInput) (*chimesdkmeetings.GetAttendeeOutput, error)
	GetAttendeeWithContext(aws.Context, *chimesdkmeetings.GetAttendeeInput, ...request.Option) (*chimesdkmeetings.GetAttendeeOutput, error)
	GetAttendeeRequest(*chimesdkmeetings.GetAttendeeInput) (*request.Request, *chimesdkmeetings.GetAttendeeOutput)

	GetMeeting(*chimesdkmeetings.GetMeetingInput) (*chimesdkmeetings.GetMeetingOutput, error)
	GetMeetingWithContext(aws.Context, *chimesdkmeetings.GetMeetingInput, ...request.Option) (*chimesdkmeetings.GetMeetingOutput, error)
	GetMeetingRequest(*chimesdkmeetings.GetMeetingInput) (*request.Request, *chimesdkmeetings.GetMeetingOutput)

	ListAttendees(*chimesdkmeetings.ListAttendeesInput) (*chimesdkmeetings.ListAttendeesOutput, error)
	ListAttendeesWithContext(aws.Context, *chimesdkmeetings.ListAttendeesInput, ...request.Option) (*chimesdkmeetings.ListAttendeesOutput, error)
	ListAttendeesRequest(*chimesdkmeetings.ListAttendeesInput) (*request.Request, *chimesdkmeetings.ListAttendeesOutput)

	ListAttendeesPages(*chimesdkmeetings.ListAttendeesInput, func(*chimesdkmeetings.ListAttendeesOutput, bool) bool) error
	ListAttendeesPagesWithContext(aws.Context, *chimesdkmeetings.ListAttendeesInput, func(*chimesdkmeetings.ListAttendeesOutput, bool) bool, ...request.Option) error

	StartMeetingTranscription(*chimesdkmeetings.StartMeetingTranscriptionInput) (*chimesdkmeetings.StartMeetingTranscriptionOutput, error)
	StartMeetingTranscriptionWithContext(aws.Context, *chimesdkmeetings.StartMeetingTranscriptionInput, ...request.Option) (*chimesdkmeetings.StartMeetingTranscriptionOutput, error)
	StartMeetingTranscriptionRequest(*chimesdkmeetings.StartMeetingTranscriptionInput) (*request.Request, *chimesdkmeetings.StartMeetingTranscriptionOutput)

	StopMeetingTranscription(*chimesdkmeetings.StopMeetingTranscriptionInput) (*chimesdkmeetings.StopMeetingTranscriptionOutput, error)
	StopMeetingTranscriptionWithContext(aws.Context, *chimesdkmeetings.StopMeetingTranscriptionInput, ...request.Option) (*chimesdkmeetings.StopMeetingTranscriptionOutput, error)
	StopMeetingTranscriptionRequest(*chimesdkmeetings.StopMeetingTranscriptionInput) (*request.Request, *chimesdkmeetings.StopMeetingTranscriptionOutput)
}

var _ ChimeSDKMeetingsAPI = (*chimesdkmeetings.ChimeSDKMeetings)(nil)
