// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarnotifications

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateNotificationRule = "CreateNotificationRule"

// CreateNotificationRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotificationRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotificationRule for more information on using the CreateNotificationRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotificationRuleRequest method.
//    req, resp := client.CreateNotificationRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/CreateNotificationRule
func (c *CodeStarNotifications) CreateNotificationRuleRequest(input *CreateNotificationRuleInput) (req *request.Request, output *CreateNotificationRuleOutput) {
	op := &request.Operation{
		Name:       opCreateNotificationRule,
		HTTPMethod: "POST",
		HTTPPath:   "/createNotificationRule",
	}

	if input == nil {
		input = &CreateNotificationRuleInput{}
	}

	output = &CreateNotificationRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotificationRule API operation for AWS CodeStar Notifications.
//
// Creates a notification rule for a resource. The rule specifies the events
// you want notifications about and the targets (such as SNS topics) where you
// want to receive them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation CreateNotificationRule for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   A resource with the same name or ID already exists. Notification rule names
//   must be unique in your AWS account.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
//   * LimitExceededException
//   One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
//   to accounts, notification rules, notifications, resources, and targets. For
//   more information, see Limits.
//
//   * ConfigurationException
//   Some or all of the configuration is incomplete, missing, or not valid.
//
//   * ConcurrentModificationException
//   AWS CodeStar Notifications can't complete the request because the resource
//   is being modified by another process. Wait a few minutes and try again.
//
//   * AccessDeniedException
//   AWS CodeStar Notifications can't create the notification rule because you
//   do not have sufficient permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/CreateNotificationRule
func (c *CodeStarNotifications) CreateNotificationRule(input *CreateNotificationRuleInput) (*CreateNotificationRuleOutput, error) {
	req, out := c.CreateNotificationRuleRequest(input)
	return out, req.Send()
}

// CreateNotificationRuleWithContext is the same as CreateNotificationRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotificationRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) CreateNotificationRuleWithContext(ctx aws.Context, input *CreateNotificationRuleInput, opts ...request.Option) (*CreateNotificationRuleOutput, error) {
	req, out := c.CreateNotificationRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotificationRule = "DeleteNotificationRule"

// DeleteNotificationRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotificationRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotificationRule for more information on using the DeleteNotificationRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotificationRuleRequest method.
//    req, resp := client.DeleteNotificationRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteNotificationRule
func (c *CodeStarNotifications) DeleteNotificationRuleRequest(input *DeleteNotificationRuleInput) (req *request.Request, output *DeleteNotificationRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationRule,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteNotificationRule",
	}

	if input == nil {
		input = &DeleteNotificationRuleInput{}
	}

	output = &DeleteNotificationRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNotificationRule API operation for AWS CodeStar Notifications.
//
// Deletes a notification rule for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation DeleteNotificationRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   One or more parameter values are not valid.
//
//   * LimitExceededException
//   One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
//   to accounts, notification rules, notifications, resources, and targets. For
//   more information, see Limits.
//
//   * ConcurrentModificationException
//   AWS CodeStar Notifications can't complete the request because the resource
//   is being modified by another process. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteNotificationRule
func (c *CodeStarNotifications) DeleteNotificationRule(input *DeleteNotificationRuleInput) (*DeleteNotificationRuleOutput, error) {
	req, out := c.DeleteNotificationRuleRequest(input)
	return out, req.Send()
}

// DeleteNotificationRuleWithContext is the same as DeleteNotificationRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotificationRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) DeleteNotificationRuleWithContext(ctx aws.Context, input *DeleteNotificationRuleInput, opts ...request.Option) (*DeleteNotificationRuleOutput, error) {
	req, out := c.DeleteNotificationRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTarget = "DeleteTarget"

// DeleteTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTarget for more information on using the DeleteTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTargetRequest method.
//    req, resp := client.DeleteTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteTarget
func (c *CodeStarNotifications) DeleteTargetRequest(input *DeleteTargetInput) (req *request.Request, output *DeleteTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteTarget",
	}

	if input == nil {
		input = &DeleteTargetInput{}
	}

	output = &DeleteTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTarget API operation for AWS CodeStar Notifications.
//
// Deletes a specified target for notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation DeleteTarget for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteTarget
func (c *CodeStarNotifications) DeleteTarget(input *DeleteTargetInput) (*DeleteTargetOutput, error) {
	req, out := c.DeleteTargetRequest(input)
	return out, req.Send()
}

// DeleteTargetWithContext is the same as DeleteTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) DeleteTargetWithContext(ctx aws.Context, input *DeleteTargetInput, opts ...request.Option) (*DeleteTargetOutput, error) {
	req, out := c.DeleteTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotificationRule = "DescribeNotificationRule"

// DescribeNotificationRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotificationRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotificationRule for more information on using the DescribeNotificationRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotificationRuleRequest method.
//    req, resp := client.DescribeNotificationRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DescribeNotificationRule
func (c *CodeStarNotifications) DescribeNotificationRuleRequest(input *DescribeNotificationRuleInput) (req *request.Request, output *DescribeNotificationRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeNotificationRule,
		HTTPMethod: "POST",
		HTTPPath:   "/describeNotificationRule",
	}

	if input == nil {
		input = &DescribeNotificationRuleInput{}
	}

	output = &DescribeNotificationRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotificationRule API operation for AWS CodeStar Notifications.
//
// Returns information about a specified notification rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation DescribeNotificationRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   AWS CodeStar Notifications can't find a resource that matches the provided
//   ARN.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DescribeNotificationRule
func (c *CodeStarNotifications) DescribeNotificationRule(input *DescribeNotificationRuleInput) (*DescribeNotificationRuleOutput, error) {
	req, out := c.DescribeNotificationRuleRequest(input)
	return out, req.Send()
}

// DescribeNotificationRuleWithContext is the same as DescribeNotificationRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotificationRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) DescribeNotificationRuleWithContext(ctx aws.Context, input *DescribeNotificationRuleInput, opts ...request.Option) (*DescribeNotificationRuleOutput, error) {
	req, out := c.DescribeNotificationRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventTypes = "ListEventTypes"

// ListEventTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListEventTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventTypes for more information on using the ListEventTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventTypesRequest method.
//    req, resp := client.ListEventTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListEventTypes
func (c *CodeStarNotifications) ListEventTypesRequest(input *ListEventTypesInput) (req *request.Request, output *ListEventTypesOutput) {
	op := &request.Operation{
		Name:       opListEventTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/listEventTypes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventTypesInput{}
	}

	output = &ListEventTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventTypes API operation for AWS CodeStar Notifications.
//
// Returns information about the event types available for configuring notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation ListEventTypes for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value for the enumeration token used in the request to return the next
//   batch of the results is not valid.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListEventTypes
func (c *CodeStarNotifications) ListEventTypes(input *ListEventTypesInput) (*ListEventTypesOutput, error) {
	req, out := c.ListEventTypesRequest(input)
	return out, req.Send()
}

// ListEventTypesWithContext is the same as ListEventTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListEventTypesWithContext(ctx aws.Context, input *ListEventTypesInput, opts ...request.Option) (*ListEventTypesOutput, error) {
	req, out := c.ListEventTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventTypesPages iterates over the pages of a ListEventTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventTypes operation.
//    pageNum := 0
//    err := client.ListEventTypesPages(params,
//        func(page *codestarnotifications.ListEventTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeStarNotifications) ListEventTypesPages(input *ListEventTypesInput, fn func(*ListEventTypesOutput, bool) bool) error {
	return c.ListEventTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventTypesPagesWithContext same as ListEventTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListEventTypesPagesWithContext(ctx aws.Context, input *ListEventTypesInput, fn func(*ListEventTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotificationRules = "ListNotificationRules"

// ListNotificationRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListNotificationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotificationRules for more information on using the ListNotificationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotificationRulesRequest method.
//    req, resp := client.ListNotificationRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListNotificationRules
func (c *CodeStarNotifications) ListNotificationRulesRequest(input *ListNotificationRulesInput) (req *request.Request, output *ListNotificationRulesOutput) {
	op := &request.Operation{
		Name:       opListNotificationRules,
		HTTPMethod: "POST",
		HTTPPath:   "/listNotificationRules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationRulesInput{}
	}

	output = &ListNotificationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotificationRules API operation for AWS CodeStar Notifications.
//
// Returns a list of the notification rules for an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation ListNotificationRules for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value for the enumeration token used in the request to return the next
//   batch of the results is not valid.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListNotificationRules
func (c *CodeStarNotifications) ListNotificationRules(input *ListNotificationRulesInput) (*ListNotificationRulesOutput, error) {
	req, out := c.ListNotificationRulesRequest(input)
	return out, req.Send()
}

// ListNotificationRulesWithContext is the same as ListNotificationRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotificationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListNotificationRulesWithContext(ctx aws.Context, input *ListNotificationRulesInput, opts ...request.Option) (*ListNotificationRulesOutput, error) {
	req, out := c.ListNotificationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationRulesPages iterates over the pages of a ListNotificationRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotificationRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotificationRules operation.
//    pageNum := 0
//    err := client.ListNotificationRulesPages(params,
//        func(page *codestarnotifications.ListNotificationRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeStarNotifications) ListNotificationRulesPages(input *ListNotificationRulesInput, fn func(*ListNotificationRulesOutput, bool) bool) error {
	return c.ListNotificationRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationRulesPagesWithContext same as ListNotificationRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListNotificationRulesPagesWithContext(ctx aws.Context, input *ListNotificationRulesInput, fn func(*ListNotificationRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTagsForResource
func (c *CodeStarNotifications) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/listTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS CodeStar Notifications.
//
// Returns a list of the tags associated with a notification rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   AWS CodeStar Notifications can't find a resource that matches the provided
//   ARN.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTagsForResource
func (c *CodeStarNotifications) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargets = "ListTargets"

// ListTargetsRequest generates a "aws/request.Request" representing the
// client's request for the ListTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargets for more information on using the ListTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsRequest method.
//    req, resp := client.ListTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets
func (c *CodeStarNotifications) ListTargetsRequest(input *ListTargetsInput) (req *request.Request, output *ListTargetsOutput) {
	op := &request.Operation{
		Name:       opListTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/listTargets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetsInput{}
	}

	output = &ListTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargets API operation for AWS CodeStar Notifications.
//
// Returns a list of the notification rule targets for an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation ListTargets for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value for the enumeration token used in the request to return the next
//   batch of the results is not valid.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/ListTargets
func (c *CodeStarNotifications) ListTargets(input *ListTargetsInput) (*ListTargetsOutput, error) {
	req, out := c.ListTargetsRequest(input)
	return out, req.Send()
}

// ListTargetsWithContext is the same as ListTargets with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListTargetsWithContext(ctx aws.Context, input *ListTargetsInput, opts ...request.Option) (*ListTargetsOutput, error) {
	req, out := c.ListTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetsPages iterates over the pages of a ListTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTargets operation.
//    pageNum := 0
//    err := client.ListTargetsPages(params,
//        func(page *codestarnotifications.ListTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeStarNotifications) ListTargetsPages(input *ListTargetsInput, fn func(*ListTargetsOutput, bool) bool) error {
	return c.ListTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetsPagesWithContext same as ListTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) ListTargetsPagesWithContext(ctx aws.Context, input *ListTargetsInput, fn func(*ListTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSubscribe = "Subscribe"

// SubscribeRequest generates a "aws/request.Request" representing the
// client's request for the Subscribe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Subscribe for more information on using the Subscribe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SubscribeRequest method.
//    req, resp := client.SubscribeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Subscribe
func (c *CodeStarNotifications) SubscribeRequest(input *SubscribeInput) (req *request.Request, output *SubscribeOutput) {
	op := &request.Operation{
		Name:       opSubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/subscribe",
	}

	if input == nil {
		input = &SubscribeInput{}
	}

	output = &SubscribeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Subscribe API operation for AWS CodeStar Notifications.
//
// Creates an association between a notification rule and an SNS topic so that
// the associated target can receive notifications when the events described
// in the rule are triggered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation Subscribe for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   AWS CodeStar Notifications can't find a resource that matches the provided
//   ARN.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Subscribe
func (c *CodeStarNotifications) Subscribe(input *SubscribeInput) (*SubscribeOutput, error) {
	req, out := c.SubscribeRequest(input)
	return out, req.Send()
}

// SubscribeWithContext is the same as Subscribe with the addition of
// the ability to pass a context and additional request options.
//
// See Subscribe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) SubscribeWithContext(ctx aws.Context, input *SubscribeInput, opts ...request.Option) (*SubscribeOutput, error) {
	req, out := c.SubscribeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/TagResource
func (c *CodeStarNotifications) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for AWS CodeStar Notifications.
//
// Associates a set of provided tags with a notification rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   AWS CodeStar Notifications can't find a resource that matches the provided
//   ARN.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
//   * ConcurrentModificationException
//   AWS CodeStar Notifications can't complete the request because the resource
//   is being modified by another process. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/TagResource
func (c *CodeStarNotifications) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnsubscribe = "Unsubscribe"

// UnsubscribeRequest generates a "aws/request.Request" representing the
// client's request for the Unsubscribe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Unsubscribe for more information on using the Unsubscribe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnsubscribeRequest method.
//    req, resp := client.UnsubscribeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Unsubscribe
func (c *CodeStarNotifications) UnsubscribeRequest(input *UnsubscribeInput) (req *request.Request, output *UnsubscribeOutput) {
	op := &request.Operation{
		Name:       opUnsubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/unsubscribe",
	}

	if input == nil {
		input = &UnsubscribeInput{}
	}

	output = &UnsubscribeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Unsubscribe API operation for AWS CodeStar Notifications.
//
// Removes an association between a notification rule and an Amazon SNS topic
// so that subscribers to that topic stop receiving notifications when the events
// described in the rule are triggered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation Unsubscribe for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/Unsubscribe
func (c *CodeStarNotifications) Unsubscribe(input *UnsubscribeInput) (*UnsubscribeOutput, error) {
	req, out := c.UnsubscribeRequest(input)
	return out, req.Send()
}

// UnsubscribeWithContext is the same as Unsubscribe with the addition of
// the ability to pass a context and additional request options.
//
// See Unsubscribe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) UnsubscribeWithContext(ctx aws.Context, input *UnsubscribeInput, opts ...request.Option) (*UnsubscribeOutput, error) {
	req, out := c.UnsubscribeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UntagResource
func (c *CodeStarNotifications) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS CodeStar Notifications.
//
// Removes the association between one or more provided tags and a notification
// rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   AWS CodeStar Notifications can't find a resource that matches the provided
//   ARN.
//
//   * ValidationException
//   One or more parameter values are not valid.
//
//   * ConcurrentModificationException
//   AWS CodeStar Notifications can't complete the request because the resource
//   is being modified by another process. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UntagResource
func (c *CodeStarNotifications) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotificationRule = "UpdateNotificationRule"

// UpdateNotificationRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotificationRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotificationRule for more information on using the UpdateNotificationRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotificationRuleRequest method.
//    req, resp := client.UpdateNotificationRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UpdateNotificationRule
func (c *CodeStarNotifications) UpdateNotificationRuleRequest(input *UpdateNotificationRuleInput) (req *request.Request, output *UpdateNotificationRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateNotificationRule,
		HTTPMethod: "POST",
		HTTPPath:   "/updateNotificationRule",
	}

	if input == nil {
		input = &UpdateNotificationRuleInput{}
	}

	output = &UpdateNotificationRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotificationRule API operation for AWS CodeStar Notifications.
//
// Updates a notification rule for a resource. You can change the events that
// trigger the notification rule, the status of the rule, and the targets that
// receive the notifications.
//
// To add or remove tags for a notification rule, you must use TagResource and
// UntagResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar Notifications's
// API operation UpdateNotificationRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   AWS CodeStar Notifications can't find a resource that matches the provided
//   ARN.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/UpdateNotificationRule
func (c *CodeStarNotifications) UpdateNotificationRule(input *UpdateNotificationRuleInput) (*UpdateNotificationRuleOutput, error) {
	req, out := c.UpdateNotificationRuleRequest(input)
	return out, req.Send()
}

// UpdateNotificationRuleWithContext is the same as UpdateNotificationRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotificationRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStarNotifications) UpdateNotificationRuleWithContext(ctx aws.Context, input *UpdateNotificationRuleInput, opts ...request.Option) (*UpdateNotificationRuleOutput, error) {
	req, out := c.UpdateNotificationRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// AWS CodeStar Notifications can't create the notification rule because you
// do not have sufficient permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS CodeStar Notifications can't complete the request because the resource
// is being modified by another process. Wait a few minutes and try again.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Some or all of the configuration is incomplete, missing, or not valid.
type ConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationException) GoString() string {
	return s.String()
}

func newErrorConfigurationException(v protocol.ResponseMetadata) error {
	return &ConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConfigurationException) Code() string {
	return "ConfigurationException"
}

// Message returns the exception's message.
func (s *ConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConfigurationException) OrigErr() error {
	return nil
}

func (s *ConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateNotificationRuleInput struct {
	_ struct{} `type:"structure"`

	// A unique, client-generated idempotency token that, when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// with the same parameters is received and a token is included, the request
	// returns information about the initial request that used that token.
	//
	// The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK,
	// an idempotency token is created for you.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The level of detail to include in the notifications for this resource. BASIC
	// will include only the contents of the event as it would appear in AWS CloudWatch.
	// FULL will include any supplemental information provided by AWS CodeStar Notifications
	// and/or the service for the resource for which the notification is created.
	//
	// DetailType is a required field
	DetailType *string `type:"string" required:"true" enum:"DetailType"`

	// A list of event types associated with this notification rule. For a list
	// of allowed events, see EventTypeSummary.
	//
	// EventTypeIds is a required field
	EventTypeIds []*string `type:"list" required:"true"`

	// The name for the notification rule. Notifictaion rule names must be unique
	// in your AWS account.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNotificationRuleInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the resource to associate with the notification
	// rule. Supported resources include pipelines in AWS CodePipeline, repositories
	// in AWS CodeCommit, and build projects in AWS CodeBuild.
	//
	// Resource is a required field
	Resource *string `type:"string" required:"true"`

	// The status of the notification rule. The default value is ENABLED. If the
	// status is set to DISABLED, notifications aren't sent for the notification
	// rule.
	Status *string `type:"string" enum:"NotificationRuleStatus"`

	// A list of tags to apply to this notification rule. Key names cannot start
	// with "aws".
	Tags map[string]*string `type:"map"`

	// A list of Amazon Resource Names (ARNs) of SNS topics to associate with the
	// notification rule.
	//
	// Targets is a required field
	Targets []*Target `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNotificationRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNotificationRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotificationRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotificationRuleInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DetailType == nil {
		invalidParams.Add(request.NewErrParamRequired("DetailType"))
	}
	if s.EventTypeIds == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeIds"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNotificationRuleInput) SetClientRequestToken(v string) *CreateNotificationRuleInput {
	s.ClientRequestToken = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *CreateNotificationRuleInput) SetDetailType(v string) *CreateNotificationRuleInput {
	s.DetailType = &v
	return s
}

// SetEventTypeIds sets the EventTypeIds field's value.
func (s *CreateNotificationRuleInput) SetEventTypeIds(v []*string) *CreateNotificationRuleInput {
	s.EventTypeIds = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNotificationRuleInput) SetName(v string) *CreateNotificationRuleInput {
	s.Name = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *CreateNotificationRuleInput) SetResource(v string) *CreateNotificationRuleInput {
	s.Resource = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateNotificationRuleInput) SetStatus(v string) *CreateNotificationRuleInput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNotificationRuleInput) SetTags(v map[string]*string) *CreateNotificationRuleInput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateNotificationRuleInput) SetTargets(v []*Target) *CreateNotificationRuleInput {
	s.Targets = v
	return s
}

type CreateNotificationRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNotificationRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNotificationRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateNotificationRuleOutput) SetArn(v string) *CreateNotificationRuleOutput {
	s.Arn = &v
	return s
}

type DeleteNotificationRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule you want to delete.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotificationRuleInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteNotificationRuleInput) SetArn(v string) *DeleteNotificationRuleInput {
	s.Arn = &v
	return s
}

type DeleteNotificationRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted notification rule.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteNotificationRuleOutput) SetArn(v string) *DeleteNotificationRuleOutput {
	s.Arn = &v
	return s
}

type DeleteTargetInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that can be used to delete all associations with this SNS
	// topic. The default value is FALSE. If set to TRUE, all associations between
	// that target and every notification rule in your AWS account are deleted.
	ForceUnsubscribeAll *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the SNS topic to delete.
	//
	// TargetAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteTargetInput's
	// String and GoString methods.
	//
	// TargetAddress is a required field
	TargetAddress *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTargetInput"}
	if s.TargetAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAddress"))
	}
	if s.TargetAddress != nil && len(*s.TargetAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceUnsubscribeAll sets the ForceUnsubscribeAll field's value.
func (s *DeleteTargetInput) SetForceUnsubscribeAll(v bool) *DeleteTargetInput {
	s.ForceUnsubscribeAll = &v
	return s
}

// SetTargetAddress sets the TargetAddress field's value.
func (s *DeleteTargetInput) SetTargetAddress(v string) *DeleteTargetInput {
	s.TargetAddress = &v
	return s
}

type DeleteTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTargetOutput) GoString() string {
	return s.String()
}

type DescribeNotificationRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotificationRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotificationRuleInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DescribeNotificationRuleInput) SetArn(v string) *DescribeNotificationRuleInput {
	s.Arn = &v
	return s
}

type DescribeNotificationRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name or email alias of the person who created the notification rule.
	CreatedBy *string `min:"1" type:"string"`

	// The date and time the notification rule was created, in timestamp format.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The level of detail included in the notifications for this resource. BASIC
	// will include only the contents of the event as it would appear in AWS CloudWatch.
	// FULL will include any supplemental information provided by AWS CodeStar Notifications
	// and/or the service for the resource for which the notification is created.
	DetailType *string `type:"string" enum:"DetailType"`

	// A list of the event types associated with the notification rule.
	EventTypes []*EventTypeSummary `type:"list"`

	// The date and time the notification rule was most recently updated, in timestamp
	// format.
	LastModifiedTimestamp *time.Time `type:"timestamp"`

	// The name of the notification rule.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeNotificationRuleOutput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the resource associated with the notification
	// rule.
	Resource *string `type:"string"`

	// The status of the notification rule. Valid statuses are on (sending notifications)
	// or off (not sending notifications).
	Status *string `type:"string" enum:"NotificationRuleStatus"`

	// The tags associated with the notification rule.
	Tags map[string]*string `type:"map"`

	// A list of the SNS topics associated with the notification rule.
	Targets []*TargetSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeNotificationRuleOutput) SetArn(v string) *DescribeNotificationRuleOutput {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeNotificationRuleOutput) SetCreatedBy(v string) *DescribeNotificationRuleOutput {
	s.CreatedBy = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DescribeNotificationRuleOutput) SetCreatedTimestamp(v time.Time) *DescribeNotificationRuleOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *DescribeNotificationRuleOutput) SetDetailType(v string) *DescribeNotificationRuleOutput {
	s.DetailType = &v
	return s
}

// SetEventTypes sets the EventTypes field's value.
func (s *DescribeNotificationRuleOutput) SetEventTypes(v []*EventTypeSummary) *DescribeNotificationRuleOutput {
	s.EventTypes = v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *DescribeNotificationRuleOutput) SetLastModifiedTimestamp(v time.Time) *DescribeNotificationRuleOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeNotificationRuleOutput) SetName(v string) *DescribeNotificationRuleOutput {
	s.Name = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *DescribeNotificationRuleOutput) SetResource(v string) *DescribeNotificationRuleOutput {
	s.Resource = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeNotificationRuleOutput) SetStatus(v string) *DescribeNotificationRuleOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeNotificationRuleOutput) SetTags(v map[string]*string) *DescribeNotificationRuleOutput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *DescribeNotificationRuleOutput) SetTargets(v []*TargetSummary) *DescribeNotificationRuleOutput {
	s.Targets = v
	return s
}

// Returns information about an event that has triggered a notification rule.
type EventTypeSummary struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the event.
	EventTypeId *string `min:"1" type:"string"`

	// The name of the event.
	EventTypeName *string `type:"string"`

	// The resource type of the event.
	ResourceType *string `min:"1" type:"string"`

	// The name of the service for which the event applies.
	ServiceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventTypeSummary) GoString() string {
	return s.String()
}

// SetEventTypeId sets the EventTypeId field's value.
func (s *EventTypeSummary) SetEventTypeId(v string) *EventTypeSummary {
	s.EventTypeId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *EventTypeSummary) SetEventTypeName(v string) *EventTypeSummary {
	s.EventTypeName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *EventTypeSummary) SetResourceType(v string) *EventTypeSummary {
	s.ResourceType = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *EventTypeSummary) SetServiceName(v string) *EventTypeSummary {
	s.ServiceName = &v
	return s
}

// The value for the enumeration token used in the request to return the next
// batch of the results is not valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One of the AWS CodeStar Notifications limits has been exceeded. Limits apply
// to accounts, notification rules, notifications, resources, and targets. For
// more information, see Limits.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a filter to apply to the list of returned event types.
// You can filter by resource type or service name.
type ListEventTypesFilter struct {
	_ struct{} `type:"structure"`

	// The system-generated name of the filter type you want to filter by.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ListEventTypesFilterName"`

	// The name of the resource type (for example, pipeline) or service name (for
	// example, CodePipeline) that you want to filter by.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTypesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTypesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventTypesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventTypesFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ListEventTypesFilter) SetName(v string) *ListEventTypesFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListEventTypesFilter) SetValue(v string) *ListEventTypesFilter {
	s.Value = &v
	return s
}

type ListEventTypesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to return information by service or resource type.
	Filters []*ListEventTypesFilter `type:"list"`

	// A non-negative integer used to limit the number of returned results. The
	// default number is 50. The maximum number of results that can be returned
	// is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListEventTypesInput) SetFilters(v []*ListEventTypesFilter) *ListEventTypesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventTypesInput) SetMaxResults(v int64) *ListEventTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventTypesInput) SetNextToken(v string) *ListEventTypesInput {
	s.NextToken = &v
	return s
}

type ListEventTypesOutput struct {
	_ struct{} `type:"structure"`

	// Information about each event, including service name, resource type, event
	// ID, and event name.
	EventTypes []*EventTypeSummary `type:"list"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventTypesOutput) GoString() string {
	return s.String()
}

// SetEventTypes sets the EventTypes field's value.
func (s *ListEventTypesOutput) SetEventTypes(v []*EventTypeSummary) *ListEventTypesOutput {
	s.EventTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventTypesOutput) SetNextToken(v string) *ListEventTypesOutput {
	s.NextToken = &v
	return s
}

// Information about a filter to apply to the list of returned notification
// rules. You can filter by event type, owner, resource, or target.
type ListNotificationRulesFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute you want to use to filter the returned notification
	// rules.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ListNotificationRulesFilterName"`

	// The value of the attribute you want to use to filter the returned notification
	// rules. For example, if you specify filtering by RESOURCE in Name, you might
	// specify the ARN of a pipeline in AWS CodePipeline for the value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationRulesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationRulesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationRulesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationRulesFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ListNotificationRulesFilter) SetName(v string) *ListNotificationRulesFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListNotificationRulesFilter) SetValue(v string) *ListNotificationRulesFilter {
	s.Value = &v
	return s
}

type ListNotificationRulesInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to return information by service or resource type. For
	// valid values, see ListNotificationRulesFilter.
	//
	// A filter with the same name can appear more than once when used with OR statements.
	// Filters with different names should be applied with AND statements.
	Filters []*ListNotificationRulesFilter `type:"list"`

	// A non-negative integer used to limit the number of returned results. The
	// maximum number of results that can be returned is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListNotificationRulesInput) SetFilters(v []*ListNotificationRulesFilter) *ListNotificationRulesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNotificationRulesInput) SetMaxResults(v int64) *ListNotificationRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationRulesInput) SetNextToken(v string) *ListNotificationRulesInput {
	s.NextToken = &v
	return s
}

type ListNotificationRulesOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `type:"string"`

	// The list of notification rules for the AWS account, by Amazon Resource Name
	// (ARN) and ID.
	NotificationRules []*NotificationRuleSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNotificationRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationRulesOutput) SetNextToken(v string) *ListNotificationRulesOutput {
	s.NextToken = &v
	return s
}

// SetNotificationRules sets the NotificationRules field's value.
func (s *ListNotificationRulesOutput) SetNotificationRules(v []*NotificationRuleSummary) *ListNotificationRulesOutput {
	s.NotificationRules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the notification rule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the notification rule.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about a filter to apply to the list of returned targets. You
// can filter by target type, address, or status. For example, to filter results
// to notification rules that have active Amazon SNS topics as targets, you
// could specify a ListTargetsFilter Name as TargetType and a Value of SNS,
// and a Name of TARGET_STATUS and a Value of ACTIVE.
type ListTargetsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the attribute you want to use to filter the returned targets.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ListTargetsFilterName"`

	// The value of the attribute you want to use to filter the returned targets.
	// For example, if you specify SNS for the Target type, you could specify an
	// Amazon Resource Name (ARN) for a topic as the value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ListTargetsFilter) SetName(v string) *ListTargetsFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListTargetsFilter) SetValue(v string) *ListTargetsFilter {
	s.Value = &v
	return s
}

type ListTargetsInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to return information by service or resource type. Valid
	// filters include target type, target address, and target status.
	//
	// A filter with the same name can appear more than once when used with OR statements.
	// Filters with different names should be applied with AND statements.
	Filters []*ListTargetsFilter `type:"list"`

	// A non-negative integer used to limit the number of returned results. The
	// maximum number of results that can be returned is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListTargetsInput) SetFilters(v []*ListTargetsFilter) *ListTargetsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetsInput) SetMaxResults(v int64) *ListTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsInput) SetNextToken(v string) *ListTargetsInput {
	s.NextToken = &v
	return s
}

type ListTargetsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that can be used in a request to return the next batch
	// of results.
	NextToken *string `type:"string"`

	// The list of notification rule targets.
	Targets []*TargetSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsOutput) SetNextToken(v string) *ListTargetsOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsOutput) SetTargets(v []*TargetSummary) *ListTargetsOutput {
	s.Targets = v
	return s
}

// Information about a specified notification rule.
type NotificationRuleSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	Arn *string `type:"string"`

	// The unique ID of the notification rule.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationRuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationRuleSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NotificationRuleSummary) SetArn(v string) *NotificationRuleSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *NotificationRuleSummary) SetId(v string) *NotificationRuleSummary {
	s.Id = &v
	return s
}

// A resource with the same name or ID already exists. Notification rule names
// must be unique in your AWS account.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS CodeStar Notifications can't find a resource that matches the provided
// ARN.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubscribeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule for which you want
	// to create the association.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	ClientRequestToken *string `min:"1" type:"string"`

	// Information about the SNS topics associated with a notification rule.
	//
	// Target is a required field
	Target *Target `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscribeInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *SubscribeInput) SetArn(v string) *SubscribeInput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *SubscribeInput) SetClientRequestToken(v string) *SubscribeInput {
	s.ClientRequestToken = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *SubscribeInput) SetTarget(v *Target) *SubscribeInput {
	s.Target = v
	return s
}

type SubscribeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule for which you have
	// created assocations.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SubscribeOutput) SetArn(v string) *SubscribeOutput {
	s.Arn = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule to tag.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The list of tags to associate with the resource. Tag key names cannot start
	// with "aws".
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags associated with the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *TagResourceOutput) SetTags(v map[string]*string) *TagResourceOutput {
	s.Tags = v
	return s
}

// Information about the SNS topics associated with a notification rule.
type Target struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SNS topic.
	//
	// TargetAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Target's
	// String and GoString methods.
	TargetAddress *string `min:"1" type:"string" sensitive:"true"`

	// The target type. Can be an Amazon SNS topic.
	TargetType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.TargetAddress != nil && len(*s.TargetAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetAddress sets the TargetAddress field's value.
func (s *Target) SetTargetAddress(v string) *Target {
	s.TargetAddress = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *Target) SetTargetType(v string) *Target {
	s.TargetType = &v
	return s
}

// Information about the targets specified for a notification rule.
type TargetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SNS topic.
	//
	// TargetAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TargetSummary's
	// String and GoString methods.
	TargetAddress *string `min:"1" type:"string" sensitive:"true"`

	// The status of the target.
	TargetStatus *string `type:"string" enum:"TargetStatus"`

	// The type of the target (for example, SNS).
	TargetType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetSummary) GoString() string {
	return s.String()
}

// SetTargetAddress sets the TargetAddress field's value.
func (s *TargetSummary) SetTargetAddress(v string) *TargetSummary {
	s.TargetAddress = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *TargetSummary) SetTargetStatus(v string) *TargetSummary {
	s.TargetStatus = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *TargetSummary) SetTargetType(v string) *TargetSummary {
	s.TargetType = &v
	return s
}

type UnsubscribeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The ARN of the SNS topic to unsubscribe from the notification rule.
	//
	// TargetAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UnsubscribeInput's
	// String and GoString methods.
	//
	// TargetAddress is a required field
	TargetAddress *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnsubscribeInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.TargetAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAddress"))
	}
	if s.TargetAddress != nil && len(*s.TargetAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UnsubscribeInput) SetArn(v string) *UnsubscribeInput {
	s.Arn = &v
	return s
}

// SetTargetAddress sets the TargetAddress field's value.
func (s *UnsubscribeInput) SetTargetAddress(v string) *UnsubscribeInput {
	s.TargetAddress = &v
	return s
}

type UnsubscribeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the the notification rule from which you
	// have removed a subscription.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsubscribeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UnsubscribeOutput) SetArn(v string) *UnsubscribeOutput {
	s.Arn = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule from which to remove
	// the tags.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The key names of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateNotificationRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notification rule.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The level of detail to include in the notifications for this resource. BASIC
	// will include only the contents of the event as it would appear in AWS CloudWatch.
	// FULL will include any supplemental information provided by AWS CodeStar Notifications
	// and/or the service for the resource for which the notification is created.
	DetailType *string `type:"string" enum:"DetailType"`

	// A list of event types associated with this notification rule.
	EventTypeIds []*string `type:"list"`

	// The name of the notification rule.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNotificationRuleInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The status of the notification rule. Valid statuses include enabled (sending
	// notifications) or disabled (not sending notifications).
	Status *string `type:"string" enum:"NotificationRuleStatus"`

	// The address and type of the targets to receive notifications from this notification
	// rule.
	Targets []*Target `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNotificationRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNotificationRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotificationRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNotificationRuleInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateNotificationRuleInput) SetArn(v string) *UpdateNotificationRuleInput {
	s.Arn = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *UpdateNotificationRuleInput) SetDetailType(v string) *UpdateNotificationRuleInput {
	s.DetailType = &v
	return s
}

// SetEventTypeIds sets the EventTypeIds field's value.
func (s *UpdateNotificationRuleInput) SetEventTypeIds(v []*string) *UpdateNotificationRuleInput {
	s.EventTypeIds = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateNotificationRuleInput) SetName(v string) *UpdateNotificationRuleInput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateNotificationRuleInput) SetStatus(v string) *UpdateNotificationRuleInput {
	s.Status = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateNotificationRuleInput) SetTargets(v []*Target) *UpdateNotificationRuleInput {
	s.Targets = v
	return s
}

type UpdateNotificationRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNotificationRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNotificationRuleOutput) GoString() string {
	return s.String()
}

// One or more parameter values are not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DetailTypeBasic is a DetailType enum value
	DetailTypeBasic = "BASIC"

	// DetailTypeFull is a DetailType enum value
	DetailTypeFull = "FULL"
)

// DetailType_Values returns all elements of the DetailType enum
func DetailType_Values() []string {
	return []string{
		DetailTypeBasic,
		DetailTypeFull,
	}
}

const (
	// ListEventTypesFilterNameResourceType is a ListEventTypesFilterName enum value
	ListEventTypesFilterNameResourceType = "RESOURCE_TYPE"

	// ListEventTypesFilterNameServiceName is a ListEventTypesFilterName enum value
	ListEventTypesFilterNameServiceName = "SERVICE_NAME"
)

// ListEventTypesFilterName_Values returns all elements of the ListEventTypesFilterName enum
func ListEventTypesFilterName_Values() []string {
	return []string{
		ListEventTypesFilterNameResourceType,
		ListEventTypesFilterNameServiceName,
	}
}

const (
	// ListNotificationRulesFilterNameEventTypeId is a ListNotificationRulesFilterName enum value
	ListNotificationRulesFilterNameEventTypeId = "EVENT_TYPE_ID"

	// ListNotificationRulesFilterNameCreatedBy is a ListNotificationRulesFilterName enum value
	ListNotificationRulesFilterNameCreatedBy = "CREATED_BY"

	// ListNotificationRulesFilterNameResource is a ListNotificationRulesFilterName enum value
	ListNotificationRulesFilterNameResource = "RESOURCE"

	// ListNotificationRulesFilterNameTargetAddress is a ListNotificationRulesFilterName enum value
	ListNotificationRulesFilterNameTargetAddress = "TARGET_ADDRESS"
)

// ListNotificationRulesFilterName_Values returns all elements of the ListNotificationRulesFilterName enum
func ListNotificationRulesFilterName_Values() []string {
	return []string{
		ListNotificationRulesFilterNameEventTypeId,
		ListNotificationRulesFilterNameCreatedBy,
		ListNotificationRulesFilterNameResource,
		ListNotificationRulesFilterNameTargetAddress,
	}
}

const (
	// ListTargetsFilterNameTargetType is a ListTargetsFilterName enum value
	ListTargetsFilterNameTargetType = "TARGET_TYPE"

	// ListTargetsFilterNameTargetAddress is a ListTargetsFilterName enum value
	ListTargetsFilterNameTargetAddress = "TARGET_ADDRESS"

	// ListTargetsFilterNameTargetStatus is a ListTargetsFilterName enum value
	ListTargetsFilterNameTargetStatus = "TARGET_STATUS"
)

// ListTargetsFilterName_Values returns all elements of the ListTargetsFilterName enum
func ListTargetsFilterName_Values() []string {
	return []string{
		ListTargetsFilterNameTargetType,
		ListTargetsFilterNameTargetAddress,
		ListTargetsFilterNameTargetStatus,
	}
}

const (
	// NotificationRuleStatusEnabled is a NotificationRuleStatus enum value
	NotificationRuleStatusEnabled = "ENABLED"

	// NotificationRuleStatusDisabled is a NotificationRuleStatus enum value
	NotificationRuleStatusDisabled = "DISABLED"
)

// NotificationRuleStatus_Values returns all elements of the NotificationRuleStatus enum
func NotificationRuleStatus_Values() []string {
	return []string{
		NotificationRuleStatusEnabled,
		NotificationRuleStatusDisabled,
	}
}

const (
	// TargetStatusPending is a TargetStatus enum value
	TargetStatusPending = "PENDING"

	// TargetStatusActive is a TargetStatus enum value
	TargetStatusActive = "ACTIVE"

	// TargetStatusUnreachable is a TargetStatus enum value
	TargetStatusUnreachable = "UNREACHABLE"

	// TargetStatusInactive is a TargetStatus enum value
	TargetStatusInactive = "INACTIVE"

	// TargetStatusDeactivated is a TargetStatus enum value
	TargetStatusDeactivated = "DEACTIVATED"
)

// TargetStatus_Values returns all elements of the TargetStatus enum
func TargetStatus_Values() []string {
	return []string{
		TargetStatusPending,
		TargetStatusActive,
		TargetStatusUnreachable,
		TargetStatusInactive,
		TargetStatusDeactivated,
	}
}
