// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gluedatabrew

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchDeleteRecipeVersion = "BatchDeleteRecipeVersion"

// BatchDeleteRecipeVersionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteRecipeVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteRecipeVersion for more information on using the BatchDeleteRecipeVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteRecipeVersionRequest method.
//    req, resp := client.BatchDeleteRecipeVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/BatchDeleteRecipeVersion
func (c *GlueDataBrew) BatchDeleteRecipeVersionRequest(input *BatchDeleteRecipeVersionInput) (req *request.Request, output *BatchDeleteRecipeVersionOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteRecipeVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/recipes/{name}/batchDeleteRecipeVersion",
	}

	if input == nil {
		input = &BatchDeleteRecipeVersionInput{}
	}

	output = &BatchDeleteRecipeVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteRecipeVersion API operation for AWS Glue DataBrew.
//
// Deletes one or more versions of a recipe at a time.
//
// The entire request will be rejected if:
//
//    * The recipe does not exist.
//
//    * There is an invalid version identifier in the list of versions.
//
//    * The version list is empty.
//
//    * The version list size exceeds 50.
//
//    * The version list contains duplicate entries.
//
// The request will complete successfully, but with partial failures, if:
//
//    * A version does not exist.
//
//    * A version is being used by a job.
//
//    * You specify LATEST_WORKING, but it's being used by a project.
//
//    * The version fails to be deleted.
//
// The LATEST_WORKING version will only be deleted if the recipe has no other
// versions. If you try to delete LATEST_WORKING while other versions exist
// (or if they can't be deleted), then LATEST_WORKING will be listed as partial
// failure in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation BatchDeleteRecipeVersion for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/BatchDeleteRecipeVersion
func (c *GlueDataBrew) BatchDeleteRecipeVersion(input *BatchDeleteRecipeVersionInput) (*BatchDeleteRecipeVersionOutput, error) {
	req, out := c.BatchDeleteRecipeVersionRequest(input)
	return out, req.Send()
}

// BatchDeleteRecipeVersionWithContext is the same as BatchDeleteRecipeVersion with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteRecipeVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) BatchDeleteRecipeVersionWithContext(ctx aws.Context, input *BatchDeleteRecipeVersionInput, opts ...request.Option) (*BatchDeleteRecipeVersionOutput, error) {
	req, out := c.BatchDeleteRecipeVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetRequest method.
//    req, resp := client.CreateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateDataset
func (c *GlueDataBrew) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/datasets",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for AWS Glue DataBrew.
//
// Creates a new DataBrew dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the specified resource was denied.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateDataset
func (c *GlueDataBrew) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfileJob = "CreateProfileJob"

// CreateProfileJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfileJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfileJob for more information on using the CreateProfileJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProfileJobRequest method.
//    req, resp := client.CreateProfileJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProfileJob
func (c *GlueDataBrew) CreateProfileJobRequest(input *CreateProfileJobInput) (req *request.Request, output *CreateProfileJobOutput) {
	op := &request.Operation{
		Name:       opCreateProfileJob,
		HTTPMethod: "POST",
		HTTPPath:   "/profileJobs",
	}

	if input == nil {
		input = &CreateProfileJobInput{}
	}

	output = &CreateProfileJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfileJob API operation for AWS Glue DataBrew.
//
// Creates a new job to analyze a dataset and create its data profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateProfileJob for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the specified resource was denied.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProfileJob
func (c *GlueDataBrew) CreateProfileJob(input *CreateProfileJobInput) (*CreateProfileJobOutput, error) {
	req, out := c.CreateProfileJobRequest(input)
	return out, req.Send()
}

// CreateProfileJobWithContext is the same as CreateProfileJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfileJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateProfileJobWithContext(ctx aws.Context, input *CreateProfileJobInput, opts ...request.Option) (*CreateProfileJobOutput, error) {
	req, out := c.CreateProfileJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProject
func (c *GlueDataBrew) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS Glue DataBrew.
//
// Creates a new DataBrew project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalServerException
//   An internal service failure occurred.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateProject
func (c *GlueDataBrew) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecipe = "CreateRecipe"

// CreateRecipeRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecipe for more information on using the CreateRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRecipeRequest method.
//    req, resp := client.CreateRecipeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipe
func (c *GlueDataBrew) CreateRecipeRequest(input *CreateRecipeInput) (req *request.Request, output *CreateRecipeOutput) {
	op := &request.Operation{
		Name:       opCreateRecipe,
		HTTPMethod: "POST",
		HTTPPath:   "/recipes",
	}

	if input == nil {
		input = &CreateRecipeInput{}
	}

	output = &CreateRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecipe API operation for AWS Glue DataBrew.
//
// Creates a new DataBrew recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateRecipe for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipe
func (c *GlueDataBrew) CreateRecipe(input *CreateRecipeInput) (*CreateRecipeOutput, error) {
	req, out := c.CreateRecipeRequest(input)
	return out, req.Send()
}

// CreateRecipeWithContext is the same as CreateRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateRecipeWithContext(ctx aws.Context, input *CreateRecipeInput, opts ...request.Option) (*CreateRecipeOutput, error) {
	req, out := c.CreateRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRecipeJob = "CreateRecipeJob"

// CreateRecipeJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateRecipeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRecipeJob for more information on using the CreateRecipeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRecipeJobRequest method.
//    req, resp := client.CreateRecipeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipeJob
func (c *GlueDataBrew) CreateRecipeJobRequest(input *CreateRecipeJobInput) (req *request.Request, output *CreateRecipeJobOutput) {
	op := &request.Operation{
		Name:       opCreateRecipeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/recipeJobs",
	}

	if input == nil {
		input = &CreateRecipeJobInput{}
	}

	output = &CreateRecipeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRecipeJob API operation for AWS Glue DataBrew.
//
// Creates a new job to transform input data, using steps defined in an existing
// Glue DataBrew recipe
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateRecipeJob for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the specified resource was denied.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRecipeJob
func (c *GlueDataBrew) CreateRecipeJob(input *CreateRecipeJobInput) (*CreateRecipeJobOutput, error) {
	req, out := c.CreateRecipeJobRequest(input)
	return out, req.Send()
}

// CreateRecipeJobWithContext is the same as CreateRecipeJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRecipeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateRecipeJobWithContext(ctx aws.Context, input *CreateRecipeJobInput, opts ...request.Option) (*CreateRecipeJobOutput, error) {
	req, out := c.CreateRecipeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleset = "CreateRuleset"

// CreateRulesetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleset for more information on using the CreateRuleset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRulesetRequest method.
//    req, resp := client.CreateRulesetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRuleset
func (c *GlueDataBrew) CreateRulesetRequest(input *CreateRulesetInput) (req *request.Request, output *CreateRulesetOutput) {
	op := &request.Operation{
		Name:       opCreateRuleset,
		HTTPMethod: "POST",
		HTTPPath:   "/rulesets",
	}

	if input == nil {
		input = &CreateRulesetInput{}
	}

	output = &CreateRulesetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleset API operation for AWS Glue DataBrew.
//
// Creates a new ruleset that can be used in a profile job to validate the data
// quality of a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateRuleset for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateRuleset
func (c *GlueDataBrew) CreateRuleset(input *CreateRulesetInput) (*CreateRulesetOutput, error) {
	req, out := c.CreateRulesetRequest(input)
	return out, req.Send()
}

// CreateRulesetWithContext is the same as CreateRuleset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateRulesetWithContext(ctx aws.Context, input *CreateRulesetInput, opts ...request.Option) (*CreateRulesetOutput, error) {
	req, out := c.CreateRulesetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchedule = "CreateSchedule"

// CreateScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchedule for more information on using the CreateSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScheduleRequest method.
//    req, resp := client.CreateScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateSchedule
func (c *GlueDataBrew) CreateScheduleRequest(input *CreateScheduleInput) (req *request.Request, output *CreateScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/schedules",
	}

	if input == nil {
		input = &CreateScheduleInput{}
	}

	output = &CreateScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchedule API operation for AWS Glue DataBrew.
//
// Creates a new schedule for one or more DataBrew jobs. Jobs can be run at
// a specific date and time, or at regular intervals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation CreateSchedule for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/CreateSchedule
func (c *GlueDataBrew) CreateSchedule(input *CreateScheduleInput) (*CreateScheduleOutput, error) {
	req, out := c.CreateScheduleRequest(input)
	return out, req.Send()
}

// CreateScheduleWithContext is the same as CreateSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) CreateScheduleWithContext(ctx aws.Context, input *CreateScheduleInput, opts ...request.Option) (*CreateScheduleOutput, error) {
	req, out := c.CreateScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteDataset
func (c *GlueDataBrew) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datasets/{name}",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataset API operation for AWS Glue DataBrew.
//
// Deletes a dataset from DataBrew.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteDataset
func (c *GlueDataBrew) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteJob
func (c *GlueDataBrew) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/jobs/{name}",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteJob API operation for AWS Glue DataBrew.
//
// Deletes the specified DataBrew job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DeleteJob for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteJob
func (c *GlueDataBrew) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteProject
func (c *GlueDataBrew) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{name}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS Glue DataBrew.
//
// Deletes an existing DataBrew project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteProject
func (c *GlueDataBrew) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecipeVersion = "DeleteRecipeVersion"

// DeleteRecipeVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecipeVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecipeVersion for more information on using the DeleteRecipeVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRecipeVersionRequest method.
//    req, resp := client.DeleteRecipeVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRecipeVersion
func (c *GlueDataBrew) DeleteRecipeVersionRequest(input *DeleteRecipeVersionInput) (req *request.Request, output *DeleteRecipeVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteRecipeVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/recipes/{name}/recipeVersion/{recipeVersion}",
	}

	if input == nil {
		input = &DeleteRecipeVersionInput{}
	}

	output = &DeleteRecipeVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRecipeVersion API operation for AWS Glue DataBrew.
//
// Deletes a single version of a DataBrew recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DeleteRecipeVersion for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRecipeVersion
func (c *GlueDataBrew) DeleteRecipeVersion(input *DeleteRecipeVersionInput) (*DeleteRecipeVersionOutput, error) {
	req, out := c.DeleteRecipeVersionRequest(input)
	return out, req.Send()
}

// DeleteRecipeVersionWithContext is the same as DeleteRecipeVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecipeVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DeleteRecipeVersionWithContext(ctx aws.Context, input *DeleteRecipeVersionInput, opts ...request.Option) (*DeleteRecipeVersionOutput, error) {
	req, out := c.DeleteRecipeVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleset = "DeleteRuleset"

// DeleteRulesetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleset for more information on using the DeleteRuleset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRulesetRequest method.
//    req, resp := client.DeleteRulesetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRuleset
func (c *GlueDataBrew) DeleteRulesetRequest(input *DeleteRulesetInput) (req *request.Request, output *DeleteRulesetOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rulesets/{name}",
	}

	if input == nil {
		input = &DeleteRulesetInput{}
	}

	output = &DeleteRulesetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRuleset API operation for AWS Glue DataBrew.
//
// Deletes a ruleset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DeleteRuleset for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteRuleset
func (c *GlueDataBrew) DeleteRuleset(input *DeleteRulesetInput) (*DeleteRulesetOutput, error) {
	req, out := c.DeleteRulesetRequest(input)
	return out, req.Send()
}

// DeleteRulesetWithContext is the same as DeleteRuleset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DeleteRulesetWithContext(ctx aws.Context, input *DeleteRulesetInput, opts ...request.Option) (*DeleteRulesetOutput, error) {
	req, out := c.DeleteRulesetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchedule = "DeleteSchedule"

// DeleteScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchedule for more information on using the DeleteSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduleRequest method.
//    req, resp := client.DeleteScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteSchedule
func (c *GlueDataBrew) DeleteScheduleRequest(input *DeleteScheduleInput) (req *request.Request, output *DeleteScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/schedules/{name}",
	}

	if input == nil {
		input = &DeleteScheduleInput{}
	}

	output = &DeleteScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSchedule API operation for AWS Glue DataBrew.
//
// Deletes the specified DataBrew schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DeleteSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DeleteSchedule
func (c *GlueDataBrew) DeleteSchedule(input *DeleteScheduleInput) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	return out, req.Send()
}

// DeleteScheduleWithContext is the same as DeleteSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DeleteScheduleWithContext(ctx aws.Context, input *DeleteScheduleInput, opts ...request.Option) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeDataset
func (c *GlueDataBrew) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "GET",
		HTTPPath:   "/datasets/{name}",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for AWS Glue DataBrew.
//
// Returns the definition of a specific DataBrew dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeDataset
func (c *GlueDataBrew) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJob
func (c *GlueDataBrew) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{name}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJob API operation for AWS Glue DataBrew.
//
// Returns the definition of a specific DataBrew job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJob
func (c *GlueDataBrew) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobRun = "DescribeJobRun"

// DescribeJobRunRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobRun for more information on using the DescribeJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRunRequest method.
//    req, resp := client.DescribeJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJobRun
func (c *GlueDataBrew) DescribeJobRunRequest(input *DescribeJobRunInput) (req *request.Request, output *DescribeJobRunOutput) {
	op := &request.Operation{
		Name:       opDescribeJobRun,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{name}/jobRun/{runId}",
	}

	if input == nil {
		input = &DescribeJobRunInput{}
	}

	output = &DescribeJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobRun API operation for AWS Glue DataBrew.
//
// Represents one run of a DataBrew job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeJobRun for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeJobRun
func (c *GlueDataBrew) DescribeJobRun(input *DescribeJobRunInput) (*DescribeJobRunOutput, error) {
	req, out := c.DescribeJobRunRequest(input)
	return out, req.Send()
}

// DescribeJobRunWithContext is the same as DescribeJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeJobRunWithContext(ctx aws.Context, input *DescribeJobRunInput, opts ...request.Option) (*DescribeJobRunOutput, error) {
	req, out := c.DescribeJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeProject
func (c *GlueDataBrew) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{name}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for AWS Glue DataBrew.
//
// Returns the definition of a specific DataBrew project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeProject
func (c *GlueDataBrew) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecipe = "DescribeRecipe"

// DescribeRecipeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecipe for more information on using the DescribeRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRecipeRequest method.
//    req, resp := client.DescribeRecipeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRecipe
func (c *GlueDataBrew) DescribeRecipeRequest(input *DescribeRecipeInput) (req *request.Request, output *DescribeRecipeOutput) {
	op := &request.Operation{
		Name:       opDescribeRecipe,
		HTTPMethod: "GET",
		HTTPPath:   "/recipes/{name}",
	}

	if input == nil {
		input = &DescribeRecipeInput{}
	}

	output = &DescribeRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecipe API operation for AWS Glue DataBrew.
//
// Returns the definition of a specific DataBrew recipe corresponding to a particular
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeRecipe for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRecipe
func (c *GlueDataBrew) DescribeRecipe(input *DescribeRecipeInput) (*DescribeRecipeOutput, error) {
	req, out := c.DescribeRecipeRequest(input)
	return out, req.Send()
}

// DescribeRecipeWithContext is the same as DescribeRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeRecipeWithContext(ctx aws.Context, input *DescribeRecipeInput, opts ...request.Option) (*DescribeRecipeOutput, error) {
	req, out := c.DescribeRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRuleset = "DescribeRuleset"

// DescribeRulesetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuleset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuleset for more information on using the DescribeRuleset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRulesetRequest method.
//    req, resp := client.DescribeRulesetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRuleset
func (c *GlueDataBrew) DescribeRulesetRequest(input *DescribeRulesetInput) (req *request.Request, output *DescribeRulesetOutput) {
	op := &request.Operation{
		Name:       opDescribeRuleset,
		HTTPMethod: "GET",
		HTTPPath:   "/rulesets/{name}",
	}

	if input == nil {
		input = &DescribeRulesetInput{}
	}

	output = &DescribeRulesetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuleset API operation for AWS Glue DataBrew.
//
// Retrieves detailed information about the ruleset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeRuleset for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeRuleset
func (c *GlueDataBrew) DescribeRuleset(input *DescribeRulesetInput) (*DescribeRulesetOutput, error) {
	req, out := c.DescribeRulesetRequest(input)
	return out, req.Send()
}

// DescribeRulesetWithContext is the same as DescribeRuleset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuleset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeRulesetWithContext(ctx aws.Context, input *DescribeRulesetInput, opts ...request.Option) (*DescribeRulesetOutput, error) {
	req, out := c.DescribeRulesetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchedule = "DescribeSchedule"

// DescribeScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchedule for more information on using the DescribeSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduleRequest method.
//    req, resp := client.DescribeScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeSchedule
func (c *GlueDataBrew) DescribeScheduleRequest(input *DescribeScheduleInput) (req *request.Request, output *DescribeScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/schedules/{name}",
	}

	if input == nil {
		input = &DescribeScheduleInput{}
	}

	output = &DescribeScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchedule API operation for AWS Glue DataBrew.
//
// Returns the definition of a specific DataBrew schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation DescribeSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DescribeSchedule
func (c *GlueDataBrew) DescribeSchedule(input *DescribeScheduleInput) (*DescribeScheduleOutput, error) {
	req, out := c.DescribeScheduleRequest(input)
	return out, req.Send()
}

// DescribeScheduleWithContext is the same as DescribeSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) DescribeScheduleWithContext(ctx aws.Context, input *DescribeScheduleInput, opts ...request.Option) (*DescribeScheduleOutput, error) {
	req, out := c.DescribeScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetsRequest method.
//    req, resp := client.ListDatasetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListDatasets
func (c *GlueDataBrew) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "GET",
		HTTPPath:   "/datasets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for AWS Glue DataBrew.
//
// Lists all of the DataBrew datasets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListDatasets for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListDatasets
func (c *GlueDataBrew) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasets operation.
//    pageNum := 0
//    err := client.ListDatasetsPages(params,
//        func(page *gluedatabrew.ListDatasetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobRuns = "ListJobRuns"

// ListJobRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobRuns for more information on using the ListJobRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobRunsRequest method.
//    req, resp := client.ListJobRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobRuns
func (c *GlueDataBrew) ListJobRunsRequest(input *ListJobRunsInput) (req *request.Request, output *ListJobRunsOutput) {
	op := &request.Operation{
		Name:       opListJobRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{name}/jobRuns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobRunsInput{}
	}

	output = &ListJobRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobRuns API operation for AWS Glue DataBrew.
//
// Lists all of the previous runs of a particular DataBrew job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListJobRuns for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobRuns
func (c *GlueDataBrew) ListJobRuns(input *ListJobRunsInput) (*ListJobRunsOutput, error) {
	req, out := c.ListJobRunsRequest(input)
	return out, req.Send()
}

// ListJobRunsWithContext is the same as ListJobRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListJobRunsWithContext(ctx aws.Context, input *ListJobRunsInput, opts ...request.Option) (*ListJobRunsOutput, error) {
	req, out := c.ListJobRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobRunsPages iterates over the pages of a ListJobRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobRuns operation.
//    pageNum := 0
//    err := client.ListJobRunsPages(params,
//        func(page *gluedatabrew.ListJobRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListJobRunsPages(input *ListJobRunsInput, fn func(*ListJobRunsOutput, bool) bool) error {
	return c.ListJobRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobRunsPagesWithContext same as ListJobRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListJobRunsPagesWithContext(ctx aws.Context, input *ListJobRunsInput, fn func(*ListJobRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobs
func (c *GlueDataBrew) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Glue DataBrew.
//
// Lists all of the DataBrew jobs that are defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListJobs
func (c *GlueDataBrew) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *gluedatabrew.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListProjects
func (c *GlueDataBrew) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS Glue DataBrew.
//
// Lists all of the DataBrew projects that are defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListProjects
func (c *GlueDataBrew) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *gluedatabrew.ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecipeVersions = "ListRecipeVersions"

// ListRecipeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecipeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecipeVersions for more information on using the ListRecipeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecipeVersionsRequest method.
//    req, resp := client.ListRecipeVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipeVersions
func (c *GlueDataBrew) ListRecipeVersionsRequest(input *ListRecipeVersionsInput) (req *request.Request, output *ListRecipeVersionsOutput) {
	op := &request.Operation{
		Name:       opListRecipeVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/recipeVersions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecipeVersionsInput{}
	}

	output = &ListRecipeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecipeVersions API operation for AWS Glue DataBrew.
//
// Lists the versions of a particular DataBrew recipe, except for LATEST_WORKING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListRecipeVersions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipeVersions
func (c *GlueDataBrew) ListRecipeVersions(input *ListRecipeVersionsInput) (*ListRecipeVersionsOutput, error) {
	req, out := c.ListRecipeVersionsRequest(input)
	return out, req.Send()
}

// ListRecipeVersionsWithContext is the same as ListRecipeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecipeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListRecipeVersionsWithContext(ctx aws.Context, input *ListRecipeVersionsInput, opts ...request.Option) (*ListRecipeVersionsOutput, error) {
	req, out := c.ListRecipeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecipeVersionsPages iterates over the pages of a ListRecipeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecipeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecipeVersions operation.
//    pageNum := 0
//    err := client.ListRecipeVersionsPages(params,
//        func(page *gluedatabrew.ListRecipeVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListRecipeVersionsPages(input *ListRecipeVersionsInput, fn func(*ListRecipeVersionsOutput, bool) bool) error {
	return c.ListRecipeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecipeVersionsPagesWithContext same as ListRecipeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListRecipeVersionsPagesWithContext(ctx aws.Context, input *ListRecipeVersionsInput, fn func(*ListRecipeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecipeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecipeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecipeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecipes = "ListRecipes"

// ListRecipesRequest generates a "aws/request.Request" representing the
// client's request for the ListRecipes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecipes for more information on using the ListRecipes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecipesRequest method.
//    req, resp := client.ListRecipesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipes
func (c *GlueDataBrew) ListRecipesRequest(input *ListRecipesInput) (req *request.Request, output *ListRecipesOutput) {
	op := &request.Operation{
		Name:       opListRecipes,
		HTTPMethod: "GET",
		HTTPPath:   "/recipes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecipesInput{}
	}

	output = &ListRecipesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecipes API operation for AWS Glue DataBrew.
//
// Lists all of the DataBrew recipes that are defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListRecipes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRecipes
func (c *GlueDataBrew) ListRecipes(input *ListRecipesInput) (*ListRecipesOutput, error) {
	req, out := c.ListRecipesRequest(input)
	return out, req.Send()
}

// ListRecipesWithContext is the same as ListRecipes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecipes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListRecipesWithContext(ctx aws.Context, input *ListRecipesInput, opts ...request.Option) (*ListRecipesOutput, error) {
	req, out := c.ListRecipesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecipesPages iterates over the pages of a ListRecipes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecipes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecipes operation.
//    pageNum := 0
//    err := client.ListRecipesPages(params,
//        func(page *gluedatabrew.ListRecipesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListRecipesPages(input *ListRecipesInput, fn func(*ListRecipesOutput, bool) bool) error {
	return c.ListRecipesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecipesPagesWithContext same as ListRecipesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListRecipesPagesWithContext(ctx aws.Context, input *ListRecipesInput, fn func(*ListRecipesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecipesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecipesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecipesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRulesets = "ListRulesets"

// ListRulesetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRulesets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRulesets for more information on using the ListRulesets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRulesetsRequest method.
//    req, resp := client.ListRulesetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets
func (c *GlueDataBrew) ListRulesetsRequest(input *ListRulesetsInput) (req *request.Request, output *ListRulesetsOutput) {
	op := &request.Operation{
		Name:       opListRulesets,
		HTTPMethod: "GET",
		HTTPPath:   "/rulesets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRulesetsInput{}
	}

	output = &ListRulesetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRulesets API operation for AWS Glue DataBrew.
//
// List all rulesets available in the current account or rulesets associated
// with a specific resource (dataset).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListRulesets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets
func (c *GlueDataBrew) ListRulesets(input *ListRulesetsInput) (*ListRulesetsOutput, error) {
	req, out := c.ListRulesetsRequest(input)
	return out, req.Send()
}

// ListRulesetsWithContext is the same as ListRulesets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRulesets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListRulesetsWithContext(ctx aws.Context, input *ListRulesetsInput, opts ...request.Option) (*ListRulesetsOutput, error) {
	req, out := c.ListRulesetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRulesetsPages iterates over the pages of a ListRulesets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRulesets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRulesets operation.
//    pageNum := 0
//    err := client.ListRulesetsPages(params,
//        func(page *gluedatabrew.ListRulesetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListRulesetsPages(input *ListRulesetsInput, fn func(*ListRulesetsOutput, bool) bool) error {
	return c.ListRulesetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRulesetsPagesWithContext same as ListRulesetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListRulesetsPagesWithContext(ctx aws.Context, input *ListRulesetsInput, fn func(*ListRulesetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRulesetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRulesetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRulesetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchedules = "ListSchedules"

// ListSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchedules for more information on using the ListSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchedulesRequest method.
//    req, resp := client.ListSchedulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListSchedules
func (c *GlueDataBrew) ListSchedulesRequest(input *ListSchedulesInput) (req *request.Request, output *ListSchedulesOutput) {
	op := &request.Operation{
		Name:       opListSchedules,
		HTTPMethod: "GET",
		HTTPPath:   "/schedules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchedulesInput{}
	}

	output = &ListSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchedules API operation for AWS Glue DataBrew.
//
// Lists the DataBrew schedules that are defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListSchedules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListSchedules
func (c *GlueDataBrew) ListSchedules(input *ListSchedulesInput) (*ListSchedulesOutput, error) {
	req, out := c.ListSchedulesRequest(input)
	return out, req.Send()
}

// ListSchedulesWithContext is the same as ListSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListSchedulesWithContext(ctx aws.Context, input *ListSchedulesInput, opts ...request.Option) (*ListSchedulesOutput, error) {
	req, out := c.ListSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchedulesPages iterates over the pages of a ListSchedules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchedules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSchedules operation.
//    pageNum := 0
//    err := client.ListSchedulesPages(params,
//        func(page *gluedatabrew.ListSchedulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GlueDataBrew) ListSchedulesPages(input *ListSchedulesInput, fn func(*ListSchedulesOutput, bool) bool) error {
	return c.ListSchedulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchedulesPagesWithContext same as ListSchedulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListSchedulesPagesWithContext(ctx aws.Context, input *ListSchedulesInput, fn func(*ListSchedulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchedulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchedulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchedulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListTagsForResource
func (c *GlueDataBrew) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Glue DataBrew.
//
// Lists all the tags for a DataBrew resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service failure occurred.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListTagsForResource
func (c *GlueDataBrew) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPublishRecipe = "PublishRecipe"

// PublishRecipeRequest generates a "aws/request.Request" representing the
// client's request for the PublishRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishRecipe for more information on using the PublishRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishRecipeRequest method.
//    req, resp := client.PublishRecipeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/PublishRecipe
func (c *GlueDataBrew) PublishRecipeRequest(input *PublishRecipeInput) (req *request.Request, output *PublishRecipeOutput) {
	op := &request.Operation{
		Name:       opPublishRecipe,
		HTTPMethod: "POST",
		HTTPPath:   "/recipes/{name}/publishRecipe",
	}

	if input == nil {
		input = &PublishRecipeInput{}
	}

	output = &PublishRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishRecipe API operation for AWS Glue DataBrew.
//
// Publishes a new version of a DataBrew recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation PublishRecipe for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/PublishRecipe
func (c *GlueDataBrew) PublishRecipe(input *PublishRecipeInput) (*PublishRecipeOutput, error) {
	req, out := c.PublishRecipeRequest(input)
	return out, req.Send()
}

// PublishRecipeWithContext is the same as PublishRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See PublishRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) PublishRecipeWithContext(ctx aws.Context, input *PublishRecipeInput, opts ...request.Option) (*PublishRecipeOutput, error) {
	req, out := c.PublishRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendProjectSessionAction = "SendProjectSessionAction"

// SendProjectSessionActionRequest generates a "aws/request.Request" representing the
// client's request for the SendProjectSessionAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendProjectSessionAction for more information on using the SendProjectSessionAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendProjectSessionActionRequest method.
//    req, resp := client.SendProjectSessionActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/SendProjectSessionAction
func (c *GlueDataBrew) SendProjectSessionActionRequest(input *SendProjectSessionActionInput) (req *request.Request, output *SendProjectSessionActionOutput) {
	op := &request.Operation{
		Name:       opSendProjectSessionAction,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{name}/sendProjectSessionAction",
	}

	if input == nil {
		input = &SendProjectSessionActionInput{}
	}

	output = &SendProjectSessionActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendProjectSessionAction API operation for AWS Glue DataBrew.
//
// Performs a recipe step within an interactive DataBrew session that's currently
// open.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation SendProjectSessionAction for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/SendProjectSessionAction
func (c *GlueDataBrew) SendProjectSessionAction(input *SendProjectSessionActionInput) (*SendProjectSessionActionOutput, error) {
	req, out := c.SendProjectSessionActionRequest(input)
	return out, req.Send()
}

// SendProjectSessionActionWithContext is the same as SendProjectSessionAction with the addition of
// the ability to pass a context and additional request options.
//
// See SendProjectSessionAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) SendProjectSessionActionWithContext(ctx aws.Context, input *SendProjectSessionActionInput, opts ...request.Option) (*SendProjectSessionActionOutput, error) {
	req, out := c.SendProjectSessionActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartJobRun = "StartJobRun"

// StartJobRunRequest generates a "aws/request.Request" representing the
// client's request for the StartJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJobRun for more information on using the StartJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartJobRunRequest method.
//    req, resp := client.StartJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartJobRun
func (c *GlueDataBrew) StartJobRunRequest(input *StartJobRunInput) (req *request.Request, output *StartJobRunOutput) {
	op := &request.Operation{
		Name:       opStartJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs/{name}/startJobRun",
	}

	if input == nil {
		input = &StartJobRunInput{}
	}

	output = &StartJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartJobRun API operation for AWS Glue DataBrew.
//
// Runs a DataBrew job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation StartJobRun for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartJobRun
func (c *GlueDataBrew) StartJobRun(input *StartJobRunInput) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	return out, req.Send()
}

// StartJobRunWithContext is the same as StartJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) StartJobRunWithContext(ctx aws.Context, input *StartJobRunInput, opts ...request.Option) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartProjectSession = "StartProjectSession"

// StartProjectSessionRequest generates a "aws/request.Request" representing the
// client's request for the StartProjectSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartProjectSession for more information on using the StartProjectSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartProjectSessionRequest method.
//    req, resp := client.StartProjectSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartProjectSession
func (c *GlueDataBrew) StartProjectSessionRequest(input *StartProjectSessionInput) (req *request.Request, output *StartProjectSessionOutput) {
	op := &request.Operation{
		Name:       opStartProjectSession,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{name}/startProjectSession",
	}

	if input == nil {
		input = &StartProjectSessionInput{}
	}

	output = &StartProjectSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartProjectSession API operation for AWS Glue DataBrew.
//
// Creates an interactive session, enabling you to manipulate data in a DataBrew
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation StartProjectSession for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StartProjectSession
func (c *GlueDataBrew) StartProjectSession(input *StartProjectSessionInput) (*StartProjectSessionOutput, error) {
	req, out := c.StartProjectSessionRequest(input)
	return out, req.Send()
}

// StartProjectSessionWithContext is the same as StartProjectSession with the addition of
// the ability to pass a context and additional request options.
//
// See StartProjectSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) StartProjectSessionWithContext(ctx aws.Context, input *StartProjectSessionInput, opts ...request.Option) (*StartProjectSessionOutput, error) {
	req, out := c.StartProjectSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopJobRun = "StopJobRun"

// StopJobRunRequest generates a "aws/request.Request" representing the
// client's request for the StopJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopJobRun for more information on using the StopJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopJobRunRequest method.
//    req, resp := client.StopJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StopJobRun
func (c *GlueDataBrew) StopJobRunRequest(input *StopJobRunInput) (req *request.Request, output *StopJobRunOutput) {
	op := &request.Operation{
		Name:       opStopJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs/{name}/jobRun/{runId}/stopJobRun",
	}

	if input == nil {
		input = &StopJobRunInput{}
	}

	output = &StopJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopJobRun API operation for AWS Glue DataBrew.
//
// Stops a particular run of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation StopJobRun for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/StopJobRun
func (c *GlueDataBrew) StopJobRun(input *StopJobRunInput) (*StopJobRunOutput, error) {
	req, out := c.StopJobRunRequest(input)
	return out, req.Send()
}

// StopJobRunWithContext is the same as StopJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See StopJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) StopJobRunWithContext(ctx aws.Context, input *StopJobRunInput, opts ...request.Option) (*StopJobRunOutput, error) {
	req, out := c.StopJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/TagResource
func (c *GlueDataBrew) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Glue DataBrew.
//
// Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe,
// job, or schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service failure occurred.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/TagResource
func (c *GlueDataBrew) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UntagResource
func (c *GlueDataBrew) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Glue DataBrew.
//
// Removes metadata tags from a DataBrew resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service failure occurred.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UntagResource
func (c *GlueDataBrew) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataset = "UpdateDataset"

// UpdateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataset for more information on using the UpdateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatasetRequest method.
//    req, resp := client.UpdateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateDataset
func (c *GlueDataBrew) UpdateDatasetRequest(input *UpdateDatasetInput) (req *request.Request, output *UpdateDatasetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataset,
		HTTPMethod: "PUT",
		HTTPPath:   "/datasets/{name}",
	}

	if input == nil {
		input = &UpdateDatasetInput{}
	}

	output = &UpdateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataset API operation for AWS Glue DataBrew.
//
// Modifies the definition of an existing DataBrew dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateDataset for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the specified resource was denied.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateDataset
func (c *GlueDataBrew) UpdateDataset(input *UpdateDatasetInput) (*UpdateDatasetOutput, error) {
	req, out := c.UpdateDatasetRequest(input)
	return out, req.Send()
}

// UpdateDatasetWithContext is the same as UpdateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateDatasetWithContext(ctx aws.Context, input *UpdateDatasetInput, opts ...request.Option) (*UpdateDatasetOutput, error) {
	req, out := c.UpdateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfileJob = "UpdateProfileJob"

// UpdateProfileJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfileJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfileJob for more information on using the UpdateProfileJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProfileJobRequest method.
//    req, resp := client.UpdateProfileJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProfileJob
func (c *GlueDataBrew) UpdateProfileJobRequest(input *UpdateProfileJobInput) (req *request.Request, output *UpdateProfileJobOutput) {
	op := &request.Operation{
		Name:       opUpdateProfileJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/profileJobs/{name}",
	}

	if input == nil {
		input = &UpdateProfileJobInput{}
	}

	output = &UpdateProfileJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfileJob API operation for AWS Glue DataBrew.
//
// Modifies the definition of an existing profile job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateProfileJob for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the specified resource was denied.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProfileJob
func (c *GlueDataBrew) UpdateProfileJob(input *UpdateProfileJobInput) (*UpdateProfileJobOutput, error) {
	req, out := c.UpdateProfileJobRequest(input)
	return out, req.Send()
}

// UpdateProfileJobWithContext is the same as UpdateProfileJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfileJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateProfileJobWithContext(ctx aws.Context, input *UpdateProfileJobInput, opts ...request.Option) (*UpdateProfileJobOutput, error) {
	req, out := c.UpdateProfileJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProject
func (c *GlueDataBrew) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{name}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS Glue DataBrew.
//
// Modifies the definition of an existing DataBrew project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateProject
func (c *GlueDataBrew) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecipe = "UpdateRecipe"

// UpdateRecipeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecipe for more information on using the UpdateRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRecipeRequest method.
//    req, resp := client.UpdateRecipeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipe
func (c *GlueDataBrew) UpdateRecipeRequest(input *UpdateRecipeInput) (req *request.Request, output *UpdateRecipeOutput) {
	op := &request.Operation{
		Name:       opUpdateRecipe,
		HTTPMethod: "PUT",
		HTTPPath:   "/recipes/{name}",
	}

	if input == nil {
		input = &UpdateRecipeInput{}
	}

	output = &UpdateRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecipe API operation for AWS Glue DataBrew.
//
// Modifies the definition of the LATEST_WORKING version of a DataBrew recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateRecipe for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input parameters for this request failed validation.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipe
func (c *GlueDataBrew) UpdateRecipe(input *UpdateRecipeInput) (*UpdateRecipeOutput, error) {
	req, out := c.UpdateRecipeRequest(input)
	return out, req.Send()
}

// UpdateRecipeWithContext is the same as UpdateRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateRecipeWithContext(ctx aws.Context, input *UpdateRecipeInput, opts ...request.Option) (*UpdateRecipeOutput, error) {
	req, out := c.UpdateRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecipeJob = "UpdateRecipeJob"

// UpdateRecipeJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecipeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecipeJob for more information on using the UpdateRecipeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRecipeJobRequest method.
//    req, resp := client.UpdateRecipeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipeJob
func (c *GlueDataBrew) UpdateRecipeJobRequest(input *UpdateRecipeJobInput) (req *request.Request, output *UpdateRecipeJobOutput) {
	op := &request.Operation{
		Name:       opUpdateRecipeJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/recipeJobs/{name}",
	}

	if input == nil {
		input = &UpdateRecipeJobInput{}
	}

	output = &UpdateRecipeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecipeJob API operation for AWS Glue DataBrew.
//
// Modifies the definition of an existing DataBrew recipe job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateRecipeJob for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the specified resource was denied.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRecipeJob
func (c *GlueDataBrew) UpdateRecipeJob(input *UpdateRecipeJobInput) (*UpdateRecipeJobOutput, error) {
	req, out := c.UpdateRecipeJobRequest(input)
	return out, req.Send()
}

// UpdateRecipeJobWithContext is the same as UpdateRecipeJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecipeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateRecipeJobWithContext(ctx aws.Context, input *UpdateRecipeJobInput, opts ...request.Option) (*UpdateRecipeJobOutput, error) {
	req, out := c.UpdateRecipeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleset = "UpdateRuleset"

// UpdateRulesetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleset for more information on using the UpdateRuleset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRulesetRequest method.
//    req, resp := client.UpdateRulesetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRuleset
func (c *GlueDataBrew) UpdateRulesetRequest(input *UpdateRulesetInput) (req *request.Request, output *UpdateRulesetOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleset,
		HTTPMethod: "PUT",
		HTTPPath:   "/rulesets/{name}",
	}

	if input == nil {
		input = &UpdateRulesetInput{}
	}

	output = &UpdateRulesetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleset API operation for AWS Glue DataBrew.
//
// Updates specified ruleset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateRuleset for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateRuleset
func (c *GlueDataBrew) UpdateRuleset(input *UpdateRulesetInput) (*UpdateRulesetOutput, error) {
	req, out := c.UpdateRulesetRequest(input)
	return out, req.Send()
}

// UpdateRulesetWithContext is the same as UpdateRuleset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateRulesetWithContext(ctx aws.Context, input *UpdateRulesetInput, opts ...request.Option) (*UpdateRulesetOutput, error) {
	req, out := c.UpdateRulesetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchedule = "UpdateSchedule"

// UpdateScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchedule for more information on using the UpdateSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateScheduleRequest method.
//    req, resp := client.UpdateScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateSchedule
func (c *GlueDataBrew) UpdateScheduleRequest(input *UpdateScheduleInput) (req *request.Request, output *UpdateScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/schedules/{name}",
	}

	if input == nil {
		input = &UpdateScheduleInput{}
	}

	output = &UpdateScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSchedule API operation for AWS Glue DataBrew.
//
// Modifies the definition of an existing DataBrew schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue DataBrew's
// API operation UpdateSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ServiceQuotaExceededException
//   A service quota is exceeded.
//
//   * ValidationException
//   The input parameters for this request failed validation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/UpdateSchedule
func (c *GlueDataBrew) UpdateSchedule(input *UpdateScheduleInput) (*UpdateScheduleOutput, error) {
	req, out := c.UpdateScheduleRequest(input)
	return out, req.Send()
}

// UpdateScheduleWithContext is the same as UpdateSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlueDataBrew) UpdateScheduleWithContext(ctx aws.Context, input *UpdateScheduleInput, opts ...request.Option) (*UpdateScheduleOutput, error) {
	req, out := c.UpdateScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to the specified resource was denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration of statistics that are allowed to be run on columns that contain
// detected entities. When undefined, no statistics will be computed on columns
// that contain detected entities.
type AllowedStatistics struct {
	_ struct{} `type:"structure"`

	// One or more column statistics to allow for columns that contain detected
	// entities.
	//
	// Statistics is a required field
	Statistics []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowedStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowedStatistics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowedStatistics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowedStatistics"}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatistics sets the Statistics field's value.
func (s *AllowedStatistics) SetStatistics(v []*string) *AllowedStatistics {
	s.Statistics = v
	return s
}

type BatchDeleteRecipeVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the recipe whose versions are to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// An array of version identifiers, for the recipe versions to be deleted. You
	// can specify numeric versions (X.Y) or LATEST_WORKING. LATEST_PUBLISHED is
	// not supported.
	//
	// RecipeVersions is a required field
	RecipeVersions []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteRecipeVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteRecipeVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteRecipeVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteRecipeVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeVersions == nil {
		invalidParams.Add(request.NewErrParamRequired("RecipeVersions"))
	}
	if s.RecipeVersions != nil && len(s.RecipeVersions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecipeVersions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BatchDeleteRecipeVersionInput) SetName(v string) *BatchDeleteRecipeVersionInput {
	s.Name = &v
	return s
}

// SetRecipeVersions sets the RecipeVersions field's value.
func (s *BatchDeleteRecipeVersionInput) SetRecipeVersions(v []*string) *BatchDeleteRecipeVersionInput {
	s.RecipeVersions = v
	return s
}

type BatchDeleteRecipeVersionOutput struct {
	_ struct{} `type:"structure"`

	// Errors, if any, that occurred while attempting to delete the recipe versions.
	Errors []*RecipeVersionErrorDetail `type:"list"`

	// The name of the recipe that was modified.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteRecipeVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteRecipeVersionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteRecipeVersionOutput) SetErrors(v []*RecipeVersionErrorDetail) *BatchDeleteRecipeVersionOutput {
	s.Errors = v
	return s
}

// SetName sets the Name field's value.
func (s *BatchDeleteRecipeVersionOutput) SetName(v string) *BatchDeleteRecipeVersionOutput {
	s.Name = &v
	return s
}

// Selector of a column from a dataset for profile job configuration. One selector
// includes either a column name or a regular expression.
type ColumnSelector struct {
	_ struct{} `type:"structure"`

	// The name of a column from a dataset.
	Name *string `min:"1" type:"string"`

	// A regular expression for selecting a column from a dataset.
	Regex *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnSelector"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regex", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ColumnSelector) SetName(v string) *ColumnSelector {
	s.Name = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *ColumnSelector) SetRegex(v string) *ColumnSelector {
	s.Regex = &v
	return s
}

// Configuration for column evaluations for a profile job. ColumnStatisticsConfiguration
// can be used to select evaluations and override parameters of evaluations
// for particular columns.
type ColumnStatisticsConfiguration struct {
	_ struct{} `type:"structure"`

	// List of column selectors. Selectors can be used to select columns from the
	// dataset. When selectors are undefined, configuration will be applied to all
	// supported columns.
	Selectors []*ColumnSelector `min:"1" type:"list"`

	// Configuration for evaluations. Statistics can be used to select evaluations
	// and override parameters of evaluations.
	//
	// Statistics is a required field
	Statistics *StatisticsConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatisticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnStatisticsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnStatisticsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnStatisticsConfiguration"}
	if s.Selectors != nil && len(s.Selectors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Selectors", 1))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Selectors != nil {
		for i, v := range s.Selectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Selectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Statistics != nil {
		if err := s.Statistics.Validate(); err != nil {
			invalidParams.AddNested("Statistics", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSelectors sets the Selectors field's value.
func (s *ColumnStatisticsConfiguration) SetSelectors(v []*ColumnSelector) *ColumnStatisticsConfiguration {
	s.Selectors = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *ColumnStatisticsConfiguration) SetStatistics(v *StatisticsConfiguration) *ColumnStatisticsConfiguration {
	s.Statistics = v
	return s
}

// Represents an individual condition that evaluates to true or false.
//
// Conditions are used with recipe actions. The action is only performed for
// column values where the condition evaluates to true.
//
// If a recipe requires more than one condition, then the recipe must specify
// multiple ConditionExpression elements. Each condition is applied to the rows
// in a dataset first, before the recipe action is performed.
type ConditionExpression struct {
	_ struct{} `type:"structure"`

	// A specific condition to apply to a recipe action. For more information, see
	// Recipe structure (https://docs.aws.amazon.com/databrew/latest/dg/recipes.html#recipes.structure)
	// in the Glue DataBrew Developer Guide.
	//
	// Condition is a required field
	Condition *string `min:"1" type:"string" required:"true"`

	// A column to apply this condition to.
	//
	// TargetColumn is a required field
	TargetColumn *string `min:"1" type:"string" required:"true"`

	// A value that the condition must evaluate to for the condition to succeed.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionExpression"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Condition != nil && len(*s.Condition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Condition", 1))
	}
	if s.TargetColumn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetColumn"))
	}
	if s.TargetColumn != nil && len(*s.TargetColumn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetColumn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ConditionExpression) SetCondition(v string) *ConditionExpression {
	s.Condition = &v
	return s
}

// SetTargetColumn sets the TargetColumn field's value.
func (s *ConditionExpression) SetTargetColumn(v string) *ConditionExpression {
	s.TargetColumn = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConditionExpression) SetValue(v string) *ConditionExpression {
	s.Value = &v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The file format of a dataset that is created from an Amazon S3 file or folder.
	Format *string `type:"string" enum:"InputFormat"`

	// Represents a set of options that define the structure of either comma-separated
	// value (CSV), Excel, or JSON input.
	FormatOptions *FormatOptions `type:"structure"`

	// Represents information on how DataBrew can find data, in either the Glue
	// Data Catalog or Amazon S3.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`

	// The name of the dataset to be created. Valid characters are alphanumeric
	// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A set of options that defines how DataBrew interprets an Amazon S3 path of
	// the dataset.
	PathOptions *PathOptions `type:"structure"`

	// Metadata tags to apply to this dataset.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.FormatOptions != nil {
		if err := s.FormatOptions.Validate(); err != nil {
			invalidParams.AddNested("FormatOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}
	if s.PathOptions != nil {
		if err := s.PathOptions.Validate(); err != nil {
			invalidParams.AddNested("PathOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *CreateDatasetInput) SetFormat(v string) *CreateDatasetInput {
	s.Format = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *CreateDatasetInput) SetFormatOptions(v *FormatOptions) *CreateDatasetInput {
	s.FormatOptions = v
	return s
}

// SetInput sets the Input field's value.
func (s *CreateDatasetInput) SetInput(v *Input) *CreateDatasetInput {
	s.Input = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDatasetInput) SetName(v string) *CreateDatasetInput {
	s.Name = &v
	return s
}

// SetPathOptions sets the PathOptions field's value.
func (s *CreateDatasetInput) SetPathOptions(v *PathOptions) *CreateDatasetInput {
	s.PathOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetInput) SetTags(v map[string]*string) *CreateDatasetInput {
	s.Tags = v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset that you created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateDatasetOutput) SetName(v string) *CreateDatasetOutput {
	s.Name = &v
	return s
}

type CreateProfileJobInput struct {
	_ struct{} `type:"structure"`

	// Configuration for profile jobs. Used to select columns, do evaluations, and
	// override default parameters of evaluations. When configuration is null, the
	// profile job will run with default settings.
	Configuration *ProfileConfiguration `type:"structure"`

	// The name of the dataset that this job is to act upon.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an encryption key that is used to protect
	// the job.
	EncryptionKeyArn *string `min:"20" type:"string"`

	// The encryption mode for the job, which can be one of the following:
	//
	//    * SSE-KMS - SSE-KMS - Server-side encryption with KMS-managed keys.
	//
	//    * SSE-S3 - Server-side encryption with keys managed by Amazon S3.
	EncryptionMode *string `type:"string" enum:"EncryptionMode"`

	// Sample configuration for profile jobs only. Determines the number of rows
	// on which the profile job will be executed. If a JobSample value is not provided,
	// the default value will be used. The default value is CUSTOM_ROWS for the
	// mode parameter and 20000 for the size parameter.
	JobSample *JobSample `type:"structure"`

	// Enables or disables Amazon CloudWatch logging for the job. If logging is
	// enabled, CloudWatch writes one log stream for each job run.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// The maximum number of nodes that DataBrew can use when the job processes
	// data.
	MaxCapacity *int64 `type:"integer"`

	// The maximum number of times to retry the job after a job run fails.
	MaxRetries *int64 `type:"integer"`

	// The name of the job to be created. Valid characters are alphanumeric (A-Z,
	// a-z, 0-9), hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Represents an Amazon S3 location (bucket name and object key) where DataBrew
	// can read input data, or write output from a job.
	//
	// OutputLocation is a required field
	OutputLocation *S3Location `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role to be assumed when DataBrew runs the job.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Metadata tags to apply to this job.
	Tags map[string]*string `min:"1" type:"map"`

	// The job's timeout in minutes. A job that attempts to run longer than this
	// timeout period ends with a status of TIMEOUT.
	Timeout *int64 `type:"integer"`

	// List of validation configurations that are applied to the profile job.
	ValidationConfigurations []*ValidationConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileJobInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputLocation"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ValidationConfigurations != nil && len(s.ValidationConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationConfigurations", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidationConfigurations != nil {
		for i, v := range s.ValidationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateProfileJobInput) SetConfiguration(v *ProfileConfiguration) *CreateProfileJobInput {
	s.Configuration = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateProfileJobInput) SetDatasetName(v string) *CreateProfileJobInput {
	s.DatasetName = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *CreateProfileJobInput) SetEncryptionKeyArn(v string) *CreateProfileJobInput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *CreateProfileJobInput) SetEncryptionMode(v string) *CreateProfileJobInput {
	s.EncryptionMode = &v
	return s
}

// SetJobSample sets the JobSample field's value.
func (s *CreateProfileJobInput) SetJobSample(v *JobSample) *CreateProfileJobInput {
	s.JobSample = v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *CreateProfileJobInput) SetLogSubscription(v string) *CreateProfileJobInput {
	s.LogSubscription = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *CreateProfileJobInput) SetMaxCapacity(v int64) *CreateProfileJobInput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *CreateProfileJobInput) SetMaxRetries(v int64) *CreateProfileJobInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProfileJobInput) SetName(v string) *CreateProfileJobInput {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateProfileJobInput) SetOutputLocation(v *S3Location) *CreateProfileJobInput {
	s.OutputLocation = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateProfileJobInput) SetRoleArn(v string) *CreateProfileJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProfileJobInput) SetTags(v map[string]*string) *CreateProfileJobInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateProfileJobInput) SetTimeout(v int64) *CreateProfileJobInput {
	s.Timeout = &v
	return s
}

// SetValidationConfigurations sets the ValidationConfigurations field's value.
func (s *CreateProfileJobInput) SetValidationConfigurations(v []*ValidationConfiguration) *CreateProfileJobInput {
	s.ValidationConfigurations = v
	return s
}

type CreateProfileJobOutput struct {
	_ struct{} `type:"structure"`

	// The name of the job that was created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateProfileJobOutput) SetName(v string) *CreateProfileJobOutput {
	s.Name = &v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing dataset to associate this project with.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// A unique name for the new project. Valid characters are alphanumeric (A-Z,
	// a-z, 0-9), hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of an existing recipe to associate with the project.
	//
	// RecipeName is a required field
	RecipeName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role to be assumed for this request.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Represents the sample size and sampling type for DataBrew to use for interactive
	// data analysis.
	Sample *Sample `type:"structure"`

	// Metadata tags to apply to this project.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecipeName"))
	}
	if s.RecipeName != nil && len(*s.RecipeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecipeName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Sample != nil {
		if err := s.Sample.Validate(); err != nil {
			invalidParams.AddNested("Sample", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateProjectInput) SetDatasetName(v string) *CreateProjectInput {
	s.DatasetName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// SetRecipeName sets the RecipeName field's value.
func (s *CreateProjectInput) SetRecipeName(v string) *CreateProjectInput {
	s.RecipeName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateProjectInput) SetRoleArn(v string) *CreateProjectInput {
	s.RoleArn = &v
	return s
}

// SetSample sets the Sample field's value.
func (s *CreateProjectInput) SetSample(v *Sample) *CreateProjectInput {
	s.Sample = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v map[string]*string) *CreateProjectInput {
	s.Tags = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The name of the project that you created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateProjectOutput) SetName(v string) *CreateProjectOutput {
	s.Name = &v
	return s
}

type CreateRecipeInput struct {
	_ struct{} `type:"structure"`

	// A description for the recipe.
	Description *string `type:"string"`

	// A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z,
	// 0-9), hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An array containing the steps to be performed by the recipe. Each recipe
	// step consists of one recipe action and (optionally) an array of condition
	// expressions.
	//
	// Steps is a required field
	Steps []*RecipeStep `type:"list" required:"true"`

	// Metadata tags to apply to this recipe.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Steps == nil {
		invalidParams.Add(request.NewErrParamRequired("Steps"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRecipeInput) SetDescription(v string) *CreateRecipeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRecipeInput) SetName(v string) *CreateRecipeInput {
	s.Name = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *CreateRecipeInput) SetSteps(v []*RecipeStep) *CreateRecipeInput {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecipeInput) SetTags(v map[string]*string) *CreateRecipeInput {
	s.Tags = v
	return s
}

type CreateRecipeJobInput struct {
	_ struct{} `type:"structure"`

	// One or more artifacts that represent the Glue Data Catalog output from running
	// the job.
	DataCatalogOutputs []*DataCatalogOutput_ `min:"1" type:"list"`

	// Represents a list of JDBC database output objects which defines the output
	// destination for a DataBrew recipe job to write to.
	DatabaseOutputs []*DatabaseOutput_ `min:"1" type:"list"`

	// The name of the dataset that this job processes.
	DatasetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an encryption key that is used to protect
	// the job.
	EncryptionKeyArn *string `min:"20" type:"string"`

	// The encryption mode for the job, which can be one of the following:
	//
	//    * SSE-KMS - Server-side encryption with keys managed by KMS.
	//
	//    * SSE-S3 - Server-side encryption with keys managed by Amazon S3.
	EncryptionMode *string `type:"string" enum:"EncryptionMode"`

	// Enables or disables Amazon CloudWatch logging for the job. If logging is
	// enabled, CloudWatch writes one log stream for each job run.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// The maximum number of nodes that DataBrew can consume when the job processes
	// data.
	MaxCapacity *int64 `type:"integer"`

	// The maximum number of times to retry the job after a job run fails.
	MaxRetries *int64 `type:"integer"`

	// A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9),
	// hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// One or more artifacts that represent the output from running the job.
	Outputs []*Output `min:"1" type:"list"`

	// Either the name of an existing project, or a combination of a recipe and
	// a dataset to associate with the recipe.
	ProjectName *string `min:"1" type:"string"`

	// Represents the name and version of a DataBrew recipe.
	RecipeReference *RecipeReference `type:"structure"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role to be assumed when DataBrew runs the job.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Metadata tags to apply to this job.
	Tags map[string]*string `min:"1" type:"map"`

	// The job's timeout in minutes. A job that attempts to run longer than this
	// timeout period ends with a status of TIMEOUT.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRecipeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRecipeJobInput"}
	if s.DataCatalogOutputs != nil && len(s.DataCatalogOutputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataCatalogOutputs", 1))
	}
	if s.DatabaseOutputs != nil && len(s.DatabaseOutputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseOutputs", 1))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Outputs != nil && len(s.Outputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outputs", 1))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.DataCatalogOutputs != nil {
		for i, v := range s.DataCatalogOutputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataCatalogOutputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DatabaseOutputs != nil {
		for i, v := range s.DatabaseOutputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DatabaseOutputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RecipeReference != nil {
		if err := s.RecipeReference.Validate(); err != nil {
			invalidParams.AddNested("RecipeReference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataCatalogOutputs sets the DataCatalogOutputs field's value.
func (s *CreateRecipeJobInput) SetDataCatalogOutputs(v []*DataCatalogOutput_) *CreateRecipeJobInput {
	s.DataCatalogOutputs = v
	return s
}

// SetDatabaseOutputs sets the DatabaseOutputs field's value.
func (s *CreateRecipeJobInput) SetDatabaseOutputs(v []*DatabaseOutput_) *CreateRecipeJobInput {
	s.DatabaseOutputs = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateRecipeJobInput) SetDatasetName(v string) *CreateRecipeJobInput {
	s.DatasetName = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *CreateRecipeJobInput) SetEncryptionKeyArn(v string) *CreateRecipeJobInput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *CreateRecipeJobInput) SetEncryptionMode(v string) *CreateRecipeJobInput {
	s.EncryptionMode = &v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *CreateRecipeJobInput) SetLogSubscription(v string) *CreateRecipeJobInput {
	s.LogSubscription = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *CreateRecipeJobInput) SetMaxCapacity(v int64) *CreateRecipeJobInput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *CreateRecipeJobInput) SetMaxRetries(v int64) *CreateRecipeJobInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRecipeJobInput) SetName(v string) *CreateRecipeJobInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateRecipeJobInput) SetOutputs(v []*Output) *CreateRecipeJobInput {
	s.Outputs = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateRecipeJobInput) SetProjectName(v string) *CreateRecipeJobInput {
	s.ProjectName = &v
	return s
}

// SetRecipeReference sets the RecipeReference field's value.
func (s *CreateRecipeJobInput) SetRecipeReference(v *RecipeReference) *CreateRecipeJobInput {
	s.RecipeReference = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateRecipeJobInput) SetRoleArn(v string) *CreateRecipeJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRecipeJobInput) SetTags(v map[string]*string) *CreateRecipeJobInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateRecipeJobInput) SetTimeout(v int64) *CreateRecipeJobInput {
	s.Timeout = &v
	return s
}

type CreateRecipeJobOutput struct {
	_ struct{} `type:"structure"`

	// The name of the job that you created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateRecipeJobOutput) SetName(v string) *CreateRecipeJobOutput {
	s.Name = &v
	return s
}

type CreateRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The name of the recipe that you created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRecipeOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateRecipeOutput) SetName(v string) *CreateRecipeOutput {
	s.Name = &v
	return s
}

type CreateRulesetInput struct {
	_ struct{} `type:"structure"`

	// The description of the ruleset.
	Description *string `type:"string"`

	// The name of the ruleset to be created. Valid characters are alphanumeric
	// (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of rules that are defined with the ruleset. A rule includes one or
	// more checks to be validated on a DataBrew dataset.
	//
	// Rules is a required field
	Rules []*Rule `min:"1" type:"list" required:"true"`

	// Metadata tags to apply to the ruleset.
	Tags map[string]*string `min:"1" type:"map"`

	// The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
	// associated with.
	//
	// TargetArn is a required field
	TargetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRulesetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRulesetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRulesetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRulesetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 20))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRulesetInput) SetDescription(v string) *CreateRulesetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRulesetInput) SetName(v string) *CreateRulesetInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateRulesetInput) SetRules(v []*Rule) *CreateRulesetInput {
	s.Rules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRulesetInput) SetTags(v map[string]*string) *CreateRulesetInput {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *CreateRulesetInput) SetTargetArn(v string) *CreateRulesetInput {
	s.TargetArn = &v
	return s
}

type CreateRulesetOutput struct {
	_ struct{} `type:"structure"`

	// The unique name of the created ruleset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRulesetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRulesetOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateRulesetOutput) SetName(v string) *CreateRulesetOutput {
	s.Name = &v
	return s
}

type CreateScheduleInput struct {
	_ struct{} `type:"structure"`

	// The date or dates and time or times when the jobs are to be run. For more
	// information, see Cron expressions (https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html)
	// in the Glue DataBrew Developer Guide.
	//
	// CronExpression is a required field
	CronExpression *string `min:"1" type:"string" required:"true"`

	// The name or names of one or more jobs to be run.
	JobNames []*string `type:"list"`

	// A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z,
	// 0-9), hyphen (-), period (.), and space.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Metadata tags to apply to this schedule.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduleInput"}
	if s.CronExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("CronExpression"))
	}
	if s.CronExpression != nil && len(*s.CronExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CronExpression", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCronExpression sets the CronExpression field's value.
func (s *CreateScheduleInput) SetCronExpression(v string) *CreateScheduleInput {
	s.CronExpression = &v
	return s
}

// SetJobNames sets the JobNames field's value.
func (s *CreateScheduleInput) SetJobNames(v []*string) *CreateScheduleInput {
	s.JobNames = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateScheduleInput) SetName(v string) *CreateScheduleInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScheduleInput) SetTags(v map[string]*string) *CreateScheduleInput {
	s.Tags = v
	return s
}

type CreateScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The name of the schedule that was created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateScheduleOutput) SetName(v string) *CreateScheduleOutput {
	s.Name = &v
	return s
}

// Represents a set of options that define how DataBrew will read a comma-separated
// value (CSV) file when creating a dataset from that file.
type CsvOptions struct {
	_ struct{} `type:"structure"`

	// A single character that specifies the delimiter being used in the CSV file.
	Delimiter *string `min:"1" type:"string"`

	// A variable that specifies whether the first row in the file is parsed as
	// the header. If this value is false, column names are auto-generated.
	HeaderRow *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CsvOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CsvOptions"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Delimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelimiter sets the Delimiter field's value.
func (s *CsvOptions) SetDelimiter(v string) *CsvOptions {
	s.Delimiter = &v
	return s
}

// SetHeaderRow sets the HeaderRow field's value.
func (s *CsvOptions) SetHeaderRow(v bool) *CsvOptions {
	s.HeaderRow = &v
	return s
}

// Represents a set of options that define how DataBrew will write a comma-separated
// value (CSV) file.
type CsvOutputOptions struct {
	_ struct{} `type:"structure"`

	// A single character that specifies the delimiter used to create CSV job output.
	Delimiter *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvOutputOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsvOutputOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CsvOutputOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CsvOutputOptions"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Delimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelimiter sets the Delimiter field's value.
func (s *CsvOutputOptions) SetDelimiter(v string) *CsvOutputOptions {
	s.Delimiter = &v
	return s
}

// Represents how metadata stored in the Glue Data Catalog is defined in a DataBrew
// dataset.
type DataCatalogInputDefinition struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Web Services account that holds the Data
	// Catalog that stores the data.
	CatalogId *string `min:"1" type:"string"`

	// The name of a database in the Data Catalog.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of a database table in the Data Catalog. This table corresponds
	// to a DataBrew dataset.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// Represents an Amazon location where DataBrew can store intermediate results.
	TempDirectory *S3Location `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCatalogInputDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCatalogInputDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCatalogInputDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataCatalogInputDefinition"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.TempDirectory != nil {
		if err := s.TempDirectory.Validate(); err != nil {
			invalidParams.AddNested("TempDirectory", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DataCatalogInputDefinition) SetCatalogId(v string) *DataCatalogInputDefinition {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DataCatalogInputDefinition) SetDatabaseName(v string) *DataCatalogInputDefinition {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DataCatalogInputDefinition) SetTableName(v string) *DataCatalogInputDefinition {
	s.TableName = &v
	return s
}

// SetTempDirectory sets the TempDirectory field's value.
func (s *DataCatalogInputDefinition) SetTempDirectory(v *S3Location) *DataCatalogInputDefinition {
	s.TempDirectory = v
	return s
}

// Represents options that specify how and where in the Glue Data Catalog DataBrew
// writes the output generated by recipe jobs.
type DataCatalogOutput_ struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Web Services account that holds the Data
	// Catalog that stores the data.
	CatalogId *string `min:"1" type:"string"`

	// The name of a database in the Data Catalog.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// Represents options that specify how and where DataBrew writes the database
	// output generated by recipe jobs.
	DatabaseOptions *DatabaseTableOutputOptions `type:"structure"`

	// A value that, if true, means that any data in the location specified for
	// output is overwritten with new output. Not supported with DatabaseOptions.
	Overwrite *bool `type:"boolean"`

	// Represents options that specify how and where DataBrew writes the Amazon
	// S3 output generated by recipe jobs.
	S3Options *S3TableOutputOptions `type:"structure"`

	// The name of a table in the Data Catalog.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCatalogOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCatalogOutput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCatalogOutput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataCatalogOutput_"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.DatabaseOptions != nil {
		if err := s.DatabaseOptions.Validate(); err != nil {
			invalidParams.AddNested("DatabaseOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Options != nil {
		if err := s.S3Options.Validate(); err != nil {
			invalidParams.AddNested("S3Options", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DataCatalogOutput_) SetCatalogId(v string) *DataCatalogOutput_ {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DataCatalogOutput_) SetDatabaseName(v string) *DataCatalogOutput_ {
	s.DatabaseName = &v
	return s
}

// SetDatabaseOptions sets the DatabaseOptions field's value.
func (s *DataCatalogOutput_) SetDatabaseOptions(v *DatabaseTableOutputOptions) *DataCatalogOutput_ {
	s.DatabaseOptions = v
	return s
}

// SetOverwrite sets the Overwrite field's value.
func (s *DataCatalogOutput_) SetOverwrite(v bool) *DataCatalogOutput_ {
	s.Overwrite = &v
	return s
}

// SetS3Options sets the S3Options field's value.
func (s *DataCatalogOutput_) SetS3Options(v *S3TableOutputOptions) *DataCatalogOutput_ {
	s.S3Options = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DataCatalogOutput_) SetTableName(v string) *DataCatalogOutput_ {
	s.TableName = &v
	return s
}

// Connection information for dataset input files stored in a database.
type DatabaseInputDefinition struct {
	_ struct{} `type:"structure"`

	// The table within the target database.
	DatabaseTableName *string `min:"1" type:"string"`

	// The Glue Connection that stores the connection information for the target
	// database.
	//
	// GlueConnectionName is a required field
	GlueConnectionName *string `min:"1" type:"string" required:"true"`

	// Custom SQL to run against the provided Glue connection. This SQL will be
	// used as the input for DataBrew projects and jobs.
	QueryString *string `min:"1" type:"string"`

	// Represents an Amazon S3 location (bucket name and object key) where DataBrew
	// can read input data, or write output from a job.
	TempDirectory *S3Location `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseInputDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseInputDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseInputDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseInputDefinition"}
	if s.DatabaseTableName != nil && len(*s.DatabaseTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseTableName", 1))
	}
	if s.GlueConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlueConnectionName"))
	}
	if s.GlueConnectionName != nil && len(*s.GlueConnectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlueConnectionName", 1))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.TempDirectory != nil {
		if err := s.TempDirectory.Validate(); err != nil {
			invalidParams.AddNested("TempDirectory", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseTableName sets the DatabaseTableName field's value.
func (s *DatabaseInputDefinition) SetDatabaseTableName(v string) *DatabaseInputDefinition {
	s.DatabaseTableName = &v
	return s
}

// SetGlueConnectionName sets the GlueConnectionName field's value.
func (s *DatabaseInputDefinition) SetGlueConnectionName(v string) *DatabaseInputDefinition {
	s.GlueConnectionName = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *DatabaseInputDefinition) SetQueryString(v string) *DatabaseInputDefinition {
	s.QueryString = &v
	return s
}

// SetTempDirectory sets the TempDirectory field's value.
func (s *DatabaseInputDefinition) SetTempDirectory(v *S3Location) *DatabaseInputDefinition {
	s.TempDirectory = v
	return s
}

// Represents a JDBC database output object which defines the output destination
// for a DataBrew recipe job to write into.
type DatabaseOutput_ struct {
	_ struct{} `type:"structure"`

	// Represents options that specify how and where DataBrew writes the database
	// output generated by recipe jobs.
	//
	// DatabaseOptions is a required field
	DatabaseOptions *DatabaseTableOutputOptions `type:"structure" required:"true"`

	// The output mode to write into the database. Currently supported option: NEW_TABLE.
	DatabaseOutputMode *string `type:"string" enum:"DatabaseOutputMode"`

	// The Glue connection that stores the connection information for the target
	// database.
	//
	// GlueConnectionName is a required field
	GlueConnectionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseOutput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseOutput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseOutput_"}
	if s.DatabaseOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseOptions"))
	}
	if s.GlueConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("GlueConnectionName"))
	}
	if s.GlueConnectionName != nil && len(*s.GlueConnectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlueConnectionName", 1))
	}
	if s.DatabaseOptions != nil {
		if err := s.DatabaseOptions.Validate(); err != nil {
			invalidParams.AddNested("DatabaseOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseOptions sets the DatabaseOptions field's value.
func (s *DatabaseOutput_) SetDatabaseOptions(v *DatabaseTableOutputOptions) *DatabaseOutput_ {
	s.DatabaseOptions = v
	return s
}

// SetDatabaseOutputMode sets the DatabaseOutputMode field's value.
func (s *DatabaseOutput_) SetDatabaseOutputMode(v string) *DatabaseOutput_ {
	s.DatabaseOutputMode = &v
	return s
}

// SetGlueConnectionName sets the GlueConnectionName field's value.
func (s *DatabaseOutput_) SetGlueConnectionName(v string) *DatabaseOutput_ {
	s.GlueConnectionName = &v
	return s
}

// Represents options that specify how and where DataBrew writes the database
// output generated by recipe jobs.
type DatabaseTableOutputOptions struct {
	_ struct{} `type:"structure"`

	// A prefix for the name of a table DataBrew will create in the database.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// Represents an Amazon S3 location (bucket name and object key) where DataBrew
	// can store intermediate results.
	TempDirectory *S3Location `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseTableOutputOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseTableOutputOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseTableOutputOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseTableOutputOptions"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.TempDirectory != nil {
		if err := s.TempDirectory.Validate(); err != nil {
			invalidParams.AddNested("TempDirectory", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DatabaseTableOutputOptions) SetTableName(v string) *DatabaseTableOutputOptions {
	s.TableName = &v
	return s
}

// SetTempDirectory sets the TempDirectory field's value.
func (s *DatabaseTableOutputOptions) SetTempDirectory(v *S3Location) *DatabaseTableOutputOptions {
	s.TempDirectory = v
	return s
}

// Represents a dataset that can be processed by DataBrew.
type Dataset struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the dataset.
	AccountId *string `type:"string"`

	// The date and time that the dataset was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who created the dataset.
	CreatedBy *string `type:"string"`

	// The file format of a dataset that is created from an Amazon S3 file or folder.
	Format *string `type:"string" enum:"InputFormat"`

	// A set of options that define how DataBrew interprets the data in the dataset.
	FormatOptions *FormatOptions `type:"structure"`

	// Information on how DataBrew can find the dataset, in either the Glue Data
	// Catalog or Amazon S3.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the user who last modified the dataset.
	LastModifiedBy *string `type:"string"`

	// The last modification date and time of the dataset.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The unique name of the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A set of options that defines how DataBrew interprets an Amazon S3 path of
	// the dataset.
	PathOptions *PathOptions `type:"structure"`

	// The unique Amazon Resource Name (ARN) for the dataset.
	ResourceArn *string `min:"20" type:"string"`

	// The location of the data for the dataset, either Amazon S3 or the Glue Data
	// Catalog.
	Source *string `type:"string" enum:"Source"`

	// Metadata tags that have been applied to the dataset.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Dataset) SetAccountId(v string) *Dataset {
	s.AccountId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Dataset) SetCreateDate(v time.Time) *Dataset {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Dataset) SetCreatedBy(v string) *Dataset {
	s.CreatedBy = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *Dataset) SetFormat(v string) *Dataset {
	s.Format = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *Dataset) SetFormatOptions(v *FormatOptions) *Dataset {
	s.FormatOptions = v
	return s
}

// SetInput sets the Input field's value.
func (s *Dataset) SetInput(v *Input) *Dataset {
	s.Input = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Dataset) SetLastModifiedBy(v string) *Dataset {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Dataset) SetLastModifiedDate(v time.Time) *Dataset {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dataset) SetName(v string) *Dataset {
	s.Name = &v
	return s
}

// SetPathOptions sets the PathOptions field's value.
func (s *Dataset) SetPathOptions(v *PathOptions) *Dataset {
	s.PathOptions = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Dataset) SetResourceArn(v string) *Dataset {
	s.ResourceArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Dataset) SetSource(v string) *Dataset {
	s.Source = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Dataset) SetTags(v map[string]*string) *Dataset {
	s.Tags = v
	return s
}

// Represents a dataset paramater that defines type and conditions for a parameter
// in the Amazon S3 path of the dataset.
type DatasetParameter struct {
	_ struct{} `type:"structure"`

	// Optional boolean value that defines whether the captured value of this parameter
	// should be used to create a new column in a dataset.
	CreateColumn *bool `type:"boolean"`

	// Additional parameter options such as a format and a timezone. Required for
	// datetime parameters.
	DatetimeOptions *DatetimeOptions `type:"structure"`

	// The optional filter expression structure to apply additional matching criteria
	// to the parameter.
	Filter *FilterExpression `type:"structure"`

	// The name of the parameter that is used in the dataset's Amazon S3 path.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of the dataset parameter, can be one of a 'String', 'Number' or
	// 'Datetime'.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ParameterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.DatetimeOptions != nil {
		if err := s.DatetimeOptions.Validate(); err != nil {
			invalidParams.AddNested("DatetimeOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateColumn sets the CreateColumn field's value.
func (s *DatasetParameter) SetCreateColumn(v bool) *DatasetParameter {
	s.CreateColumn = &v
	return s
}

// SetDatetimeOptions sets the DatetimeOptions field's value.
func (s *DatasetParameter) SetDatetimeOptions(v *DatetimeOptions) *DatasetParameter {
	s.DatetimeOptions = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *DatasetParameter) SetFilter(v *FilterExpression) *DatasetParameter {
	s.Filter = v
	return s
}

// SetName sets the Name field's value.
func (s *DatasetParameter) SetName(v string) *DatasetParameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *DatasetParameter) SetType(v string) *DatasetParameter {
	s.Type = &v
	return s
}

// Represents additional options for correct interpretation of datetime parameters
// used in the Amazon S3 path of a dataset.
type DatetimeOptions struct {
	_ struct{} `type:"structure"`

	// Required option, that defines the datetime format used for a date parameter
	// in the Amazon S3 path. Should use only supported datetime specifiers and
	// separation characters, all literal a-z or A-Z characters should be escaped
	// with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
	//
	// Format is a required field
	Format *string `min:"2" type:"string" required:"true"`

	// Optional value for a non-US locale code, needed for correct interpretation
	// of some date formats.
	LocaleCode *string `min:"2" type:"string"`

	// Optional value for a timezone offset of the datetime parameter value in the
	// Amazon S3 path. Shouldn't be used if Format for this parameter includes timezone
	// fields. If no offset specified, UTC is assumed.
	TimezoneOffset *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatetimeOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatetimeOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatetimeOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatetimeOptions"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Format != nil && len(*s.Format) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Format", 2))
	}
	if s.LocaleCode != nil && len(*s.LocaleCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleCode", 2))
	}
	if s.TimezoneOffset != nil && len(*s.TimezoneOffset) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimezoneOffset", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *DatetimeOptions) SetFormat(v string) *DatetimeOptions {
	s.Format = &v
	return s
}

// SetLocaleCode sets the LocaleCode field's value.
func (s *DatetimeOptions) SetLocaleCode(v string) *DatetimeOptions {
	s.LocaleCode = &v
	return s
}

// SetTimezoneOffset sets the TimezoneOffset field's value.
func (s *DatetimeOptions) SetTimezoneOffset(v string) *DatetimeOptions {
	s.TimezoneOffset = &v
	return s
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the dataset to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteDatasetInput) SetName(v string) *DeleteDatasetInput {
	s.Name = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset that you deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteDatasetOutput) SetName(v string) *DeleteDatasetOutput {
	s.Name = &v
	return s
}

type DeleteJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the job to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteJobInput) SetName(v string) *DeleteJobInput {
	s.Name = &v
	return s
}

type DeleteJobOutput struct {
	_ struct{} `type:"structure"`

	// The name of the job that you deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteJobOutput) SetName(v string) *DeleteJobOutput {
	s.Name = &v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the project to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteProjectInput) SetName(v string) *DeleteProjectInput {
	s.Name = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`

	// The name of the project that you deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteProjectOutput) SetName(v string) *DeleteProjectOutput {
	s.Name = &v
	return s
}

type DeleteRecipeVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the recipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the recipe to be deleted. You can specify a numeric versions
	// (X.Y) or LATEST_WORKING. LATEST_PUBLISHED is not supported.
	//
	// RecipeVersion is a required field
	RecipeVersion *string `location:"uri" locationName:"recipeVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecipeVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecipeVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecipeVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecipeVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RecipeVersion"))
	}
	if s.RecipeVersion != nil && len(*s.RecipeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecipeVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteRecipeVersionInput) SetName(v string) *DeleteRecipeVersionInput {
	s.Name = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *DeleteRecipeVersionInput) SetRecipeVersion(v string) *DeleteRecipeVersionInput {
	s.RecipeVersion = &v
	return s
}

type DeleteRecipeVersionOutput struct {
	_ struct{} `type:"structure"`

	// The name of the recipe that was deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of the recipe that was deleted.
	//
	// RecipeVersion is a required field
	RecipeVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecipeVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecipeVersionOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteRecipeVersionOutput) SetName(v string) *DeleteRecipeVersionOutput {
	s.Name = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *DeleteRecipeVersionOutput) SetRecipeVersion(v string) *DeleteRecipeVersionOutput {
	s.RecipeVersion = &v
	return s
}

type DeleteRulesetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ruleset to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRulesetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRulesetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRulesetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRulesetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteRulesetInput) SetName(v string) *DeleteRulesetInput {
	s.Name = &v
	return s
}

type DeleteRulesetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the deleted ruleset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRulesetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRulesetOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteRulesetOutput) SetName(v string) *DeleteRulesetOutput {
	s.Name = &v
	return s
}

type DeleteScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schedule to be deleted.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteScheduleInput) SetName(v string) *DeleteScheduleInput {
	s.Name = &v
	return s
}

type DeleteScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The name of the schedule that was deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteScheduleOutput) SetName(v string) *DeleteScheduleOutput {
	s.Name = &v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the dataset to be described.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeDatasetInput) SetName(v string) *DescribeDatasetInput {
	s.Name = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the dataset was created.
	CreateDate *time.Time `type:"timestamp"`

	// The identifier (user name) of the user who created the dataset.
	CreatedBy *string `type:"string"`

	// The file format of a dataset that is created from an Amazon S3 file or folder.
	Format *string `type:"string" enum:"InputFormat"`

	// Represents a set of options that define the structure of either comma-separated
	// value (CSV), Excel, or JSON input.
	FormatOptions *FormatOptions `type:"structure"`

	// Represents information on how DataBrew can find data, in either the Glue
	// Data Catalog or Amazon S3.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`

	// The identifier (user name) of the user who last modified the dataset.
	LastModifiedBy *string `type:"string"`

	// The date and time that the dataset was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A set of options that defines how DataBrew interprets an Amazon S3 path of
	// the dataset.
	PathOptions *PathOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	ResourceArn *string `min:"20" type:"string"`

	// The location of the data for this dataset, Amazon S3 or the Glue Data Catalog.
	Source *string `type:"string" enum:"Source"`

	// Metadata tags associated with this dataset.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DescribeDatasetOutput) SetCreateDate(v time.Time) *DescribeDatasetOutput {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeDatasetOutput) SetCreatedBy(v string) *DescribeDatasetOutput {
	s.CreatedBy = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DescribeDatasetOutput) SetFormat(v string) *DescribeDatasetOutput {
	s.Format = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *DescribeDatasetOutput) SetFormatOptions(v *FormatOptions) *DescribeDatasetOutput {
	s.FormatOptions = v
	return s
}

// SetInput sets the Input field's value.
func (s *DescribeDatasetOutput) SetInput(v *Input) *DescribeDatasetOutput {
	s.Input = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeDatasetOutput) SetLastModifiedBy(v string) *DescribeDatasetOutput {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeDatasetOutput) SetLastModifiedDate(v time.Time) *DescribeDatasetOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeDatasetOutput) SetName(v string) *DescribeDatasetOutput {
	s.Name = &v
	return s
}

// SetPathOptions sets the PathOptions field's value.
func (s *DescribeDatasetOutput) SetPathOptions(v *PathOptions) *DescribeDatasetOutput {
	s.PathOptions = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeDatasetOutput) SetResourceArn(v string) *DescribeDatasetOutput {
	s.ResourceArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDatasetOutput) SetSource(v string) *DescribeDatasetOutput {
	s.Source = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDatasetOutput) SetTags(v map[string]*string) *DescribeDatasetOutput {
	s.Tags = v
	return s
}

type DescribeJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the job to be described.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeJobInput) SetName(v string) *DescribeJobInput {
	s.Name = &v
	return s
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the job was created.
	CreateDate *time.Time `type:"timestamp"`

	// The identifier (user name) of the user associated with the creation of the
	// job.
	CreatedBy *string `type:"string"`

	// One or more artifacts that represent the Glue Data Catalog output from running
	// the job.
	DataCatalogOutputs []*DataCatalogOutput_ `min:"1" type:"list"`

	// Represents a list of JDBC database output objects which defines the output
	// destination for a DataBrew recipe job to write into.
	DatabaseOutputs []*DatabaseOutput_ `min:"1" type:"list"`

	// The dataset that the job acts upon.
	DatasetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an encryption key that is used to protect
	// the job.
	EncryptionKeyArn *string `min:"20" type:"string"`

	// The encryption mode for the job, which can be one of the following:
	//
	//    * SSE-KMS - Server-side encryption with keys managed by KMS.
	//
	//    * SSE-S3 - Server-side encryption with keys managed by Amazon S3.
	EncryptionMode *string `type:"string" enum:"EncryptionMode"`

	// Sample configuration for profile jobs only. Determines the number of rows
	// on which the profile job will be executed.
	JobSample *JobSample `type:"structure"`

	// The identifier (user name) of the user who last modified the job.
	LastModifiedBy *string `type:"string"`

	// The date and time that the job was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Indicates whether Amazon CloudWatch logging is enabled for this job.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// The maximum number of compute nodes that DataBrew can consume when the job
	// processes data.
	MaxCapacity *int64 `type:"integer"`

	// The maximum number of times to retry the job after a job run fails.
	MaxRetries *int64 `type:"integer"`

	// The name of the job.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// One or more artifacts that represent the output from running the job.
	Outputs []*Output `min:"1" type:"list"`

	// Configuration for profile jobs. Used to select columns, do evaluations, and
	// override default parameters of evaluations. When configuration is null, the
	// profile job will run with default settings.
	ProfileConfiguration *ProfileConfiguration `type:"structure"`

	// The DataBrew project associated with this job.
	ProjectName *string `min:"1" type:"string"`

	// Represents the name and version of a DataBrew recipe.
	RecipeReference *RecipeReference `type:"structure"`

	// The Amazon Resource Name (ARN) of the job.
	ResourceArn *string `min:"20" type:"string"`

	// The ARN of the Identity and Access Management (IAM) role to be assumed when
	// DataBrew runs the job.
	RoleArn *string `min:"20" type:"string"`

	// Metadata tags associated with this job.
	Tags map[string]*string `min:"1" type:"map"`

	// The job's timeout in minutes. A job that attempts to run longer than this
	// timeout period ends with a status of TIMEOUT.
	Timeout *int64 `type:"integer"`

	// The job type, which must be one of the following:
	//
	//    * PROFILE - The job analyzes the dataset to determine its size, data types,
	//    data distribution, and more.
	//
	//    * RECIPE - The job applies one or more transformations to a dataset.
	Type *string `type:"string" enum:"JobType"`

	// List of validation configurations that are applied to the profile job.
	ValidationConfigurations []*ValidationConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DescribeJobOutput) SetCreateDate(v time.Time) *DescribeJobOutput {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeJobOutput) SetCreatedBy(v string) *DescribeJobOutput {
	s.CreatedBy = &v
	return s
}

// SetDataCatalogOutputs sets the DataCatalogOutputs field's value.
func (s *DescribeJobOutput) SetDataCatalogOutputs(v []*DataCatalogOutput_) *DescribeJobOutput {
	s.DataCatalogOutputs = v
	return s
}

// SetDatabaseOutputs sets the DatabaseOutputs field's value.
func (s *DescribeJobOutput) SetDatabaseOutputs(v []*DatabaseOutput_) *DescribeJobOutput {
	s.DatabaseOutputs = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeJobOutput) SetDatasetName(v string) *DescribeJobOutput {
	s.DatasetName = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *DescribeJobOutput) SetEncryptionKeyArn(v string) *DescribeJobOutput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *DescribeJobOutput) SetEncryptionMode(v string) *DescribeJobOutput {
	s.EncryptionMode = &v
	return s
}

// SetJobSample sets the JobSample field's value.
func (s *DescribeJobOutput) SetJobSample(v *JobSample) *DescribeJobOutput {
	s.JobSample = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeJobOutput) SetLastModifiedBy(v string) *DescribeJobOutput {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeJobOutput) SetLastModifiedDate(v time.Time) *DescribeJobOutput {
	s.LastModifiedDate = &v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *DescribeJobOutput) SetLogSubscription(v string) *DescribeJobOutput {
	s.LogSubscription = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *DescribeJobOutput) SetMaxCapacity(v int64) *DescribeJobOutput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *DescribeJobOutput) SetMaxRetries(v int64) *DescribeJobOutput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeJobOutput) SetName(v string) *DescribeJobOutput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *DescribeJobOutput) SetOutputs(v []*Output) *DescribeJobOutput {
	s.Outputs = v
	return s
}

// SetProfileConfiguration sets the ProfileConfiguration field's value.
func (s *DescribeJobOutput) SetProfileConfiguration(v *ProfileConfiguration) *DescribeJobOutput {
	s.ProfileConfiguration = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeJobOutput) SetProjectName(v string) *DescribeJobOutput {
	s.ProjectName = &v
	return s
}

// SetRecipeReference sets the RecipeReference field's value.
func (s *DescribeJobOutput) SetRecipeReference(v *RecipeReference) *DescribeJobOutput {
	s.RecipeReference = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeJobOutput) SetResourceArn(v string) *DescribeJobOutput {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeJobOutput) SetRoleArn(v string) *DescribeJobOutput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeJobOutput) SetTags(v map[string]*string) *DescribeJobOutput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *DescribeJobOutput) SetTimeout(v int64) *DescribeJobOutput {
	s.Timeout = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeJobOutput) SetType(v string) *DescribeJobOutput {
	s.Type = &v
	return s
}

// SetValidationConfigurations sets the ValidationConfigurations field's value.
func (s *DescribeJobOutput) SetValidationConfigurations(v []*ValidationConfiguration) *DescribeJobOutput {
	s.ValidationConfigurations = v
	return s
}

type DescribeJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the job being processed during this run.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The unique identifier of the job run.
	//
	// RunId is a required field
	RunId *string `location:"uri" locationName:"runId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobRunInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RunId == nil {
		invalidParams.Add(request.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeJobRunInput) SetName(v string) *DescribeJobRunInput {
	s.Name = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *DescribeJobRunInput) SetRunId(v string) *DescribeJobRunInput {
	s.RunId = &v
	return s
}

type DescribeJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The number of times that DataBrew has attempted to run the job.
	Attempt *int64 `type:"integer"`

	// The date and time when the job completed processing.
	CompletedOn *time.Time `type:"timestamp"`

	// One or more artifacts that represent the Glue Data Catalog output from running
	// the job.
	DataCatalogOutputs []*DataCatalogOutput_ `min:"1" type:"list"`

	// Represents a list of JDBC database output objects which defines the output
	// destination for a DataBrew recipe job to write into.
	DatabaseOutputs []*DatabaseOutput_ `min:"1" type:"list"`

	// The name of the dataset for the job to process.
	DatasetName *string `min:"1" type:"string"`

	// A message indicating an error (if any) that was encountered when the job
	// ran.
	ErrorMessage *string `type:"string"`

	// The amount of time, in seconds, during which the job run consumed resources.
	ExecutionTime *int64 `type:"integer"`

	// The name of the job being processed during this run.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// Sample configuration for profile jobs only. Determines the number of rows
	// on which the profile job will be executed. If a JobSample value is not provided,
	// the default value will be used. The default value is CUSTOM_ROWS for the
	// mode parameter and 20000 for the size parameter.
	JobSample *JobSample `type:"structure"`

	// The name of an Amazon CloudWatch log group, where the job writes diagnostic
	// messages when it runs.
	LogGroupName *string `min:"1" type:"string"`

	// The current status of Amazon CloudWatch logging for the job run.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// One or more output artifacts from a job run.
	Outputs []*Output `min:"1" type:"list"`

	// Configuration for profile jobs. Used to select columns, do evaluations, and
	// override default parameters of evaluations. When configuration is null, the
	// profile job will run with default settings.
	ProfileConfiguration *ProfileConfiguration `type:"structure"`

	// Represents the name and version of a DataBrew recipe.
	RecipeReference *RecipeReference `type:"structure"`

	// The unique identifier of the job run.
	RunId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the user who started the job run.
	StartedBy *string `type:"string"`

	// The date and time when the job run began.
	StartedOn *time.Time `type:"timestamp"`

	// The current state of the job run entity itself.
	State *string `type:"string" enum:"JobRunState"`

	// List of validation configurations that are applied to the profile job.
	ValidationConfigurations []*ValidationConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobRunOutput) GoString() string {
	return s.String()
}

// SetAttempt sets the Attempt field's value.
func (s *DescribeJobRunOutput) SetAttempt(v int64) *DescribeJobRunOutput {
	s.Attempt = &v
	return s
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *DescribeJobRunOutput) SetCompletedOn(v time.Time) *DescribeJobRunOutput {
	s.CompletedOn = &v
	return s
}

// SetDataCatalogOutputs sets the DataCatalogOutputs field's value.
func (s *DescribeJobRunOutput) SetDataCatalogOutputs(v []*DataCatalogOutput_) *DescribeJobRunOutput {
	s.DataCatalogOutputs = v
	return s
}

// SetDatabaseOutputs sets the DatabaseOutputs field's value.
func (s *DescribeJobRunOutput) SetDatabaseOutputs(v []*DatabaseOutput_) *DescribeJobRunOutput {
	s.DatabaseOutputs = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeJobRunOutput) SetDatasetName(v string) *DescribeJobRunOutput {
	s.DatasetName = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeJobRunOutput) SetErrorMessage(v string) *DescribeJobRunOutput {
	s.ErrorMessage = &v
	return s
}

// SetExecutionTime sets the ExecutionTime field's value.
func (s *DescribeJobRunOutput) SetExecutionTime(v int64) *DescribeJobRunOutput {
	s.ExecutionTime = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DescribeJobRunOutput) SetJobName(v string) *DescribeJobRunOutput {
	s.JobName = &v
	return s
}

// SetJobSample sets the JobSample field's value.
func (s *DescribeJobRunOutput) SetJobSample(v *JobSample) *DescribeJobRunOutput {
	s.JobSample = v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *DescribeJobRunOutput) SetLogGroupName(v string) *DescribeJobRunOutput {
	s.LogGroupName = &v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *DescribeJobRunOutput) SetLogSubscription(v string) *DescribeJobRunOutput {
	s.LogSubscription = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *DescribeJobRunOutput) SetOutputs(v []*Output) *DescribeJobRunOutput {
	s.Outputs = v
	return s
}

// SetProfileConfiguration sets the ProfileConfiguration field's value.
func (s *DescribeJobRunOutput) SetProfileConfiguration(v *ProfileConfiguration) *DescribeJobRunOutput {
	s.ProfileConfiguration = v
	return s
}

// SetRecipeReference sets the RecipeReference field's value.
func (s *DescribeJobRunOutput) SetRecipeReference(v *RecipeReference) *DescribeJobRunOutput {
	s.RecipeReference = v
	return s
}

// SetRunId sets the RunId field's value.
func (s *DescribeJobRunOutput) SetRunId(v string) *DescribeJobRunOutput {
	s.RunId = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *DescribeJobRunOutput) SetStartedBy(v string) *DescribeJobRunOutput {
	s.StartedBy = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *DescribeJobRunOutput) SetStartedOn(v time.Time) *DescribeJobRunOutput {
	s.StartedOn = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeJobRunOutput) SetState(v string) *DescribeJobRunOutput {
	s.State = &v
	return s
}

// SetValidationConfigurations sets the ValidationConfigurations field's value.
func (s *DescribeJobRunOutput) SetValidationConfigurations(v []*ValidationConfiguration) *DescribeJobRunOutput {
	s.ValidationConfigurations = v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the project to be described.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeProjectInput) SetName(v string) *DescribeProjectInput {
	s.Name = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the project was created.
	CreateDate *time.Time `type:"timestamp"`

	// The identifier (user name) of the user who created the project.
	CreatedBy *string `type:"string"`

	// The dataset associated with the project.
	DatasetName *string `min:"1" type:"string"`

	// The identifier (user name) of the user who last modified the project.
	LastModifiedBy *string `type:"string"`

	// The date and time that the project was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the project.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The date and time when the project was opened.
	OpenDate *time.Time `type:"timestamp"`

	// The identifier (user name) of the user that opened the project for use.
	OpenedBy *string `type:"string"`

	// The recipe associated with this job.
	RecipeName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the project.
	ResourceArn *string `min:"20" type:"string"`

	// The ARN of the Identity and Access Management (IAM) role to be assumed when
	// DataBrew runs the job.
	RoleArn *string `min:"20" type:"string"`

	// Represents the sample size and sampling type for DataBrew to use for interactive
	// data analysis.
	Sample *Sample `type:"structure"`

	// Describes the current state of the session:
	//
	//    * PROVISIONING - allocating resources for the session.
	//
	//    * INITIALIZING - getting the session ready for first use.
	//
	//    * ASSIGNED - the session is ready for use.
	SessionStatus *string `type:"string" enum:"SessionStatus"`

	// Metadata tags associated with this project.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DescribeProjectOutput) SetCreateDate(v time.Time) *DescribeProjectOutput {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeProjectOutput) SetCreatedBy(v string) *DescribeProjectOutput {
	s.CreatedBy = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeProjectOutput) SetDatasetName(v string) *DescribeProjectOutput {
	s.DatasetName = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeProjectOutput) SetLastModifiedBy(v string) *DescribeProjectOutput {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeProjectOutput) SetLastModifiedDate(v time.Time) *DescribeProjectOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeProjectOutput) SetName(v string) *DescribeProjectOutput {
	s.Name = &v
	return s
}

// SetOpenDate sets the OpenDate field's value.
func (s *DescribeProjectOutput) SetOpenDate(v time.Time) *DescribeProjectOutput {
	s.OpenDate = &v
	return s
}

// SetOpenedBy sets the OpenedBy field's value.
func (s *DescribeProjectOutput) SetOpenedBy(v string) *DescribeProjectOutput {
	s.OpenedBy = &v
	return s
}

// SetRecipeName sets the RecipeName field's value.
func (s *DescribeProjectOutput) SetRecipeName(v string) *DescribeProjectOutput {
	s.RecipeName = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeProjectOutput) SetResourceArn(v string) *DescribeProjectOutput {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeProjectOutput) SetRoleArn(v string) *DescribeProjectOutput {
	s.RoleArn = &v
	return s
}

// SetSample sets the Sample field's value.
func (s *DescribeProjectOutput) SetSample(v *Sample) *DescribeProjectOutput {
	s.Sample = v
	return s
}

// SetSessionStatus sets the SessionStatus field's value.
func (s *DescribeProjectOutput) SetSessionStatus(v string) *DescribeProjectOutput {
	s.SessionStatus = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeProjectOutput) SetTags(v map[string]*string) *DescribeProjectOutput {
	s.Tags = v
	return s
}

type DescribeRecipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the recipe to be described.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The recipe version identifier. If this parameter isn't specified, then the
	// latest published version is returned.
	RecipeVersion *string `location:"querystring" locationName:"recipeVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeVersion != nil && len(*s.RecipeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecipeVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeRecipeInput) SetName(v string) *DescribeRecipeInput {
	s.Name = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *DescribeRecipeInput) SetRecipeVersion(v string) *DescribeRecipeInput {
	s.RecipeVersion = &v
	return s
}

type DescribeRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the recipe was created.
	CreateDate *time.Time `type:"timestamp"`

	// The identifier (user name) of the user who created the recipe.
	CreatedBy *string `type:"string"`

	// The description of the recipe.
	Description *string `type:"string"`

	// The identifier (user name) of the user who last modified the recipe.
	LastModifiedBy *string `type:"string"`

	// The date and time that the recipe was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the recipe.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of the project associated with this recipe.
	ProjectName *string `min:"1" type:"string"`

	// The identifier (user name) of the user who last published the recipe.
	PublishedBy *string `type:"string"`

	// The date and time when the recipe was last published.
	PublishedDate *time.Time `type:"timestamp"`

	// The recipe version identifier.
	RecipeVersion *string `min:"1" type:"string"`

	// The ARN of the recipe.
	ResourceArn *string `min:"20" type:"string"`

	// One or more steps to be performed by the recipe. Each step consists of an
	// action, and the conditions under which the action should succeed.
	Steps []*RecipeStep `type:"list"`

	// Metadata tags associated with this project.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecipeOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DescribeRecipeOutput) SetCreateDate(v time.Time) *DescribeRecipeOutput {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeRecipeOutput) SetCreatedBy(v string) *DescribeRecipeOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRecipeOutput) SetDescription(v string) *DescribeRecipeOutput {
	s.Description = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeRecipeOutput) SetLastModifiedBy(v string) *DescribeRecipeOutput {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeRecipeOutput) SetLastModifiedDate(v time.Time) *DescribeRecipeOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRecipeOutput) SetName(v string) *DescribeRecipeOutput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeRecipeOutput) SetProjectName(v string) *DescribeRecipeOutput {
	s.ProjectName = &v
	return s
}

// SetPublishedBy sets the PublishedBy field's value.
func (s *DescribeRecipeOutput) SetPublishedBy(v string) *DescribeRecipeOutput {
	s.PublishedBy = &v
	return s
}

// SetPublishedDate sets the PublishedDate field's value.
func (s *DescribeRecipeOutput) SetPublishedDate(v time.Time) *DescribeRecipeOutput {
	s.PublishedDate = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *DescribeRecipeOutput) SetRecipeVersion(v string) *DescribeRecipeOutput {
	s.RecipeVersion = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeRecipeOutput) SetResourceArn(v string) *DescribeRecipeOutput {
	s.ResourceArn = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *DescribeRecipeOutput) SetSteps(v []*RecipeStep) *DescribeRecipeOutput {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRecipeOutput) SetTags(v map[string]*string) *DescribeRecipeOutput {
	s.Tags = v
	return s
}

type DescribeRulesetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ruleset to be described.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRulesetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRulesetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRulesetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRulesetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeRulesetInput) SetName(v string) *DescribeRulesetInput {
	s.Name = &v
	return s
}

type DescribeRulesetOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the ruleset was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who created the ruleset.
	CreatedBy *string `type:"string"`

	// The description of the ruleset.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user who last modified the ruleset.
	LastModifiedBy *string `type:"string"`

	// The modification date and time of the ruleset.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the ruleset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the ruleset.
	ResourceArn *string `min:"20" type:"string"`

	// A list of rules that are defined with the ruleset. A rule includes one or
	// more checks to be validated on a DataBrew dataset.
	Rules []*Rule `min:"1" type:"list"`

	// Metadata tags that have been applied to the ruleset.
	Tags map[string]*string `min:"1" type:"map"`

	// The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
	// associated with.
	TargetArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRulesetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRulesetOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DescribeRulesetOutput) SetCreateDate(v time.Time) *DescribeRulesetOutput {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeRulesetOutput) SetCreatedBy(v string) *DescribeRulesetOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRulesetOutput) SetDescription(v string) *DescribeRulesetOutput {
	s.Description = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeRulesetOutput) SetLastModifiedBy(v string) *DescribeRulesetOutput {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeRulesetOutput) SetLastModifiedDate(v time.Time) *DescribeRulesetOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRulesetOutput) SetName(v string) *DescribeRulesetOutput {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeRulesetOutput) SetResourceArn(v string) *DescribeRulesetOutput {
	s.ResourceArn = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *DescribeRulesetOutput) SetRules(v []*Rule) *DescribeRulesetOutput {
	s.Rules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRulesetOutput) SetTags(v map[string]*string) *DescribeRulesetOutput {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *DescribeRulesetOutput) SetTargetArn(v string) *DescribeRulesetOutput {
	s.TargetArn = &v
	return s
}

type DescribeScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schedule to be described.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeScheduleInput) SetName(v string) *DescribeScheduleInput {
	s.Name = &v
	return s
}

type DescribeScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the schedule was created.
	CreateDate *time.Time `type:"timestamp"`

	// The identifier (user name) of the user who created the schedule.
	CreatedBy *string `type:"string"`

	// The date or dates and time or times when the jobs are to be run for the schedule.
	// For more information, see Cron expressions (https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html)
	// in the Glue DataBrew Developer Guide.
	CronExpression *string `min:"1" type:"string"`

	// The name or names of one or more jobs to be run by using the schedule.
	JobNames []*string `type:"list"`

	// The identifier (user name) of the user who last modified the schedule.
	LastModifiedBy *string `type:"string"`

	// The date and time that the schedule was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the schedule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the schedule.
	ResourceArn *string `min:"20" type:"string"`

	// Metadata tags associated with this schedule.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DescribeScheduleOutput) SetCreateDate(v time.Time) *DescribeScheduleOutput {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeScheduleOutput) SetCreatedBy(v string) *DescribeScheduleOutput {
	s.CreatedBy = &v
	return s
}

// SetCronExpression sets the CronExpression field's value.
func (s *DescribeScheduleOutput) SetCronExpression(v string) *DescribeScheduleOutput {
	s.CronExpression = &v
	return s
}

// SetJobNames sets the JobNames field's value.
func (s *DescribeScheduleOutput) SetJobNames(v []*string) *DescribeScheduleOutput {
	s.JobNames = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *DescribeScheduleOutput) SetLastModifiedBy(v string) *DescribeScheduleOutput {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeScheduleOutput) SetLastModifiedDate(v time.Time) *DescribeScheduleOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeScheduleOutput) SetName(v string) *DescribeScheduleOutput {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeScheduleOutput) SetResourceArn(v string) *DescribeScheduleOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeScheduleOutput) SetTags(v map[string]*string) *DescribeScheduleOutput {
	s.Tags = v
	return s
}

// Configuration of entity detection for a profile job. When undefined, entity
// detection is disabled.
type EntityDetectorConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration of statistics that are allowed to be run on columns that contain
	// detected entities. When undefined, no statistics will be computed on columns
	// that contain detected entities.
	AllowedStatistics []*AllowedStatistics `min:"1" type:"list"`

	// Entity types to detect. Can be any of the following:
	//
	//    * USA_SSN
	//
	//    * EMAIL
	//
	//    * USA_ITIN
	//
	//    * USA_PASSPORT_NUMBER
	//
	//    * PHONE_NUMBER
	//
	//    * USA_DRIVING_LICENSE
	//
	//    * BANK_ACCOUNT
	//
	//    * CREDIT_CARD
	//
	//    * IP_ADDRESS
	//
	//    * MAC_ADDRESS
	//
	//    * USA_DEA_NUMBER
	//
	//    * USA_HCPCS_CODE
	//
	//    * USA_NATIONAL_PROVIDER_IDENTIFIER
	//
	//    * USA_NATIONAL_DRUG_CODE
	//
	//    * USA_HEALTH_INSURANCE_CLAIM_NUMBER
	//
	//    * USA_MEDICARE_BENEFICIARY_IDENTIFIER
	//
	//    * USA_CPT_CODE
	//
	//    * PERSON_NAME
	//
	//    * DATE
	//
	// The Entity type group USA_ALL is also supported, and includes all of the
	// above entity types except PERSON_NAME and DATE.
	//
	// EntityTypes is a required field
	EntityTypes []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityDetectorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityDetectorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityDetectorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityDetectorConfiguration"}
	if s.AllowedStatistics != nil && len(s.AllowedStatistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedStatistics", 1))
	}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.EntityTypes != nil && len(s.EntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityTypes", 1))
	}
	if s.AllowedStatistics != nil {
		for i, v := range s.AllowedStatistics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AllowedStatistics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedStatistics sets the AllowedStatistics field's value.
func (s *EntityDetectorConfiguration) SetAllowedStatistics(v []*AllowedStatistics) *EntityDetectorConfiguration {
	s.AllowedStatistics = v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EntityDetectorConfiguration) SetEntityTypes(v []*string) *EntityDetectorConfiguration {
	s.EntityTypes = v
	return s
}

// Represents a set of options that define how DataBrew will interpret a Microsoft
// Excel file when creating a dataset from that file.
type ExcelOptions struct {
	_ struct{} `type:"structure"`

	// A variable that specifies whether the first row in the file is parsed as
	// the header. If this value is false, column names are auto-generated.
	HeaderRow *bool `type:"boolean"`

	// One or more sheet numbers in the Excel file that will be included in the
	// dataset.
	SheetIndexes []*int64 `min:"1" type:"list"`

	// One or more named sheets in the Excel file that will be included in the dataset.
	SheetNames []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExcelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExcelOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExcelOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExcelOptions"}
	if s.SheetIndexes != nil && len(s.SheetIndexes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SheetIndexes", 1))
	}
	if s.SheetNames != nil && len(s.SheetNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SheetNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderRow sets the HeaderRow field's value.
func (s *ExcelOptions) SetHeaderRow(v bool) *ExcelOptions {
	s.HeaderRow = &v
	return s
}

// SetSheetIndexes sets the SheetIndexes field's value.
func (s *ExcelOptions) SetSheetIndexes(v []*int64) *ExcelOptions {
	s.SheetIndexes = v
	return s
}

// SetSheetNames sets the SheetNames field's value.
func (s *ExcelOptions) SetSheetNames(v []*string) *ExcelOptions {
	s.SheetNames = v
	return s
}

// Represents a limit imposed on number of Amazon S3 files that should be selected
// for a dataset from a connected Amazon S3 path.
type FilesLimit struct {
	_ struct{} `type:"structure"`

	// The number of Amazon S3 files to select.
	//
	// MaxFiles is a required field
	MaxFiles *int64 `min:"1" type:"integer" required:"true"`

	// A criteria to use for Amazon S3 files sorting before their selection. By
	// default uses DESCENDING order, i.e. most recent files are selected first.
	// Anotherpossible value is ASCENDING.
	Order *string `type:"string" enum:"Order"`

	// A criteria to use for Amazon S3 files sorting before their selection. By
	// default uses LAST_MODIFIED_DATE as a sorting criteria. Currently it's the
	// only allowed value.
	OrderedBy *string `type:"string" enum:"OrderedBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilesLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilesLimit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilesLimit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilesLimit"}
	if s.MaxFiles == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxFiles"))
	}
	if s.MaxFiles != nil && *s.MaxFiles < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxFiles", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxFiles sets the MaxFiles field's value.
func (s *FilesLimit) SetMaxFiles(v int64) *FilesLimit {
	s.MaxFiles = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *FilesLimit) SetOrder(v string) *FilesLimit {
	s.Order = &v
	return s
}

// SetOrderedBy sets the OrderedBy field's value.
func (s *FilesLimit) SetOrderedBy(v string) *FilesLimit {
	s.OrderedBy = &v
	return s
}

// Represents a structure for defining parameter conditions. Supported conditions
// are described here: Supported conditions for dynamic datasets (https://docs.aws.amazon.com/databrew/latest/dg/datasets.multiple-files.html#conditions.for.dynamic.datasets)
// in the Glue DataBrew Developer Guide.
type FilterExpression struct {
	_ struct{} `type:"structure"`

	// The expression which includes condition names followed by substitution variables,
	// possibly grouped and combined with other conditions. For example, "(starts_with
	// :prefix1 or starts_with :prefix2) and (ends_with :suffix1 or ends_with :suffix2)".
	// Substitution variables should start with ':' symbol.
	//
	// Expression is a required field
	Expression *string `min:"4" type:"string" required:"true"`

	// The map of substitution variable names to their values used in this filter
	// expression.
	//
	// ValuesMap is a required field
	ValuesMap map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterExpression"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 4))
	}
	if s.ValuesMap == nil {
		invalidParams.Add(request.NewErrParamRequired("ValuesMap"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *FilterExpression) SetExpression(v string) *FilterExpression {
	s.Expression = &v
	return s
}

// SetValuesMap sets the ValuesMap field's value.
func (s *FilterExpression) SetValuesMap(v map[string]*string) *FilterExpression {
	s.ValuesMap = v
	return s
}

// Represents a set of options that define the structure of either comma-separated
// value (CSV), Excel, or JSON input.
type FormatOptions struct {
	_ struct{} `type:"structure"`

	// Options that define how CSV input is to be interpreted by DataBrew.
	Csv *CsvOptions `type:"structure"`

	// Options that define how Excel input is to be interpreted by DataBrew.
	Excel *ExcelOptions `type:"structure"`

	// Options that define how JSON input is to be interpreted by DataBrew.
	Json *JsonOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormatOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormatOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FormatOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FormatOptions"}
	if s.Csv != nil {
		if err := s.Csv.Validate(); err != nil {
			invalidParams.AddNested("Csv", err.(request.ErrInvalidParams))
		}
	}
	if s.Excel != nil {
		if err := s.Excel.Validate(); err != nil {
			invalidParams.AddNested("Excel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsv sets the Csv field's value.
func (s *FormatOptions) SetCsv(v *CsvOptions) *FormatOptions {
	s.Csv = v
	return s
}

// SetExcel sets the Excel field's value.
func (s *FormatOptions) SetExcel(v *ExcelOptions) *FormatOptions {
	s.Excel = v
	return s
}

// SetJson sets the Json field's value.
func (s *FormatOptions) SetJson(v *JsonOptions) *FormatOptions {
	s.Json = v
	return s
}

// Represents information on how DataBrew can find data, in either the Glue
// Data Catalog or Amazon S3.
type Input struct {
	_ struct{} `type:"structure"`

	// The Glue Data Catalog parameters for the data.
	DataCatalogInputDefinition *DataCatalogInputDefinition `type:"structure"`

	// Connection information for dataset input files stored in a database.
	DatabaseInputDefinition *DatabaseInputDefinition `type:"structure"`

	// Contains additional resource information needed for specific datasets.
	Metadata *Metadata `type:"structure"`

	// The Amazon S3 location where the data is stored.
	S3InputDefinition *S3Location `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Input"}
	if s.DataCatalogInputDefinition != nil {
		if err := s.DataCatalogInputDefinition.Validate(); err != nil {
			invalidParams.AddNested("DataCatalogInputDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.DatabaseInputDefinition != nil {
		if err := s.DatabaseInputDefinition.Validate(); err != nil {
			invalidParams.AddNested("DatabaseInputDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.Metadata != nil {
		if err := s.Metadata.Validate(); err != nil {
			invalidParams.AddNested("Metadata", err.(request.ErrInvalidParams))
		}
	}
	if s.S3InputDefinition != nil {
		if err := s.S3InputDefinition.Validate(); err != nil {
			invalidParams.AddNested("S3InputDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataCatalogInputDefinition sets the DataCatalogInputDefinition field's value.
func (s *Input) SetDataCatalogInputDefinition(v *DataCatalogInputDefinition) *Input {
	s.DataCatalogInputDefinition = v
	return s
}

// SetDatabaseInputDefinition sets the DatabaseInputDefinition field's value.
func (s *Input) SetDatabaseInputDefinition(v *DatabaseInputDefinition) *Input {
	s.DatabaseInputDefinition = v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Input) SetMetadata(v *Metadata) *Input {
	s.Metadata = v
	return s
}

// SetS3InputDefinition sets the S3InputDefinition field's value.
func (s *Input) SetS3InputDefinition(v *S3Location) *Input {
	s.S3InputDefinition = v
	return s
}

// An internal service failure occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents all of the attributes of a DataBrew job.
type Job struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the job.
	AccountId *string `type:"string"`

	// The date and time that the job was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who created the job.
	CreatedBy *string `type:"string"`

	// One or more artifacts that represent the Glue Data Catalog output from running
	// the job.
	DataCatalogOutputs []*DataCatalogOutput_ `min:"1" type:"list"`

	// Represents a list of JDBC database output objects which defines the output
	// destination for a DataBrew recipe job to write into.
	DatabaseOutputs []*DatabaseOutput_ `min:"1" type:"list"`

	// A dataset that the job is to process.
	DatasetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an encryption key that is used to protect
	// the job output. For more information, see Encrypting data written by DataBrew
	// jobs (https://docs.aws.amazon.com/databrew/latest/dg/encryption-security-configuration.html)
	EncryptionKeyArn *string `min:"20" type:"string"`

	// The encryption mode for the job, which can be one of the following:
	//
	//    * SSE-KMS - Server-side encryption with keys managed by KMS.
	//
	//    * SSE-S3 - Server-side encryption with keys managed by Amazon S3.
	EncryptionMode *string `type:"string" enum:"EncryptionMode"`

	// A sample configuration for profile jobs only, which determines the number
	// of rows on which the profile job is run. If a JobSample value isn't provided,
	// the default value is used. The default value is CUSTOM_ROWS for the mode
	// parameter and 20,000 for the size parameter.
	JobSample *JobSample `type:"structure"`

	// The Amazon Resource Name (ARN) of the user who last modified the job.
	LastModifiedBy *string `type:"string"`

	// The modification date and time of the job.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The current status of Amazon CloudWatch logging for the job.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// The maximum number of nodes that can be consumed when the job processes data.
	MaxCapacity *int64 `type:"integer"`

	// The maximum number of times to retry the job after a job run fails.
	MaxRetries *int64 `type:"integer"`

	// The unique name of the job.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// One or more artifacts that represent output from running the job.
	Outputs []*Output `min:"1" type:"list"`

	// The name of the project that the job is associated with.
	ProjectName *string `min:"1" type:"string"`

	// A set of steps that the job runs.
	RecipeReference *RecipeReference `type:"structure"`

	// The unique Amazon Resource Name (ARN) for the job.
	ResourceArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) of the role to be assumed for this job.
	RoleArn *string `min:"20" type:"string"`

	// Metadata tags that have been applied to the job.
	Tags map[string]*string `min:"1" type:"map"`

	// The job's timeout in minutes. A job that attempts to run longer than this
	// timeout period ends with a status of TIMEOUT.
	Timeout *int64 `type:"integer"`

	// The job type of the job, which must be one of the following:
	//
	//    * PROFILE - A job to analyze a dataset, to determine its size, data types,
	//    data distribution, and more.
	//
	//    * RECIPE - A job to apply one or more transformations to a dataset.
	Type *string `type:"string" enum:"JobType"`

	// List of validation configurations that are applied to the profile job.
	ValidationConfigurations []*ValidationConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Job) SetAccountId(v string) *Job {
	s.AccountId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Job) SetCreateDate(v time.Time) *Job {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Job) SetCreatedBy(v string) *Job {
	s.CreatedBy = &v
	return s
}

// SetDataCatalogOutputs sets the DataCatalogOutputs field's value.
func (s *Job) SetDataCatalogOutputs(v []*DataCatalogOutput_) *Job {
	s.DataCatalogOutputs = v
	return s
}

// SetDatabaseOutputs sets the DatabaseOutputs field's value.
func (s *Job) SetDatabaseOutputs(v []*DatabaseOutput_) *Job {
	s.DatabaseOutputs = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *Job) SetDatasetName(v string) *Job {
	s.DatasetName = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *Job) SetEncryptionKeyArn(v string) *Job {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *Job) SetEncryptionMode(v string) *Job {
	s.EncryptionMode = &v
	return s
}

// SetJobSample sets the JobSample field's value.
func (s *Job) SetJobSample(v *JobSample) *Job {
	s.JobSample = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Job) SetLastModifiedBy(v string) *Job {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Job) SetLastModifiedDate(v time.Time) *Job {
	s.LastModifiedDate = &v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *Job) SetLogSubscription(v string) *Job {
	s.LogSubscription = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *Job) SetMaxCapacity(v int64) *Job {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *Job) SetMaxRetries(v int64) *Job {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *Job) SetName(v string) *Job {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Job) SetOutputs(v []*Output) *Job {
	s.Outputs = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *Job) SetProjectName(v string) *Job {
	s.ProjectName = &v
	return s
}

// SetRecipeReference sets the RecipeReference field's value.
func (s *Job) SetRecipeReference(v *RecipeReference) *Job {
	s.RecipeReference = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Job) SetResourceArn(v string) *Job {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Job) SetRoleArn(v string) *Job {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Job) SetTags(v map[string]*string) *Job {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *Job) SetTimeout(v int64) *Job {
	s.Timeout = &v
	return s
}

// SetType sets the Type field's value.
func (s *Job) SetType(v string) *Job {
	s.Type = &v
	return s
}

// SetValidationConfigurations sets the ValidationConfigurations field's value.
func (s *Job) SetValidationConfigurations(v []*ValidationConfiguration) *Job {
	s.ValidationConfigurations = v
	return s
}

// Represents one run of a DataBrew job.
type JobRun struct {
	_ struct{} `type:"structure"`

	// The number of times that DataBrew has attempted to run the job.
	Attempt *int64 `type:"integer"`

	// The date and time when the job completed processing.
	CompletedOn *time.Time `type:"timestamp"`

	// One or more artifacts that represent the Glue Data Catalog output from running
	// the job.
	DataCatalogOutputs []*DataCatalogOutput_ `min:"1" type:"list"`

	// Represents a list of JDBC database output objects which defines the output
	// destination for a DataBrew recipe job to write into.
	DatabaseOutputs []*DatabaseOutput_ `min:"1" type:"list"`

	// The name of the dataset for the job to process.
	DatasetName *string `min:"1" type:"string"`

	// A message indicating an error (if any) that was encountered when the job
	// ran.
	ErrorMessage *string `type:"string"`

	// The amount of time, in seconds, during which a job run consumed resources.
	ExecutionTime *int64 `type:"integer"`

	// The name of the job being processed during this run.
	JobName *string `min:"1" type:"string"`

	// A sample configuration for profile jobs only, which determines the number
	// of rows on which the profile job is run. If a JobSample value isn't provided,
	// the default is used. The default value is CUSTOM_ROWS for the mode parameter
	// and 20,000 for the size parameter.
	JobSample *JobSample `type:"structure"`

	// The name of an Amazon CloudWatch log group, where the job writes diagnostic
	// messages when it runs.
	LogGroupName *string `min:"1" type:"string"`

	// The current status of Amazon CloudWatch logging for the job run.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// One or more output artifacts from a job run.
	Outputs []*Output `min:"1" type:"list"`

	// The set of steps processed by the job.
	RecipeReference *RecipeReference `type:"structure"`

	// The unique identifier of the job run.
	RunId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the user who initiated the job run.
	StartedBy *string `type:"string"`

	// The date and time when the job run began.
	StartedOn *time.Time `type:"timestamp"`

	// The current state of the job run entity itself.
	State *string `type:"string" enum:"JobRunState"`

	// List of validation configurations that are applied to the profile job run.
	ValidationConfigurations []*ValidationConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRun) GoString() string {
	return s.String()
}

// SetAttempt sets the Attempt field's value.
func (s *JobRun) SetAttempt(v int64) *JobRun {
	s.Attempt = &v
	return s
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *JobRun) SetCompletedOn(v time.Time) *JobRun {
	s.CompletedOn = &v
	return s
}

// SetDataCatalogOutputs sets the DataCatalogOutputs field's value.
func (s *JobRun) SetDataCatalogOutputs(v []*DataCatalogOutput_) *JobRun {
	s.DataCatalogOutputs = v
	return s
}

// SetDatabaseOutputs sets the DatabaseOutputs field's value.
func (s *JobRun) SetDatabaseOutputs(v []*DatabaseOutput_) *JobRun {
	s.DatabaseOutputs = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *JobRun) SetDatasetName(v string) *JobRun {
	s.DatasetName = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *JobRun) SetErrorMessage(v string) *JobRun {
	s.ErrorMessage = &v
	return s
}

// SetExecutionTime sets the ExecutionTime field's value.
func (s *JobRun) SetExecutionTime(v int64) *JobRun {
	s.ExecutionTime = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobRun) SetJobName(v string) *JobRun {
	s.JobName = &v
	return s
}

// SetJobSample sets the JobSample field's value.
func (s *JobRun) SetJobSample(v *JobSample) *JobRun {
	s.JobSample = v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *JobRun) SetLogGroupName(v string) *JobRun {
	s.LogGroupName = &v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *JobRun) SetLogSubscription(v string) *JobRun {
	s.LogSubscription = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *JobRun) SetOutputs(v []*Output) *JobRun {
	s.Outputs = v
	return s
}

// SetRecipeReference sets the RecipeReference field's value.
func (s *JobRun) SetRecipeReference(v *RecipeReference) *JobRun {
	s.RecipeReference = v
	return s
}

// SetRunId sets the RunId field's value.
func (s *JobRun) SetRunId(v string) *JobRun {
	s.RunId = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *JobRun) SetStartedBy(v string) *JobRun {
	s.StartedBy = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *JobRun) SetStartedOn(v time.Time) *JobRun {
	s.StartedOn = &v
	return s
}

// SetState sets the State field's value.
func (s *JobRun) SetState(v string) *JobRun {
	s.State = &v
	return s
}

// SetValidationConfigurations sets the ValidationConfigurations field's value.
func (s *JobRun) SetValidationConfigurations(v []*ValidationConfiguration) *JobRun {
	s.ValidationConfigurations = v
	return s
}

// A sample configuration for profile jobs only, which determines the number
// of rows on which the profile job is run. If a JobSample value isn't provided,
// the default is used. The default value is CUSTOM_ROWS for the mode parameter
// and 20,000 for the size parameter.
type JobSample struct {
	_ struct{} `type:"structure"`

	// A value that determines whether the profile job is run on the entire dataset
	// or a specified number of rows. This value must be one of the following:
	//
	//    * FULL_DATASET - The profile job is run on the entire dataset.
	//
	//    * CUSTOM_ROWS - The profile job is run on the number of rows specified
	//    in the Size parameter.
	Mode *string `type:"string" enum:"SampleMode"`

	// The Size parameter is only required when the mode is CUSTOM_ROWS. The profile
	// job is run on the specified number of rows. The maximum value for size is
	// Long.MAX_VALUE.
	//
	// Long.MAX_VALUE = 9223372036854775807
	Size *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSample) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSample) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *JobSample) SetMode(v string) *JobSample {
	s.Mode = &v
	return s
}

// SetSize sets the Size field's value.
func (s *JobSample) SetSize(v int64) *JobSample {
	s.Size = &v
	return s
}

// Represents the JSON-specific options that define how input is to be interpreted
// by Glue DataBrew.
type JsonOptions struct {
	_ struct{} `type:"structure"`

	// A value that specifies whether JSON input contains embedded new line characters.
	MultiLine *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JsonOptions) GoString() string {
	return s.String()
}

// SetMultiLine sets the MultiLine field's value.
func (s *JsonOptions) SetMultiLine(v bool) *JsonOptions {
	s.MultiLine = &v
	return s
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of datasets that are defined.
	//
	// Datasets is a required field
	Datasets []*Dataset `type:"list" required:"true"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasets sets the Datasets field's value.
func (s *ListDatasetsOutput) SetDatasets(v []*Dataset) *ListDatasetsOutput {
	s.Datasets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListJobRunsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the job.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobRunsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobRunsInput) SetMaxResults(v int64) *ListJobRunsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListJobRunsInput) SetName(v string) *ListJobRunsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobRunsInput) SetNextToken(v string) *ListJobRunsInput {
	s.NextToken = &v
	return s
}

type ListJobRunsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job runs that have occurred for the specified job.
	//
	// JobRuns is a required field
	JobRuns []*JobRun `type:"list" required:"true"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobRunsOutput) GoString() string {
	return s.String()
}

// SetJobRuns sets the JobRuns field's value.
func (s *ListJobRunsOutput) SetJobRuns(v []*JobRun) *ListJobRunsOutput {
	s.JobRuns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobRunsOutput) SetNextToken(v string) *ListJobRunsOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a dataset. Using this parameter indicates to return only those
	// jobs that act on the specified dataset.
	DatasetName *string `location:"querystring" locationName:"datasetName" min:"1" type:"string"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token generated by DataBrew that specifies where to continue pagination
	// if a previous request was truncated. To get the next set of pages, pass in
	// the NextToken value from the response object of the previous page call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of a project. Using this parameter indicates to return only those
	// jobs that are associated with the specified project.
	ProjectName *string `location:"querystring" locationName:"projectName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *ListJobsInput) SetDatasetName(v string) *ListJobsInput {
	s.DatasetName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListJobsInput) SetProjectName(v string) *ListJobsInput {
	s.ProjectName = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs that are defined.
	//
	// Jobs is a required field
	Jobs []*Job `type:"list" required:"true"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*Job) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// A list of projects that are defined .
	//
	// Projects is a required field
	Projects []*Project `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*Project) *ListProjectsOutput {
	s.Projects = v
	return s
}

type ListRecipeVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the recipe for which to return version information.
	//
	// Name is a required field
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string" required:"true"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipeVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecipeVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecipeVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecipeVersionsInput) SetMaxResults(v int64) *ListRecipeVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListRecipeVersionsInput) SetName(v string) *ListRecipeVersionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipeVersionsInput) SetNextToken(v string) *ListRecipeVersionsInput {
	s.NextToken = &v
	return s
}

type ListRecipeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// A list of versions for the specified recipe.
	//
	// Recipes is a required field
	Recipes []*Recipe `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipeVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipeVersionsOutput) SetNextToken(v string) *ListRecipeVersionsOutput {
	s.NextToken = &v
	return s
}

// SetRecipes sets the Recipes field's value.
func (s *ListRecipeVersionsOutput) SetRecipes(v []*Recipe) *ListRecipeVersionsOutput {
	s.Recipes = v
	return s
}

type ListRecipesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Return only those recipes with a version identifier of LATEST_WORKING or
	// LATEST_PUBLISHED. If RecipeVersion is omitted, ListRecipes returns all of
	// the LATEST_PUBLISHED recipe versions.
	//
	// Valid values: LATEST_WORKING | LATEST_PUBLISHED
	RecipeVersion *string `location:"querystring" locationName:"recipeVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecipesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecipesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RecipeVersion != nil && len(*s.RecipeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecipeVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecipesInput) SetMaxResults(v int64) *ListRecipesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipesInput) SetNextToken(v string) *ListRecipesInput {
	s.NextToken = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *ListRecipesInput) SetRecipeVersion(v string) *ListRecipesInput {
	s.RecipeVersion = &v
	return s
}

type ListRecipesOutput struct {
	_ struct{} `type:"structure"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// A list of recipes that are defined.
	//
	// Recipes is a required field
	Recipes []*Recipe `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecipesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecipesOutput) SetNextToken(v string) *ListRecipesOutput {
	s.NextToken = &v
	return s
}

// SetRecipes sets the Recipes field's value.
func (s *ListRecipesOutput) SetRecipes(v []*Recipe) *ListRecipesOutput {
	s.Recipes = v
	return s
}

type ListRulesetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token generated by DataBrew that specifies where to continue pagination
	// if a previous request was truncated. To get the next set of pages, pass in
	// the NextToken value from the response object of the previous page call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter
	// indicates to return only those rulesets that are associated with the specified
	// resource.
	TargetArn *string `location:"querystring" locationName:"targetArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRulesetsInput) SetMaxResults(v int64) *ListRulesetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesetsInput) SetNextToken(v string) *ListRulesetsInput {
	s.NextToken = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ListRulesetsInput) SetTargetArn(v string) *ListRulesetsInput {
	s.TargetArn = &v
	return s
}

type ListRulesetsOutput struct {
	_ struct{} `type:"structure"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// A list of RulesetItem. RulesetItem contains meta data of a ruleset.
	//
	// Rulesets is a required field
	Rulesets []*RulesetItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesetsOutput) SetNextToken(v string) *ListRulesetsOutput {
	s.NextToken = &v
	return s
}

// SetRulesets sets the Rulesets field's value.
func (s *ListRulesetsOutput) SetRulesets(v []*RulesetItem) *ListRulesetsOutput {
	s.Rulesets = v
	return s
}

type ListSchedulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the job that these schedules apply to.
	JobName *string `location:"querystring" locationName:"jobName" min:"1" type:"string"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchedulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchedulesInput"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *ListSchedulesInput) SetJobName(v string) *ListSchedulesInput {
	s.JobName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchedulesInput) SetMaxResults(v int64) *ListSchedulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchedulesInput) SetNextToken(v string) *ListSchedulesInput {
	s.NextToken = &v
	return s
}

type ListSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// A list of schedules that are defined.
	//
	// Schedules is a required field
	Schedules []*Schedule `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchedulesOutput) SetNextToken(v string) *ListSchedulesOutput {
	s.NextToken = &v
	return s
}

// SetSchedules sets the Schedules field's value.
func (s *ListSchedulesOutput) SetSchedules(v []*Schedule) *ListSchedulesOutput {
	s.Schedules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the DataBrew
	// resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the DataBrew resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains additional resource information needed for specific datasets.
type Metadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the dataset. Currently, DataBrew
	// only supports ARNs from Amazon AppFlow.
	SourceArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metadata"}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceArn sets the SourceArn field's value.
func (s *Metadata) SetSourceArn(v string) *Metadata {
	s.SourceArn = &v
	return s
}

// Represents options that specify how and where in Amazon S3 DataBrew writes
// the output generated by recipe jobs or profile jobs.
type Output struct {
	_ struct{} `type:"structure"`

	// The compression algorithm used to compress the output text of the job.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The data format of the output of the job.
	Format *string `type:"string" enum:"OutputFormat"`

	// Represents options that define how DataBrew formats job output files.
	FormatOptions *OutputFormatOptions `type:"structure"`

	// The location in Amazon S3 where the job writes its output.
	//
	// Location is a required field
	Location *S3Location `type:"structure" required:"true"`

	// A value that, if true, means that any data in the location specified for
	// output is overwritten with new output.
	Overwrite *bool `type:"boolean"`

	// The names of one or more partition columns for the output of the job.
	PartitionColumns []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Output"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.FormatOptions != nil {
		if err := s.FormatOptions.Validate(); err != nil {
			invalidParams.AddNested("FormatOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *Output) SetCompressionFormat(v string) *Output {
	s.CompressionFormat = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *Output) SetFormat(v string) *Output {
	s.Format = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *Output) SetFormatOptions(v *OutputFormatOptions) *Output {
	s.FormatOptions = v
	return s
}

// SetLocation sets the Location field's value.
func (s *Output) SetLocation(v *S3Location) *Output {
	s.Location = v
	return s
}

// SetOverwrite sets the Overwrite field's value.
func (s *Output) SetOverwrite(v bool) *Output {
	s.Overwrite = &v
	return s
}

// SetPartitionColumns sets the PartitionColumns field's value.
func (s *Output) SetPartitionColumns(v []*string) *Output {
	s.PartitionColumns = v
	return s
}

// Represents a set of options that define the structure of comma-separated
// (CSV) job output.
type OutputFormatOptions struct {
	_ struct{} `type:"structure"`

	// Represents a set of options that define the structure of comma-separated
	// value (CSV) job output.
	Csv *CsvOutputOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFormatOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFormatOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputFormatOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputFormatOptions"}
	if s.Csv != nil {
		if err := s.Csv.Validate(); err != nil {
			invalidParams.AddNested("Csv", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsv sets the Csv field's value.
func (s *OutputFormatOptions) SetCsv(v *CsvOutputOptions) *OutputFormatOptions {
	s.Csv = v
	return s
}

// Represents a set of options that define how DataBrew selects files for a
// given Amazon S3 path in a dataset.
type PathOptions struct {
	_ struct{} `type:"structure"`

	// If provided, this structure imposes a limit on a number of files that should
	// be selected.
	FilesLimit *FilesLimit `type:"structure"`

	// If provided, this structure defines a date range for matching Amazon S3 objects
	// based on their LastModifiedDate attribute in Amazon S3.
	LastModifiedDateCondition *FilterExpression `type:"structure"`

	// A structure that maps names of parameters used in the Amazon S3 path of a
	// dataset to their definitions.
	Parameters map[string]*DatasetParameter `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PathOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PathOptions"}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.FilesLimit != nil {
		if err := s.FilesLimit.Validate(); err != nil {
			invalidParams.AddNested("FilesLimit", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDateCondition != nil {
		if err := s.LastModifiedDateCondition.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDateCondition", err.(request.ErrInvalidParams))
		}
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilesLimit sets the FilesLimit field's value.
func (s *PathOptions) SetFilesLimit(v *FilesLimit) *PathOptions {
	s.FilesLimit = v
	return s
}

// SetLastModifiedDateCondition sets the LastModifiedDateCondition field's value.
func (s *PathOptions) SetLastModifiedDateCondition(v *FilterExpression) *PathOptions {
	s.LastModifiedDateCondition = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PathOptions) SetParameters(v map[string]*DatasetParameter) *PathOptions {
	s.Parameters = v
	return s
}

// Configuration for profile jobs. Configuration can be used to select columns,
// do evaluations, and override default parameters of evaluations. When configuration
// is undefined, the profile job will apply default settings to all supported
// columns.
type ProfileConfiguration struct {
	_ struct{} `type:"structure"`

	// List of configurations for column evaluations. ColumnStatisticsConfigurations
	// are used to select evaluations and override parameters of evaluations for
	// particular columns. When ColumnStatisticsConfigurations is undefined, the
	// profile job will profile all supported columns and run all supported evaluations.
	ColumnStatisticsConfigurations []*ColumnStatisticsConfiguration `min:"1" type:"list"`

	// Configuration for inter-column evaluations. Configuration can be used to
	// select evaluations and override parameters of evaluations. When configuration
	// is undefined, the profile job will run all supported inter-column evaluations.
	DatasetStatisticsConfiguration *StatisticsConfiguration `type:"structure"`

	// Configuration of entity detection for a profile job. When undefined, entity
	// detection is disabled.
	EntityDetectorConfiguration *EntityDetectorConfiguration `type:"structure"`

	// List of column selectors. ProfileColumns can be used to select columns from
	// the dataset. When ProfileColumns is undefined, the profile job will profile
	// all supported columns.
	ProfileColumns []*ColumnSelector `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProfileConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProfileConfiguration"}
	if s.ColumnStatisticsConfigurations != nil && len(s.ColumnStatisticsConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnStatisticsConfigurations", 1))
	}
	if s.ProfileColumns != nil && len(s.ProfileColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileColumns", 1))
	}
	if s.ColumnStatisticsConfigurations != nil {
		for i, v := range s.ColumnStatisticsConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnStatisticsConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DatasetStatisticsConfiguration != nil {
		if err := s.DatasetStatisticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DatasetStatisticsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityDetectorConfiguration != nil {
		if err := s.EntityDetectorConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EntityDetectorConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProfileColumns != nil {
		for i, v := range s.ProfileColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProfileColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnStatisticsConfigurations sets the ColumnStatisticsConfigurations field's value.
func (s *ProfileConfiguration) SetColumnStatisticsConfigurations(v []*ColumnStatisticsConfiguration) *ProfileConfiguration {
	s.ColumnStatisticsConfigurations = v
	return s
}

// SetDatasetStatisticsConfiguration sets the DatasetStatisticsConfiguration field's value.
func (s *ProfileConfiguration) SetDatasetStatisticsConfiguration(v *StatisticsConfiguration) *ProfileConfiguration {
	s.DatasetStatisticsConfiguration = v
	return s
}

// SetEntityDetectorConfiguration sets the EntityDetectorConfiguration field's value.
func (s *ProfileConfiguration) SetEntityDetectorConfiguration(v *EntityDetectorConfiguration) *ProfileConfiguration {
	s.EntityDetectorConfiguration = v
	return s
}

// SetProfileColumns sets the ProfileColumns field's value.
func (s *ProfileConfiguration) SetProfileColumns(v []*ColumnSelector) *ProfileConfiguration {
	s.ProfileColumns = v
	return s
}

// Represents all of the attributes of a DataBrew project.
type Project struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the project.
	AccountId *string `type:"string"`

	// The date and time that the project was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who crated the project.
	CreatedBy *string `type:"string"`

	// The dataset that the project is to act upon.
	DatasetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the user who last modified the project.
	LastModifiedBy *string `type:"string"`

	// The last modification date and time for the project.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The unique name of a project.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The date and time when the project was opened.
	OpenDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user that opened the project for use.
	OpenedBy *string `type:"string"`

	// The name of a recipe that will be developed during a project session.
	//
	// RecipeName is a required field
	RecipeName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the project.
	ResourceArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) of the role that will be assumed for this
	// project.
	RoleArn *string `min:"20" type:"string"`

	// The sample size and sampling type to apply to the data. If this parameter
	// isn't specified, then the sample consists of the first 500 rows from the
	// dataset.
	Sample *Sample `type:"structure"`

	// Metadata tags that have been applied to the project.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Project) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Project) SetAccountId(v string) *Project {
	s.AccountId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Project) SetCreateDate(v time.Time) *Project {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Project) SetCreatedBy(v string) *Project {
	s.CreatedBy = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *Project) SetDatasetName(v string) *Project {
	s.DatasetName = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Project) SetLastModifiedBy(v string) *Project {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Project) SetLastModifiedDate(v time.Time) *Project {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Project) SetName(v string) *Project {
	s.Name = &v
	return s
}

// SetOpenDate sets the OpenDate field's value.
func (s *Project) SetOpenDate(v time.Time) *Project {
	s.OpenDate = &v
	return s
}

// SetOpenedBy sets the OpenedBy field's value.
func (s *Project) SetOpenedBy(v string) *Project {
	s.OpenedBy = &v
	return s
}

// SetRecipeName sets the RecipeName field's value.
func (s *Project) SetRecipeName(v string) *Project {
	s.RecipeName = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Project) SetResourceArn(v string) *Project {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Project) SetRoleArn(v string) *Project {
	s.RoleArn = &v
	return s
}

// SetSample sets the Sample field's value.
func (s *Project) SetSample(v *Sample) *Project {
	s.Sample = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Project) SetTags(v map[string]*string) *Project {
	s.Tags = v
	return s
}

type PublishRecipeInput struct {
	_ struct{} `type:"structure"`

	// A description of the recipe to be published, for this version of the recipe.
	Description *string `type:"string"`

	// The name of the recipe to be published.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishRecipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PublishRecipeInput) SetDescription(v string) *PublishRecipeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublishRecipeInput) SetName(v string) *PublishRecipeInput {
	s.Name = &v
	return s
}

type PublishRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The name of the recipe that you published.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishRecipeOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PublishRecipeOutput) SetName(v string) *PublishRecipeOutput {
	s.Name = &v
	return s
}

// Represents one or more actions to be performed on a DataBrew dataset.
type Recipe struct {
	_ struct{} `type:"structure"`

	// The date and time that the recipe was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who created the recipe.
	CreatedBy *string `type:"string"`

	// The description of the recipe.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user who last modified the recipe.
	LastModifiedBy *string `type:"string"`

	// The last modification date and time of the recipe.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The unique name for the recipe.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of the project that the recipe is associated with.
	ProjectName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the user who published the recipe.
	PublishedBy *string `type:"string"`

	// The date and time when the recipe was published.
	PublishedDate *time.Time `type:"timestamp"`

	// The identifier for the version for the recipe. Must be one of the following:
	//
	//    * Numeric version (X.Y) - X and Y stand for major and minor version numbers.
	//    The maximum length of each is 6 digits, and neither can be negative values.
	//    Both X and Y are required, and "0.0" isn't a valid version.
	//
	//    * LATEST_WORKING - the most recent valid version being developed in a
	//    DataBrew project.
	//
	//    * LATEST_PUBLISHED - the most recent published version.
	RecipeVersion *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the recipe.
	ResourceArn *string `min:"20" type:"string"`

	// A list of steps that are defined by the recipe.
	Steps []*RecipeStep `type:"list"`

	// Metadata tags that have been applied to the recipe.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recipe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recipe) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *Recipe) SetCreateDate(v time.Time) *Recipe {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Recipe) SetCreatedBy(v string) *Recipe {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Recipe) SetDescription(v string) *Recipe {
	s.Description = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Recipe) SetLastModifiedBy(v string) *Recipe {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Recipe) SetLastModifiedDate(v time.Time) *Recipe {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recipe) SetName(v string) *Recipe {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *Recipe) SetProjectName(v string) *Recipe {
	s.ProjectName = &v
	return s
}

// SetPublishedBy sets the PublishedBy field's value.
func (s *Recipe) SetPublishedBy(v string) *Recipe {
	s.PublishedBy = &v
	return s
}

// SetPublishedDate sets the PublishedDate field's value.
func (s *Recipe) SetPublishedDate(v time.Time) *Recipe {
	s.PublishedDate = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *Recipe) SetRecipeVersion(v string) *Recipe {
	s.RecipeVersion = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Recipe) SetResourceArn(v string) *Recipe {
	s.ResourceArn = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *Recipe) SetSteps(v []*RecipeStep) *Recipe {
	s.Steps = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Recipe) SetTags(v map[string]*string) *Recipe {
	s.Tags = v
	return s
}

// Represents a transformation and associated parameters that are used to apply
// a change to a DataBrew dataset. For more information, see Recipe actions
// reference (https://docs.aws.amazon.com/databrew/latest/dg/recipe-actions-reference.html).
type RecipeAction struct {
	_ struct{} `type:"structure"`

	// The name of a valid DataBrew transformation to be performed on the data.
	//
	// Operation is a required field
	Operation *string `min:"1" type:"string" required:"true"`

	// Contextual parameters for the transformation.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecipeAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecipeAction"}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}
	if s.Operation != nil && len(*s.Operation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Operation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperation sets the Operation field's value.
func (s *RecipeAction) SetOperation(v string) *RecipeAction {
	s.Operation = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *RecipeAction) SetParameters(v map[string]*string) *RecipeAction {
	s.Parameters = v
	return s
}

// Represents the name and version of a DataBrew recipe.
type RecipeReference struct {
	_ struct{} `type:"structure"`

	// The name of the recipe.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier for the version for the recipe.
	RecipeVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecipeReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecipeReference"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeVersion != nil && len(*s.RecipeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecipeVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *RecipeReference) SetName(v string) *RecipeReference {
	s.Name = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *RecipeReference) SetRecipeVersion(v string) *RecipeReference {
	s.RecipeVersion = &v
	return s
}

// Represents a single step from a DataBrew recipe to be performed.
type RecipeStep struct {
	_ struct{} `type:"structure"`

	// The particular action to be performed in the recipe step.
	//
	// Action is a required field
	Action *RecipeAction `type:"structure" required:"true"`

	// One or more conditions that must be met for the recipe step to succeed.
	//
	// All of the conditions in the array must be met. In other words, all of the
	// conditions must be combined using a logical AND operation.
	ConditionExpressions []*ConditionExpression `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeStep) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecipeStep) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecipeStep"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.ConditionExpressions != nil {
		for i, v := range s.ConditionExpressions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConditionExpressions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RecipeStep) SetAction(v *RecipeAction) *RecipeStep {
	s.Action = v
	return s
}

// SetConditionExpressions sets the ConditionExpressions field's value.
func (s *RecipeStep) SetConditionExpressions(v []*ConditionExpression) *RecipeStep {
	s.ConditionExpressions = v
	return s
}

// Represents any errors encountered when attempting to delete multiple recipe
// versions.
type RecipeVersionErrorDetail struct {
	_ struct{} `type:"structure"`

	// The HTTP status code for the error.
	ErrorCode *string `type:"string"`

	// The text of the error message.
	ErrorMessage *string `type:"string"`

	// The identifier for the recipe version associated with this error.
	RecipeVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeVersionErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipeVersionErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *RecipeVersionErrorDetail) SetErrorCode(v string) *RecipeVersionErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *RecipeVersionErrorDetail) SetErrorMessage(v string) *RecipeVersionErrorDetail {
	s.ErrorMessage = &v
	return s
}

// SetRecipeVersion sets the RecipeVersion field's value.
func (s *RecipeVersionErrorDetail) SetRecipeVersion(v string) *RecipeVersionErrorDetail {
	s.RecipeVersion = &v
	return s
}

// One or more resources can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a single data quality requirement that should be validated in
// the scope of this dataset.
type Rule struct {
	_ struct{} `type:"structure"`

	// The expression which includes column references, condition names followed
	// by variable references, possibly grouped and combined with other conditions.
	// For example, (:col1 starts_with :prefix1 or :col1 starts_with :prefix2) and
	// (:col1 ends_with :suffix1 or :col1 ends_with :suffix2). Column and value
	// references are substitution variables that should start with the ':' symbol.
	// Depending on the context, substitution variables' values can be either an
	// actual value or a column name. These values are defined in the SubstitutionMap.
	// If a CheckExpression starts with a column reference, then ColumnSelectors
	// in the rule should be null. If ColumnSelectors has been defined, then there
	// should be no columnn reference in the left side of a condition, for example,
	// is_between :val1 and :val2.
	//
	// CheckExpression is a required field
	CheckExpression *string `min:"4" type:"string" required:"true"`

	// List of column selectors. Selectors can be used to select columns using a
	// name or regular expression from the dataset. Rule will be applied to selected
	// columns.
	ColumnSelectors []*ColumnSelector `min:"1" type:"list"`

	// A value that specifies whether the rule is disabled. Once a rule is disabled,
	// a profile job will not validate it during a job run. Default value is false.
	Disabled *bool `type:"boolean"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The map of substitution variable names to their values used in a check expression.
	// Variable names should start with a ':' (colon). Variable values can either
	// be actual values or column names. To differentiate between the two, column
	// names should be enclosed in backticks, for example, ":col1": "`Column A`".
	SubstitutionMap map[string]*string `type:"map"`

	// The threshold used with a non-aggregate check expression. Non-aggregate check
	// expressions will be applied to each row in a specific column, and the threshold
	// will be used to determine whether the validation succeeds.
	Threshold *Threshold `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.CheckExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckExpression"))
	}
	if s.CheckExpression != nil && len(*s.CheckExpression) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CheckExpression", 4))
	}
	if s.ColumnSelectors != nil && len(s.ColumnSelectors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnSelectors", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ColumnSelectors != nil {
		for i, v := range s.ColumnSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Threshold != nil {
		if err := s.Threshold.Validate(); err != nil {
			invalidParams.AddNested("Threshold", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckExpression sets the CheckExpression field's value.
func (s *Rule) SetCheckExpression(v string) *Rule {
	s.CheckExpression = &v
	return s
}

// SetColumnSelectors sets the ColumnSelectors field's value.
func (s *Rule) SetColumnSelectors(v []*ColumnSelector) *Rule {
	s.ColumnSelectors = v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *Rule) SetDisabled(v bool) *Rule {
	s.Disabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetSubstitutionMap sets the SubstitutionMap field's value.
func (s *Rule) SetSubstitutionMap(v map[string]*string) *Rule {
	s.SubstitutionMap = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *Rule) SetThreshold(v *Threshold) *Rule {
	s.Threshold = v
	return s
}

// Contains metadata about the ruleset.
type RulesetItem struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the ruleset.
	AccountId *string `type:"string"`

	// The date and time that the ruleset was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who created the ruleset.
	CreatedBy *string `type:"string"`

	// The description of the ruleset.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user who last modified the ruleset.
	LastModifiedBy *string `type:"string"`

	// The modification date and time of the ruleset.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the ruleset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the ruleset.
	ResourceArn *string `min:"20" type:"string"`

	// The number of rules that are defined in the ruleset.
	RuleCount *int64 `type:"integer"`

	// Metadata tags that have been applied to the ruleset.
	Tags map[string]*string `min:"1" type:"map"`

	// The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset is
	// associated with.
	//
	// TargetArn is a required field
	TargetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RulesetItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RulesetItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RulesetItem) SetAccountId(v string) *RulesetItem {
	s.AccountId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *RulesetItem) SetCreateDate(v time.Time) *RulesetItem {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *RulesetItem) SetCreatedBy(v string) *RulesetItem {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RulesetItem) SetDescription(v string) *RulesetItem {
	s.Description = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *RulesetItem) SetLastModifiedBy(v string) *RulesetItem {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *RulesetItem) SetLastModifiedDate(v time.Time) *RulesetItem {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *RulesetItem) SetName(v string) *RulesetItem {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RulesetItem) SetResourceArn(v string) *RulesetItem {
	s.ResourceArn = &v
	return s
}

// SetRuleCount sets the RuleCount field's value.
func (s *RulesetItem) SetRuleCount(v int64) *RulesetItem {
	s.RuleCount = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RulesetItem) SetTags(v map[string]*string) *RulesetItem {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *RulesetItem) SetTargetArn(v string) *RulesetItem {
	s.TargetArn = &v
	return s
}

// Represents an Amazon S3 location (bucket name and object key) where DataBrew
// can read input data, or write output from a job.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The unique name of the object in the bucket.
	Key *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// Represents options that specify how and where DataBrew writes the Amazon
// S3 output generated by recipe jobs.
type S3TableOutputOptions struct {
	_ struct{} `type:"structure"`

	// Represents an Amazon S3 location (bucket name and object key) where DataBrew
	// can write output from a job.
	//
	// Location is a required field
	Location *S3Location `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3TableOutputOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3TableOutputOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3TableOutputOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3TableOutputOptions"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *S3TableOutputOptions) SetLocation(v *S3Location) *S3TableOutputOptions {
	s.Location = v
	return s
}

// Represents the sample size and sampling type for DataBrew to use for interactive
// data analysis.
type Sample struct {
	_ struct{} `type:"structure"`

	// The number of rows in the sample.
	Size *int64 `min:"1" type:"integer"`

	// The way in which DataBrew obtains rows from a dataset.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"SampleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sample) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sample) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sample) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sample"}
	if s.Size != nil && *s.Size < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Size", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSize sets the Size field's value.
func (s *Sample) SetSize(v int64) *Sample {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *Sample) SetType(v string) *Sample {
	s.Type = &v
	return s
}

// Represents one or more dates and times when a job is to run.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the schedule.
	AccountId *string `type:"string"`

	// The date and time that the schedule was created.
	CreateDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the user who created the schedule.
	CreatedBy *string `type:"string"`

	// The dates and times when the job is to run. For more information, see Cron
	// expressions (https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html)
	// in the Glue DataBrew Developer Guide.
	CronExpression *string `min:"1" type:"string"`

	// A list of jobs to be run, according to the schedule.
	JobNames []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the user who last modified the schedule.
	LastModifiedBy *string `type:"string"`

	// The date and time when the schedule was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the schedule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the schedule.
	ResourceArn *string `min:"20" type:"string"`

	// Metadata tags that have been applied to the schedule.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Schedule) SetAccountId(v string) *Schedule {
	s.AccountId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Schedule) SetCreateDate(v time.Time) *Schedule {
	s.CreateDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Schedule) SetCreatedBy(v string) *Schedule {
	s.CreatedBy = &v
	return s
}

// SetCronExpression sets the CronExpression field's value.
func (s *Schedule) SetCronExpression(v string) *Schedule {
	s.CronExpression = &v
	return s
}

// SetJobNames sets the JobNames field's value.
func (s *Schedule) SetJobNames(v []*string) *Schedule {
	s.JobNames = v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *Schedule) SetLastModifiedBy(v string) *Schedule {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Schedule) SetLastModifiedDate(v time.Time) *Schedule {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Schedule) SetName(v string) *Schedule {
	s.Name = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Schedule) SetResourceArn(v string) *Schedule {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Schedule) SetTags(v map[string]*string) *Schedule {
	s.Tags = v
	return s
}

type SendProjectSessionActionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for an interactive session that's currently open and
	// ready for work. The action will be performed on this session.
	//
	// ClientSessionId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SendProjectSessionActionInput's
	// String and GoString methods.
	ClientSessionId *string `min:"1" type:"string" sensitive:"true"`

	// The name of the project to apply the action to.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// If true, the result of the recipe step will be returned, but not applied.
	Preview *bool `type:"boolean"`

	// Represents a single step from a DataBrew recipe to be performed.
	RecipeStep *RecipeStep `type:"structure"`

	// The index from which to preview a step. This index is used to preview the
	// result of steps that have already been applied, so that the resulting view
	// frame is from earlier in the view frame stack.
	StepIndex *int64 `type:"integer"`

	// Represents the data being transformed during an action.
	ViewFrame *ViewFrame `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendProjectSessionActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendProjectSessionActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendProjectSessionActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendProjectSessionActionInput"}
	if s.ClientSessionId != nil && len(*s.ClientSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientSessionId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RecipeStep != nil {
		if err := s.RecipeStep.Validate(); err != nil {
			invalidParams.AddNested("RecipeStep", err.(request.ErrInvalidParams))
		}
	}
	if s.ViewFrame != nil {
		if err := s.ViewFrame.Validate(); err != nil {
			invalidParams.AddNested("ViewFrame", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientSessionId sets the ClientSessionId field's value.
func (s *SendProjectSessionActionInput) SetClientSessionId(v string) *SendProjectSessionActionInput {
	s.ClientSessionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *SendProjectSessionActionInput) SetName(v string) *SendProjectSessionActionInput {
	s.Name = &v
	return s
}

// SetPreview sets the Preview field's value.
func (s *SendProjectSessionActionInput) SetPreview(v bool) *SendProjectSessionActionInput {
	s.Preview = &v
	return s
}

// SetRecipeStep sets the RecipeStep field's value.
func (s *SendProjectSessionActionInput) SetRecipeStep(v *RecipeStep) *SendProjectSessionActionInput {
	s.RecipeStep = v
	return s
}

// SetStepIndex sets the StepIndex field's value.
func (s *SendProjectSessionActionInput) SetStepIndex(v int64) *SendProjectSessionActionInput {
	s.StepIndex = &v
	return s
}

// SetViewFrame sets the ViewFrame field's value.
func (s *SendProjectSessionActionInput) SetViewFrame(v *ViewFrame) *SendProjectSessionActionInput {
	s.ViewFrame = v
	return s
}

type SendProjectSessionActionOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the action that was performed.
	ActionId *int64 `type:"integer"`

	// The name of the project that was affected by the action.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A message indicating the result of performing the action.
	Result *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendProjectSessionActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendProjectSessionActionOutput) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *SendProjectSessionActionOutput) SetActionId(v int64) *SendProjectSessionActionOutput {
	s.ActionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *SendProjectSessionActionOutput) SetName(v string) *SendProjectSessionActionOutput {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *SendProjectSessionActionOutput) SetResult(v string) *SendProjectSessionActionOutput {
	s.Result = &v
	return s
}

// A service quota is exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the job to be run.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartJobRunInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartJobRunInput) SetName(v string) *StartJobRunInput {
	s.Name = &v
	return s
}

type StartJobRunOutput struct {
	_ struct{} `type:"structure"`

	// A system-generated identifier for this particular job run.
	//
	// RunId is a required field
	RunId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartJobRunOutput) GoString() string {
	return s.String()
}

// SetRunId sets the RunId field's value.
func (s *StartJobRunOutput) SetRunId(v string) *StartJobRunOutput {
	s.RunId = &v
	return s
}

type StartProjectSessionInput struct {
	_ struct{} `type:"structure"`

	// A value that, if true, enables you to take control of a session, even if
	// a different client is currently accessing the project.
	AssumeControl *bool `type:"boolean"`

	// The name of the project to act upon.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartProjectSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartProjectSessionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssumeControl sets the AssumeControl field's value.
func (s *StartProjectSessionInput) SetAssumeControl(v bool) *StartProjectSessionInput {
	s.AssumeControl = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartProjectSessionInput) SetName(v string) *StartProjectSessionInput {
	s.Name = &v
	return s
}

type StartProjectSessionOutput struct {
	_ struct{} `type:"structure"`

	// A system-generated identifier for the session.
	//
	// ClientSessionId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartProjectSessionOutput's
	// String and GoString methods.
	ClientSessionId *string `min:"1" type:"string" sensitive:"true"`

	// The name of the project to be acted upon.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectSessionOutput) GoString() string {
	return s.String()
}

// SetClientSessionId sets the ClientSessionId field's value.
func (s *StartProjectSessionOutput) SetClientSessionId(v string) *StartProjectSessionOutput {
	s.ClientSessionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartProjectSessionOutput) SetName(v string) *StartProjectSessionOutput {
	s.Name = &v
	return s
}

// Override of a particular evaluation for a profile job.
type StatisticOverride struct {
	_ struct{} `type:"structure"`

	// A map that includes overrides of an evaluation’s parameters.
	//
	// Parameters is a required field
	Parameters map[string]*string `type:"map" required:"true"`

	// The name of an evaluation
	//
	// Statistic is a required field
	Statistic *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatisticOverride"}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Statistic != nil && len(*s.Statistic) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistic", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *StatisticOverride) SetParameters(v map[string]*string) *StatisticOverride {
	s.Parameters = v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *StatisticOverride) SetStatistic(v string) *StatisticOverride {
	s.Statistic = &v
	return s
}

// Configuration of evaluations for a profile job. This configuration can be
// used to select evaluations and override the parameters of selected evaluations.
type StatisticsConfiguration struct {
	_ struct{} `type:"structure"`

	// List of included evaluations. When the list is undefined, all supported evaluations
	// will be included.
	IncludedStatistics []*string `min:"1" type:"list"`

	// List of overrides for evaluations.
	Overrides []*StatisticOverride `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatisticsConfiguration"}
	if s.IncludedStatistics != nil && len(s.IncludedStatistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncludedStatistics", 1))
	}
	if s.Overrides != nil && len(s.Overrides) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Overrides", 1))
	}
	if s.Overrides != nil {
		for i, v := range s.Overrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Overrides", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludedStatistics sets the IncludedStatistics field's value.
func (s *StatisticsConfiguration) SetIncludedStatistics(v []*string) *StatisticsConfiguration {
	s.IncludedStatistics = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *StatisticsConfiguration) SetOverrides(v []*StatisticOverride) *StatisticsConfiguration {
	s.Overrides = v
	return s
}

type StopJobRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the job to be stopped.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The ID of the job run to be stopped.
	//
	// RunId is a required field
	RunId *string `location:"uri" locationName:"runId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopJobRunInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RunId == nil {
		invalidParams.Add(request.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopJobRunInput) SetName(v string) *StopJobRunInput {
	s.Name = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *StopJobRunInput) SetRunId(v string) *StopJobRunInput {
	s.RunId = &v
	return s
}

type StopJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the job run that you stopped.
	//
	// RunId is a required field
	RunId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopJobRunOutput) GoString() string {
	return s.String()
}

// SetRunId sets the RunId field's value.
func (s *StopJobRunOutput) SetRunId(v string) *StopJobRunOutput {
	s.RunId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The DataBrew resource to which tags should be added. The value for this parameter
	// is an Amazon Resource Name (ARN). For DataBrew, you can tag a dataset, a
	// job, a project, or a recipe.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// One or more tags to be assigned to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The threshold used with a non-aggregate check expression. The non-aggregate
// check expression will be applied to each row in a specific column. Then the
// threshold will be used to determine whether the validation succeeds.
type Threshold struct {
	_ struct{} `type:"structure"`

	// The type of a threshold. Used for comparison of an actual count of rows that
	// satisfy the rule to the threshold value.
	Type *string `type:"string" enum:"ThresholdType"`

	// Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full
	// sample size used for validation.
	Unit *string `type:"string" enum:"ThresholdUnit"`

	// The value of a threshold.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Threshold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Threshold) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Threshold) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Threshold"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *Threshold) SetType(v string) *Threshold {
	s.Type = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Threshold) SetUnit(v string) *Threshold {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Threshold) SetValue(v float64) *Threshold {
	s.Value = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A DataBrew resource from which you want to remove a tag or tags. The value
	// for this parameter is an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The tag keys (names) of one or more tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The file format of a dataset that is created from an Amazon S3 file or folder.
	Format *string `type:"string" enum:"InputFormat"`

	// Represents a set of options that define the structure of either comma-separated
	// value (CSV), Excel, or JSON input.
	FormatOptions *FormatOptions `type:"structure"`

	// Represents information on how DataBrew can find data, in either the Glue
	// Data Catalog or Amazon S3.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`

	// The name of the dataset to be updated.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A set of options that defines how DataBrew interprets an Amazon S3 path of
	// the dataset.
	PathOptions *PathOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasetInput"}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.FormatOptions != nil {
		if err := s.FormatOptions.Validate(); err != nil {
			invalidParams.AddNested("FormatOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}
	if s.PathOptions != nil {
		if err := s.PathOptions.Validate(); err != nil {
			invalidParams.AddNested("PathOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *UpdateDatasetInput) SetFormat(v string) *UpdateDatasetInput {
	s.Format = &v
	return s
}

// SetFormatOptions sets the FormatOptions field's value.
func (s *UpdateDatasetInput) SetFormatOptions(v *FormatOptions) *UpdateDatasetInput {
	s.FormatOptions = v
	return s
}

// SetInput sets the Input field's value.
func (s *UpdateDatasetInput) SetInput(v *Input) *UpdateDatasetInput {
	s.Input = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDatasetInput) SetName(v string) *UpdateDatasetInput {
	s.Name = &v
	return s
}

// SetPathOptions sets the PathOptions field's value.
func (s *UpdateDatasetInput) SetPathOptions(v *PathOptions) *UpdateDatasetInput {
	s.PathOptions = v
	return s
}

type UpdateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset that you updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateDatasetOutput) SetName(v string) *UpdateDatasetOutput {
	s.Name = &v
	return s
}

type UpdateProfileJobInput struct {
	_ struct{} `type:"structure"`

	// Configuration for profile jobs. Used to select columns, do evaluations, and
	// override default parameters of evaluations. When configuration is null, the
	// profile job will run with default settings.
	Configuration *ProfileConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of an encryption key that is used to protect
	// the job.
	EncryptionKeyArn *string `min:"20" type:"string"`

	// The encryption mode for the job, which can be one of the following:
	//
	//    * SSE-KMS - Server-side encryption with keys managed by KMS.
	//
	//    * SSE-S3 - Server-side encryption with keys managed by Amazon S3.
	EncryptionMode *string `type:"string" enum:"EncryptionMode"`

	// Sample configuration for Profile Jobs only. Determines the number of rows
	// on which the Profile job will be executed. If a JobSample value is not provided
	// for profile jobs, the default value will be used. The default value is CUSTOM_ROWS
	// for the mode parameter and 20000 for the size parameter.
	JobSample *JobSample `type:"structure"`

	// Enables or disables Amazon CloudWatch logging for the job. If logging is
	// enabled, CloudWatch writes one log stream for each job run.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// The maximum number of compute nodes that DataBrew can use when the job processes
	// data.
	MaxCapacity *int64 `type:"integer"`

	// The maximum number of times to retry the job after a job run fails.
	MaxRetries *int64 `type:"integer"`

	// The name of the job to be updated.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Represents an Amazon S3 location (bucket name and object key) where DataBrew
	// can read input data, or write output from a job.
	//
	// OutputLocation is a required field
	OutputLocation *S3Location `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role to be assumed when DataBrew runs the job.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The job's timeout in minutes. A job that attempts to run longer than this
	// timeout period ends with a status of TIMEOUT.
	Timeout *int64 `type:"integer"`

	// List of validation configurations that are applied to the profile job.
	ValidationConfigurations []*ValidationConfiguration `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileJobInput"}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputLocation"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ValidationConfigurations != nil && len(s.ValidationConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationConfigurations", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidationConfigurations != nil {
		for i, v := range s.ValidationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateProfileJobInput) SetConfiguration(v *ProfileConfiguration) *UpdateProfileJobInput {
	s.Configuration = v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *UpdateProfileJobInput) SetEncryptionKeyArn(v string) *UpdateProfileJobInput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *UpdateProfileJobInput) SetEncryptionMode(v string) *UpdateProfileJobInput {
	s.EncryptionMode = &v
	return s
}

// SetJobSample sets the JobSample field's value.
func (s *UpdateProfileJobInput) SetJobSample(v *JobSample) *UpdateProfileJobInput {
	s.JobSample = v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *UpdateProfileJobInput) SetLogSubscription(v string) *UpdateProfileJobInput {
	s.LogSubscription = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *UpdateProfileJobInput) SetMaxCapacity(v int64) *UpdateProfileJobInput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *UpdateProfileJobInput) SetMaxRetries(v int64) *UpdateProfileJobInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProfileJobInput) SetName(v string) *UpdateProfileJobInput {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *UpdateProfileJobInput) SetOutputLocation(v *S3Location) *UpdateProfileJobInput {
	s.OutputLocation = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateProfileJobInput) SetRoleArn(v string) *UpdateProfileJobInput {
	s.RoleArn = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UpdateProfileJobInput) SetTimeout(v int64) *UpdateProfileJobInput {
	s.Timeout = &v
	return s
}

// SetValidationConfigurations sets the ValidationConfigurations field's value.
func (s *UpdateProfileJobInput) SetValidationConfigurations(v []*ValidationConfiguration) *UpdateProfileJobInput {
	s.ValidationConfigurations = v
	return s
}

type UpdateProfileJobOutput struct {
	_ struct{} `type:"structure"`

	// The name of the job that was updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateProfileJobOutput) SetName(v string) *UpdateProfileJobOutput {
	s.Name = &v
	return s
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the project to be updated.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Represents the sample size and sampling type for DataBrew to use for interactive
	// data analysis.
	Sample *Sample `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Sample != nil {
		if err := s.Sample.Validate(); err != nil {
			invalidParams.AddNested("Sample", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateProjectInput) SetRoleArn(v string) *UpdateProjectInput {
	s.RoleArn = &v
	return s
}

// SetSample sets the Sample field's value.
func (s *UpdateProjectInput) SetSample(v *Sample) *UpdateProjectInput {
	s.Sample = v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the project was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the project that you updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UpdateProjectOutput) SetLastModifiedDate(v time.Time) *UpdateProjectOutput {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectOutput) SetName(v string) *UpdateProjectOutput {
	s.Name = &v
	return s
}

type UpdateRecipeInput struct {
	_ struct{} `type:"structure"`

	// A description of the recipe.
	Description *string `type:"string"`

	// The name of the recipe to be updated.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// One or more steps to be performed by the recipe. Each step consists of an
	// action, and the conditions under which the action should succeed.
	Steps []*RecipeStep `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRecipeInput) SetDescription(v string) *UpdateRecipeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRecipeInput) SetName(v string) *UpdateRecipeInput {
	s.Name = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *UpdateRecipeInput) SetSteps(v []*RecipeStep) *UpdateRecipeInput {
	s.Steps = v
	return s
}

type UpdateRecipeJobInput struct {
	_ struct{} `type:"structure"`

	// One or more artifacts that represent the Glue Data Catalog output from running
	// the job.
	DataCatalogOutputs []*DataCatalogOutput_ `min:"1" type:"list"`

	// Represents a list of JDBC database output objects which defines the output
	// destination for a DataBrew recipe job to write into.
	DatabaseOutputs []*DatabaseOutput_ `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of an encryption key that is used to protect
	// the job.
	EncryptionKeyArn *string `min:"20" type:"string"`

	// The encryption mode for the job, which can be one of the following:
	//
	//    * SSE-KMS - Server-side encryption with keys managed by KMS.
	//
	//    * SSE-S3 - Server-side encryption with keys managed by Amazon S3.
	EncryptionMode *string `type:"string" enum:"EncryptionMode"`

	// Enables or disables Amazon CloudWatch logging for the job. If logging is
	// enabled, CloudWatch writes one log stream for each job run.
	LogSubscription *string `type:"string" enum:"LogSubscription"`

	// The maximum number of nodes that DataBrew can consume when the job processes
	// data.
	MaxCapacity *int64 `type:"integer"`

	// The maximum number of times to retry the job after a job run fails.
	MaxRetries *int64 `type:"integer"`

	// The name of the job to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// One or more artifacts that represent the output from running the job.
	Outputs []*Output `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role to be assumed when DataBrew runs the job.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The job's timeout in minutes. A job that attempts to run longer than this
	// timeout period ends with a status of TIMEOUT.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecipeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecipeJobInput"}
	if s.DataCatalogOutputs != nil && len(s.DataCatalogOutputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataCatalogOutputs", 1))
	}
	if s.DatabaseOutputs != nil && len(s.DatabaseOutputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseOutputs", 1))
	}
	if s.EncryptionKeyArn != nil && len(*s.EncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Outputs != nil && len(s.Outputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outputs", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.DataCatalogOutputs != nil {
		for i, v := range s.DataCatalogOutputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataCatalogOutputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DatabaseOutputs != nil {
		for i, v := range s.DatabaseOutputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DatabaseOutputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataCatalogOutputs sets the DataCatalogOutputs field's value.
func (s *UpdateRecipeJobInput) SetDataCatalogOutputs(v []*DataCatalogOutput_) *UpdateRecipeJobInput {
	s.DataCatalogOutputs = v
	return s
}

// SetDatabaseOutputs sets the DatabaseOutputs field's value.
func (s *UpdateRecipeJobInput) SetDatabaseOutputs(v []*DatabaseOutput_) *UpdateRecipeJobInput {
	s.DatabaseOutputs = v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *UpdateRecipeJobInput) SetEncryptionKeyArn(v string) *UpdateRecipeJobInput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *UpdateRecipeJobInput) SetEncryptionMode(v string) *UpdateRecipeJobInput {
	s.EncryptionMode = &v
	return s
}

// SetLogSubscription sets the LogSubscription field's value.
func (s *UpdateRecipeJobInput) SetLogSubscription(v string) *UpdateRecipeJobInput {
	s.LogSubscription = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *UpdateRecipeJobInput) SetMaxCapacity(v int64) *UpdateRecipeJobInput {
	s.MaxCapacity = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *UpdateRecipeJobInput) SetMaxRetries(v int64) *UpdateRecipeJobInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRecipeJobInput) SetName(v string) *UpdateRecipeJobInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *UpdateRecipeJobInput) SetOutputs(v []*Output) *UpdateRecipeJobInput {
	s.Outputs = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateRecipeJobInput) SetRoleArn(v string) *UpdateRecipeJobInput {
	s.RoleArn = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UpdateRecipeJobInput) SetTimeout(v int64) *UpdateRecipeJobInput {
	s.Timeout = &v
	return s
}

type UpdateRecipeJobOutput struct {
	_ struct{} `type:"structure"`

	// The name of the job that you updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateRecipeJobOutput) SetName(v string) *UpdateRecipeJobOutput {
	s.Name = &v
	return s
}

type UpdateRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The name of the recipe that was updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecipeOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateRecipeOutput) SetName(v string) *UpdateRecipeOutput {
	s.Name = &v
	return s
}

type UpdateRulesetInput struct {
	_ struct{} `type:"structure"`

	// The description of the ruleset.
	Description *string `type:"string"`

	// The name of the ruleset to be updated.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A list of rules that are defined with the ruleset. A rule includes one or
	// more checks to be validated on a DataBrew dataset.
	//
	// Rules is a required field
	Rules []*Rule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRulesetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRulesetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRulesetInput) SetDescription(v string) *UpdateRulesetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRulesetInput) SetName(v string) *UpdateRulesetInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateRulesetInput) SetRules(v []*Rule) *UpdateRulesetInput {
	s.Rules = v
	return s
}

type UpdateRulesetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the updated ruleset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesetOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateRulesetOutput) SetName(v string) *UpdateRulesetOutput {
	s.Name = &v
	return s
}

type UpdateScheduleInput struct {
	_ struct{} `type:"structure"`

	// The date or dates and time or times when the jobs are to be run. For more
	// information, see Cron expressions (https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html)
	// in the Glue DataBrew Developer Guide.
	//
	// CronExpression is a required field
	CronExpression *string `min:"1" type:"string" required:"true"`

	// The name or names of one or more jobs to be run for this schedule.
	JobNames []*string `type:"list"`

	// The name of the schedule to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScheduleInput"}
	if s.CronExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("CronExpression"))
	}
	if s.CronExpression != nil && len(*s.CronExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CronExpression", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCronExpression sets the CronExpression field's value.
func (s *UpdateScheduleInput) SetCronExpression(v string) *UpdateScheduleInput {
	s.CronExpression = &v
	return s
}

// SetJobNames sets the JobNames field's value.
func (s *UpdateScheduleInput) SetJobNames(v []*string) *UpdateScheduleInput {
	s.JobNames = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateScheduleInput) SetName(v string) *UpdateScheduleInput {
	s.Name = &v
	return s
}

type UpdateScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The name of the schedule that was updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateScheduleOutput) SetName(v string) *UpdateScheduleOutput {
	s.Name = &v
	return s
}

// Configuration for data quality validation. Used to select the Rulesets and
// Validation Mode to be used in the profile job. When ValidationConfiguration
// is null, the profile job will run without data quality validation.
type ValidationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the ruleset to be validated in the profile
	// job. The TargetArn of the selected ruleset should be the same as the Amazon
	// Resource Name (ARN) of the dataset that is associated with the profile job.
	//
	// RulesetArn is a required field
	RulesetArn *string `min:"20" type:"string" required:"true"`

	// Mode of data quality validation. Default mode is “CHECK_ALL” which verifies
	// all rules defined in the selected ruleset.
	ValidationMode *string `type:"string" enum:"ValidationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidationConfiguration"}
	if s.RulesetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RulesetArn"))
	}
	if s.RulesetArn != nil && len(*s.RulesetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RulesetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRulesetArn sets the RulesetArn field's value.
func (s *ValidationConfiguration) SetRulesetArn(v string) *ValidationConfiguration {
	s.RulesetArn = &v
	return s
}

// SetValidationMode sets the ValidationMode field's value.
func (s *ValidationConfiguration) SetValidationMode(v string) *ValidationConfiguration {
	s.ValidationMode = &v
	return s
}

// The input parameters for this request failed validation.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the data being transformed during an action.
type ViewFrame struct {
	_ struct{} `type:"structure"`

	// Controls if analytics computation is enabled or disabled. Enabled by default.
	Analytics *string `type:"string" enum:"AnalyticsMode"`

	// The number of columns to include in the view frame, beginning with the StartColumnIndex
	// value and ignoring any columns in the HiddenColumns list.
	ColumnRange *int64 `type:"integer"`

	// A list of columns to hide in the view frame.
	HiddenColumns []*string `type:"list"`

	// The number of rows to include in the view frame, beginning with the StartRowIndex
	// value.
	RowRange *int64 `type:"integer"`

	// The starting index for the range of columns to return in the view frame.
	//
	// StartColumnIndex is a required field
	StartColumnIndex *int64 `type:"integer" required:"true"`

	// The starting index for the range of rows to return in the view frame.
	StartRowIndex *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewFrame) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ViewFrame) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ViewFrame) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ViewFrame"}
	if s.StartColumnIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("StartColumnIndex"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalytics sets the Analytics field's value.
func (s *ViewFrame) SetAnalytics(v string) *ViewFrame {
	s.Analytics = &v
	return s
}

// SetColumnRange sets the ColumnRange field's value.
func (s *ViewFrame) SetColumnRange(v int64) *ViewFrame {
	s.ColumnRange = &v
	return s
}

// SetHiddenColumns sets the HiddenColumns field's value.
func (s *ViewFrame) SetHiddenColumns(v []*string) *ViewFrame {
	s.HiddenColumns = v
	return s
}

// SetRowRange sets the RowRange field's value.
func (s *ViewFrame) SetRowRange(v int64) *ViewFrame {
	s.RowRange = &v
	return s
}

// SetStartColumnIndex sets the StartColumnIndex field's value.
func (s *ViewFrame) SetStartColumnIndex(v int64) *ViewFrame {
	s.StartColumnIndex = &v
	return s
}

// SetStartRowIndex sets the StartRowIndex field's value.
func (s *ViewFrame) SetStartRowIndex(v int64) *ViewFrame {
	s.StartRowIndex = &v
	return s
}

const (
	// AnalyticsModeEnable is a AnalyticsMode enum value
	AnalyticsModeEnable = "ENABLE"

	// AnalyticsModeDisable is a AnalyticsMode enum value
	AnalyticsModeDisable = "DISABLE"
)

// AnalyticsMode_Values returns all elements of the AnalyticsMode enum
func AnalyticsMode_Values() []string {
	return []string{
		AnalyticsModeEnable,
		AnalyticsModeDisable,
	}
}

const (
	// CompressionFormatGzip is a CompressionFormat enum value
	CompressionFormatGzip = "GZIP"

	// CompressionFormatLz4 is a CompressionFormat enum value
	CompressionFormatLz4 = "LZ4"

	// CompressionFormatSnappy is a CompressionFormat enum value
	CompressionFormatSnappy = "SNAPPY"

	// CompressionFormatBzip2 is a CompressionFormat enum value
	CompressionFormatBzip2 = "BZIP2"

	// CompressionFormatDeflate is a CompressionFormat enum value
	CompressionFormatDeflate = "DEFLATE"

	// CompressionFormatLzo is a CompressionFormat enum value
	CompressionFormatLzo = "LZO"

	// CompressionFormatBrotli is a CompressionFormat enum value
	CompressionFormatBrotli = "BROTLI"

	// CompressionFormatZstd is a CompressionFormat enum value
	CompressionFormatZstd = "ZSTD"

	// CompressionFormatZlib is a CompressionFormat enum value
	CompressionFormatZlib = "ZLIB"
)

// CompressionFormat_Values returns all elements of the CompressionFormat enum
func CompressionFormat_Values() []string {
	return []string{
		CompressionFormatGzip,
		CompressionFormatLz4,
		CompressionFormatSnappy,
		CompressionFormatBzip2,
		CompressionFormatDeflate,
		CompressionFormatLzo,
		CompressionFormatBrotli,
		CompressionFormatZstd,
		CompressionFormatZlib,
	}
}

const (
	// DatabaseOutputModeNewTable is a DatabaseOutputMode enum value
	DatabaseOutputModeNewTable = "NEW_TABLE"
)

// DatabaseOutputMode_Values returns all elements of the DatabaseOutputMode enum
func DatabaseOutputMode_Values() []string {
	return []string{
		DatabaseOutputModeNewTable,
	}
}

const (
	// EncryptionModeSseKms is a EncryptionMode enum value
	EncryptionModeSseKms = "SSE-KMS"

	// EncryptionModeSseS3 is a EncryptionMode enum value
	EncryptionModeSseS3 = "SSE-S3"
)

// EncryptionMode_Values returns all elements of the EncryptionMode enum
func EncryptionMode_Values() []string {
	return []string{
		EncryptionModeSseKms,
		EncryptionModeSseS3,
	}
}

const (
	// InputFormatCsv is a InputFormat enum value
	InputFormatCsv = "CSV"

	// InputFormatJson is a InputFormat enum value
	InputFormatJson = "JSON"

	// InputFormatParquet is a InputFormat enum value
	InputFormatParquet = "PARQUET"

	// InputFormatExcel is a InputFormat enum value
	InputFormatExcel = "EXCEL"
)

// InputFormat_Values returns all elements of the InputFormat enum
func InputFormat_Values() []string {
	return []string{
		InputFormatCsv,
		InputFormatJson,
		InputFormatParquet,
		InputFormatExcel,
	}
}

const (
	// JobRunStateStarting is a JobRunState enum value
	JobRunStateStarting = "STARTING"

	// JobRunStateRunning is a JobRunState enum value
	JobRunStateRunning = "RUNNING"

	// JobRunStateStopping is a JobRunState enum value
	JobRunStateStopping = "STOPPING"

	// JobRunStateStopped is a JobRunState enum value
	JobRunStateStopped = "STOPPED"

	// JobRunStateSucceeded is a JobRunState enum value
	JobRunStateSucceeded = "SUCCEEDED"

	// JobRunStateFailed is a JobRunState enum value
	JobRunStateFailed = "FAILED"

	// JobRunStateTimeout is a JobRunState enum value
	JobRunStateTimeout = "TIMEOUT"
)

// JobRunState_Values returns all elements of the JobRunState enum
func JobRunState_Values() []string {
	return []string{
		JobRunStateStarting,
		JobRunStateRunning,
		JobRunStateStopping,
		JobRunStateStopped,
		JobRunStateSucceeded,
		JobRunStateFailed,
		JobRunStateTimeout,
	}
}

const (
	// JobTypeProfile is a JobType enum value
	JobTypeProfile = "PROFILE"

	// JobTypeRecipe is a JobType enum value
	JobTypeRecipe = "RECIPE"
)

// JobType_Values returns all elements of the JobType enum
func JobType_Values() []string {
	return []string{
		JobTypeProfile,
		JobTypeRecipe,
	}
}

const (
	// LogSubscriptionEnable is a LogSubscription enum value
	LogSubscriptionEnable = "ENABLE"

	// LogSubscriptionDisable is a LogSubscription enum value
	LogSubscriptionDisable = "DISABLE"
)

// LogSubscription_Values returns all elements of the LogSubscription enum
func LogSubscription_Values() []string {
	return []string{
		LogSubscriptionEnable,
		LogSubscriptionDisable,
	}
}

const (
	// OrderDescending is a Order enum value
	OrderDescending = "DESCENDING"

	// OrderAscending is a Order enum value
	OrderAscending = "ASCENDING"
)

// Order_Values returns all elements of the Order enum
func Order_Values() []string {
	return []string{
		OrderDescending,
		OrderAscending,
	}
}

const (
	// OrderedByLastModifiedDate is a OrderedBy enum value
	OrderedByLastModifiedDate = "LAST_MODIFIED_DATE"
)

// OrderedBy_Values returns all elements of the OrderedBy enum
func OrderedBy_Values() []string {
	return []string{
		OrderedByLastModifiedDate,
	}
}

const (
	// OutputFormatCsv is a OutputFormat enum value
	OutputFormatCsv = "CSV"

	// OutputFormatJson is a OutputFormat enum value
	OutputFormatJson = "JSON"

	// OutputFormatParquet is a OutputFormat enum value
	OutputFormatParquet = "PARQUET"

	// OutputFormatGlueparquet is a OutputFormat enum value
	OutputFormatGlueparquet = "GLUEPARQUET"

	// OutputFormatAvro is a OutputFormat enum value
	OutputFormatAvro = "AVRO"

	// OutputFormatOrc is a OutputFormat enum value
	OutputFormatOrc = "ORC"

	// OutputFormatXml is a OutputFormat enum value
	OutputFormatXml = "XML"

	// OutputFormatTableauhyper is a OutputFormat enum value
	OutputFormatTableauhyper = "TABLEAUHYPER"
)

// OutputFormat_Values returns all elements of the OutputFormat enum
func OutputFormat_Values() []string {
	return []string{
		OutputFormatCsv,
		OutputFormatJson,
		OutputFormatParquet,
		OutputFormatGlueparquet,
		OutputFormatAvro,
		OutputFormatOrc,
		OutputFormatXml,
		OutputFormatTableauhyper,
	}
}

const (
	// ParameterTypeDatetime is a ParameterType enum value
	ParameterTypeDatetime = "Datetime"

	// ParameterTypeNumber is a ParameterType enum value
	ParameterTypeNumber = "Number"

	// ParameterTypeString is a ParameterType enum value
	ParameterTypeString = "String"
)

// ParameterType_Values returns all elements of the ParameterType enum
func ParameterType_Values() []string {
	return []string{
		ParameterTypeDatetime,
		ParameterTypeNumber,
		ParameterTypeString,
	}
}

const (
	// SampleModeFullDataset is a SampleMode enum value
	SampleModeFullDataset = "FULL_DATASET"

	// SampleModeCustomRows is a SampleMode enum value
	SampleModeCustomRows = "CUSTOM_ROWS"
)

// SampleMode_Values returns all elements of the SampleMode enum
func SampleMode_Values() []string {
	return []string{
		SampleModeFullDataset,
		SampleModeCustomRows,
	}
}

const (
	// SampleTypeFirstN is a SampleType enum value
	SampleTypeFirstN = "FIRST_N"

	// SampleTypeLastN is a SampleType enum value
	SampleTypeLastN = "LAST_N"

	// SampleTypeRandom is a SampleType enum value
	SampleTypeRandom = "RANDOM"
)

// SampleType_Values returns all elements of the SampleType enum
func SampleType_Values() []string {
	return []string{
		SampleTypeFirstN,
		SampleTypeLastN,
		SampleTypeRandom,
	}
}

const (
	// SessionStatusAssigned is a SessionStatus enum value
	SessionStatusAssigned = "ASSIGNED"

	// SessionStatusFailed is a SessionStatus enum value
	SessionStatusFailed = "FAILED"

	// SessionStatusInitializing is a SessionStatus enum value
	SessionStatusInitializing = "INITIALIZING"

	// SessionStatusProvisioning is a SessionStatus enum value
	SessionStatusProvisioning = "PROVISIONING"

	// SessionStatusReady is a SessionStatus enum value
	SessionStatusReady = "READY"

	// SessionStatusRecycling is a SessionStatus enum value
	SessionStatusRecycling = "RECYCLING"

	// SessionStatusRotating is a SessionStatus enum value
	SessionStatusRotating = "ROTATING"

	// SessionStatusTerminated is a SessionStatus enum value
	SessionStatusTerminated = "TERMINATED"

	// SessionStatusTerminating is a SessionStatus enum value
	SessionStatusTerminating = "TERMINATING"

	// SessionStatusUpdating is a SessionStatus enum value
	SessionStatusUpdating = "UPDATING"
)

// SessionStatus_Values returns all elements of the SessionStatus enum
func SessionStatus_Values() []string {
	return []string{
		SessionStatusAssigned,
		SessionStatusFailed,
		SessionStatusInitializing,
		SessionStatusProvisioning,
		SessionStatusReady,
		SessionStatusRecycling,
		SessionStatusRotating,
		SessionStatusTerminated,
		SessionStatusTerminating,
		SessionStatusUpdating,
	}
}

const (
	// SourceS3 is a Source enum value
	SourceS3 = "S3"

	// SourceDataCatalog is a Source enum value
	SourceDataCatalog = "DATA-CATALOG"

	// SourceDatabase is a Source enum value
	SourceDatabase = "DATABASE"
)

// Source_Values returns all elements of the Source enum
func Source_Values() []string {
	return []string{
		SourceS3,
		SourceDataCatalog,
		SourceDatabase,
	}
}

const (
	// ThresholdTypeGreaterThanOrEqual is a ThresholdType enum value
	ThresholdTypeGreaterThanOrEqual = "GREATER_THAN_OR_EQUAL"

	// ThresholdTypeLessThanOrEqual is a ThresholdType enum value
	ThresholdTypeLessThanOrEqual = "LESS_THAN_OR_EQUAL"

	// ThresholdTypeGreaterThan is a ThresholdType enum value
	ThresholdTypeGreaterThan = "GREATER_THAN"

	// ThresholdTypeLessThan is a ThresholdType enum value
	ThresholdTypeLessThan = "LESS_THAN"
)

// ThresholdType_Values returns all elements of the ThresholdType enum
func ThresholdType_Values() []string {
	return []string{
		ThresholdTypeGreaterThanOrEqual,
		ThresholdTypeLessThanOrEqual,
		ThresholdTypeGreaterThan,
		ThresholdTypeLessThan,
	}
}

const (
	// ThresholdUnitCount is a ThresholdUnit enum value
	ThresholdUnitCount = "COUNT"

	// ThresholdUnitPercentage is a ThresholdUnit enum value
	ThresholdUnitPercentage = "PERCENTAGE"
)

// ThresholdUnit_Values returns all elements of the ThresholdUnit enum
func ThresholdUnit_Values() []string {
	return []string{
		ThresholdUnitCount,
		ThresholdUnitPercentage,
	}
}

const (
	// ValidationModeCheckAll is a ValidationMode enum value
	ValidationModeCheckAll = "CHECK_ALL"
)

// ValidationMode_Values returns all elements of the ValidationMode enum
func ValidationMode_Values() []string {
	return []string{
		ValidationModeCheckAll,
	}
}
