# Share Claim

A share claim makes blob(s) available to others. (that is, parties who are not
the owner of the Camlistore instance).

Example:

    {"camliVersion": 1,

     // Type of authentication required to access the share. Currently only haveref
     // is supported, which means that anyone with the claim blobref can access.
     "authType": "haveref",

     "camliType": "claim",
     "camliSigner": "sha1-f2b0b7da718b97ce8c31591d8ed4645c777f3ef4",
     "claimDate": "2014-09-04T20:04:09.193945801Z",
     "claimType": "share",

     // The blob or search to share. Exactly one of these must be present. It is an
     // error to set neither or both.
     "target": "sha1-543fbdfdbcb1297af8a4dc7d299c0cb90e2bea0f",
     "search": <JSON object of type *search.SearchQuery>,

     // If true, anything recursively reachable from target or search is also
     // shared. Edges that are guaranteed to be followed for purposes of
     // reachability are:
     // - blobRef and bytesRef values of camliType="blob|file"
     // - members of camliType="static-set"
     // Currently reachability is implemented more loosely, but clients should not
     // depend on that.
     "transitive": false,

     <REQUIRED-JSON-SIGNATURE>
    }
