﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="HtmlColorName.cs" company="None, it's free for all.">
//   Copyright (c) None, it's free for all. All rights reserved.
// </copyright>
// <summary>
//   The HTML color names and their hexadecimal values.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace ThingM.Blink1.ColorProcessor
{
    /// <summary>
    /// The HTML color names and their hexadecimal values.
    /// </summary>
    public static class HtmlColorName
    {
        #region Constants

        /// <summary>
        /// The alice blue.
        /// </summary>
        public const string AliceBlue = "#F0F8FF";

        /// <summary>
        /// The antique white.
        /// </summary>
        public const string AntiqueWhite = "#FAEBD7";

        /// <summary>
        /// The aqua.
        /// </summary>
        public const string Aqua = "#00FFFF";

        /// <summary>
        /// The aquamarine.
        /// </summary>
        public const string Aquamarine = "#7FFFD4";

        /// <summary>
        /// The azure.
        /// </summary>
        public const string Azure = "#F0FFFF";

        /// <summary>
        /// The beige.
        /// </summary>
        public const string Beige = "#F5F5DC";

        /// <summary>
        /// The bisque.
        /// </summary>
        public const string Bisque = "#FFE4C4";

        /// <summary>
        /// The black.
        /// </summary>
        public const string Black = "#000000";

        /// <summary>
        /// The blanched almond.
        /// </summary>
        public const string BlanchedAlmond = "#FFEBCD";

        /// <summary>
        /// The blue.
        /// </summary>
        public const string Blue = "#0000FF";

        /// <summary>
        /// The blue violet.
        /// </summary>
        public const string BlueViolet = "#8A2BE2";

        /// <summary>
        /// The brown.
        /// </summary>
        public const string Brown = "#A52A2A";

        /// <summary>
        /// The burly wood.
        /// </summary>
        public const string BurlyWood = "#DEB887";

        /// <summary>
        /// The cadet blue.
        /// </summary>
        public const string CadetBlue = "#5F9EA0";

        /// <summary>
        /// The chartreuse.
        /// </summary>
        public const string Chartreuse = "#7FFF00";

        /// <summary>
        /// The chocolate.
        /// </summary>
        public const string Chocolate = "#D2691E";

        /// <summary>
        /// The coral.
        /// </summary>
        public const string Coral = "#FF7F50";

        /// <summary>
        /// The cornflower blue.
        /// </summary>
        public const string CornflowerBlue = "#6495ED";

        /// <summary>
        /// The cornsilk.
        /// </summary>
        public const string Cornsilk = "#FFF8DC";

        /// <summary>
        /// The crimson.
        /// </summary>
        public const string Crimson = "#DC143C";

        /// <summary>
        /// The cyan.
        /// </summary>
        public const string Cyan = "#00FFFF";

        /// <summary>
        /// The dark blue.
        /// </summary>
        public const string DarkBlue = "#00008B";

        /// <summary>
        /// The dark cyan.
        /// </summary>
        public const string DarkCyan = "#008B8B";

        /// <summary>
        /// The dark golden rod.
        /// </summary>
        public const string DarkGoldenRod = "#B8860B";

        /// <summary>
        /// The dark gray.
        /// </summary>
        public const string DarkGray = "#A9A9A9";

        /// <summary>
        /// The dark green.
        /// </summary>
        public const string DarkGreen = "#006400";

        /// <summary>
        /// The dark grey.
        /// </summary>
        public const string DarkGrey = "#A9A9A9";

        /// <summary>
        /// The dark khaki.
        /// </summary>
        public const string DarkKhaki = "#BDB76B";

        /// <summary>
        /// The dark magenta.
        /// </summary>
        public const string DarkMagenta = "#8B008B";

        /// <summary>
        /// The dark olive green.
        /// </summary>
        public const string DarkOliveGreen = "#556B2F";

        /// <summary>
        /// The dark orchid.
        /// </summary>
        public const string DarkOrchid = "#9932CC";

        /// <summary>
        /// The dark red.
        /// </summary>
        public const string DarkRed = "#8B0000";

        /// <summary>
        /// The dark salmon.
        /// </summary>
        public const string DarkSalmon = "#E9967A";

        /// <summary>
        /// The dark sea green.
        /// </summary>
        public const string DarkSeaGreen = "#8FBC8F";

        /// <summary>
        /// The dark slate blue.
        /// </summary>
        public const string DarkSlateBlue = "#483D8B";

        /// <summary>
        /// The dark slate gray.
        /// </summary>
        public const string DarkSlateGray = "#2F4F4F";

        /// <summary>
        /// The dark slate grey.
        /// </summary>
        public const string DarkSlateGrey = "#2F4F4F";

        /// <summary>
        /// The dark turquoise.
        /// </summary>
        public const string DarkTurquoise = "#00CED1";

        /// <summary>
        /// The dark violet.
        /// </summary>
        public const string DarkViolet = "#9400D3";

        /// <summary>
        /// The darkorange.
        /// </summary>
        public const string Darkorange = "#FF8C00";

        /// <summary>
        /// The deep pink.
        /// </summary>
        public const string DeepPink = "#FF1493";

        /// <summary>
        /// The deep sky blue.
        /// </summary>
        public const string DeepSkyBlue = "#00BFFF";

        /// <summary>
        /// The dim gray.
        /// </summary>
        public const string DimGray = "#696969";

        /// <summary>
        /// The dim grey.
        /// </summary>
        public const string DimGrey = "#696969";

        /// <summary>
        /// The dodger blue.
        /// </summary>
        public const string DodgerBlue = "#1E90FF";

        /// <summary>
        /// The fire brick.
        /// </summary>
        public const string FireBrick = "#B22222";

        /// <summary>
        /// The floral white.
        /// </summary>
        public const string FloralWhite = "#FFFAF0";

        /// <summary>
        /// The forest green.
        /// </summary>
        public const string ForestGreen = "#228B22";

        /// <summary>
        /// The fuchsia.
        /// </summary>
        public const string Fuchsia = "#FF00FF";

        /// <summary>
        /// The gainsboro.
        /// </summary>
        public const string Gainsboro = "#DCDCDC";

        /// <summary>
        /// The ghost white.
        /// </summary>
        public const string GhostWhite = "#F8F8FF";

        /// <summary>
        /// The gold.
        /// </summary>
        public const string Gold = "#FFD700";

        /// <summary>
        /// The golden rod.
        /// </summary>
        public const string GoldenRod = "#DAA520";

        /// <summary>
        /// The gray.
        /// </summary>
        public const string Gray = "#808080";

        /// <summary>
        /// The green.
        /// </summary>
        public const string Green = "#008000";

        /// <summary>
        /// The green yellow.
        /// </summary>
        public const string GreenYellow = "#ADFF2F";

        /// <summary>
        /// The grey.
        /// </summary>
        public const string Grey = "#808080";

        /// <summary>
        /// The honey dew.
        /// </summary>
        public const string HoneyDew = "#F0FFF0";

        /// <summary>
        /// The hot pink.
        /// </summary>
        public const string HotPink = "#FF69B4";

        /// <summary>
        /// The indian red.
        /// </summary>
        public const string IndianRed = "#CD5C5C";

        /// <summary>
        /// The indigo.
        /// </summary>
        public const string Indigo = "#4B0082";

        /// <summary>
        /// The ivory.
        /// </summary>
        public const string Ivory = "#FFFFF0";

        /// <summary>
        /// The khaki.
        /// </summary>
        public const string Khaki = "#F0E68C";

        /// <summary>
        /// The lavender.
        /// </summary>
        public const string Lavender = "#E6E6FA";

        /// <summary>
        /// The lavender blush.
        /// </summary>
        public const string LavenderBlush = "#FFF0F5";

        /// <summary>
        /// The lawn green.
        /// </summary>
        public const string LawnGreen = "#7CFC00";

        /// <summary>
        /// The lemon chiffon.
        /// </summary>
        public const string LemonChiffon = "#FFFACD";

        /// <summary>
        /// The light blue.
        /// </summary>
        public const string LightBlue = "#ADD8E6";

        /// <summary>
        /// The light coral.
        /// </summary>
        public const string LightCoral = "#F08080";

        /// <summary>
        /// The light cyan.
        /// </summary>
        public const string LightCyan = "#E0FFFF";

        /// <summary>
        /// The light golden rod yellow.
        /// </summary>
        public const string LightGoldenRodYellow = "#FAFAD2";

        /// <summary>
        /// The light gray.
        /// </summary>
        public const string LightGray = "#D3D3D3";

        /// <summary>
        /// The light green.
        /// </summary>
        public const string LightGreen = "#90EE90";

        /// <summary>
        /// The light grey.
        /// </summary>
        public const string LightGrey = "#D3D3D3";

        /// <summary>
        /// The light pink.
        /// </summary>
        public const string LightPink = "#FFB6C1";

        /// <summary>
        /// The light salmon.
        /// </summary>
        public const string LightSalmon = "#FFA07A";

        /// <summary>
        /// The light sea green.
        /// </summary>
        public const string LightSeaGreen = "#20B2AA";

        /// <summary>
        /// The light sky blue.
        /// </summary>
        public const string LightSkyBlue = "#87CEFA";

        /// <summary>
        /// The light slate gray.
        /// </summary>
        public const string LightSlateGray = "#778899";

        /// <summary>
        /// The light slate grey.
        /// </summary>
        public const string LightSlateGrey = "#778899";

        /// <summary>
        /// The light steel blue.
        /// </summary>
        public const string LightSteelBlue = "#B0C4DE";

        /// <summary>
        /// The light yellow.
        /// </summary>
        public const string LightYellow = "#FFFFE0";

        /// <summary>
        /// The lime.
        /// </summary>
        public const string Lime = "#00FF00";

        /// <summary>
        /// The lime green.
        /// </summary>
        public const string LimeGreen = "#32CD32";

        /// <summary>
        /// The linen.
        /// </summary>
        public const string Linen = "#FAF0E6";

        /// <summary>
        /// The magenta.
        /// </summary>
        public const string Magenta = "#FF00FF";

        /// <summary>
        /// The maroon.
        /// </summary>
        public const string Maroon = "#800000";

        /// <summary>
        /// The medium aqua marine.
        /// </summary>
        public const string MediumAquaMarine = "#66CDAA";

        /// <summary>
        /// The medium blue.
        /// </summary>
        public const string MediumBlue = "#0000CD";

        /// <summary>
        /// The medium orchid.
        /// </summary>
        public const string MediumOrchid = "#BA55D3";

        /// <summary>
        /// The medium purple.
        /// </summary>
        public const string MediumPurple = "#9370DB";

        /// <summary>
        /// The medium sea green.
        /// </summary>
        public const string MediumSeaGreen = "#3CB371";

        /// <summary>
        /// The medium slate blue.
        /// </summary>
        public const string MediumSlateBlue = "#7B68EE";

        /// <summary>
        /// The medium spring green.
        /// </summary>
        public const string MediumSpringGreen = "#00FA9A";

        /// <summary>
        /// The medium turquoise.
        /// </summary>
        public const string MediumTurquoise = "#48D1CC";

        /// <summary>
        /// The medium violet red.
        /// </summary>
        public const string MediumVioletRed = "#C71585";

        /// <summary>
        /// The midnight blue.
        /// </summary>
        public const string MidnightBlue = "#191970";

        /// <summary>
        /// The mint cream.
        /// </summary>
        public const string MintCream = "#F5FFFA";

        /// <summary>
        /// The misty rose.
        /// </summary>
        public const string MistyRose = "#FFE4E1";

        /// <summary>
        /// The moccasin.
        /// </summary>
        public const string Moccasin = "#FFE4B5";

        /// <summary>
        /// The navajo white.
        /// </summary>
        public const string NavajoWhite = "#FFDEAD";

        /// <summary>
        /// The navy.
        /// </summary>
        public const string Navy = "#000080";

        /// <summary>
        /// The old lace.
        /// </summary>
        public const string OldLace = "#FDF5E6";

        /// <summary>
        /// The olive.
        /// </summary>
        public const string Olive = "#808000";

        /// <summary>
        /// The olive drab.
        /// </summary>
        public const string OliveDrab = "#6B8E23";

        /// <summary>
        /// The orange.
        /// </summary>
        public const string Orange = "#FFA500";

        /// <summary>
        /// The orange red.
        /// </summary>
        public const string OrangeRed = "#FF4500";

        /// <summary>
        /// The orchid.
        /// </summary>
        public const string Orchid = "#DA70D6";

        /// <summary>
        /// The pale golden rod.
        /// </summary>
        public const string PaleGoldenRod = "#EEE8AA";

        /// <summary>
        /// The pale green.
        /// </summary>
        public const string PaleGreen = "#98FB98";

        /// <summary>
        /// The pale turquoise.
        /// </summary>
        public const string PaleTurquoise = "#AFEEEE";

        /// <summary>
        /// The pale violet red.
        /// </summary>
        public const string PaleVioletRed = "#DB7093";

        /// <summary>
        /// The papaya whip.
        /// </summary>
        public const string PapayaWhip = "#FFEFD5";

        /// <summary>
        /// The peach puff.
        /// </summary>
        public const string PeachPuff = "#FFDAB9";

        /// <summary>
        /// The peru.
        /// </summary>
        public const string Peru = "#CD853F";

        /// <summary>
        /// The pink.
        /// </summary>
        public const string Pink = "#FFC0CB";

        /// <summary>
        /// The plum.
        /// </summary>
        public const string Plum = "#DDA0DD";

        /// <summary>
        /// The powder blue.
        /// </summary>
        public const string PowderBlue = "#B0E0E6";

        /// <summary>
        /// The purple.
        /// </summary>
        public const string Purple = "#800080";

        /// <summary>
        /// The red.
        /// </summary>
        public const string Red = "#FF0000";

        /// <summary>
        /// The rosy brown.
        /// </summary>
        public const string RosyBrown = "#BC8F8F";

        /// <summary>
        /// The royal blue.
        /// </summary>
        public const string RoyalBlue = "#4169E1";

        /// <summary>
        /// The saddle brown.
        /// </summary>
        public const string SaddleBrown = "#8B4513";

        /// <summary>
        /// The salmon.
        /// </summary>
        public const string Salmon = "#FA8072";

        /// <summary>
        /// The sandy brown.
        /// </summary>
        public const string SandyBrown = "#F4A460";

        /// <summary>
        /// The sea green.
        /// </summary>
        public const string SeaGreen = "#2E8B57";

        /// <summary>
        /// The sea shell.
        /// </summary>
        public const string SeaShell = "#FFF5EE";

        /// <summary>
        /// The sienna.
        /// </summary>
        public const string Sienna = "#A0522D";

        /// <summary>
        /// The silver.
        /// </summary>
        public const string Silver = "#C0C0C0";

        /// <summary>
        /// The sky blue.
        /// </summary>
        public const string SkyBlue = "#87CEEB";

        /// <summary>
        /// The slate blue.
        /// </summary>
        public const string SlateBlue = "#6A5ACD";

        /// <summary>
        /// The slate gray.
        /// </summary>
        public const string SlateGray = "#708090";

        /// <summary>
        /// The slate grey.
        /// </summary>
        public const string SlateGrey = "#708090";

        /// <summary>
        /// The snow.
        /// </summary>
        public const string Snow = "#FFFAFA";

        /// <summary>
        /// The spring green.
        /// </summary>
        public const string SpringGreen = "#00FF7F";

        /// <summary>
        /// The steel blue.
        /// </summary>
        public const string SteelBlue = "#4682B4";

        /// <summary>
        /// The tan.
        /// </summary>
        public const string Tan = "#D2B48C";

        /// <summary>
        /// The teal.
        /// </summary>
        public const string Teal = "#008080";

        /// <summary>
        /// The thistle.
        /// </summary>
        public const string Thistle = "#D8BFD8";

        /// <summary>
        /// The tomato.
        /// </summary>
        public const string Tomato = "#FF6347";

        /// <summary>
        /// The turquoise.
        /// </summary>
        public const string Turquoise = "#40E0D0";

        /// <summary>
        /// The violet.
        /// </summary>
        public const string Violet = "#EE82EE";

        /// <summary>
        /// The wheat.
        /// </summary>
        public const string Wheat = "#F5DEB3";

        /// <summary>
        /// The white.
        /// </summary>
        public const string White = "#FFFFFF";

        /// <summary>
        /// The white smoke.
        /// </summary>
        public const string WhiteSmoke = "#F5F5F5";

        /// <summary>
        /// The yellow.
        /// </summary>
        public const string Yellow = "#FFFF00";

        /// <summary>
        /// The yellow green.
        /// </summary>
        public const string YellowGreen = "#9ACD32";

        #endregion
    }
}