// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCertificateAuthority = "CreateCertificateAuthority"

// CreateCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificateAuthority for more information on using the CreateCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateAuthorityRequest method.
//    req, resp := client.CreateCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthority
func (c *ACMPCA) CreateCertificateAuthorityRequest(input *CreateCertificateAuthorityInput) (req *request.Request, output *CreateCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCertificateAuthorityInput{}
	}

	output = &CreateCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Creates a root or subordinate private certificate authority (CA). You must
// specify the CA configuration, the certificate revocation list (CRL) configuration,
// the CA type, and an optional idempotency token to avoid accidental creation
// of multiple CAs. The CA configuration specifies the name of the algorithm
// and key size to be used to create the CA private key, the type of signing
// algorithm that the CA uses, and X.500 subject information. The CRL configuration
// specifies the CRL expiration period in days (the validity period of the CRL),
// the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the
// S3 bucket that is included in certificates issued by the CA. If successful,
// this action returns the Amazon Resource Name (ARN) of the CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation CreateCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * InvalidPolicyException
//   The S3 bucket policy is not valid. The policy must give ACM Private CA rights
//   to read from and write to the bucket and find the bucket location.
//
//   * InvalidTagException
//   The tag associated with the CA is not valid. The invalid argument is contained
//   in the message field.
//
//   * LimitExceededException
//   An ACM Private CA limit has been exceeded. See the exception message returned
//   to determine the limit that was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthority
func (c *ACMPCA) CreateCertificateAuthority(input *CreateCertificateAuthorityInput) (*CreateCertificateAuthorityOutput, error) {
	req, out := c.CreateCertificateAuthorityRequest(input)
	return out, req.Send()
}

// CreateCertificateAuthorityWithContext is the same as CreateCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) CreateCertificateAuthorityWithContext(ctx aws.Context, input *CreateCertificateAuthorityInput, opts ...request.Option) (*CreateCertificateAuthorityOutput, error) {
	req, out := c.CreateCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCertificateAuthorityAuditReport = "CreateCertificateAuthorityAuditReport"

// CreateCertificateAuthorityAuditReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateAuthorityAuditReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificateAuthorityAuditReport for more information on using the CreateCertificateAuthorityAuditReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateAuthorityAuditReportRequest method.
//    req, resp := client.CreateCertificateAuthorityAuditReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthorityAuditReport
func (c *ACMPCA) CreateCertificateAuthorityAuditReportRequest(input *CreateCertificateAuthorityAuditReportInput) (req *request.Request, output *CreateCertificateAuthorityAuditReportOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateAuthorityAuditReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCertificateAuthorityAuditReportInput{}
	}

	output = &CreateCertificateAuthorityAuditReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateAuthorityAuditReport API operation for AWS Certificate Manager Private Certificate Authority.
//
// Creates an audit report that lists every time that your CA private key is
// used. The report is saved in the Amazon S3 bucket that you specify on input.
// The IssueCertificate and RevokeCertificate actions use the private key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation CreateCertificateAuthorityAuditReport for usage and error information.
//
// Returned Error Types:
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthorityAuditReport
func (c *ACMPCA) CreateCertificateAuthorityAuditReport(input *CreateCertificateAuthorityAuditReportInput) (*CreateCertificateAuthorityAuditReportOutput, error) {
	req, out := c.CreateCertificateAuthorityAuditReportRequest(input)
	return out, req.Send()
}

// CreateCertificateAuthorityAuditReportWithContext is the same as CreateCertificateAuthorityAuditReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateAuthorityAuditReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) CreateCertificateAuthorityAuditReportWithContext(ctx aws.Context, input *CreateCertificateAuthorityAuditReportInput, opts ...request.Option) (*CreateCertificateAuthorityAuditReportOutput, error) {
	req, out := c.CreateCertificateAuthorityAuditReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePermission = "CreatePermission"

// CreatePermissionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePermission for more information on using the CreatePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePermissionRequest method.
//    req, resp := client.CreatePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission
func (c *ACMPCA) CreatePermissionRequest(input *CreatePermissionInput) (req *request.Request, output *CreatePermissionOutput) {
	op := &request.Operation{
		Name:       opCreatePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePermissionInput{}
	}

	output = &CreatePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreatePermission API operation for AWS Certificate Manager Private Certificate Authority.
//
// Assigns permissions from a private CA to a designated AWS service. Services
// are specified by their service principals and can be given permission to
// create and retrieve certificates on a private CA. Services can also be given
// permission to list the active permissions that the private CA has granted.
// For ACM to automatically renew your private CA's certificates, you must assign
// all possible permissions from the CA to the ACM service principal.
//
// At this time, you can only assign permissions to ACM (acm.amazonaws.com).
// Permissions can be revoked with the DeletePermission action and listed with
// the ListPermissions action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation CreatePermission for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * PermissionAlreadyExistsException
//   The designated permission has already been given to the user.
//
//   * LimitExceededException
//   An ACM Private CA limit has been exceeded. See the exception message returned
//   to determine the limit that was exceeded.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission
func (c *ACMPCA) CreatePermission(input *CreatePermissionInput) (*CreatePermissionOutput, error) {
	req, out := c.CreatePermissionRequest(input)
	return out, req.Send()
}

// CreatePermissionWithContext is the same as CreatePermission with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) CreatePermissionWithContext(ctx aws.Context, input *CreatePermissionInput, opts ...request.Option) (*CreatePermissionOutput, error) {
	req, out := c.CreatePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificateAuthority = "DeleteCertificateAuthority"

// DeleteCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificateAuthority for more information on using the DeleteCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateAuthorityRequest method.
//    req, resp := client.DeleteCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeleteCertificateAuthority
func (c *ACMPCA) DeleteCertificateAuthorityRequest(input *DeleteCertificateAuthorityInput) (req *request.Request, output *DeleteCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateAuthorityInput{}
	}

	output = &DeleteCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Deletes a private certificate authority (CA). You must provide the Amazon
// Resource Name (ARN) of the private CA that you want to delete. You can find
// the ARN by calling the ListCertificateAuthorities action.
//
// Deleting a CA will invalidate other CAs and certificates below it in your
// CA hierarchy.
//
// Before you can delete a CA that you have created and activated, you must
// disable it. To do this, call the UpdateCertificateAuthority action and set
// the CertificateAuthorityStatus parameter to DISABLED.
//
// Additionally, you can delete a CA if you are waiting for it to be created
// (that is, the status of the CA is CREATING). You can also delete it if the
// CA has been created but you haven't yet imported the signed certificate into
// ACM Private CA (that is, the status of the CA is PENDING_CERTIFICATE).
//
// When you successfully call DeleteCertificateAuthority, the CA's status changes
// to DELETED. However, the CA won't be permanently deleted until the restoration
// period has passed. By default, if you do not set the PermanentDeletionTimeInDays
// parameter, the CA remains restorable for 30 days. You can set the parameter
// from 7 to 30 days. The DescribeCertificateAuthority action returns the time
// remaining in the restoration window of a private CA in the DELETED state.
// To restore an eligible CA, call the RestoreCertificateAuthority action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DeleteCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeleteCertificateAuthority
func (c *ACMPCA) DeleteCertificateAuthority(input *DeleteCertificateAuthorityInput) (*DeleteCertificateAuthorityOutput, error) {
	req, out := c.DeleteCertificateAuthorityRequest(input)
	return out, req.Send()
}

// DeleteCertificateAuthorityWithContext is the same as DeleteCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DeleteCertificateAuthorityWithContext(ctx aws.Context, input *DeleteCertificateAuthorityInput, opts ...request.Option) (*DeleteCertificateAuthorityOutput, error) {
	req, out := c.DeleteCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermission = "DeletePermission"

// DeletePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermission for more information on using the DeletePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePermissionRequest method.
//    req, resp := client.DeletePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePermission
func (c *ACMPCA) DeletePermissionRequest(input *DeletePermissionInput) (req *request.Request, output *DeletePermissionOutput) {
	op := &request.Operation{
		Name:       opDeletePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionInput{}
	}

	output = &DeletePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermission API operation for AWS Certificate Manager Private Certificate Authority.
//
// Revokes permissions that a private CA assigned to a designated AWS service.
// Permissions can be created with the CreatePermission action and listed with
// the ListPermissions action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DeletePermission for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePermission
func (c *ACMPCA) DeletePermission(input *DeletePermissionInput) (*DeletePermissionOutput, error) {
	req, out := c.DeletePermissionRequest(input)
	return out, req.Send()
}

// DeletePermissionWithContext is the same as DeletePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DeletePermissionWithContext(ctx aws.Context, input *DeletePermissionInput, opts ...request.Option) (*DeletePermissionOutput, error) {
	req, out := c.DeletePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificateAuthority = "DescribeCertificateAuthority"

// DescribeCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificateAuthority for more information on using the DescribeCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateAuthorityRequest method.
//    req, resp := client.DescribeCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthority
func (c *ACMPCA) DescribeCertificateAuthorityRequest(input *DescribeCertificateAuthorityInput) (req *request.Request, output *DescribeCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateAuthorityInput{}
	}

	output = &DescribeCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists information about your private certificate authority (CA). You specify
// the private CA on input by its ARN (Amazon Resource Name). The output contains
// the status of your CA. This can be any of the following:
//
//    * CREATING - ACM Private CA is creating your private certificate authority.
//
//    * PENDING_CERTIFICATE - The certificate is pending. You must use your
//    ACM Private CA-hosted or on-premises root or subordinate CA to sign your
//    private CA CSR and then import it into PCA.
//
//    * ACTIVE - Your private CA is active.
//
//    * DISABLED - Your private CA has been disabled.
//
//    * EXPIRED - Your private CA certificate has expired.
//
//    * FAILED - Your private CA has failed. Your CA can fail because of problems
//    such a network outage or backend AWS failure or other errors. A failed
//    CA can never return to the pending state. You must create a new CA.
//
//    * DELETED - Your private CA is within the restoration period, after which
//    it is permanently deleted. The length of time remaining in the CA's restoration
//    period is also included in this action's output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DescribeCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthority
func (c *ACMPCA) DescribeCertificateAuthority(input *DescribeCertificateAuthorityInput) (*DescribeCertificateAuthorityOutput, error) {
	req, out := c.DescribeCertificateAuthorityRequest(input)
	return out, req.Send()
}

// DescribeCertificateAuthorityWithContext is the same as DescribeCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DescribeCertificateAuthorityWithContext(ctx aws.Context, input *DescribeCertificateAuthorityInput, opts ...request.Option) (*DescribeCertificateAuthorityOutput, error) {
	req, out := c.DescribeCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificateAuthorityAuditReport = "DescribeCertificateAuthorityAuditReport"

// DescribeCertificateAuthorityAuditReportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificateAuthorityAuditReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificateAuthorityAuditReport for more information on using the DescribeCertificateAuthorityAuditReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateAuthorityAuditReportRequest method.
//    req, resp := client.DescribeCertificateAuthorityAuditReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthorityAuditReport
func (c *ACMPCA) DescribeCertificateAuthorityAuditReportRequest(input *DescribeCertificateAuthorityAuditReportInput) (req *request.Request, output *DescribeCertificateAuthorityAuditReportOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificateAuthorityAuditReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateAuthorityAuditReportInput{}
	}

	output = &DescribeCertificateAuthorityAuditReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificateAuthorityAuditReport API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists information about a specific audit report created by calling the CreateCertificateAuthorityAuditReport
// action. Audit information is created every time the certificate authority
// (CA) private key is used. The private key is used when you call the IssueCertificate
// action or the RevokeCertificate action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DescribeCertificateAuthorityAuditReport for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthorityAuditReport
func (c *ACMPCA) DescribeCertificateAuthorityAuditReport(input *DescribeCertificateAuthorityAuditReportInput) (*DescribeCertificateAuthorityAuditReportOutput, error) {
	req, out := c.DescribeCertificateAuthorityAuditReportRequest(input)
	return out, req.Send()
}

// DescribeCertificateAuthorityAuditReportWithContext is the same as DescribeCertificateAuthorityAuditReport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificateAuthorityAuditReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DescribeCertificateAuthorityAuditReportWithContext(ctx aws.Context, input *DescribeCertificateAuthorityAuditReportInput, opts ...request.Option) (*DescribeCertificateAuthorityAuditReportOutput, error) {
	req, out := c.DescribeCertificateAuthorityAuditReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificate = "GetCertificate"

// GetCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificate for more information on using the GetCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateRequest method.
//    req, resp := client.GetCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate
func (c *ACMPCA) GetCertificateRequest(input *GetCertificateInput) (req *request.Request, output *GetCertificateOutput) {
	op := &request.Operation{
		Name:       opGetCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateInput{}
	}

	output = &GetCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves a certificate from your private CA. The ARN of the certificate
// is returned when you call the IssueCertificate action. You must specify both
// the ARN of your private CA and the ARN of the issued certificate when calling
// the GetCertificate action. You can retrieve the certificate if it is in the
// ISSUED state. You can call the CreateCertificateAuthorityAuditReport action
// to create a report that contains information about all of the certificates
// issued and revoked by your private CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetCertificate for usage and error information.
//
// Returned Error Types:
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate
func (c *ACMPCA) GetCertificate(input *GetCertificateInput) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	return out, req.Send()
}

// GetCertificateWithContext is the same as GetCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetCertificateWithContext(ctx aws.Context, input *GetCertificateInput, opts ...request.Option) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificateAuthorityCertificate = "GetCertificateAuthorityCertificate"

// GetCertificateAuthorityCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificateAuthorityCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificateAuthorityCertificate for more information on using the GetCertificateAuthorityCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateAuthorityCertificateRequest method.
//    req, resp := client.GetCertificateAuthorityCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate
func (c *ACMPCA) GetCertificateAuthorityCertificateRequest(input *GetCertificateAuthorityCertificateInput) (req *request.Request, output *GetCertificateAuthorityCertificateOutput) {
	op := &request.Operation{
		Name:       opGetCertificateAuthorityCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateAuthorityCertificateInput{}
	}

	output = &GetCertificateAuthorityCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificateAuthorityCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the certificate and certificate chain for your private certificate
// authority (CA). Both the certificate and the chain are base64 PEM-encoded.
// The chain does not include the CA certificate. Each certificate in the chain
// signs the one before it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetCertificateAuthorityCertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate
func (c *ACMPCA) GetCertificateAuthorityCertificate(input *GetCertificateAuthorityCertificateInput) (*GetCertificateAuthorityCertificateOutput, error) {
	req, out := c.GetCertificateAuthorityCertificateRequest(input)
	return out, req.Send()
}

// GetCertificateAuthorityCertificateWithContext is the same as GetCertificateAuthorityCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificateAuthorityCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetCertificateAuthorityCertificateWithContext(ctx aws.Context, input *GetCertificateAuthorityCertificateInput, opts ...request.Option) (*GetCertificateAuthorityCertificateOutput, error) {
	req, out := c.GetCertificateAuthorityCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificateAuthorityCsr = "GetCertificateAuthorityCsr"

// GetCertificateAuthorityCsrRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificateAuthorityCsr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificateAuthorityCsr for more information on using the GetCertificateAuthorityCsr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateAuthorityCsrRequest method.
//    req, resp := client.GetCertificateAuthorityCsrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr
func (c *ACMPCA) GetCertificateAuthorityCsrRequest(input *GetCertificateAuthorityCsrInput) (req *request.Request, output *GetCertificateAuthorityCsrOutput) {
	op := &request.Operation{
		Name:       opGetCertificateAuthorityCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateAuthorityCsrInput{}
	}

	output = &GetCertificateAuthorityCsrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificateAuthorityCsr API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the certificate signing request (CSR) for your private certificate
// authority (CA). The CSR is created when you call the CreateCertificateAuthority
// action. Sign the CSR with your ACM Private CA-hosted or on-premises root
// or subordinate CA. Then import the signed certificate back into ACM Private
// CA by calling the ImportCertificateAuthorityCertificate action. The CSR is
// returned as a base64 PEM-encoded string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetCertificateAuthorityCsr for usage and error information.
//
// Returned Error Types:
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr
func (c *ACMPCA) GetCertificateAuthorityCsr(input *GetCertificateAuthorityCsrInput) (*GetCertificateAuthorityCsrOutput, error) {
	req, out := c.GetCertificateAuthorityCsrRequest(input)
	return out, req.Send()
}

// GetCertificateAuthorityCsrWithContext is the same as GetCertificateAuthorityCsr with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificateAuthorityCsr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetCertificateAuthorityCsrWithContext(ctx aws.Context, input *GetCertificateAuthorityCsrInput, opts ...request.Option) (*GetCertificateAuthorityCsrOutput, error) {
	req, out := c.GetCertificateAuthorityCsrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportCertificateAuthorityCertificate = "ImportCertificateAuthorityCertificate"

// ImportCertificateAuthorityCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificateAuthorityCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCertificateAuthorityCertificate for more information on using the ImportCertificateAuthorityCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCertificateAuthorityCertificateRequest method.
//    req, resp := client.ImportCertificateAuthorityCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ImportCertificateAuthorityCertificate
func (c *ACMPCA) ImportCertificateAuthorityCertificateRequest(input *ImportCertificateAuthorityCertificateInput) (req *request.Request, output *ImportCertificateAuthorityCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificateAuthorityCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateAuthorityCertificateInput{}
	}

	output = &ImportCertificateAuthorityCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ImportCertificateAuthorityCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Imports a signed private CA certificate into ACM Private CA. This action
// is used when you are using a chain of trust whose root is located outside
// ACM Private CA. Before you can call this action, the following preparations
// must in place:
//
// In ACM Private CA, call the CreateCertificateAuthority action to create the
// private CA that that you plan to back with the imported certificate.
//
// Call the GetCertificateAuthorityCsr action to generate a certificate signing
// request (CSR).
//
// Sign the CSR using a root or intermediate CA hosted either by an on-premises
// PKI hierarchy or a commercial CA..
//
// Create a certificate chain and copy the signed certificate and the certificate
// chain to your working directory.
//
// The following requirements apply when you import a CA certificate.
//
//    * You cannot import a non-self-signed certificate for use as a root CA.
//
//    * You cannot import a self-signed certificate for use as a subordinate
//    CA.
//
//    * Your certificate chain must not include the private CA certificate that
//    you are importing.
//
//    * Your ACM Private CA-hosted or on-premises CA certificate must be the
//    last certificate in your chain. The subordinate certificate, if any, that
//    your root CA signed must be next to last. The subordinate certificate
//    signed by the preceding subordinate CA must come next, and so on until
//    your chain is built.
//
//    * The chain must be PEM-encoded.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ImportCertificateAuthorityCertificate for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidRequestException
//   The request action cannot be performed or is prohibited.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * MalformedCertificateException
//   One or more fields in the certificate are invalid.
//
//   * CertificateMismatchException
//   The certificate authority certificate you are importing does not comply with
//   conditions specified in the certificate that signed it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ImportCertificateAuthorityCertificate
func (c *ACMPCA) ImportCertificateAuthorityCertificate(input *ImportCertificateAuthorityCertificateInput) (*ImportCertificateAuthorityCertificateOutput, error) {
	req, out := c.ImportCertificateAuthorityCertificateRequest(input)
	return out, req.Send()
}

// ImportCertificateAuthorityCertificateWithContext is the same as ImportCertificateAuthorityCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCertificateAuthorityCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ImportCertificateAuthorityCertificateWithContext(ctx aws.Context, input *ImportCertificateAuthorityCertificateInput, opts ...request.Option) (*ImportCertificateAuthorityCertificateOutput, error) {
	req, out := c.ImportCertificateAuthorityCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIssueCertificate = "IssueCertificate"

// IssueCertificateRequest generates a "aws/request.Request" representing the
// client's request for the IssueCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IssueCertificate for more information on using the IssueCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IssueCertificateRequest method.
//    req, resp := client.IssueCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate
func (c *ACMPCA) IssueCertificateRequest(input *IssueCertificateInput) (req *request.Request, output *IssueCertificateOutput) {
	op := &request.Operation{
		Name:       opIssueCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IssueCertificateInput{}
	}

	output = &IssueCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IssueCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Uses your private certificate authority (CA) to issue a client certificate.
// This action returns the Amazon Resource Name (ARN) of the certificate. You
// can retrieve the certificate by calling the GetCertificate action and specifying
// the ARN.
//
// You cannot use the ACM ListCertificateAuthorities action to retrieve the
// ARNs of the certificates that you issue by using ACM Private CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation IssueCertificate for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   An ACM Private CA limit has been exceeded. See the exception message returned
//   to determine the limit that was exceeded.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * MalformedCSRException
//   The certificate signing request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate
func (c *ACMPCA) IssueCertificate(input *IssueCertificateInput) (*IssueCertificateOutput, error) {
	req, out := c.IssueCertificateRequest(input)
	return out, req.Send()
}

// IssueCertificateWithContext is the same as IssueCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See IssueCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) IssueCertificateWithContext(ctx aws.Context, input *IssueCertificateInput, opts ...request.Option) (*IssueCertificateOutput, error) {
	req, out := c.IssueCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificateAuthorities = "ListCertificateAuthorities"

// ListCertificateAuthoritiesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificateAuthorities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificateAuthorities for more information on using the ListCertificateAuthorities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificateAuthoritiesRequest method.
//    req, resp := client.ListCertificateAuthoritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities
func (c *ACMPCA) ListCertificateAuthoritiesRequest(input *ListCertificateAuthoritiesInput) (req *request.Request, output *ListCertificateAuthoritiesOutput) {
	op := &request.Operation{
		Name:       opListCertificateAuthorities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCertificateAuthoritiesInput{}
	}

	output = &ListCertificateAuthoritiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificateAuthorities API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists the private certificate authorities that you created by using the CreateCertificateAuthority
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ListCertificateAuthorities for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token specified in the NextToken argument is not valid. Use the token
//   returned from your previous call to ListCertificateAuthorities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities
func (c *ACMPCA) ListCertificateAuthorities(input *ListCertificateAuthoritiesInput) (*ListCertificateAuthoritiesOutput, error) {
	req, out := c.ListCertificateAuthoritiesRequest(input)
	return out, req.Send()
}

// ListCertificateAuthoritiesWithContext is the same as ListCertificateAuthorities with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificateAuthorities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListCertificateAuthoritiesWithContext(ctx aws.Context, input *ListCertificateAuthoritiesInput, opts ...request.Option) (*ListCertificateAuthoritiesOutput, error) {
	req, out := c.ListCertificateAuthoritiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCertificateAuthoritiesPages iterates over the pages of a ListCertificateAuthorities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCertificateAuthorities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCertificateAuthorities operation.
//    pageNum := 0
//    err := client.ListCertificateAuthoritiesPages(params,
//        func(page *acmpca.ListCertificateAuthoritiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACMPCA) ListCertificateAuthoritiesPages(input *ListCertificateAuthoritiesInput, fn func(*ListCertificateAuthoritiesOutput, bool) bool) error {
	return c.ListCertificateAuthoritiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCertificateAuthoritiesPagesWithContext same as ListCertificateAuthoritiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListCertificateAuthoritiesPagesWithContext(ctx aws.Context, input *ListCertificateAuthoritiesInput, fn func(*ListCertificateAuthoritiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCertificateAuthoritiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCertificateAuthoritiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCertificateAuthoritiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionsRequest method.
//    req, resp := client.ListPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions
func (c *ACMPCA) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists all the permissions, if any, that have been assigned by a private CA.
// Permissions can be granted with the CreatePermission action and revoked with
// the DeletePermission action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidNextTokenException
//   The token specified in the NextToken argument is not valid. Use the token
//   returned from your previous call to ListCertificateAuthorities.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions
func (c *ACMPCA) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionsPages iterates over the pages of a ListPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPermissions operation.
//    pageNum := 0
//    err := client.ListPermissionsPages(params,
//        func(page *acmpca.ListPermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACMPCA) ListPermissionsPages(input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool) error {
	return c.ListPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionsPagesWithContext same as ListPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListPermissionsPagesWithContext(ctx aws.Context, input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags
func (c *ACMPCA) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists the tags, if any, that are associated with your private CA. Tags are
// labels that you can use to identify and organize your CAs. Each tag consists
// of a key and an optional value. Call the TagCertificateAuthority action to
// add one or more tags to your CA. Call the UntagCertificateAuthority action
// to remove tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags
func (c *ACMPCA) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *acmpca.ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACMPCA) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRestoreCertificateAuthority = "RestoreCertificateAuthority"

// RestoreCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the RestoreCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreCertificateAuthority for more information on using the RestoreCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreCertificateAuthorityRequest method.
//    req, resp := client.RestoreCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RestoreCertificateAuthority
func (c *ACMPCA) RestoreCertificateAuthorityRequest(input *RestoreCertificateAuthorityInput) (req *request.Request, output *RestoreCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opRestoreCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreCertificateAuthorityInput{}
	}

	output = &RestoreCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Restores a certificate authority (CA) that is in the DELETED state. You can
// restore a CA during the period that you defined in the PermanentDeletionTimeInDays
// parameter of the DeleteCertificateAuthority action. Currently, you can specify
// 7 to 30 days. If you did not specify a PermanentDeletionTimeInDays value,
// by default you can restore the CA at any time in a 30 day period. You can
// check the time remaining in the restoration period of a private CA in the
// DELETED state by calling the DescribeCertificateAuthority or ListCertificateAuthorities
// actions. The status of a restored CA is set to its pre-deletion status when
// the RestoreCertificateAuthority action returns. To change its status to ACTIVE,
// call the UpdateCertificateAuthority action. If the private CA was in the
// PENDING_CERTIFICATE state at deletion, you must use the ImportCertificateAuthorityCertificate
// action to import a certificate authority into the private CA before it can
// be activated. You cannot restore a CA after the restoration period has ended.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation RestoreCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RestoreCertificateAuthority
func (c *ACMPCA) RestoreCertificateAuthority(input *RestoreCertificateAuthorityInput) (*RestoreCertificateAuthorityOutput, error) {
	req, out := c.RestoreCertificateAuthorityRequest(input)
	return out, req.Send()
}

// RestoreCertificateAuthorityWithContext is the same as RestoreCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) RestoreCertificateAuthorityWithContext(ctx aws.Context, input *RestoreCertificateAuthorityInput, opts ...request.Option) (*RestoreCertificateAuthorityOutput, error) {
	req, out := c.RestoreCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeCertificate = "RevokeCertificate"

// RevokeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RevokeCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeCertificate for more information on using the RevokeCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeCertificateRequest method.
//    req, resp := client.RevokeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate
func (c *ACMPCA) RevokeCertificateRequest(input *RevokeCertificateInput) (req *request.Request, output *RevokeCertificateOutput) {
	op := &request.Operation{
		Name:       opRevokeCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeCertificateInput{}
	}

	output = &RevokeCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Revokes a certificate that was issued inside ACM Private CA. If you enable
// a certificate revocation list (CRL) when you create or update your private
// CA, information about the revoked certificates will be included in the CRL.
// ACM Private CA writes the CRL to an S3 bucket that you specify. For more
// information about revocation, see the CrlConfiguration structure. ACM Private
// CA also writes revocation information to the audit report. For more information,
// see CreateCertificateAuthorityAuditReport.
//
// You cannot revoke a root CA self-signed certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation RevokeCertificate for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidRequestException
//   The request action cannot be performed or is prohibited.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * LimitExceededException
//   An ACM Private CA limit has been exceeded. See the exception message returned
//   to determine the limit that was exceeded.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * RequestAlreadyProcessedException
//   Your request has already been completed.
//
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate
func (c *ACMPCA) RevokeCertificate(input *RevokeCertificateInput) (*RevokeCertificateOutput, error) {
	req, out := c.RevokeCertificateRequest(input)
	return out, req.Send()
}

// RevokeCertificateWithContext is the same as RevokeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) RevokeCertificateWithContext(ctx aws.Context, input *RevokeCertificateInput, opts ...request.Option) (*RevokeCertificateOutput, error) {
	req, out := c.RevokeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagCertificateAuthority = "TagCertificateAuthority"

// TagCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the TagCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagCertificateAuthority for more information on using the TagCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagCertificateAuthorityRequest method.
//    req, resp := client.TagCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/TagCertificateAuthority
func (c *ACMPCA) TagCertificateAuthorityRequest(input *TagCertificateAuthorityInput) (req *request.Request, output *TagCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opTagCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagCertificateAuthorityInput{}
	}

	output = &TagCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Adds one or more tags to your private CA. Tags are labels that you can use
// to identify and organize your AWS resources. Each tag consists of a key and
// an optional value. You specify the private CA on input by its Amazon Resource
// Name (ARN). You specify the tag by using a key-value pair. You can apply
// a tag to just one private CA if you want to identify a specific characteristic
// of that CA, or you can apply the same tag to multiple private CAs if you
// want to filter for a common relationship among those CAs. To remove one or
// more tags, use the UntagCertificateAuthority action. Call the ListTags action
// to see what tags are associated with your CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation TagCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * InvalidTagException
//   The tag associated with the CA is not valid. The invalid argument is contained
//   in the message field.
//
//   * TooManyTagsException
//   You can associate up to 50 tags with a private CA. Exception information
//   is contained in the exception message field.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/TagCertificateAuthority
func (c *ACMPCA) TagCertificateAuthority(input *TagCertificateAuthorityInput) (*TagCertificateAuthorityOutput, error) {
	req, out := c.TagCertificateAuthorityRequest(input)
	return out, req.Send()
}

// TagCertificateAuthorityWithContext is the same as TagCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See TagCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) TagCertificateAuthorityWithContext(ctx aws.Context, input *TagCertificateAuthorityInput, opts ...request.Option) (*TagCertificateAuthorityOutput, error) {
	req, out := c.TagCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagCertificateAuthority = "UntagCertificateAuthority"

// UntagCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the UntagCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagCertificateAuthority for more information on using the UntagCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagCertificateAuthorityRequest method.
//    req, resp := client.UntagCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UntagCertificateAuthority
func (c *ACMPCA) UntagCertificateAuthorityRequest(input *UntagCertificateAuthorityInput) (req *request.Request, output *UntagCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opUntagCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagCertificateAuthorityInput{}
	}

	output = &UntagCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Remove one or more tags from your private CA. A tag consists of a key-value
// pair. If you do not specify the value portion of the tag when calling this
// action, the tag will be removed regardless of value. If you specify a value,
// the tag is removed only if it is associated with the specified value. To
// add tags to a private CA, use the TagCertificateAuthority. Call the ListTags
// action to see what tags are associated with your CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation UntagCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * InvalidTagException
//   The tag associated with the CA is not valid. The invalid argument is contained
//   in the message field.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UntagCertificateAuthority
func (c *ACMPCA) UntagCertificateAuthority(input *UntagCertificateAuthorityInput) (*UntagCertificateAuthorityOutput, error) {
	req, out := c.UntagCertificateAuthorityRequest(input)
	return out, req.Send()
}

// UntagCertificateAuthorityWithContext is the same as UntagCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See UntagCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) UntagCertificateAuthorityWithContext(ctx aws.Context, input *UntagCertificateAuthorityInput, opts ...request.Option) (*UntagCertificateAuthorityOutput, error) {
	req, out := c.UntagCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCertificateAuthority = "UpdateCertificateAuthority"

// UpdateCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCertificateAuthority for more information on using the UpdateCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCertificateAuthorityRequest method.
//    req, resp := client.UpdateCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UpdateCertificateAuthority
func (c *ACMPCA) UpdateCertificateAuthorityRequest(input *UpdateCertificateAuthorityInput) (req *request.Request, output *UpdateCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opUpdateCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCertificateAuthorityInput{}
	}

	output = &UpdateCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Updates the status or configuration of a private certificate authority (CA).
// Your private CA must be in the ACTIVE or DISABLED state before you can update
// it. You can disable a private CA that is in the ACTIVE state or make a CA
// that is in the DISABLED state active again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation UpdateCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, or audit report
//   cannot be found.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The private CA is in a state during which a report or certificate cannot
//   be generated.
//
//   * InvalidPolicyException
//   The S3 bucket policy is not valid. The policy must give ACM Private CA rights
//   to read from and write to the bucket and find the bucket location.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UpdateCertificateAuthority
func (c *ACMPCA) UpdateCertificateAuthority(input *UpdateCertificateAuthorityInput) (*UpdateCertificateAuthorityOutput, error) {
	req, out := c.UpdateCertificateAuthorityRequest(input)
	return out, req.Send()
}

// UpdateCertificateAuthorityWithContext is the same as UpdateCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) UpdateCertificateAuthorityWithContext(ctx aws.Context, input *UpdateCertificateAuthorityInput, opts ...request.Option) (*UpdateCertificateAuthorityOutput, error) {
	req, out := c.UpdateCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains information about the certificate subject. The certificate can be
// one issued by your private certificate authority (CA) or it can be your private
// CA certificate. The Subject field in the certificate identifies the entity
// that owns or controls the public key in the certificate. The entity can be
// a user, computer, device, or service. The Subject must contain an X.500 distinguished
// name (DN). A DN is a sequence of relative distinguished names (RDNs). The
// RDNs are separated by commas in the certificate. The DN must be unique for
// each entity, but your private CA can issue more than one certificate with
// the same DN to the same entity.
type ASN1Subject struct {
	_ struct{} `type:"structure"`

	// Fully qualified domain name (FQDN) associated with the certificate subject.
	CommonName *string `type:"string"`

	// Two-digit code that specifies the country in which the certificate subject
	// located.
	Country *string `type:"string"`

	// Disambiguating information for the certificate subject.
	DistinguishedNameQualifier *string `type:"string"`

	// Typically a qualifier appended to the name of an individual. Examples include
	// Jr. for junior, Sr. for senior, and III for third.
	GenerationQualifier *string `type:"string"`

	// First name.
	GivenName *string `type:"string"`

	// Concatenation that typically contains the first letter of the GivenName,
	// the first letter of the middle name if one exists, and the first letter of
	// the SurName.
	Initials *string `type:"string"`

	// The locality (such as a city or town) in which the certificate subject is
	// located.
	Locality *string `type:"string"`

	// Legal name of the organization with which the certificate subject is affiliated.
	Organization *string `type:"string"`

	// A subdivision or unit of the organization (such as sales or finance) with
	// which the certificate subject is affiliated.
	OrganizationalUnit *string `type:"string"`

	// Typically a shortened version of a longer GivenName. For example, Jonathan
	// is often shortened to John. Elizabeth is often shortened to Beth, Liz, or
	// Eliza.
	Pseudonym *string `type:"string"`

	// The certificate serial number.
	SerialNumber *string `type:"string"`

	// State in which the subject of the certificate is located.
	State *string `type:"string"`

	// Family name. In the US and the UK, for example, the surname of an individual
	// is ordered last. In Asian cultures the surname is typically ordered first.
	Surname *string `type:"string"`

	// A title such as Mr. or Ms., which is pre-pended to the name to refer formally
	// to the certificate subject.
	Title *string `type:"string"`
}

// String returns the string representation
func (s ASN1Subject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ASN1Subject) GoString() string {
	return s.String()
}

// SetCommonName sets the CommonName field's value.
func (s *ASN1Subject) SetCommonName(v string) *ASN1Subject {
	s.CommonName = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *ASN1Subject) SetCountry(v string) *ASN1Subject {
	s.Country = &v
	return s
}

// SetDistinguishedNameQualifier sets the DistinguishedNameQualifier field's value.
func (s *ASN1Subject) SetDistinguishedNameQualifier(v string) *ASN1Subject {
	s.DistinguishedNameQualifier = &v
	return s
}

// SetGenerationQualifier sets the GenerationQualifier field's value.
func (s *ASN1Subject) SetGenerationQualifier(v string) *ASN1Subject {
	s.GenerationQualifier = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *ASN1Subject) SetGivenName(v string) *ASN1Subject {
	s.GivenName = &v
	return s
}

// SetInitials sets the Initials field's value.
func (s *ASN1Subject) SetInitials(v string) *ASN1Subject {
	s.Initials = &v
	return s
}

// SetLocality sets the Locality field's value.
func (s *ASN1Subject) SetLocality(v string) *ASN1Subject {
	s.Locality = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *ASN1Subject) SetOrganization(v string) *ASN1Subject {
	s.Organization = &v
	return s
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *ASN1Subject) SetOrganizationalUnit(v string) *ASN1Subject {
	s.OrganizationalUnit = &v
	return s
}

// SetPseudonym sets the Pseudonym field's value.
func (s *ASN1Subject) SetPseudonym(v string) *ASN1Subject {
	s.Pseudonym = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *ASN1Subject) SetSerialNumber(v string) *ASN1Subject {
	s.SerialNumber = &v
	return s
}

// SetState sets the State field's value.
func (s *ASN1Subject) SetState(v string) *ASN1Subject {
	s.State = &v
	return s
}

// SetSurname sets the Surname field's value.
func (s *ASN1Subject) SetSurname(v string) *ASN1Subject {
	s.Surname = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ASN1Subject) SetTitle(v string) *ASN1Subject {
	s.Title = &v
	return s
}

// Contains information about your private certificate authority (CA). Your
// private CA can issue and revoke X.509 digital certificates. Digital certificates
// verify that the entity named in the certificate Subject field owns or controls
// the public key contained in the Subject Public Key Info field. Call the CreateCertificateAuthority
// action to create your private CA. You must then call the GetCertificateAuthorityCertificate
// action to retrieve a private CA certificate signing request (CSR). Sign the
// CSR with your ACM Private CA-hosted or on-premises root or subordinate CA
// certificate. Call the ImportCertificateAuthorityCertificate action to import
// the signed certificate into AWS Certificate Manager (ACM).
type CertificateAuthority struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) for your private certificate authority (CA). The
	// format is 12345678-1234-1234-1234-123456789012 .
	Arn *string `min:"5" type:"string"`

	// Your private CA configuration.
	CertificateAuthorityConfiguration *CertificateAuthorityConfiguration `type:"structure"`

	// Date and time at which your private CA was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Reason the request to create your private CA failed.
	FailureReason *string `type:"string" enum:"FailureReason"`

	// Date and time at which your private CA was last updated.
	LastStateChangeAt *time.Time `type:"timestamp"`

	// Date and time after which your private CA certificate is not valid.
	NotAfter *time.Time `type:"timestamp"`

	// Date and time before which your private CA certificate is not valid.
	NotBefore *time.Time `type:"timestamp"`

	// The period during which a deleted CA can be restored. For more information,
	// see the PermanentDeletionTimeInDays parameter of the DeleteCertificateAuthorityRequest
	// action.
	RestorableUntil *time.Time `type:"timestamp"`

	// Information about the certificate revocation list (CRL) created and maintained
	// by your private CA.
	RevocationConfiguration *RevocationConfiguration `type:"structure"`

	// Serial number of your private CA.
	Serial *string `type:"string"`

	// Status of your private CA.
	Status *string `type:"string" enum:"CertificateAuthorityStatus"`

	// Type of your private CA.
	Type *string `type:"string" enum:"CertificateAuthorityType"`
}

// String returns the string representation
func (s CertificateAuthority) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateAuthority) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CertificateAuthority) SetArn(v string) *CertificateAuthority {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityConfiguration sets the CertificateAuthorityConfiguration field's value.
func (s *CertificateAuthority) SetCertificateAuthorityConfiguration(v *CertificateAuthorityConfiguration) *CertificateAuthority {
	s.CertificateAuthorityConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CertificateAuthority) SetCreatedAt(v time.Time) *CertificateAuthority {
	s.CreatedAt = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CertificateAuthority) SetFailureReason(v string) *CertificateAuthority {
	s.FailureReason = &v
	return s
}

// SetLastStateChangeAt sets the LastStateChangeAt field's value.
func (s *CertificateAuthority) SetLastStateChangeAt(v time.Time) *CertificateAuthority {
	s.LastStateChangeAt = &v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *CertificateAuthority) SetNotAfter(v time.Time) *CertificateAuthority {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *CertificateAuthority) SetNotBefore(v time.Time) *CertificateAuthority {
	s.NotBefore = &v
	return s
}

// SetRestorableUntil sets the RestorableUntil field's value.
func (s *CertificateAuthority) SetRestorableUntil(v time.Time) *CertificateAuthority {
	s.RestorableUntil = &v
	return s
}

// SetRevocationConfiguration sets the RevocationConfiguration field's value.
func (s *CertificateAuthority) SetRevocationConfiguration(v *RevocationConfiguration) *CertificateAuthority {
	s.RevocationConfiguration = v
	return s
}

// SetSerial sets the Serial field's value.
func (s *CertificateAuthority) SetSerial(v string) *CertificateAuthority {
	s.Serial = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateAuthority) SetStatus(v string) *CertificateAuthority {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CertificateAuthority) SetType(v string) *CertificateAuthority {
	s.Type = &v
	return s
}

// Contains configuration information for your private certificate authority
// (CA). This includes information about the class of public key algorithm and
// the key pair that your private CA creates when it issues a certificate. It
// also includes the signature algorithm that it uses when issuing certificates,
// and its X.500 distinguished name. You must specify this information when
// you call the CreateCertificateAuthority action.
type CertificateAuthorityConfiguration struct {
	_ struct{} `type:"structure"`

	// Type of the public key algorithm and size, in bits, of the key pair that
	// your CA creates when it issues a certificate. When you create a subordinate
	// CA, you must use a key algorithm supported by the parent CA.
	//
	// KeyAlgorithm is a required field
	KeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`

	// Name of the algorithm your private CA uses to sign certificate requests.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm *string `type:"string" required:"true" enum:"SigningAlgorithm"`

	// Structure that contains X.500 distinguished name information for your private
	// CA.
	//
	// Subject is a required field
	Subject *ASN1Subject `type:"structure" required:"true"`
}

// String returns the string representation
func (s CertificateAuthorityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateAuthorityConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CertificateAuthorityConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CertificateAuthorityConfiguration"}
	if s.KeyAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAlgorithm"))
	}
	if s.SigningAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAlgorithm"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *CertificateAuthorityConfiguration) SetKeyAlgorithm(v string) *CertificateAuthorityConfiguration {
	s.KeyAlgorithm = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *CertificateAuthorityConfiguration) SetSigningAlgorithm(v string) *CertificateAuthorityConfiguration {
	s.SigningAlgorithm = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *CertificateAuthorityConfiguration) SetSubject(v *ASN1Subject) *CertificateAuthorityConfiguration {
	s.Subject = v
	return s
}

// The certificate authority certificate you are importing does not comply with
// conditions specified in the certificate that signed it.
type CertificateMismatchException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CertificateMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateMismatchException) GoString() string {
	return s.String()
}

func newErrorCertificateMismatchException(v protocol.ResponseMetadata) error {
	return &CertificateMismatchException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s CertificateMismatchException) Code() string {
	return "CertificateMismatchException"
}

// Message returns the exception's message.
func (s CertificateMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s CertificateMismatchException) OrigErr() error {
	return nil
}

func (s CertificateMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s CertificateMismatchException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s CertificateMismatchException) RequestID() string {
	return s.respMetadata.RequestID
}

// A previous update to your private CA is still ongoing.
type ConcurrentModificationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConcurrentModificationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConcurrentModificationException) RequestID() string {
	return s.respMetadata.RequestID
}

type CreateCertificateAuthorityAuditReportInput struct {
	_ struct{} `type:"structure"`

	// The format in which to create the report. This can be either JSON or CSV.
	//
	// AuditReportResponseFormat is a required field
	AuditReportResponseFormat *string `type:"string" required:"true" enum:"AuditReportResponseFormat"`

	// The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The name of the S3 bucket that will contain the audit report.
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCertificateAuthorityAuditReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateAuthorityAuditReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateAuthorityAuditReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateAuthorityAuditReportInput"}
	if s.AuditReportResponseFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("AuditReportResponseFormat"))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditReportResponseFormat sets the AuditReportResponseFormat field's value.
func (s *CreateCertificateAuthorityAuditReportInput) SetAuditReportResponseFormat(v string) *CreateCertificateAuthorityAuditReportInput {
	s.AuditReportResponseFormat = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateCertificateAuthorityAuditReportInput) SetCertificateAuthorityArn(v string) *CreateCertificateAuthorityAuditReportInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateCertificateAuthorityAuditReportInput) SetS3BucketName(v string) *CreateCertificateAuthorityAuditReportInput {
	s.S3BucketName = &v
	return s
}

type CreateCertificateAuthorityAuditReportOutput struct {
	_ struct{} `type:"structure"`

	// An alphanumeric string that contains a report identifier.
	AuditReportId *string `min:"36" type:"string"`

	// The key that uniquely identifies the report file in your S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s CreateCertificateAuthorityAuditReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateAuthorityAuditReportOutput) GoString() string {
	return s.String()
}

// SetAuditReportId sets the AuditReportId field's value.
func (s *CreateCertificateAuthorityAuditReportOutput) SetAuditReportId(v string) *CreateCertificateAuthorityAuditReportOutput {
	s.AuditReportId = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *CreateCertificateAuthorityAuditReportOutput) SetS3Key(v string) *CreateCertificateAuthorityAuditReportOutput {
	s.S3Key = &v
	return s
}

type CreateCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// Name and bit size of the private key algorithm, the name of the signing algorithm,
	// and X.500 certificate subject information.
	//
	// CertificateAuthorityConfiguration is a required field
	CertificateAuthorityConfiguration *CertificateAuthorityConfiguration `type:"structure" required:"true"`

	// The type of the certificate authority.
	//
	// CertificateAuthorityType is a required field
	CertificateAuthorityType *string `type:"string" required:"true" enum:"CertificateAuthorityType"`

	// Alphanumeric string that can be used to distinguish between calls to CreateCertificateAuthority.
	// Idempotency tokens time out after five minutes. Therefore, if you call CreateCertificateAuthority
	// multiple times with the same idempotency token within a five minute period,
	// ACM Private CA recognizes that you are requesting only one certificate. As
	// a result, ACM Private CA issues only one. If you change the idempotency token
	// for each call, however, ACM Private CA recognizes that you are requesting
	// multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// Contains a Boolean value that you can use to enable a certification revocation
	// list (CRL) for the CA, the name of the S3 bucket to which ACM Private CA
	// will write the CRL, and an optional CNAME alias that you can use to hide
	// the name of your bucket in the CRL Distribution Points extension of your
	// CA certificate. For more information, see the CrlConfiguration structure.
	RevocationConfiguration *RevocationConfiguration `type:"structure"`

	// Key-value pairs that will be attached to the new private CA. You can associate
	// up to 50 tags with a private CA. For information using tags with
	//
	// IAM to manage permissions, see Controlling Access Using IAM Tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateAuthorityInput"}
	if s.CertificateAuthorityConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityConfiguration"))
	}
	if s.CertificateAuthorityType == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityType"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.CertificateAuthorityConfiguration != nil {
		if err := s.CertificateAuthorityConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CertificateAuthorityConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RevocationConfiguration != nil {
		if err := s.RevocationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RevocationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityConfiguration sets the CertificateAuthorityConfiguration field's value.
func (s *CreateCertificateAuthorityInput) SetCertificateAuthorityConfiguration(v *CertificateAuthorityConfiguration) *CreateCertificateAuthorityInput {
	s.CertificateAuthorityConfiguration = v
	return s
}

// SetCertificateAuthorityType sets the CertificateAuthorityType field's value.
func (s *CreateCertificateAuthorityInput) SetCertificateAuthorityType(v string) *CreateCertificateAuthorityInput {
	s.CertificateAuthorityType = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateCertificateAuthorityInput) SetIdempotencyToken(v string) *CreateCertificateAuthorityInput {
	s.IdempotencyToken = &v
	return s
}

// SetRevocationConfiguration sets the RevocationConfiguration field's value.
func (s *CreateCertificateAuthorityInput) SetRevocationConfiguration(v *RevocationConfiguration) *CreateCertificateAuthorityInput {
	s.RevocationConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCertificateAuthorityInput) SetTags(v []*Tag) *CreateCertificateAuthorityInput {
	s.Tags = v
	return s
}

type CreateCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// If successful, the Amazon Resource Name (ARN) of the certificate authority
	// (CA). This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	CertificateAuthorityArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s CreateCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateCertificateAuthorityOutput) SetCertificateAuthorityArn(v string) *CreateCertificateAuthorityOutput {
	s.CertificateAuthorityArn = &v
	return s
}

type CreatePermissionInput struct {
	_ struct{} `type:"structure"`

	// The actions that the specified AWS service principal can use. These include
	// IssueCertificate, GetCertificate, and ListPermissions.
	//
	// Actions is a required field
	Actions []*string `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the CA that grants the permissions. You
	// can find the ARN by calling the ListCertificateAuthorities action. This must
	// have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The AWS service or identity that receives the permission. At this time, the
	// only valid principal is acm.amazonaws.com.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// The ID of the calling account.
	SourceAccount *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CreatePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePermissionInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.SourceAccount != nil && len(*s.SourceAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SourceAccount", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreatePermissionInput) SetActions(v []*string) *CreatePermissionInput {
	s.Actions = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreatePermissionInput) SetCertificateAuthorityArn(v string) *CreatePermissionInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *CreatePermissionInput) SetPrincipal(v string) *CreatePermissionInput {
	s.Principal = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *CreatePermissionInput) SetSourceAccount(v string) *CreatePermissionInput {
	s.SourceAccount = &v
	return s
}

type CreatePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePermissionOutput) GoString() string {
	return s.String()
}

// Contains configuration information for a certificate revocation list (CRL).
// Your private certificate authority (CA) creates base CRLs. Delta CRLs are
// not supported. You can enable CRLs for your new or an existing private CA
// by setting the Enabled parameter to true. Your private CA writes CRLs to
// an S3 bucket that you specify in the S3BucketName parameter. You can hide
// the name of your bucket by specifying a value for the CustomCname parameter.
// Your private CA copies the CNAME or the S3 bucket name to the CRL Distribution
// Points extension of each certificate it issues. Your S3 bucket policy must
// give write permission to ACM Private CA.
//
// Your private CA uses the value in the ExpirationInDays parameter to calculate
// the nextUpdate field in the CRL. The CRL is refreshed at 1/2 the age of next
// update or when a certificate is revoked. When a certificate is revoked, it
// is recorded in the next CRL that is generated and in the next audit report.
// Only time valid certificates are listed in the CRL. Expired certificates
// are not included.
//
// CRLs contain the following fields:
//
//    * Version: The current version number defined in RFC 5280 is V2. The integer
//    value is 0x1.
//
//    * Signature Algorithm: The name of the algorithm used to sign the CRL.
//
//    * Issuer: The X.500 distinguished name of your private CA that issued
//    the CRL.
//
//    * Last Update: The issue date and time of this CRL.
//
//    * Next Update: The day and time by which the next CRL will be issued.
//
//    * Revoked Certificates: List of revoked certificates. Each list item contains
//    the following information. Serial Number: The serial number, in hexadecimal
//    format, of the revoked certificate. Revocation Date: Date and time the
//    certificate was revoked. CRL Entry Extensions: Optional extensions for
//    the CRL entry. X509v3 CRL Reason Code: Reason the certificate was revoked.
//
//    * CRL Extensions: Optional extensions for the CRL. X509v3 Authority Key
//    Identifier: Identifies the public key associated with the private key
//    used to sign the certificate. X509v3 CRL Number:: Decimal sequence number
//    for the CRL.
//
//    * Signature Algorithm: Algorithm used by your private CA to sign the CRL.
//
//    * Signature Value: Signature computed over the CRL.
//
// Certificate revocation lists created by ACM Private CA are DER-encoded. You
// can use the following OpenSSL command to list a CRL.
//
// openssl crl -inform DER -text -in crl_path -noout
type CrlConfiguration struct {
	_ struct{} `type:"structure"`

	// Name inserted into the certificate CRL Distribution Points extension that
	// enables the use of an alias for the CRL distribution point. Use this value
	// if you don't want the name of your S3 bucket to be public.
	CustomCname *string `type:"string"`

	// Boolean value that specifies whether certificate revocation lists (CRLs)
	// are enabled. You can use this value to enable certificate revocation for
	// a new CA when you call the CreateCertificateAuthority action or for an existing
	// CA when you call the UpdateCertificateAuthority action.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Number of days until a certificate expires.
	ExpirationInDays *int64 `min:"1" type:"integer"`

	// Name of the S3 bucket that contains the CRL. If you do not provide a value
	// for the CustomCname argument, the name of your S3 bucket is placed into the
	// CRL Distribution Points extension of the issued certificate. You can change
	// the name of your bucket by calling the UpdateCertificateAuthority action.
	// You must specify a bucket policy that allows ACM Private CA to write the
	// CRL to your bucket.
	S3BucketName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s CrlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CrlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrlConfiguration"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.ExpirationInDays != nil && *s.ExpirationInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationInDays", 1))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomCname sets the CustomCname field's value.
func (s *CrlConfiguration) SetCustomCname(v string) *CrlConfiguration {
	s.CustomCname = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CrlConfiguration) SetEnabled(v bool) *CrlConfiguration {
	s.Enabled = &v
	return s
}

// SetExpirationInDays sets the ExpirationInDays field's value.
func (s *CrlConfiguration) SetExpirationInDays(v int64) *CrlConfiguration {
	s.ExpirationInDays = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CrlConfiguration) SetS3BucketName(v string) *CrlConfiguration {
	s.S3BucketName = &v
	return s
}

type DeleteCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The number of days to make a CA restorable after it has been deleted. This
	// can be anywhere from 7 to 30 days, with 30 being the default.
	PermanentDeletionTimeInDays *int64 `min:"7" type:"integer"`
}

// String returns the string representation
func (s DeleteCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.PermanentDeletionTimeInDays != nil && *s.PermanentDeletionTimeInDays < 7 {
		invalidParams.Add(request.NewErrParamMinValue("PermanentDeletionTimeInDays", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DeleteCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *DeleteCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetPermanentDeletionTimeInDays sets the PermanentDeletionTimeInDays field's value.
func (s *DeleteCertificateAuthorityInput) SetPermanentDeletionTimeInDays(v int64) *DeleteCertificateAuthorityInput {
	s.PermanentDeletionTimeInDays = &v
	return s
}

type DeleteCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateAuthorityOutput) GoString() string {
	return s.String()
}

type DeletePermissionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the private CA that issued the permissions.
	// You can find the CA's ARN by calling the ListCertificateAuthorities action.
	// This must have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The AWS service or identity that will have its CA permissions revoked. At
	// this time, the only valid service principal is acm.amazonaws.com
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// The AWS account that calls this action.
	SourceAccount *string `min:"12" type:"string"`
}

// String returns the string representation
func (s DeletePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.SourceAccount != nil && len(*s.SourceAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SourceAccount", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DeletePermissionInput) SetCertificateAuthorityArn(v string) *DeletePermissionInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *DeletePermissionInput) SetPrincipal(v string) *DeletePermissionInput {
	s.Principal = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *DeletePermissionInput) SetSourceAccount(v string) *DeletePermissionInput {
	s.SourceAccount = &v
	return s
}

type DeletePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionOutput) GoString() string {
	return s.String()
}

type DescribeCertificateAuthorityAuditReportInput struct {
	_ struct{} `type:"structure"`

	// The report ID returned by calling the CreateCertificateAuthorityAuditReport
	// action.
	//
	// AuditReportId is a required field
	AuditReportId *string `min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the private CA. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateAuthorityAuditReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateAuthorityAuditReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateAuthorityAuditReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateAuthorityAuditReportInput"}
	if s.AuditReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuditReportId"))
	}
	if s.AuditReportId != nil && len(*s.AuditReportId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AuditReportId", 36))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditReportId sets the AuditReportId field's value.
func (s *DescribeCertificateAuthorityAuditReportInput) SetAuditReportId(v string) *DescribeCertificateAuthorityAuditReportInput {
	s.AuditReportId = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DescribeCertificateAuthorityAuditReportInput) SetCertificateAuthorityArn(v string) *DescribeCertificateAuthorityAuditReportInput {
	s.CertificateAuthorityArn = &v
	return s
}

type DescribeCertificateAuthorityAuditReportOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether report creation is in progress, has succeeded, or has failed.
	AuditReportStatus *string `type:"string" enum:"AuditReportStatus"`

	// The date and time at which the report was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Name of the S3 bucket that contains the report.
	S3BucketName *string `type:"string"`

	// S3 key that uniquely identifies the report file in your S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificateAuthorityAuditReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateAuthorityAuditReportOutput) GoString() string {
	return s.String()
}

// SetAuditReportStatus sets the AuditReportStatus field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetAuditReportStatus(v string) *DescribeCertificateAuthorityAuditReportOutput {
	s.AuditReportStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetCreatedAt(v time.Time) *DescribeCertificateAuthorityAuditReportOutput {
	s.CreatedAt = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetS3BucketName(v string) *DescribeCertificateAuthorityAuditReportOutput {
	s.S3BucketName = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetS3Key(v string) *DescribeCertificateAuthorityAuditReportOutput {
	s.S3Key = &v
	return s
}

type DescribeCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DescribeCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *DescribeCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

type DescribeCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// A CertificateAuthority structure that contains information about your private
	// CA.
	CertificateAuthority *CertificateAuthority `type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthority sets the CertificateAuthority field's value.
func (s *DescribeCertificateAuthorityOutput) SetCertificateAuthority(v *CertificateAuthority) *DescribeCertificateAuthorityOutput {
	s.CertificateAuthority = v
	return s
}

type GetCertificateAuthorityCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of your private CA. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateAuthorityCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateAuthorityCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateAuthorityCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateAuthorityCertificateInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetCertificateAuthorityCertificateInput) SetCertificateAuthorityArn(v string) *GetCertificateAuthorityCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

type GetCertificateAuthorityCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Base64-encoded certificate authority (CA) certificate.
	Certificate *string `type:"string"`

	// Base64-encoded certificate chain that includes any intermediate certificates
	// and chains up to root on-premises certificate that you used to sign your
	// private CA certificate. The chain does not include your private CA certificate.
	// If this is a root CA, the value will be null.
	CertificateChain *string `type:"string"`
}

// String returns the string representation
func (s GetCertificateAuthorityCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateAuthorityCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetCertificateAuthorityCertificateOutput) SetCertificate(v string) *GetCertificateAuthorityCertificateOutput {
	s.Certificate = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *GetCertificateAuthorityCertificateOutput) SetCertificateChain(v string) *GetCertificateAuthorityCertificateOutput {
	s.CertificateChain = &v
	return s
}

type GetCertificateAuthorityCsrInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateAuthorityCsrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateAuthorityCsrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateAuthorityCsrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateAuthorityCsrInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetCertificateAuthorityCsrInput) SetCertificateAuthorityArn(v string) *GetCertificateAuthorityCsrInput {
	s.CertificateAuthorityArn = &v
	return s
}

type GetCertificateAuthorityCsrOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate signing request (CSR) for your private
	// CA certificate.
	Csr *string `type:"string"`
}

// String returns the string representation
func (s GetCertificateAuthorityCsrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateAuthorityCsrOutput) GoString() string {
	return s.String()
}

// SetCsr sets the Csr field's value.
func (s *GetCertificateAuthorityCsrOutput) SetCsr(v string) *GetCertificateAuthorityCsrOutput {
	s.Csr = &v
	return s
}

type GetCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the issued certificate. The ARN contains the certificate serial
	// number and must be in the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 5))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *GetCertificateInput) SetCertificateArn(v string) *GetCertificateInput {
	s.CertificateArn = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetCertificateInput) SetCertificateAuthorityArn(v string) *GetCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

type GetCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate specified by the CertificateArn parameter.
	Certificate *string `type:"string"`

	// The base64 PEM-encoded certificate chain that chains up to the on-premises
	// root CA certificate that you used to sign your private CA certificate.
	CertificateChain *string `type:"string"`
}

// String returns the string representation
func (s GetCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetCertificateOutput) SetCertificate(v string) *GetCertificateOutput {
	s.Certificate = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *GetCertificateOutput) SetCertificateChain(v string) *GetCertificateOutput {
	s.CertificateChain = &v
	return s
}

type ImportCertificateAuthorityCertificateInput struct {
	_ struct{} `type:"structure"`

	// The PEM-encoded certificate for a private CA. This may be a self-signed certificate
	// in the case of a root CA, or it may be signed by another CA that you control.
	//
	// Certificate is automatically base64 encoded/decoded by the SDK.
	//
	// Certificate is a required field
	Certificate []byte `min:"1" type:"blob" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// A PEM-encoded file that contains all of your certificates, other than the
	// certificate you're importing, chaining up to your root CA. Your ACM Private
	// CA-hosted or on-premises root certificate is the last in the chain, and each
	// certificate in the chain signs the one preceding.
	//
	// This parameter must be supplied when you import a subordinate CA. When you
	// import a root CA, there is no chain.
	//
	// CertificateChain is automatically base64 encoded/decoded by the SDK.
	CertificateChain []byte `type:"blob"`
}

// String returns the string representation
func (s ImportCertificateAuthorityCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateAuthorityCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateAuthorityCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateAuthorityCertificateInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(s.Certificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 1))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ImportCertificateAuthorityCertificateInput) SetCertificate(v []byte) *ImportCertificateAuthorityCertificateInput {
	s.Certificate = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ImportCertificateAuthorityCertificateInput) SetCertificateAuthorityArn(v string) *ImportCertificateAuthorityCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *ImportCertificateAuthorityCertificateInput) SetCertificateChain(v []byte) *ImportCertificateAuthorityCertificateInput {
	s.CertificateChain = v
	return s
}

type ImportCertificateAuthorityCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportCertificateAuthorityCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateAuthorityCertificateOutput) GoString() string {
	return s.String()
}

// One or more of the specified arguments was not valid.
type InvalidArgsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidArgsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidArgsException) GoString() string {
	return s.String()
}

func newErrorInvalidArgsException(v protocol.ResponseMetadata) error {
	return &InvalidArgsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidArgsException) Code() string {
	return "InvalidArgsException"
}

// Message returns the exception's message.
func (s InvalidArgsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidArgsException) OrigErr() error {
	return nil
}

func (s InvalidArgsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidArgsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidArgsException) RequestID() string {
	return s.respMetadata.RequestID
}

// The requested Amazon Resource Name (ARN) does not refer to an existing resource.
type InvalidArnException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidArnException) GoString() string {
	return s.String()
}

func newErrorInvalidArnException(v protocol.ResponseMetadata) error {
	return &InvalidArnException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidArnException) Code() string {
	return "InvalidArnException"
}

// Message returns the exception's message.
func (s InvalidArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidArnException) OrigErr() error {
	return nil
}

func (s InvalidArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidArnException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidArnException) RequestID() string {
	return s.respMetadata.RequestID
}

// The token specified in the NextToken argument is not valid. Use the token
// returned from your previous call to ListCertificateAuthorities.
type InvalidNextTokenException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidNextTokenException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidNextTokenException) RequestID() string {
	return s.respMetadata.RequestID
}

// The S3 bucket policy is not valid. The policy must give ACM Private CA rights
// to read from and write to the bucket and find the bucket location.
type InvalidPolicyException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidPolicyException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidPolicyException) Code() string {
	return "InvalidPolicyException"
}

// Message returns the exception's message.
func (s InvalidPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidPolicyException) OrigErr() error {
	return nil
}

func (s InvalidPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidPolicyException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidPolicyException) RequestID() string {
	return s.respMetadata.RequestID
}

// The request action cannot be performed or is prohibited.
type InvalidRequestException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidRequestException) OrigErr() error {
	return nil
}

func (s InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidRequestException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidRequestException) RequestID() string {
	return s.respMetadata.RequestID
}

// The private CA is in a state during which a report or certificate cannot
// be generated.
type InvalidStateException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidStateException) GoString() string {
	return s.String()
}

func newErrorInvalidStateException(v protocol.ResponseMetadata) error {
	return &InvalidStateException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidStateException) Code() string {
	return "InvalidStateException"
}

// Message returns the exception's message.
func (s InvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidStateException) OrigErr() error {
	return nil
}

func (s InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidStateException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidStateException) RequestID() string {
	return s.respMetadata.RequestID
}

// The tag associated with the CA is not valid. The invalid argument is contained
// in the message field.
type InvalidTagException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidTagException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidTagException) GoString() string {
	return s.String()
}

func newErrorInvalidTagException(v protocol.ResponseMetadata) error {
	return &InvalidTagException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidTagException) Code() string {
	return "InvalidTagException"
}

// Message returns the exception's message.
func (s InvalidTagException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidTagException) OrigErr() error {
	return nil
}

func (s InvalidTagException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidTagException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidTagException) RequestID() string {
	return s.respMetadata.RequestID
}

type IssueCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The certificate signing request (CSR) for the certificate you want to issue.
	// You can use the following OpenSSL command to create the CSR and a 2048 bit
	// RSA private key.
	//
	// openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
	// -out csr/test_cert_.csr
	//
	// If you have a configuration file, you can use the following OpenSSL command.
	// The usr_cert block in the configuration file contains your X509 version 3
	// extensions.
	//
	// openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
	// -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr
	//
	// Csr is automatically base64 encoded/decoded by the SDK.
	//
	// Csr is a required field
	Csr []byte `min:"1" type:"blob" required:"true"`

	// Custom string that can be used to distinguish between calls to the IssueCertificate
	// action. Idempotency tokens time out after one hour. Therefore, if you call
	// IssueCertificate multiple times with the same idempotency token within 5
	// minutes, ACM Private CA recognizes that you are requesting only one certificate
	// and will issue only one. If you change the idempotency token for each call,
	// PCA recognizes that you are requesting multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// The name of the algorithm that will be used to sign the certificate to be
	// issued.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm *string `type:"string" required:"true" enum:"SigningAlgorithm"`

	// Specifies a custom configuration template to use when issuing a certificate.
	// If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1
	// template.
	//
	// The following service-owned TemplateArn values are supported by ACM Private
	// CA:
	//
	//    * arn:aws:acm-pca:::template/EndEntityCertificate/V1
	//
	//    * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1
	//
	//    * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1
	//
	//    * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1
	//
	//    * arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1
	//
	//    * arn:aws:acm-pca:::template/RootCACertificate/V1
	//
	// For more information, see Using Templates (https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html).
	TemplateArn *string `min:"5" type:"string"`

	// The type of the validity period.
	//
	// Validity is a required field
	Validity *Validity `type:"structure" required:"true"`
}

// String returns the string representation
func (s IssueCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IssueCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IssueCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IssueCertificateInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Csr == nil {
		invalidParams.Add(request.NewErrParamRequired("Csr"))
	}
	if s.Csr != nil && len(s.Csr) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Csr", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.SigningAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAlgorithm"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}
	if s.Validity == nil {
		invalidParams.Add(request.NewErrParamRequired("Validity"))
	}
	if s.Validity != nil {
		if err := s.Validity.Validate(); err != nil {
			invalidParams.AddNested("Validity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *IssueCertificateInput) SetCertificateAuthorityArn(v string) *IssueCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCsr sets the Csr field's value.
func (s *IssueCertificateInput) SetCsr(v []byte) *IssueCertificateInput {
	s.Csr = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *IssueCertificateInput) SetIdempotencyToken(v string) *IssueCertificateInput {
	s.IdempotencyToken = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *IssueCertificateInput) SetSigningAlgorithm(v string) *IssueCertificateInput {
	s.SigningAlgorithm = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *IssueCertificateInput) SetTemplateArn(v string) *IssueCertificateInput {
	s.TemplateArn = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *IssueCertificateInput) SetValidity(v *Validity) *IssueCertificateInput {
	s.Validity = v
	return s
}

type IssueCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the issued certificate and the certificate
	// serial number. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245
	CertificateArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s IssueCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IssueCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *IssueCertificateOutput) SetCertificateArn(v string) *IssueCertificateOutput {
	s.CertificateArn = &v
	return s
}

// An ACM Private CA limit has been exceeded. See the exception message returned
// to determine the limit that was exceeded.
type LimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitExceededException) OrigErr() error {
	return nil
}

func (s LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListCertificateAuthoritiesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificateAuthoritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificateAuthoritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificateAuthoritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificateAuthoritiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCertificateAuthoritiesInput) SetMaxResults(v int64) *ListCertificateAuthoritiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificateAuthoritiesInput) SetNextToken(v string) *ListCertificateAuthoritiesInput {
	s.NextToken = &v
	return s
}

type ListCertificateAuthoritiesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about each certificate authority you have created.
	CertificateAuthorities []*CertificateAuthority `type:"list"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificateAuthoritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificateAuthoritiesOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorities sets the CertificateAuthorities field's value.
func (s *ListCertificateAuthoritiesOutput) SetCertificateAuthorities(v []*CertificateAuthority) *ListCertificateAuthoritiesOutput {
	s.CertificateAuthorities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificateAuthoritiesOutput) SetNextToken(v string) *ListCertificateAuthoritiesOutput {
	s.NextToken = &v
	return s
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the private CA to inspect. You can find
	// the ARN by calling the ListCertificateAuthorities action. This must be of
	// the form: arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	// You can get a private CA's ARN by running the ListCertificateAuthorities
	// action.
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// When paginating results, use this parameter to specify the maximum number
	// of items to return in the response. If additional items exist beyond the
	// number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// When paginating results, use this parameter in a subsequent request after
	// you receive a response with truncated results. Set it to the value of NextToken
	// from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ListPermissionsInput) SetCertificateAuthorityArn(v string) *ListPermissionsInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`

	// Summary information about each permission assigned by the specified private
	// CA, including the action enabled, the policy provided, and the time of creation.
	Permissions []*Permission `type:"list"`
}

// String returns the string representation
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionsOutput) SetPermissions(v []*Permission) *ListPermissionsOutput {
	s.Permissions = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response. If additional items exist beyond the
	// number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of NextToken
	// from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ListTagsInput) SetCertificateAuthorityArn(v string) *ListTagsInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`

	// The tags associated with your private CA.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v []*Tag) *ListTagsOutput {
	s.Tags = v
	return s
}

// The certificate signing request is invalid.
type MalformedCSRException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MalformedCSRException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MalformedCSRException) GoString() string {
	return s.String()
}

func newErrorMalformedCSRException(v protocol.ResponseMetadata) error {
	return &MalformedCSRException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s MalformedCSRException) Code() string {
	return "MalformedCSRException"
}

// Message returns the exception's message.
func (s MalformedCSRException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s MalformedCSRException) OrigErr() error {
	return nil
}

func (s MalformedCSRException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s MalformedCSRException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s MalformedCSRException) RequestID() string {
	return s.respMetadata.RequestID
}

// One or more fields in the certificate are invalid.
type MalformedCertificateException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MalformedCertificateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MalformedCertificateException) GoString() string {
	return s.String()
}

func newErrorMalformedCertificateException(v protocol.ResponseMetadata) error {
	return &MalformedCertificateException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s MalformedCertificateException) Code() string {
	return "MalformedCertificateException"
}

// Message returns the exception's message.
func (s MalformedCertificateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s MalformedCertificateException) OrigErr() error {
	return nil
}

func (s MalformedCertificateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s MalformedCertificateException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s MalformedCertificateException) RequestID() string {
	return s.respMetadata.RequestID
}

// Permissions designate which private CA actions can be performed by an AWS
// service or entity. In order for ACM to automatically renew private certificates,
// you must give the ACM service principal all available permissions (IssueCertificate,
// GetCertificate, and ListPermissions). Permissions can be assigned with the
// CreatePermission action, removed with the DeletePermission action, and listed
// with the ListPermissions action.
type Permission struct {
	_ struct{} `type:"structure"`

	// The private CA actions that can be performed by the designated AWS service.
	Actions []*string `min:"1" type:"list"`

	// The Amazon Resource Number (ARN) of the private CA from which the permission
	// was issued.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// The time at which the permission was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the policy that is associated with the permission.
	Policy *string `type:"string"`

	// The AWS service or entity that holds the permission. At this time, the only
	// valid principal is acm.amazonaws.com.
	Principal *string `type:"string"`

	// The ID of the account that assigned the permission.
	SourceAccount *string `type:"string"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Permission) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Permission) SetActions(v []*string) *Permission {
	s.Actions = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *Permission) SetCertificateAuthorityArn(v string) *Permission {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Permission) SetCreatedAt(v time.Time) *Permission {
	s.CreatedAt = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *Permission) SetPolicy(v string) *Permission {
	s.Policy = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *Permission) SetPrincipal(v string) *Permission {
	s.Principal = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *Permission) SetSourceAccount(v string) *Permission {
	s.SourceAccount = &v
	return s
}

// The designated permission has already been given to the user.
type PermissionAlreadyExistsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s PermissionAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorPermissionAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &PermissionAlreadyExistsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s PermissionAlreadyExistsException) Code() string {
	return "PermissionAlreadyExistsException"
}

// Message returns the exception's message.
func (s PermissionAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s PermissionAlreadyExistsException) OrigErr() error {
	return nil
}

func (s PermissionAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s PermissionAlreadyExistsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s PermissionAlreadyExistsException) RequestID() string {
	return s.respMetadata.RequestID
}

// Your request has already been completed.
type RequestAlreadyProcessedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RequestAlreadyProcessedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestAlreadyProcessedException) GoString() string {
	return s.String()
}

func newErrorRequestAlreadyProcessedException(v protocol.ResponseMetadata) error {
	return &RequestAlreadyProcessedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s RequestAlreadyProcessedException) Code() string {
	return "RequestAlreadyProcessedException"
}

// Message returns the exception's message.
func (s RequestAlreadyProcessedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s RequestAlreadyProcessedException) OrigErr() error {
	return nil
}

func (s RequestAlreadyProcessedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s RequestAlreadyProcessedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s RequestAlreadyProcessedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The request has failed for an unspecified reason.
type RequestFailedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestFailedException) GoString() string {
	return s.String()
}

func newErrorRequestFailedException(v protocol.ResponseMetadata) error {
	return &RequestFailedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s RequestFailedException) Code() string {
	return "RequestFailedException"
}

// Message returns the exception's message.
func (s RequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s RequestFailedException) OrigErr() error {
	return nil
}

func (s RequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s RequestFailedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s RequestFailedException) RequestID() string {
	return s.respMetadata.RequestID
}

// Your request is already in progress.
type RequestInProgressException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RequestInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestInProgressException) GoString() string {
	return s.String()
}

func newErrorRequestInProgressException(v protocol.ResponseMetadata) error {
	return &RequestInProgressException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s RequestInProgressException) Code() string {
	return "RequestInProgressException"
}

// Message returns the exception's message.
func (s RequestInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s RequestInProgressException) OrigErr() error {
	return nil
}

func (s RequestInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s RequestInProgressException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s RequestInProgressException) RequestID() string {
	return s.respMetadata.RequestID
}

// A resource such as a private CA, S3 bucket, certificate, or audit report
// cannot be found.
type ResourceNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

type RestoreCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *RestoreCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *RestoreCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

type RestoreCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// Certificate revocation information used by the CreateCertificateAuthority
// and UpdateCertificateAuthority actions. Your private certificate authority
// (CA) can create and maintain a certificate revocation list (CRL). A CRL contains
// information about certificates revoked by your CA. For more information,
// see RevokeCertificate.
type RevocationConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration of the certificate revocation list (CRL), if any, maintained
	// by your private CA.
	CrlConfiguration *CrlConfiguration `type:"structure"`
}

// String returns the string representation
func (s RevocationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevocationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevocationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevocationConfiguration"}
	if s.CrlConfiguration != nil {
		if err := s.CrlConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrlConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlConfiguration sets the CrlConfiguration field's value.
func (s *RevocationConfiguration) SetCrlConfiguration(v *CrlConfiguration) *RevocationConfiguration {
	s.CrlConfiguration = v
	return s
}

type RevokeCertificateInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the private CA that issued the certificate
	// to be revoked. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Serial number of the certificate to be revoked. This must be in hexadecimal
	// format. You can retrieve the serial number by calling GetCertificate with
	// the Amazon Resource Name (ARN) of the certificate you want and the ARN of
	// your private CA. The GetCertificate action retrieves the certificate in the
	// PEM format. You can use the following OpenSSL command to list the certificate
	// in text format and copy the hexadecimal serial number.
	//
	// openssl x509 -in file_path -text -noout
	//
	// You can also copy the serial number from the console or use the DescribeCertificate
	// (https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html)
	// action in the AWS Certificate Manager API Reference.
	//
	// CertificateSerial is a required field
	CertificateSerial *string `type:"string" required:"true"`

	// Specifies why you revoked the certificate.
	//
	// RevocationReason is a required field
	RevocationReason *string `type:"string" required:"true" enum:"RevocationReason"`
}

// String returns the string representation
func (s RevokeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeCertificateInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.CertificateSerial == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateSerial"))
	}
	if s.RevocationReason == nil {
		invalidParams.Add(request.NewErrParamRequired("RevocationReason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *RevokeCertificateInput) SetCertificateAuthorityArn(v string) *RevokeCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCertificateSerial sets the CertificateSerial field's value.
func (s *RevokeCertificateInput) SetCertificateSerial(v string) *RevokeCertificateInput {
	s.CertificateSerial = &v
	return s
}

// SetRevocationReason sets the RevocationReason field's value.
func (s *RevokeCertificateInput) SetRevocationReason(v string) *RevokeCertificateInput {
	s.RevocationReason = &v
	return s
}

type RevokeCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeCertificateOutput) GoString() string {
	return s.String()
}

// Tags are labels that you can use to identify and organize your private CAs.
// Each tag consists of a key and an optional value. You can associate up to
// 50 tags with a private CA. To add one or more tags to a private CA, call
// the TagCertificateAuthority action. To remove a tag, call the UntagCertificateAuthority
// action.
type Tag struct {
	_ struct{} `type:"structure"`

	// Key (name) of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// List of tags to be associated with the CA.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *TagCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *TagCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagCertificateAuthorityInput) SetTags(v []*Tag) *TagCertificateAuthorityInput {
	s.Tags = v
	return s
}

type TagCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// You can associate up to 50 tags with a private CA. Exception information
// is contained in the exception message field.
type TooManyTagsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TooManyTagsException) OrigErr() error {
	return nil
}

func (s TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TooManyTagsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TooManyTagsException) RequestID() string {
	return s.respMetadata.RequestID
}

type UntagCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// List of tags to be removed from the CA.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *UntagCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *UntagCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UntagCertificateAuthorityInput) SetTags(v []*Tag) *UntagCertificateAuthorityInput {
	s.Tags = v
	return s
}

type UntagCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagCertificateAuthorityOutput) GoString() string {
	return s.String()
}

type UpdateCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the private CA that issued the certificate
	// to be revoked. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Revocation information for your private CA.
	RevocationConfiguration *RevocationConfiguration `type:"structure"`

	// Status of your private CA.
	Status *string `type:"string" enum:"CertificateAuthorityStatus"`
}

// String returns the string representation
func (s UpdateCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.RevocationConfiguration != nil {
		if err := s.RevocationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RevocationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *UpdateCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *UpdateCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetRevocationConfiguration sets the RevocationConfiguration field's value.
func (s *UpdateCertificateAuthorityInput) SetRevocationConfiguration(v *RevocationConfiguration) *UpdateCertificateAuthorityInput {
	s.RevocationConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateCertificateAuthorityInput) SetStatus(v string) *UpdateCertificateAuthorityInput {
	s.Status = &v
	return s
}

type UpdateCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// Length of time for which the certificate issued by your private certificate
// authority (CA), or by the private CA itself, is valid in days, months, or
// years. You can issue a certificate by calling the IssueCertificate action.
type Validity struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Value parameter represents days, months, or years.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ValidityPeriodType"`

	// Time period.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s Validity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Validity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Validity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Validity"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *Validity) SetType(v string) *Validity {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Validity) SetValue(v int64) *Validity {
	s.Value = &v
	return s
}

const (
	// ActionTypeIssueCertificate is a ActionType enum value
	ActionTypeIssueCertificate = "IssueCertificate"

	// ActionTypeGetCertificate is a ActionType enum value
	ActionTypeGetCertificate = "GetCertificate"

	// ActionTypeListPermissions is a ActionType enum value
	ActionTypeListPermissions = "ListPermissions"
)

const (
	// AuditReportResponseFormatJson is a AuditReportResponseFormat enum value
	AuditReportResponseFormatJson = "JSON"

	// AuditReportResponseFormatCsv is a AuditReportResponseFormat enum value
	AuditReportResponseFormatCsv = "CSV"
)

const (
	// AuditReportStatusCreating is a AuditReportStatus enum value
	AuditReportStatusCreating = "CREATING"

	// AuditReportStatusSuccess is a AuditReportStatus enum value
	AuditReportStatusSuccess = "SUCCESS"

	// AuditReportStatusFailed is a AuditReportStatus enum value
	AuditReportStatusFailed = "FAILED"
)

const (
	// CertificateAuthorityStatusCreating is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusCreating = "CREATING"

	// CertificateAuthorityStatusPendingCertificate is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusPendingCertificate = "PENDING_CERTIFICATE"

	// CertificateAuthorityStatusActive is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusActive = "ACTIVE"

	// CertificateAuthorityStatusDeleted is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusDeleted = "DELETED"

	// CertificateAuthorityStatusDisabled is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusDisabled = "DISABLED"

	// CertificateAuthorityStatusExpired is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusExpired = "EXPIRED"

	// CertificateAuthorityStatusFailed is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusFailed = "FAILED"
)

const (
	// CertificateAuthorityTypeRoot is a CertificateAuthorityType enum value
	CertificateAuthorityTypeRoot = "ROOT"

	// CertificateAuthorityTypeSubordinate is a CertificateAuthorityType enum value
	CertificateAuthorityTypeSubordinate = "SUBORDINATE"
)

const (
	// FailureReasonRequestTimedOut is a FailureReason enum value
	FailureReasonRequestTimedOut = "REQUEST_TIMED_OUT"

	// FailureReasonUnsupportedAlgorithm is a FailureReason enum value
	FailureReasonUnsupportedAlgorithm = "UNSUPPORTED_ALGORITHM"

	// FailureReasonOther is a FailureReason enum value
	FailureReasonOther = "OTHER"
)

const (
	// KeyAlgorithmRsa2048 is a KeyAlgorithm enum value
	KeyAlgorithmRsa2048 = "RSA_2048"

	// KeyAlgorithmRsa4096 is a KeyAlgorithm enum value
	KeyAlgorithmRsa4096 = "RSA_4096"

	// KeyAlgorithmEcPrime256v1 is a KeyAlgorithm enum value
	KeyAlgorithmEcPrime256v1 = "EC_prime256v1"

	// KeyAlgorithmEcSecp384r1 is a KeyAlgorithm enum value
	KeyAlgorithmEcSecp384r1 = "EC_secp384r1"
)

const (
	// RevocationReasonUnspecified is a RevocationReason enum value
	RevocationReasonUnspecified = "UNSPECIFIED"

	// RevocationReasonKeyCompromise is a RevocationReason enum value
	RevocationReasonKeyCompromise = "KEY_COMPROMISE"

	// RevocationReasonCertificateAuthorityCompromise is a RevocationReason enum value
	RevocationReasonCertificateAuthorityCompromise = "CERTIFICATE_AUTHORITY_COMPROMISE"

	// RevocationReasonAffiliationChanged is a RevocationReason enum value
	RevocationReasonAffiliationChanged = "AFFILIATION_CHANGED"

	// RevocationReasonSuperseded is a RevocationReason enum value
	RevocationReasonSuperseded = "SUPERSEDED"

	// RevocationReasonCessationOfOperation is a RevocationReason enum value
	RevocationReasonCessationOfOperation = "CESSATION_OF_OPERATION"

	// RevocationReasonPrivilegeWithdrawn is a RevocationReason enum value
	RevocationReasonPrivilegeWithdrawn = "PRIVILEGE_WITHDRAWN"

	// RevocationReasonAACompromise is a RevocationReason enum value
	RevocationReasonAACompromise = "A_A_COMPROMISE"
)

const (
	// SigningAlgorithmSha256withecdsa is a SigningAlgorithm enum value
	SigningAlgorithmSha256withecdsa = "SHA256WITHECDSA"

	// SigningAlgorithmSha384withecdsa is a SigningAlgorithm enum value
	SigningAlgorithmSha384withecdsa = "SHA384WITHECDSA"

	// SigningAlgorithmSha512withecdsa is a SigningAlgorithm enum value
	SigningAlgorithmSha512withecdsa = "SHA512WITHECDSA"

	// SigningAlgorithmSha256withrsa is a SigningAlgorithm enum value
	SigningAlgorithmSha256withrsa = "SHA256WITHRSA"

	// SigningAlgorithmSha384withrsa is a SigningAlgorithm enum value
	SigningAlgorithmSha384withrsa = "SHA384WITHRSA"

	// SigningAlgorithmSha512withrsa is a SigningAlgorithm enum value
	SigningAlgorithmSha512withrsa = "SHA512WITHRSA"
)

const (
	// ValidityPeriodTypeEndDate is a ValidityPeriodType enum value
	ValidityPeriodTypeEndDate = "END_DATE"

	// ValidityPeriodTypeAbsolute is a ValidityPeriodType enum value
	ValidityPeriodTypeAbsolute = "ABSOLUTE"

	// ValidityPeriodTypeDays is a ValidityPeriodType enum value
	ValidityPeriodTypeDays = "DAYS"

	// ValidityPeriodTypeMonths is a ValidityPeriodType enum value
	ValidityPeriodTypeMonths = "MONTHS"

	// ValidityPeriodTypeYears is a ValidityPeriodType enum value
	ValidityPeriodTypeYears = "YEARS"
)
