/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.access.AbstractCacheAccess;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.access.exception.InvalidArgumentException;
import org.apache.commons.jcs3.access.exception.InvalidHandleException;
import org.apache.commons.jcs3.access.exception.ObjectExistsException;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;

public class CacheAccess<K, V>
extends AbstractCacheAccess<K, V>
implements ICacheAccess<K, V> {
    public CacheAccess(CompositeCache<K, V> cacheControl) {
        super(cacheControl);
    }

    @Override
    public V get(K name) {
        ICacheElement element = this.getCacheControl().get(name);
        return element != null ? (V)element.getVal() : null;
    }

    @Override
    public V get(K name, Supplier<V> supplier) {
        V value = this.get(name);
        if (value == null) {
            value = supplier.get();
            this.put(name, value);
        }
        return value;
    }

    @Override
    public Map<K, V> getMatching(String pattern) {
        Map wrappedResults = this.getCacheControl().getMatching(pattern);
        Map<Object, Object> unwrappedResults = wrappedResults == null ? new HashMap() : wrappedResults.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ICacheElement)entry.getValue()).getVal()));
        return unwrappedResults;
    }

    @Override
    public ICacheElement<K, V> getCacheElement(K name) {
        return this.getCacheControl().get(name);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getCacheElements(Set<K> names) {
        return this.getCacheControl().getMultiple(names);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatchingCacheElements(String pattern) {
        return this.getCacheControl().getMatching(pattern);
    }

    @Override
    public void putSafe(K key, V value) {
        if (this.getCacheControl().get(key) != null) {
            throw new ObjectExistsException("putSafe failed.  Object exists in the cache for key [" + key + "].  Remove first or use a non-safe put to override the value.");
        }
        this.put(key, value);
    }

    @Override
    public void put(K name, V obj) {
        this.put(name, obj, this.getCacheControl().getElementAttributes());
    }

    @Override
    public void put(K key, V val, IElementAttributes attr) {
        if (key == null) {
            throw new InvalidArgumentException("Key must not be null");
        }
        if (val == null) {
            throw new InvalidArgumentException("Value must not be null");
        }
        try {
            CacheElement<K, V> ce = new CacheElement<K, V>(this.getCacheControl().getCacheName(), key, val);
            ce.setElementAttributes(attr);
            this.getCacheControl().update(ce);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void remove(K name) {
        this.getCacheControl().remove(name);
    }

    @Override
    public void resetElementAttributes(K name, IElementAttributes attr) {
        ICacheElement element = this.getCacheControl().get(name);
        if (element == null) {
            throw new InvalidHandleException("Object for name [" + name + "] is not in the cache");
        }
        this.put(element.getKey(), element.getVal(), attr);
    }

    @Override
    public IElementAttributes getElementAttributes(K name) throws CacheException {
        IElementAttributes attr = null;
        try {
            attr = this.getCacheControl().getElementAttributes(name);
        }
        catch (IOException ioe) {
            throw new CacheException("Failure getting element attributes", ioe);
        }
        return attr;
    }
}

