/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2022 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include "config.h"

#include "gtk/gtkdialogerror.h"

/**
 * gtk_dialog_error_quark:
 *
 * Registers an error quark for an operation that requires a dialog if
 * necessary.
 *
 * Returns: the error quark
 */
GQuark
gtk_dialog_error_quark (void)
{
  return g_quark_from_static_string ("gtk-dialog-error-quark");
}
