// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/admin/database/v1/backup.proto

package database

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates the current state of the backup.
type Backup_State int32

const (
	// Not specified.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The pending backup is still being created. Operations on the
	// backup may fail with `FAILED_PRECONDITION` in this state.
	Backup_CREATING Backup_State = 1
	// The backup is complete and ready for use.
	Backup_READY Backup_State = 2
)

var Backup_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
}

var Backup_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
}

func (x Backup_State) String() string {
	return proto.EnumName(Backup_State_name, int32(x))
}

func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{0, 0}
}

// A backup of a Cloud Spanner database.
type Backup struct {
	// Required for the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] operation.
	// Name of the database from which this backup was
	// created. This needs to be in the same instance as the backup.
	// Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>`.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// Required for the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// operation. The expiration time of the backup, with microseconds
	// granularity that must be at least 6 hours and at most 366 days
	// from the time the CreateBackup request is processed. Once the `expire_time`
	// has passed, the backup is eligible to be automatically deleted by Cloud
	// Spanner to free the resources used by the backup.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only for the [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] operation.
	// Required for the [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup] operation.
	//
	// A globally unique identifier for the backup which cannot be
	// changed. Values are of the form
	// `projects/<project>/instances/<instance>/backups/[a-z][a-z0-9_\-]*[a-z0-9]`
	// The final segment of the name must be between 2 and 60 characters
	// in length.
	//
	// The backup is stored in the location(s) specified in the instance
	// configuration of the instance containing the backup, identified
	// by the prefix of the backup name of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The backup will contain an externally consistent
	// copy of the database at the timestamp specified by
	// `create_time`. `create_time` is approximately the time the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] request is received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Size of the backup in bytes.
	SizeBytes int64 `protobuf:"varint,5,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The current state of the backup.
	State Backup_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.spanner.admin.database.v1.Backup_State" json:"state,omitempty"`
	// Output only. The names of the restored databases that reference the backup.
	// The database names are of
	// the form `projects/<project>/instances/<instance>/databases/<database>`.
	// Referencing databases may exist in different instances. The existence of
	// any referencing database prevents the backup from being deleted. When a
	// restored database from the backup enters the `READY` state, the reference
	// to the backup is removed.
	ReferencingDatabases []string `protobuf:"bytes,7,rep,name=referencing_databases,json=referencingDatabases,proto3" json:"referencing_databases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Backup) Reset()         { *m = Backup{} }
func (m *Backup) String() string { return proto.CompactTextString(m) }
func (*Backup) ProtoMessage()    {}
func (*Backup) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{0}
}

func (m *Backup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Backup.Unmarshal(m, b)
}
func (m *Backup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Backup.Marshal(b, m, deterministic)
}
func (m *Backup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backup.Merge(m, src)
}
func (m *Backup) XXX_Size() int {
	return xxx_messageInfo_Backup.Size(m)
}
func (m *Backup) XXX_DiscardUnknown() {
	xxx_messageInfo_Backup.DiscardUnknown(m)
}

var xxx_messageInfo_Backup proto.InternalMessageInfo

func (m *Backup) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *Backup) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *Backup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Backup) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Backup) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

func (m *Backup) GetState() Backup_State {
	if m != nil {
		return m.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (m *Backup) GetReferencingDatabases() []string {
	if m != nil {
		return m.ReferencingDatabases
	}
	return nil
}

// The request for [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
type CreateBackupRequest struct {
	// Required. The name of the instance in which the backup will be
	// created. This must be the same instance that contains the database the
	// backup will be created from. The backup will be stored in the
	// location(s) specified in the instance configuration of this
	// instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the backup to be created. The `backup_id` appended to
	// `parent` forms the full backup name of the form
	// `projects/<project>/instances/<instance>/backups/<backup_id>`.
	BackupId string `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Required. The backup to create.
	Backup               *Backup  `protobuf:"bytes,3,opt,name=backup,proto3" json:"backup,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateBackupRequest) Reset()         { *m = CreateBackupRequest{} }
func (m *CreateBackupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateBackupRequest) ProtoMessage()    {}
func (*CreateBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{1}
}

func (m *CreateBackupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBackupRequest.Unmarshal(m, b)
}
func (m *CreateBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBackupRequest.Marshal(b, m, deterministic)
}
func (m *CreateBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBackupRequest.Merge(m, src)
}
func (m *CreateBackupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateBackupRequest.Size(m)
}
func (m *CreateBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBackupRequest proto.InternalMessageInfo

func (m *CreateBackupRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateBackupRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *CreateBackupRequest) GetBackup() *Backup {
	if m != nil {
		return m.Backup
	}
	return nil
}

// Metadata type for the operation returned by
// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
type CreateBackupMetadata struct {
	// The name of the backup being created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the database the backup is created from.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// The progress of the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup] operation.
	Progress *OperationProgress `protobuf:"bytes,3,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which cancellation of this operation was received.
	// [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
	// starts asynchronous cancellation on a long-running operation. The server
	// makes a best effort to cancel the operation, but success is not guaranteed.
	// Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateBackupMetadata) Reset()         { *m = CreateBackupMetadata{} }
func (m *CreateBackupMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateBackupMetadata) ProtoMessage()    {}
func (*CreateBackupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{2}
}

func (m *CreateBackupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBackupMetadata.Unmarshal(m, b)
}
func (m *CreateBackupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBackupMetadata.Marshal(b, m, deterministic)
}
func (m *CreateBackupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBackupMetadata.Merge(m, src)
}
func (m *CreateBackupMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateBackupMetadata.Size(m)
}
func (m *CreateBackupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBackupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBackupMetadata proto.InternalMessageInfo

func (m *CreateBackupMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateBackupMetadata) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *CreateBackupMetadata) GetProgress() *OperationProgress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (m *CreateBackupMetadata) GetCancelTime() *timestamp.Timestamp {
	if m != nil {
		return m.CancelTime
	}
	return nil
}

// The request for [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup].
type UpdateBackupRequest struct {
	// Required. The backup to update. `backup.name`, and the fields to be updated
	// as specified by `update_mask` are required. Other fields are ignored.
	// Update is only supported for the following fields:
	//  * `backup.expire_time`.
	Backup *Backup `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// Required. A mask specifying which fields (e.g. `expire_time`) in the
	// Backup resource should be updated. This mask is relative to the Backup
	// resource, not to the request message. The field mask must always be
	// specified; this prevents any future fields from being erased accidentally
	// by clients that do not know about them.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateBackupRequest) Reset()         { *m = UpdateBackupRequest{} }
func (m *UpdateBackupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBackupRequest) ProtoMessage()    {}
func (*UpdateBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{3}
}

func (m *UpdateBackupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBackupRequest.Unmarshal(m, b)
}
func (m *UpdateBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBackupRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBackupRequest.Merge(m, src)
}
func (m *UpdateBackupRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBackupRequest.Size(m)
}
func (m *UpdateBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBackupRequest proto.InternalMessageInfo

func (m *UpdateBackupRequest) GetBackup() *Backup {
	if m != nil {
		return m.Backup
	}
	return nil
}

func (m *UpdateBackupRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for [GetBackup][google.spanner.admin.database.v1.DatabaseAdmin.GetBackup].
type GetBackupRequest struct {
	// Required. Name of the backup.
	// Values are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBackupRequest) Reset()         { *m = GetBackupRequest{} }
func (m *GetBackupRequest) String() string { return proto.CompactTextString(m) }
func (*GetBackupRequest) ProtoMessage()    {}
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{4}
}

func (m *GetBackupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBackupRequest.Unmarshal(m, b)
}
func (m *GetBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBackupRequest.Marshal(b, m, deterministic)
}
func (m *GetBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBackupRequest.Merge(m, src)
}
func (m *GetBackupRequest) XXX_Size() int {
	return xxx_messageInfo_GetBackupRequest.Size(m)
}
func (m *GetBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBackupRequest proto.InternalMessageInfo

func (m *GetBackupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [DeleteBackup][google.spanner.admin.database.v1.DatabaseAdmin.DeleteBackup].
type DeleteBackupRequest struct {
	// Required. Name of the backup to delete.
	// Values are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteBackupRequest) Reset()         { *m = DeleteBackupRequest{} }
func (m *DeleteBackupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteBackupRequest) ProtoMessage()    {}
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{5}
}

func (m *DeleteBackupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteBackupRequest.Unmarshal(m, b)
}
func (m *DeleteBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteBackupRequest.Marshal(b, m, deterministic)
}
func (m *DeleteBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteBackupRequest.Merge(m, src)
}
func (m *DeleteBackupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteBackupRequest.Size(m)
}
func (m *DeleteBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteBackupRequest proto.InternalMessageInfo

func (m *DeleteBackupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [ListBackups][google.spanner.admin.database.v1.DatabaseAdmin.ListBackups].
type ListBackupsRequest struct {
	// Required. The instance to list backups from.  Values are of the
	// form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that filters the list of returned backups.
	//
	// A filter expression consists of a field name, a comparison operator, and a
	// value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the [Backup][google.spanner.admin.database.v1.Backup] are eligible for filtering:
	//
	//   * `name`
	//   * `database`
	//   * `state`
	//   * `create_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
	//   * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
	//   * `size_bytes`
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic, but
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   * `name:Howl` - The backup's name contains the string "howl".
	//   * `database:prod`
	//          - The database's name contains the string "prod".
	//   * `state:CREATING` - The backup is pending creation.
	//   * `state:READY` - The backup is fully created and ready for use.
	//   * `(name:howl) AND (create_time < \"2018-03-28T14:50:00Z\")`
	//          - The backup name contains the string "howl" and `create_time`
	//              of the backup is before 2018-03-28T14:50:00Z.
	//   * `expire_time < \"2018-03-28T14:50:00Z\"`
	//          - The backup `expire_time` is before 2018-03-28T14:50:00Z.
	//   * `size_bytes > 10000000000` - The backup's size is greater than 10GB
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of backups to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListBackupsResponse.next_page_token] from a
	// previous [ListBackupsResponse][google.spanner.admin.database.v1.ListBackupsResponse] to the same `parent` and with the same
	// `filter`.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBackupsRequest) Reset()         { *m = ListBackupsRequest{} }
func (m *ListBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBackupsRequest) ProtoMessage()    {}
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{6}
}

func (m *ListBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBackupsRequest.Unmarshal(m, b)
}
func (m *ListBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBackupsRequest.Marshal(b, m, deterministic)
}
func (m *ListBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupsRequest.Merge(m, src)
}
func (m *ListBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBackupsRequest.Size(m)
}
func (m *ListBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupsRequest proto.InternalMessageInfo

func (m *ListBackupsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListBackupsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListBackupsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ListBackups][google.spanner.admin.database.v1.DatabaseAdmin.ListBackups].
type ListBackupsResponse struct {
	// The list of matching backups. Backups returned are ordered by `create_time`
	// in descending order, starting from the most recent `create_time`.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListBackups][google.spanner.admin.database.v1.DatabaseAdmin.ListBackups] call to fetch more
	// of the matching backups.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBackupsResponse) Reset()         { *m = ListBackupsResponse{} }
func (m *ListBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBackupsResponse) ProtoMessage()    {}
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{7}
}

func (m *ListBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBackupsResponse.Unmarshal(m, b)
}
func (m *ListBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBackupsResponse.Marshal(b, m, deterministic)
}
func (m *ListBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupsResponse.Merge(m, src)
}
func (m *ListBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBackupsResponse.Size(m)
}
func (m *ListBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupsResponse proto.InternalMessageInfo

func (m *ListBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations].
type ListBackupOperationsRequest struct {
	// Required. The instance of the backup operations. Values are of
	// the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that filters the list of returned backup operations.
	//
	// A filter expression consists of a field name, a
	// comparison operator, and a value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the [operation][google.longrunning.Operation]
	// are eligible for filtering:
	//
	//   * `name` - The name of the long-running operation
	//   * `done` - False if the operation is in progress, else true.
	//   * `metadata.@type` - the type of metadata. For example, the type string
	//      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
	//      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
	//   * `metadata.<field_name>` - any field in metadata.value.
	//   * `error` - Error associated with the long-running operation.
	//   * `response.@type` - the type of response.
	//   * `response.<field_name>` - any field in response.value.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic, but
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   * `done:true` - The operation is complete.
	//   * `metadata.database:prod` - The database the backup was taken from has
	//      a name containing the string "prod".
	//   * `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` <br/>
	//     `(metadata.name:howl) AND` <br/>
	//     `(metadata.progress.start_time < \"2018-03-28T14:50:00Z\") AND` <br/>
	//     `(error:*)` - Returns operations where:
	//     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
	//     * The backup name contains the string "howl".
	//     * The operation started before 2018-03-28T14:50:00Z.
	//     * The operation resulted in an error.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of operations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
	// from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
	// same `parent` and with the same `filter`.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBackupOperationsRequest) Reset()         { *m = ListBackupOperationsRequest{} }
func (m *ListBackupOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBackupOperationsRequest) ProtoMessage()    {}
func (*ListBackupOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{8}
}

func (m *ListBackupOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBackupOperationsRequest.Unmarshal(m, b)
}
func (m *ListBackupOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBackupOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListBackupOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupOperationsRequest.Merge(m, src)
}
func (m *ListBackupOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBackupOperationsRequest.Size(m)
}
func (m *ListBackupOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupOperationsRequest proto.InternalMessageInfo

func (m *ListBackupOperationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListBackupOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListBackupOperationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBackupOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations].
type ListBackupOperationsResponse struct {
	// The list of matching backup [long-running
	// operations][google.longrunning.Operation]. Each operation's name will be
	// prefixed by the backup's name and the operation's
	// [metadata][google.longrunning.Operation.metadata] will be of type
	// [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata]. Operations returned include those that are
	// pending or have completed/failed/canceled within the last 7 days.
	// Operations returned are ordered by
	// `operation.metadata.value.progress.start_time` in descending order starting
	// from the most recently started operation.
	Operations []*longrunning.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations]
	// call to fetch more of the matching metadata.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBackupOperationsResponse) Reset()         { *m = ListBackupOperationsResponse{} }
func (m *ListBackupOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBackupOperationsResponse) ProtoMessage()    {}
func (*ListBackupOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{9}
}

func (m *ListBackupOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBackupOperationsResponse.Unmarshal(m, b)
}
func (m *ListBackupOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBackupOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListBackupOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupOperationsResponse.Merge(m, src)
}
func (m *ListBackupOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBackupOperationsResponse.Size(m)
}
func (m *ListBackupOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupOperationsResponse proto.InternalMessageInfo

func (m *ListBackupOperationsResponse) GetOperations() []*longrunning.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListBackupOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Information about a backup.
type BackupInfo struct {
	// Name of the backup.
	Backup string `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// The backup contains an externally consistent copy of `source_database` at
	// the timestamp specified by `create_time`.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Name of the database the backup was created from.
	SourceDatabase       string   `protobuf:"bytes,3,opt,name=source_database,json=sourceDatabase,proto3" json:"source_database,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupInfo) Reset()         { *m = BackupInfo{} }
func (m *BackupInfo) String() string { return proto.CompactTextString(m) }
func (*BackupInfo) ProtoMessage()    {}
func (*BackupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_01041bd470c86c57, []int{10}
}

func (m *BackupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupInfo.Unmarshal(m, b)
}
func (m *BackupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupInfo.Marshal(b, m, deterministic)
}
func (m *BackupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupInfo.Merge(m, src)
}
func (m *BackupInfo) XXX_Size() int {
	return xxx_messageInfo_BackupInfo.Size(m)
}
func (m *BackupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BackupInfo proto.InternalMessageInfo

func (m *BackupInfo) GetBackup() string {
	if m != nil {
		return m.Backup
	}
	return ""
}

func (m *BackupInfo) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *BackupInfo) GetSourceDatabase() string {
	if m != nil {
		return m.SourceDatabase
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.spanner.admin.database.v1.Backup_State", Backup_State_name, Backup_State_value)
	proto.RegisterType((*Backup)(nil), "google.spanner.admin.database.v1.Backup")
	proto.RegisterType((*CreateBackupRequest)(nil), "google.spanner.admin.database.v1.CreateBackupRequest")
	proto.RegisterType((*CreateBackupMetadata)(nil), "google.spanner.admin.database.v1.CreateBackupMetadata")
	proto.RegisterType((*UpdateBackupRequest)(nil), "google.spanner.admin.database.v1.UpdateBackupRequest")
	proto.RegisterType((*GetBackupRequest)(nil), "google.spanner.admin.database.v1.GetBackupRequest")
	proto.RegisterType((*DeleteBackupRequest)(nil), "google.spanner.admin.database.v1.DeleteBackupRequest")
	proto.RegisterType((*ListBackupsRequest)(nil), "google.spanner.admin.database.v1.ListBackupsRequest")
	proto.RegisterType((*ListBackupsResponse)(nil), "google.spanner.admin.database.v1.ListBackupsResponse")
	proto.RegisterType((*ListBackupOperationsRequest)(nil), "google.spanner.admin.database.v1.ListBackupOperationsRequest")
	proto.RegisterType((*ListBackupOperationsResponse)(nil), "google.spanner.admin.database.v1.ListBackupOperationsResponse")
	proto.RegisterType((*BackupInfo)(nil), "google.spanner.admin.database.v1.BackupInfo")
}

func init() {
	proto.RegisterFile("google/spanner/admin/database/v1/backup.proto", fileDescriptor_01041bd470c86c57)
}

var fileDescriptor_01041bd470c86c57 = []byte{
	// 973 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0x67, 0xec, 0xd8, 0xb5, 0x5f, 0xa0, 0x0d, 0x93, 0x16, 0x19, 0xb7, 0x51, 0x8c, 0x29, 0xad,
	0x2f, 0xec, 0x2a, 0xed, 0x81, 0x42, 0x84, 0xa8, 0x9d, 0xb8, 0xc1, 0x12, 0x69, 0xad, 0xb5, 0x5b,
	0xa9, 0xc8, 0x92, 0x35, 0x5e, 0x8f, 0x97, 0x25, 0xde, 0x99, 0x65, 0x67, 0x1c, 0x95, 0x46, 0x39,
	0x70, 0xe0, 0xc2, 0x77, 0x80, 0x3b, 0x1c, 0xf9, 0x02, 0xdc, 0xb9, 0x21, 0xf1, 0x01, 0x72, 0xe6,
	0x23, 0x70, 0x42, 0xf3, 0x67, 0xed, 0x4d, 0x48, 0x71, 0x50, 0x38, 0x70, 0x1b, 0xbf, 0xfd, 0xbd,
	0xdf, 0xfc, 0xe6, 0xf7, 0xde, 0x9b, 0x31, 0xbc, 0x1f, 0x70, 0x1e, 0x4c, 0xa9, 0x2b, 0x62, 0xc2,
	0x18, 0x4d, 0x5c, 0x32, 0x8e, 0x42, 0xe6, 0x8e, 0x89, 0x24, 0x23, 0x22, 0xa8, 0x7b, 0xb8, 0xe5,
	0x8e, 0x88, 0x7f, 0x30, 0x8b, 0x9d, 0x38, 0xe1, 0x92, 0xe3, 0x9a, 0x81, 0x3b, 0x16, 0xee, 0x68,
	0xb8, 0x93, 0xc2, 0x9d, 0xc3, 0xad, 0xea, 0xa6, 0x25, 0x24, 0x71, 0xe8, 0x4e, 0x42, 0x3a, 0x1d,
	0x0f, 0x47, 0xf4, 0x0b, 0x72, 0x18, 0xf2, 0xc4, 0x50, 0x54, 0xdf, 0xce, 0x00, 0x12, 0x2a, 0xf8,
	0x2c, 0xf1, 0xa9, 0xfd, 0xf4, 0xae, 0xfd, 0x34, 0xe5, 0x2c, 0x48, 0x66, 0x8c, 0x85, 0x2c, 0x70,
	0x79, 0x4c, 0x13, 0x22, 0x43, 0xce, 0x84, 0x05, 0x59, 0x09, 0xae, 0xfe, 0x35, 0x9a, 0x4d, 0xec,
	0x2e, 0x11, 0x11, 0x07, 0x16, 0xb1, 0x79, 0x16, 0x21, 0xc3, 0x88, 0x0a, 0x49, 0x22, 0x7b, 0x8a,
	0xea, 0xf2, 0x43, 0xfb, 0x3c, 0x8a, 0x38, 0xb3, 0xf0, 0x5b, 0x19, 0xc5, 0x84, 0x31, 0x2e, 0xb3,
	0x7a, 0xea, 0xdf, 0xaf, 0x40, 0xb1, 0xa5, 0x3d, 0xc2, 0x0f, 0xa1, 0x94, 0x92, 0x54, 0x72, 0x35,
	0xd4, 0x28, 0xb7, 0x6e, 0xff, 0xd9, 0x7c, 0x07, 0x36, 0x53, 0xb7, 0x0c, 0x0f, 0x89, 0x43, 0xe1,
	0xf8, 0x3c, 0x72, 0x77, 0x2d, 0xd6, 0x9b, 0x67, 0xe1, 0x6d, 0x58, 0xa5, 0x2f, 0xe2, 0x30, 0xa1,
	0x43, 0xa5, 0xb9, 0x92, 0xaf, 0xa1, 0xc6, 0xea, 0xbd, 0xaa, 0x4d, 0x74, 0xd2, 0x03, 0x39, 0xfd,
	0xf4, 0x40, 0x1e, 0x18, 0xb8, 0x0a, 0x60, 0x0c, 0x2b, 0x8c, 0x44, 0xb4, 0x82, 0xd4, 0xd6, 0x9e,
	0x5e, 0xe3, 0x87, 0xb0, 0xea, 0x27, 0x94, 0x48, 0x4b, 0xb8, 0xb2, 0x8c, 0xb0, 0x95, 0x3f, 0x69,
	0xe6, 0x3d, 0x30, 0x39, 0x9a, 0xb5, 0x0e, 0x20, 0xc2, 0x97, 0x74, 0x38, 0xfa, 0x5a, 0x52, 0x51,
	0x29, 0xd4, 0x50, 0x23, 0x6f, 0x40, 0x65, 0x15, 0x6e, 0xa9, 0x28, 0xee, 0x40, 0x41, 0x48, 0x22,
	0x69, 0xa5, 0x58, 0x43, 0x8d, 0xab, 0xf7, 0x1c, 0x67, 0x59, 0x9b, 0x38, 0xc6, 0x31, 0xa7, 0xa7,
	0xb2, 0x0c, 0x9d, 0x61, 0xc0, 0x0f, 0xe0, 0x46, 0x42, 0x27, 0x34, 0xa1, 0xcc, 0x0f, 0x59, 0x30,
	0x4c, 0x73, 0x44, 0xe5, 0x4a, 0x2d, 0xdf, 0x28, 0x1b, 0xe8, 0xf5, 0x0c, 0x22, 0x35, 0x51, 0xd4,
	0x3f, 0x80, 0x82, 0xa6, 0xc3, 0x37, 0xe0, 0xcd, 0x5e, 0xbf, 0xd9, 0x6f, 0x0f, 0x9f, 0x3e, 0xee,
	0x75, 0xdb, 0x3b, 0x9d, 0x47, 0x9d, 0xf6, 0xee, 0xda, 0x6b, 0xf8, 0x75, 0x28, 0xed, 0x78, 0xed,
	0x66, 0xbf, 0xf3, 0x78, 0x6f, 0x0d, 0xe1, 0x32, 0x14, 0xbc, 0x76, 0x73, 0xf7, 0xf9, 0x5a, 0xee,
	0xa3, 0xc1, 0x1f, 0xcd, 0xe7, 0xb0, 0xf1, 0x8a, 0x22, 0xd9, 0xd2, 0x3e, 0x88, 0x13, 0xfe, 0x25,
	0xf5, 0xa5, 0x70, 0x8f, 0xec, 0xea, 0xd8, 0x0d, 0x99, 0x90, 0x84, 0xf9, 0x54, 0xb8, 0x47, 0xe9,
	0xf2, 0xd8, 0x8e, 0x8b, 0x70, 0x8f, 0xcc, 0xe2, 0xb8, 0xfe, 0x0b, 0x82, 0xf5, 0x1d, 0x6d, 0xa7,
	0xa1, 0xf2, 0xe8, 0x57, 0x33, 0x2a, 0x24, 0xfe, 0x04, 0x8a, 0x31, 0x49, 0x28, 0x93, 0xa6, 0x5e,
	0xad, 0xbb, 0x27, 0xcd, 0xdc, 0x3f, 0x75, 0x4b, 0xc7, 0x6e, 0xe1, 0xd9, 0x34, 0x5c, 0x83, 0xb2,
	0xd9, 0x63, 0x18, 0x8e, 0x6d, 0xbb, 0xe5, 0x4f, 0x9a, 0x39, 0xaf, 0x64, 0xa2, 0x9d, 0x31, 0x6e,
	0x43, 0xd1, 0xac, 0x6d, 0x23, 0x35, 0x2e, 0x5a, 0x17, 0x43, 0x64, 0x93, 0xeb, 0xbf, 0x23, 0xb8,
	0x9e, 0x3d, 0xc1, 0x3e, 0x95, 0x44, 0xe5, 0x9c, 0xdb, 0x70, 0xd5, 0xb3, 0x33, 0x90, 0xe9, 0xee,
	0x27, 0x50, 0x8a, 0x13, 0x1e, 0x24, 0x54, 0x08, 0xab, 0xe8, 0xfe, 0x72, 0x45, 0x4f, 0xd2, 0x0b,
	0xa0, 0x6b, 0x53, 0xbd, 0x39, 0x89, 0x1a, 0x17, 0x5f, 0x79, 0x32, 0xbd, 0x60, 0x77, 0x7b, 0x60,
	0xe0, 0x2a, 0x50, 0xff, 0x01, 0xc1, 0xfa, 0xd3, 0x78, 0xfc, 0xb7, 0xc2, 0x2c, 0x5c, 0x43, 0x97,
	0x70, 0x4d, 0x4d, 0xde, 0x4c, 0xb3, 0xeb, 0xab, 0x49, 0x7b, 0x71, 0x9e, 0xb6, 0x47, 0xea, 0xf6,
	0xda, 0x27, 0xe2, 0xc0, 0x64, 0x83, 0xc9, 0x51, 0x81, 0xfa, 0x3e, 0xac, 0xed, 0x51, 0x79, 0x5a,
	0xdc, 0x87, 0x59, 0xcb, 0x5b, 0xef, 0xe9, 0x9e, 0xd9, 0x5c, 0xd2, 0xbc, 0xa6, 0x32, 0xf5, 0x2e,
	0xac, 0xef, 0xd2, 0x29, 0x3d, 0x7b, 0xdc, 0x4b, 0x30, 0xfe, 0x88, 0x00, 0x7f, 0x16, 0x0a, 0x2b,
	0x51, 0xfc, 0x67, 0x9d, 0xfd, 0x16, 0x14, 0x27, 0xe1, 0x54, 0xd2, 0xc4, 0x76, 0x90, 0xfd, 0x85,
	0x6f, 0x42, 0x39, 0x26, 0x01, 0x1d, 0xaa, 0x8b, 0x47, 0x37, 0x50, 0xc1, 0x2b, 0xa9, 0x40, 0x2f,
	0x7c, 0x49, 0xf1, 0x06, 0x80, 0xfe, 0x28, 0xf9, 0x01, 0x65, 0xba, 0x15, 0xca, 0x9e, 0x86, 0xf7,
	0x55, 0xa0, 0xfe, 0x0d, 0x82, 0xf5, 0x53, 0x5a, 0x45, 0xcc, 0x99, 0xa0, 0xb8, 0x05, 0x57, 0xec,
	0xc8, 0x56, 0x50, 0x2d, 0xff, 0x6f, 0xca, 0xed, 0xa5, 0x89, 0xf8, 0x0e, 0x5c, 0x63, 0xf4, 0x85,
	0x1c, 0x66, 0xf6, 0x37, 0xc2, 0xdf, 0x50, 0xe1, 0xee, 0x5c, 0xc3, 0xcf, 0x08, 0x6e, 0x2e, 0x34,
	0xcc, 0x1b, 0xfb, 0xff, 0x6d, 0xdc, 0xb7, 0x08, 0x6e, 0x9d, 0x2f, 0xda, 0x3a, 0xf8, 0x31, 0xc0,
	0xe2, 0x91, 0xb6, 0x26, 0x6e, 0xa4, 0x26, 0x66, 0x9e, 0xf2, 0xc5, 0x24, 0x7b, 0x99, 0x84, 0x0b,
	0x9b, 0xf7, 0x1d, 0x02, 0x30, 0x1a, 0x3a, 0x6c, 0xc2, 0xd5, 0x51, 0x33, 0x53, 0x5a, 0x9e, 0x8f,
	0xdd, 0xf6, 0xe9, 0x07, 0x2f, 0x77, 0x81, 0x2b, 0x61, 0xf1, 0xd6, 0xdd, 0x85, 0x6b, 0xe6, 0x0f,
	0xc9, 0xfc, 0xdd, 0xd1, 0x6e, 0x95, 0xbd, 0xab, 0x26, 0x9c, 0x3e, 0x36, 0xad, 0xdf, 0x10, 0xdc,
	0xf6, 0x79, 0xb4, 0xb4, 0x55, 0x5a, 0xab, 0x46, 0x72, 0x57, 0xed, 0xdb, 0x45, 0x9f, 0x7f, 0x6a,
	0x13, 0x02, 0x3e, 0x25, 0x2c, 0x70, 0x78, 0x12, 0xb8, 0x01, 0x65, 0x5a, 0x95, 0xbb, 0x28, 0xee,
	0xab, 0xff, 0x98, 0x6c, 0xa7, 0xeb, 0x9f, 0x72, 0x77, 0xf6, 0x0c, 0xd5, 0xce, 0x94, 0xcf, 0xc6,
	0x4e, 0xcf, 0x2a, 0x68, 0x6a, 0x05, 0xa9, 0x4e, 0xe7, 0xd9, 0xd6, 0xaf, 0x29, 0x70, 0xa0, 0x81,
	0x03, 0x0b, 0x1c, 0x68, 0xe0, 0x20, 0x05, 0x0e, 0x9e, 0x6d, 0x8d, 0x8a, 0x5a, 0xc6, 0xfd, 0xbf,
	0x02, 0x00, 0x00, 0xff, 0xff, 0x62, 0x5f, 0x5b, 0x08, 0x13, 0x0a, 0x00, 0x00,
}
