// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_connection_impl.h"
#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace baremetalsolution_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<baremetalsolution_v2::BareMetalSolutionRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<baremetalsolution_v2::BareMetalSolutionBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    baremetalsolution_v2::BareMetalSolutionConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<baremetalsolution_v2::
               BareMetalSolutionConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<baremetalsolution_v2::BareMetalSolutionPollingPolicyOption>()
      ->clone();
}

}  // namespace

BareMetalSolutionConnectionImpl::BareMetalSolutionConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<baremetalsolution_v2_internal::BareMetalSolutionStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), BareMetalSolutionConnection::options())) {}

StreamRange<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionConnectionImpl::ListInstances(
    google::cloud::baremetalsolution::v2::ListInstancesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListInstances(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Instance>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListInstancesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::baremetalsolution::v2::
                       ListInstancesRequest const& request) {
              return stub->ListInstances(context, request);
            },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListInstancesResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::Instance> result(
            r.instances().size());
        auto& messages = *r.mutable_instances();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionConnectionImpl::GetInstance(
    google::cloud::baremetalsolution::v2::GetInstanceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetInstance(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::GetInstanceRequest const&
                 request) { return stub_->GetInstance(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionConnectionImpl::UpdateInstance(
    google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::Instance>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
              request) {
        return stub->AsyncUpdateInstance(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::Instance>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateInstance(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionConnectionImpl::RenameInstance(
    google::cloud::baremetalsolution::v2::RenameInstanceRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RenameInstance(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::RenameInstanceRequest const&
                 request) { return stub_->RenameInstance(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
BareMetalSolutionConnectionImpl::ResetInstance(
    google::cloud::baremetalsolution::v2::ResetInstanceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::ResetInstanceResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::ResetInstanceRequest const&
              request) {
        return stub->AsyncResetInstance(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::ResetInstanceResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResetInstance(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
BareMetalSolutionConnectionImpl::StartInstance(
    google::cloud::baremetalsolution::v2::StartInstanceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::StartInstanceResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::StartInstanceRequest const&
              request) {
        return stub->AsyncStartInstance(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::StartInstanceResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StartInstance(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
BareMetalSolutionConnectionImpl::StopInstance(
    google::cloud::baremetalsolution::v2::StopInstanceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::StopInstanceResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::StopInstanceRequest const&
              request) {
        return stub->AsyncStopInstance(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::StopInstanceResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StopInstance(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    EnableInteractiveSerialConsoleResponse>>
BareMetalSolutionConnectionImpl::EnableInteractiveSerialConsole(
    google::cloud::baremetalsolution::v2::
        EnableInteractiveSerialConsoleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::
          EnableInteractiveSerialConsoleResponse>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::baremetalsolution::v2::
                         EnableInteractiveSerialConsoleRequest const& request) {
        return stub->AsyncEnableInteractiveSerialConsole(cq, std::move(context),
                                                         options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::
              EnableInteractiveSerialConsoleResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EnableInteractiveSerialConsole(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    DisableInteractiveSerialConsoleResponse>>
BareMetalSolutionConnectionImpl::DisableInteractiveSerialConsole(
    google::cloud::baremetalsolution::v2::
        DisableInteractiveSerialConsoleRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::
          DisableInteractiveSerialConsoleResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::
              DisableInteractiveSerialConsoleRequest const& request) {
        return stub->AsyncDisableInteractiveSerialConsole(
            cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::
              DisableInteractiveSerialConsoleResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DisableInteractiveSerialConsole(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionConnectionImpl::DetachLun(
    google::cloud::baremetalsolution::v2::DetachLunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::Instance>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::DetachLunRequest const&
              request) {
        return stub->AsyncDetachLun(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::Instance>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DetachLun(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionConnectionImpl::ListSSHKeys(
    google::cloud::baremetalsolution::v2::ListSSHKeysRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSSHKeys(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::SSHKey>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListSSHKeysRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::baremetalsolution::v2::ListSSHKeysRequest const&
                    request) { return stub->ListSSHKeys(context, request); },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListSSHKeysResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::SSHKey> result(
            r.ssh_keys().size());
        auto& messages = *r.mutable_ssh_keys();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionConnectionImpl::CreateSSHKey(
    google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSSHKey(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const&
                 request) { return stub_->CreateSSHKey(context, request); },
      request, __func__);
}

Status BareMetalSolutionConnectionImpl::DeleteSSHKey(
    google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSSHKey(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const&
                 request) { return stub_->DeleteSSHKey(context, request); },
      request, __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionConnectionImpl::ListVolumes(
    google::cloud::baremetalsolution::v2::ListVolumesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListVolumes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Volume>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListVolumesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::baremetalsolution::v2::ListVolumesRequest const&
                    request) { return stub->ListVolumes(context, request); },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListVolumesResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::Volume> result(
            r.volumes().size());
        auto& messages = *r.mutable_volumes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionConnectionImpl::GetVolume(
    google::cloud::baremetalsolution::v2::GetVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetVolume(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::GetVolumeRequest const&
                 request) { return stub_->GetVolume(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionConnectionImpl::UpdateVolume(
    google::cloud::baremetalsolution::v2::UpdateVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::Volume>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::UpdateVolumeRequest const&
              request) {
        return stub->AsyncUpdateVolume(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::Volume>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateVolume(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionConnectionImpl::RenameVolume(
    google::cloud::baremetalsolution::v2::RenameVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RenameVolume(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::RenameVolumeRequest const&
                 request) { return stub_->RenameVolume(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnectionImpl::EvictVolume(
    google::cloud::baremetalsolution::v2::EvictVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::EvictVolumeRequest const&
              request) {
        return stub->AsyncEvictVolume(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::baremetalsolution::v2::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EvictVolume(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionConnectionImpl::ResizeVolume(
    google::cloud::baremetalsolution::v2::ResizeVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::Volume>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::ResizeVolumeRequest const&
              request) {
        return stub->AsyncResizeVolume(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::Volume>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResizeVolume(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionConnectionImpl::ListNetworks(
    google::cloud::baremetalsolution::v2::ListNetworksRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNetworks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Network>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListNetworksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::baremetalsolution::v2::ListNetworksRequest const&
                    request) { return stub->ListNetworks(context, request); },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListNetworksResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::Network> result(
            r.networks().size());
        auto& messages = *r.mutable_networks();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::baremetalsolution::v2::ListNetworkUsageResponse>
BareMetalSolutionConnectionImpl::ListNetworkUsage(
    google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListNetworkUsage(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&
              request) { return stub_->ListNetworkUsage(context, request); },
      request, __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionConnectionImpl::GetNetwork(
    google::cloud::baremetalsolution::v2::GetNetworkRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNetwork(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::GetNetworkRequest const&
                 request) { return stub_->GetNetwork(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::Network>>
BareMetalSolutionConnectionImpl::UpdateNetwork(
    google::cloud::baremetalsolution::v2::UpdateNetworkRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::Network>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::UpdateNetworkRequest const&
              request) {
        return stub->AsyncUpdateNetwork(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::Network>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateNetwork(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionConnectionImpl::CreateVolumeSnapshot(
    google::cloud::baremetalsolution::v2::CreateVolumeSnapshotRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateVolumeSnapshot(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::
                 CreateVolumeSnapshotRequest const& request) {
        return stub_->CreateVolumeSnapshot(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
BareMetalSolutionConnectionImpl::RestoreVolumeSnapshot(
    google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::VolumeSnapshot>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::baremetalsolution::v2::
                         RestoreVolumeSnapshotRequest const& request) {
        return stub->AsyncRestoreVolumeSnapshot(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::VolumeSnapshot>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RestoreVolumeSnapshot(request),
      polling_policy(*current), __func__);
}

Status BareMetalSolutionConnectionImpl::DeleteVolumeSnapshot(
    google::cloud::baremetalsolution::v2::DeleteVolumeSnapshotRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteVolumeSnapshot(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::
                 DeleteVolumeSnapshotRequest const& request) {
        return stub_->DeleteVolumeSnapshot(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionConnectionImpl::GetVolumeSnapshot(
    google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetVolumeSnapshot(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&
              request) { return stub_->GetVolumeSnapshot(context, request); },
      request, __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionConnectionImpl::ListVolumeSnapshots(
    google::cloud::baremetalsolution::v2::ListVolumeSnapshotsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListVolumeSnapshots(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::
              ListVolumeSnapshotsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::baremetalsolution::v2::
                       ListVolumeSnapshotsRequest const& request) {
              return stub->ListVolumeSnapshots(context, request);
            },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListVolumeSnapshotsResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::VolumeSnapshot>
            result(r.volume_snapshots().size());
        auto& messages = *r.mutable_volume_snapshots();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionConnectionImpl::GetLun(
    google::cloud::baremetalsolution::v2::GetLunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLun(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::baremetalsolution::v2::GetLunRequest const& request) {
        return stub_->GetLun(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionConnectionImpl::ListLuns(
    google::cloud::baremetalsolution::v2::ListLunsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLuns(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Lun>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListLunsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::baremetalsolution::v2::ListLunsRequest const&
                       request) { return stub->ListLuns(context, request); },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListLunsResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::Lun> result(
            r.luns().size());
        auto& messages = *r.mutable_luns();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnectionImpl::EvictLun(
    google::cloud::baremetalsolution::v2::EvictLunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::EvictLunRequest const&
              request) {
        return stub->AsyncEvictLun(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::baremetalsolution::v2::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EvictLun(request), polling_policy(*current),
      __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionConnectionImpl::GetNfsShare(
    google::cloud::baremetalsolution::v2::GetNfsShareRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNfsShare(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::GetNfsShareRequest const&
                 request) { return stub_->GetNfsShare(context, request); },
      request, __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionConnectionImpl::ListNfsShares(
    google::cloud::baremetalsolution::v2::ListNfsSharesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNfsShares(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::NfsShare>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListNfsSharesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::baremetalsolution::v2::
                       ListNfsSharesRequest const& request) {
              return stub->ListNfsShares(context, request);
            },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListNfsSharesResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::NfsShare> result(
            r.nfs_shares().size());
        auto& messages = *r.mutable_nfs_shares();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionConnectionImpl::UpdateNfsShare(
    google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::NfsShare>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
              request) {
        return stub->AsyncUpdateNfsShare(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::NfsShare>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateNfsShare(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionConnectionImpl::CreateNfsShare(
    google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::NfsShare>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
              request) {
        return stub->AsyncCreateNfsShare(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::baremetalsolution::v2::NfsShare>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateNfsShare(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionConnectionImpl::RenameNfsShare(
    google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RenameNfsShare(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&
                 request) { return stub_->RenameNfsShare(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnectionImpl::DeleteNfsShare(
    google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::baremetalsolution::v2::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
              request) {
        return stub->AsyncDeleteNfsShare(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::baremetalsolution::v2::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteNfsShare(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>
BareMetalSolutionConnectionImpl::ListProvisioningQuotas(
    google::cloud::baremetalsolution::v2::ListProvisioningQuotasRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListProvisioningQuotas(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::
              ListProvisioningQuotasRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::baremetalsolution::v2::
                       ListProvisioningQuotasRequest const& request) {
              return stub->ListProvisioningQuotas(context, request);
            },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListProvisioningQuotasResponse
             r) {
        std::vector<google::cloud::baremetalsolution::v2::ProvisioningQuota>
            result(r.provisioning_quotas().size());
        auto& messages = *r.mutable_provisioning_quotas();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::baremetalsolution::v2::SubmitProvisioningConfigResponse>
BareMetalSolutionConnectionImpl::SubmitProvisioningConfig(
    google::cloud::baremetalsolution::v2::SubmitProvisioningConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SubmitProvisioningConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::
                 SubmitProvisioningConfigRequest const& request) {
        return stub_->SubmitProvisioningConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionConnectionImpl::GetProvisioningConfig(
    google::cloud::baremetalsolution::v2::GetProvisioningConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProvisioningConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::
                 GetProvisioningConfigRequest const& request) {
        return stub_->GetProvisioningConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionConnectionImpl::CreateProvisioningConfig(
    google::cloud::baremetalsolution::v2::CreateProvisioningConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateProvisioningConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::
                 CreateProvisioningConfigRequest const& request) {
        return stub_->CreateProvisioningConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionConnectionImpl::UpdateProvisioningConfig(
    google::cloud::baremetalsolution::v2::UpdateProvisioningConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateProvisioningConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::
                 UpdateProvisioningConfigRequest const& request) {
        return stub_->UpdateProvisioningConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionConnectionImpl::RenameNetwork(
    google::cloud::baremetalsolution::v2::RenameNetworkRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RenameNetwork(request),
      [this](grpc::ClientContext& context,
             google::cloud::baremetalsolution::v2::RenameNetworkRequest const&
                 request) { return stub_->RenameNetwork(context, request); },
      request, __func__);
}

StreamRange<google::cloud::baremetalsolution::v2::OSImage>
BareMetalSolutionConnectionImpl::ListOSImages(
    google::cloud::baremetalsolution::v2::ListOSImagesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOSImages(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::OSImage>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<baremetalsolution_v2::BareMetalSolutionRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::baremetalsolution::v2::ListOSImagesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::baremetalsolution::v2::ListOSImagesRequest const&
                    request) { return stub->ListOSImages(context, request); },
            r, function_name);
      },
      [](google::cloud::baremetalsolution::v2::ListOSImagesResponse r) {
        std::vector<google::cloud::baremetalsolution::v2::OSImage> result(
            r.os_images().size());
        auto& messages = *r.mutable_os_images();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2_internal
}  // namespace cloud
}  // namespace google
