// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/target_https_proxies/v1/target_https_proxies.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_HTTPS_PROXIES_V1_INTERNAL_TARGET_HTTPS_PROXIES_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_HTTPS_PROXIES_V1_INTERNAL_TARGET_HTTPS_PROXIES_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/target_https_proxies/v1/internal/target_https_proxies_rest_stub.h"
#include "google/cloud/compute/target_https_proxies/v1/internal/target_https_proxies_retry_traits.h"
#include "google/cloud/compute/target_https_proxies/v1/target_https_proxies_connection.h"
#include "google/cloud/compute/target_https_proxies/v1/target_https_proxies_connection_idempotency_policy.h"
#include "google/cloud/compute/target_https_proxies/v1/target_https_proxies_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_https_proxies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TargetHttpsProxiesRestConnectionImpl
    : public compute_target_https_proxies_v1::TargetHttpsProxiesConnection {
 public:
  ~TargetHttpsProxiesRestConnectionImpl() override = default;

  TargetHttpsProxiesRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          compute_target_https_proxies_v1_internal::TargetHttpsProxiesRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::TargetHttpsProxiesScopedList>>
  AggregatedListTargetHttpsProxies(
      google::cloud::cpp::compute::target_https_proxies::v1::
          AggregatedListTargetHttpsProxiesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteTargetHttpsProxy(
      google::cloud::cpp::compute::target_https_proxies::v1::
          DeleteTargetHttpsProxyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetHttpsProxy>
  GetTargetHttpsProxy(google::cloud::cpp::compute::target_https_proxies::v1::
                          GetTargetHttpsProxyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertTargetHttpsProxy(
      google::cloud::cpp::compute::target_https_proxies::v1::
          InsertTargetHttpsProxyRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::TargetHttpsProxy>
  ListTargetHttpsProxies(google::cloud::cpp::compute::target_https_proxies::v1::
                             ListTargetHttpsProxiesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchTargetHttpsProxy(
      google::cloud::cpp::compute::target_https_proxies::v1::
          PatchTargetHttpsProxyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetCertificateMap(google::cloud::cpp::compute::target_https_proxies::v1::
                        SetCertificateMapRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetQuicOverride(
      google::cloud::cpp::compute::target_https_proxies::v1::
          SetQuicOverrideRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSslCertificates(google::cloud::cpp::compute::target_https_proxies::v1::
                         SetSslCertificatesRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetSslPolicy(
      google::cloud::cpp::compute::target_https_proxies::v1::
          SetSslPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetUrlMap(
      google::cloud::cpp::compute::target_https_proxies::v1::
          SetUrlMapRequest const& request) override;

 private:
  static std::unique_ptr<
      compute_target_https_proxies_v1::TargetHttpsProxiesRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<compute_target_https_proxies_v1::
                 TargetHttpsProxiesRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_target_https_proxies_v1::
                 TargetHttpsProxiesBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<compute_target_https_proxies_v1::
                             TargetHttpsProxiesConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_target_https_proxies_v1::
                 TargetHttpsProxiesConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_target_https_proxies_v1::
                 TargetHttpsProxiesPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      compute_target_https_proxies_v1_internal::TargetHttpsProxiesRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_https_proxies_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_HTTPS_PROXIES_V1_INTERNAL_TARGET_HTTPS_PROXIES_REST_CONNECTION_IMPL_H
