// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datafusion/v1/datafusion.proto

#include "google/cloud/datafusion/v1/data_fusion_connection.h"
#include "google/cloud/datafusion/v1/data_fusion_options.h"
#include "google/cloud/datafusion/v1/internal/data_fusion_connection_impl.h"
#include "google/cloud/datafusion/v1/internal/data_fusion_option_defaults.h"
#include "google/cloud/datafusion/v1/internal/data_fusion_stub_factory.h"
#include "google/cloud/datafusion/v1/internal/data_fusion_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace datafusion_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataFusionConnection::~DataFusionConnection() = default;

StreamRange<google::cloud::datafusion::v1::Version>
DataFusionConnection::ListAvailableVersions(
    google::cloud::datafusion::v1::
        ListAvailableVersionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::datafusion::v1::Version>>();
}

StreamRange<google::cloud::datafusion::v1::Instance>
DataFusionConnection::ListInstances(
    google::cloud::datafusion::v1::
        ListInstancesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::datafusion::v1::Instance>>();
}

StatusOr<google::cloud::datafusion::v1::Instance>
DataFusionConnection::GetInstance(
    google::cloud::datafusion::v1::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::datafusion::v1::Instance>>
DataFusionConnection::CreateInstance(
    google::cloud::datafusion::v1::CreateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::datafusion::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::datafusion::v1::OperationMetadata>>
DataFusionConnection::DeleteInstance(
    google::cloud::datafusion::v1::DeleteInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::datafusion::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::datafusion::v1::Instance>>
DataFusionConnection::UpdateInstance(
    google::cloud::datafusion::v1::UpdateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::datafusion::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::datafusion::v1::Instance>>
DataFusionConnection::RestartInstance(
    google::cloud::datafusion::v1::RestartInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::datafusion::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<DataFusionConnection> MakeDataFusionConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DataFusionPolicyOptionList>(options, __func__);
  options =
      datafusion_v1_internal::DataFusionDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = datafusion_v1_internal::CreateDefaultDataFusionStub(
      background->cq(), options);
  return datafusion_v1_internal::MakeDataFusionTracingConnection(
      std::make_shared<datafusion_v1_internal::DataFusionConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datafusion_v1
}  // namespace cloud
}  // namespace google
