// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datafusion/v1/datafusion.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAFUSION_V1_INTERNAL_DATA_FUSION_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAFUSION_V1_INTERNAL_DATA_FUSION_CONNECTION_IMPL_H

#include "google/cloud/datafusion/v1/data_fusion_connection.h"
#include "google/cloud/datafusion/v1/data_fusion_connection_idempotency_policy.h"
#include "google/cloud/datafusion/v1/data_fusion_options.h"
#include "google/cloud/datafusion/v1/internal/data_fusion_retry_traits.h"
#include "google/cloud/datafusion/v1/internal/data_fusion_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datafusion_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataFusionConnectionImpl : public datafusion_v1::DataFusionConnection {
 public:
  ~DataFusionConnectionImpl() override = default;

  DataFusionConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<datafusion_v1_internal::DataFusionStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::datafusion::v1::Version> ListAvailableVersions(
      google::cloud::datafusion::v1::ListAvailableVersionsRequest request)
      override;

  StreamRange<google::cloud::datafusion::v1::Instance> ListInstances(
      google::cloud::datafusion::v1::ListInstancesRequest request) override;

  StatusOr<google::cloud::datafusion::v1::Instance> GetInstance(
      google::cloud::datafusion::v1::GetInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::datafusion::v1::Instance>> CreateInstance(
      google::cloud::datafusion::v1::CreateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::datafusion::v1::OperationMetadata>>
  DeleteInstance(google::cloud::datafusion::v1::DeleteInstanceRequest const&
                     request) override;

  future<StatusOr<google::cloud::datafusion::v1::Instance>> UpdateInstance(
      google::cloud::datafusion::v1::UpdateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::datafusion::v1::Instance>> RestartInstance(
      google::cloud::datafusion::v1::RestartInstanceRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<datafusion_v1_internal::DataFusionStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datafusion_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAFUSION_V1_INTERNAL_DATA_FUSION_CONNECTION_IMPL_H
