// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/entity_type.proto

#include "google/cloud/dialogflow_cx/entity_types_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EntityTypesClient::EntityTypesClient(
    std::shared_ptr<EntityTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EntityTypesClient::~EntityTypesClient() = default;

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::GetEntityType(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetEntityTypeRequest request;
  request.set_name(name);
  return connection_->GetEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::GetEntityType(
    google::cloud::dialogflow::cx::v3::GetEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::CreateEntityType(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::EntityType const& entity_type,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateEntityTypeRequest request;
  request.set_parent(parent);
  *request.mutable_entity_type() = entity_type;
  return connection_->CreateEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::CreateEntityType(
    google::cloud::dialogflow::cx::v3::CreateEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::UpdateEntityType(
    google::cloud::dialogflow::cx::v3::EntityType const& entity_type,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateEntityTypeRequest request;
  *request.mutable_entity_type() = entity_type;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::UpdateEntityType(
    google::cloud::dialogflow::cx::v3::UpdateEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEntityType(request);
}

Status EntityTypesClient::DeleteEntityType(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteEntityTypeRequest request;
  request.set_name(name);
  return connection_->DeleteEntityType(request);
}

Status EntityTypesClient::DeleteEntityType(
    google::cloud::dialogflow::cx::v3::DeleteEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEntityType(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::ListEntityTypes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListEntityTypesRequest request;
  request.set_parent(parent);
  return connection_->ListEntityTypes(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::EntityType>
EntityTypesClient::ListEntityTypes(
    google::cloud::dialogflow::cx::v3::ListEntityTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEntityTypes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
