// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

#include "google/cloud/netapp/v1/internal/net_app_connection_impl.h"
#include "google/cloud/netapp/v1/internal/net_app_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace netapp_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<netapp_v1::NetAppRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<netapp_v1::NetAppRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<netapp_v1::NetAppBackoffPolicyOption>()->clone();
}

std::unique_ptr<netapp_v1::NetAppConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<netapp_v1::NetAppConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<netapp_v1::NetAppPollingPolicyOption>()->clone();
}

}  // namespace

NetAppConnectionImpl::NetAppConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<netapp_v1_internal::NetAppStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      NetAppConnection::options())) {}

StreamRange<google::cloud::netapp::v1::StoragePool>
NetAppConnectionImpl::ListStoragePools(
    google::cloud::netapp::v1::ListStoragePoolsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListStoragePools(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::netapp::v1::StoragePool>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<netapp_v1::NetAppRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::netapp::v1::ListStoragePoolsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::netapp::v1::ListStoragePoolsRequest const&
                       request) {
              return stub->ListStoragePools(context, request);
            },
            r, function_name);
      },
      [](google::cloud::netapp::v1::ListStoragePoolsResponse r) {
        std::vector<google::cloud::netapp::v1::StoragePool> result(
            r.storage_pools().size());
        auto& messages = *r.mutable_storage_pools();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppConnectionImpl::CreateStoragePool(
    google::cloud::netapp::v1::CreateStoragePoolRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::StoragePool>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::CreateStoragePoolRequest const& request) {
        return stub->AsyncCreateStoragePool(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::StoragePool>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateStoragePool(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::netapp::v1::StoragePool>
NetAppConnectionImpl::GetStoragePool(
    google::cloud::netapp::v1::GetStoragePoolRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetStoragePool(request),
      [this](grpc::ClientContext& context,
             google::cloud::netapp::v1::GetStoragePoolRequest const& request) {
        return stub_->GetStoragePool(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::StoragePool>>
NetAppConnectionImpl::UpdateStoragePool(
    google::cloud::netapp::v1::UpdateStoragePoolRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::StoragePool>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::UpdateStoragePoolRequest const& request) {
        return stub->AsyncUpdateStoragePool(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::StoragePool>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateStoragePool(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppConnectionImpl::DeleteStoragePool(
    google::cloud::netapp::v1::DeleteStoragePoolRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::DeleteStoragePoolRequest const& request) {
        return stub->AsyncDeleteStoragePool(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::netapp::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteStoragePool(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::netapp::v1::Volume>
NetAppConnectionImpl::ListVolumes(
    google::cloud::netapp::v1::ListVolumesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListVolumes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::netapp::v1::Volume>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<netapp_v1::NetAppRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::netapp::v1::ListVolumesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::netapp::v1::ListVolumesRequest const& request) {
              return stub->ListVolumes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::netapp::v1::ListVolumesResponse r) {
        std::vector<google::cloud::netapp::v1::Volume> result(
            r.volumes().size());
        auto& messages = *r.mutable_volumes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::netapp::v1::Volume> NetAppConnectionImpl::GetVolume(
    google::cloud::netapp::v1::GetVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetVolume(request),
      [this](grpc::ClientContext& context,
             google::cloud::netapp::v1::GetVolumeRequest const& request) {
        return stub_->GetVolume(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppConnectionImpl::CreateVolume(
    google::cloud::netapp::v1::CreateVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Volume>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::CreateVolumeRequest const& request) {
        return stub->AsyncCreateVolume(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Volume>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateVolume(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppConnectionImpl::UpdateVolume(
    google::cloud::netapp::v1::UpdateVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Volume>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::UpdateVolumeRequest const& request) {
        return stub->AsyncUpdateVolume(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Volume>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateVolume(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppConnectionImpl::DeleteVolume(
    google::cloud::netapp::v1::DeleteVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::DeleteVolumeRequest const& request) {
        return stub->AsyncDeleteVolume(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::netapp::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteVolume(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Volume>>
NetAppConnectionImpl::RevertVolume(
    google::cloud::netapp::v1::RevertVolumeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Volume>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::RevertVolumeRequest const& request) {
        return stub->AsyncRevertVolume(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Volume>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RevertVolume(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::netapp::v1::Snapshot>
NetAppConnectionImpl::ListSnapshots(
    google::cloud::netapp::v1::ListSnapshotsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSnapshots(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::netapp::v1::Snapshot>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<netapp_v1::NetAppRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::netapp::v1::ListSnapshotsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::netapp::v1::ListSnapshotsRequest const&
                       request) {
              return stub->ListSnapshots(context, request);
            },
            r, function_name);
      },
      [](google::cloud::netapp::v1::ListSnapshotsResponse r) {
        std::vector<google::cloud::netapp::v1::Snapshot> result(
            r.snapshots().size());
        auto& messages = *r.mutable_snapshots();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::netapp::v1::Snapshot> NetAppConnectionImpl::GetSnapshot(
    google::cloud::netapp::v1::GetSnapshotRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSnapshot(request),
      [this](grpc::ClientContext& context,
             google::cloud::netapp::v1::GetSnapshotRequest const& request) {
        return stub_->GetSnapshot(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppConnectionImpl::CreateSnapshot(
    google::cloud::netapp::v1::CreateSnapshotRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Snapshot>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::CreateSnapshotRequest const& request) {
        return stub->AsyncCreateSnapshot(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Snapshot>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSnapshot(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppConnectionImpl::DeleteSnapshot(
    google::cloud::netapp::v1::DeleteSnapshotRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::DeleteSnapshotRequest const& request) {
        return stub->AsyncDeleteSnapshot(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::netapp::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSnapshot(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Snapshot>>
NetAppConnectionImpl::UpdateSnapshot(
    google::cloud::netapp::v1::UpdateSnapshotRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Snapshot>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::UpdateSnapshotRequest const& request) {
        return stub->AsyncUpdateSnapshot(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Snapshot>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSnapshot(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::netapp::v1::ActiveDirectory>
NetAppConnectionImpl::ListActiveDirectories(
    google::cloud::netapp::v1::ListActiveDirectoriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListActiveDirectories(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::netapp::v1::ActiveDirectory>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<netapp_v1::NetAppRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::netapp::v1::ListActiveDirectoriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::netapp::v1::ListActiveDirectoriesRequest const&
                    request) {
              return stub->ListActiveDirectories(context, request);
            },
            r, function_name);
      },
      [](google::cloud::netapp::v1::ListActiveDirectoriesResponse r) {
        std::vector<google::cloud::netapp::v1::ActiveDirectory> result(
            r.active_directories().size());
        auto& messages = *r.mutable_active_directories();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::netapp::v1::ActiveDirectory>
NetAppConnectionImpl::GetActiveDirectory(
    google::cloud::netapp::v1::GetActiveDirectoryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetActiveDirectory(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::netapp::v1::GetActiveDirectoryRequest const& request) {
        return stub_->GetActiveDirectory(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppConnectionImpl::CreateActiveDirectory(
    google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::ActiveDirectory>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::CreateActiveDirectoryRequest const&
              request) {
        return stub->AsyncCreateActiveDirectory(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::ActiveDirectory>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateActiveDirectory(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::ActiveDirectory>>
NetAppConnectionImpl::UpdateActiveDirectory(
    google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::ActiveDirectory>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::UpdateActiveDirectoryRequest const&
              request) {
        return stub->AsyncUpdateActiveDirectory(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::ActiveDirectory>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateActiveDirectory(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppConnectionImpl::DeleteActiveDirectory(
    google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::DeleteActiveDirectoryRequest const&
              request) {
        return stub->AsyncDeleteActiveDirectory(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::netapp::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteActiveDirectory(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::netapp::v1::KmsConfig>
NetAppConnectionImpl::ListKmsConfigs(
    google::cloud::netapp::v1::ListKmsConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListKmsConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::netapp::v1::KmsConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<netapp_v1::NetAppRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::netapp::v1::ListKmsConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::netapp::v1::ListKmsConfigsRequest const&
                       request) {
              return stub->ListKmsConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::netapp::v1::ListKmsConfigsResponse r) {
        std::vector<google::cloud::netapp::v1::KmsConfig> result(
            r.kms_configs().size());
        auto& messages = *r.mutable_kms_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppConnectionImpl::CreateKmsConfig(
    google::cloud::netapp::v1::CreateKmsConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::KmsConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::CreateKmsConfigRequest const& request) {
        return stub->AsyncCreateKmsConfig(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::KmsConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateKmsConfig(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::netapp::v1::KmsConfig>
NetAppConnectionImpl::GetKmsConfig(
    google::cloud::netapp::v1::GetKmsConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetKmsConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::netapp::v1::GetKmsConfigRequest const& request) {
        return stub_->GetKmsConfig(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppConnectionImpl::UpdateKmsConfig(
    google::cloud::netapp::v1::UpdateKmsConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::KmsConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::UpdateKmsConfigRequest const& request) {
        return stub->AsyncUpdateKmsConfig(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::KmsConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateKmsConfig(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::KmsConfig>>
NetAppConnectionImpl::EncryptVolumes(
    google::cloud::netapp::v1::EncryptVolumesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::KmsConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::EncryptVolumesRequest const& request) {
        return stub->AsyncEncryptVolumes(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::KmsConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EncryptVolumes(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::netapp::v1::VerifyKmsConfigResponse>
NetAppConnectionImpl::VerifyKmsConfig(
    google::cloud::netapp::v1::VerifyKmsConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->VerifyKmsConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::netapp::v1::VerifyKmsConfigRequest const& request) {
        return stub_->VerifyKmsConfig(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppConnectionImpl::DeleteKmsConfig(
    google::cloud::netapp::v1::DeleteKmsConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::DeleteKmsConfigRequest const& request) {
        return stub->AsyncDeleteKmsConfig(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::netapp::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteKmsConfig(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::netapp::v1::Replication>
NetAppConnectionImpl::ListReplications(
    google::cloud::netapp::v1::ListReplicationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReplications(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::netapp::v1::Replication>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<netapp_v1::NetAppRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::netapp::v1::ListReplicationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::netapp::v1::ListReplicationsRequest const&
                       request) {
              return stub->ListReplications(context, request);
            },
            r, function_name);
      },
      [](google::cloud::netapp::v1::ListReplicationsResponse r) {
        std::vector<google::cloud::netapp::v1::Replication> result(
            r.replications().size());
        auto& messages = *r.mutable_replications();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::netapp::v1::Replication>
NetAppConnectionImpl::GetReplication(
    google::cloud::netapp::v1::GetReplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetReplication(request),
      [this](grpc::ClientContext& context,
             google::cloud::netapp::v1::GetReplicationRequest const& request) {
        return stub_->GetReplication(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppConnectionImpl::CreateReplication(
    google::cloud::netapp::v1::CreateReplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Replication>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::CreateReplicationRequest const& request) {
        return stub->AsyncCreateReplication(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Replication>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateReplication(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::OperationMetadata>>
NetAppConnectionImpl::DeleteReplication(
    google::cloud::netapp::v1::DeleteReplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::DeleteReplicationRequest const& request) {
        return stub->AsyncDeleteReplication(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::netapp::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteReplication(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppConnectionImpl::UpdateReplication(
    google::cloud::netapp::v1::UpdateReplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Replication>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::UpdateReplicationRequest const& request) {
        return stub->AsyncUpdateReplication(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Replication>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateReplication(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppConnectionImpl::StopReplication(
    google::cloud::netapp::v1::StopReplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Replication>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::StopReplicationRequest const& request) {
        return stub->AsyncStopReplication(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Replication>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StopReplication(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppConnectionImpl::ResumeReplication(
    google::cloud::netapp::v1::ResumeReplicationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Replication>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::ResumeReplicationRequest const& request) {
        return stub->AsyncResumeReplication(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Replication>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResumeReplication(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::netapp::v1::Replication>>
NetAppConnectionImpl::ReverseReplicationDirection(
    google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::netapp::v1::Replication>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
              request) {
        return stub->AsyncReverseReplicationDirection(cq, std::move(context),
                                                      options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::netapp::v1::Replication>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ReverseReplicationDirection(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace netapp_v1_internal
}  // namespace cloud
}  // namespace google
