// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policysimulator/v1/simulator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYSIMULATOR_V1_SIMULATOR_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYSIMULATOR_V1_SIMULATOR_CLIENT_H

#include "google/cloud/policysimulator/v1/simulator_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace policysimulator_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Policy Simulator API service.
///
/// Policy Simulator is a collection of endpoints for creating, running, and
/// viewing a [Replay][google.cloud.policysimulator.v1.Replay]. A
/// [Replay][google.cloud.policysimulator.v1.Replay] is a type of simulation
/// that lets you see how your principals' access to resources might change if
/// you changed your IAM policy.
///
/// During a [Replay][google.cloud.policysimulator.v1.Replay], Policy Simulator
/// re-evaluates, or replays, past access attempts under both the current policy
/// and  your proposed policy, and compares those results to determine how your
/// principals' access might change under the proposed policy.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.policysimulator.v1.Replay]:
/// @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
///
class SimulatorClient {
 public:
  explicit SimulatorClient(std::shared_ptr<SimulatorConnection> connection,
                           Options opts = {});
  ~SimulatorClient();

  ///@{
  /// @name Copy and move support
  SimulatorClient(SimulatorClient const&) = default;
  SimulatorClient& operator=(SimulatorClient const&) = default;
  SimulatorClient(SimulatorClient&&) = default;
  SimulatorClient& operator=(SimulatorClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(SimulatorClient const& a, SimulatorClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(SimulatorClient const& a, SimulatorClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Gets the specified [Replay][google.cloud.policysimulator.v1.Replay]. Each
  /// `Replay` is available for at least 7 days.
  ///
  /// @param name  Required. The name of the [Replay][google.cloud.policysimulator.v1.Replay]
  ///  to retrieve, in the following format:
  ///  @n
  ///  `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`,
  ///  where `{resource-id}` is the ID of the project, folder, or organization
  ///  that owns the `Replay`.
  ///  @n
  ///  Example:
  ///  `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.policysimulator.v1.Replay])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.policysimulator.v1.GetReplayRequest]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L255}
  /// [google.cloud.policysimulator.v1.Replay]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
  ///
  // clang-format on
  StatusOr<google::cloud::policysimulator::v1::Replay> GetReplay(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the specified [Replay][google.cloud.policysimulator.v1.Replay]. Each
  /// `Replay` is available for at least 7 days.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.policysimulator.v1.GetReplayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.policysimulator.v1.Replay])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.policysimulator.v1.GetReplayRequest]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L255}
  /// [google.cloud.policysimulator.v1.Replay]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
  ///
  // clang-format on
  StatusOr<google::cloud::policysimulator::v1::Replay> GetReplay(
      google::cloud::policysimulator::v1::GetReplayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates and starts a [Replay][google.cloud.policysimulator.v1.Replay] using
  /// the given [ReplayConfig][google.cloud.policysimulator.v1.ReplayConfig].
  ///
  /// @param parent  Required. The parent resource where this
  ///  [Replay][google.cloud.policysimulator.v1.Replay] will be created. This
  ///  resource must be a project, folder, or organization with a location.
  ///  @n
  ///  Example: `projects/my-example-project/locations/global`
  /// @param replay  Required. The [Replay][google.cloud.policysimulator.v1.Replay] to create.
  ///  Set `Replay.ReplayConfig` to configure the replay.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.policysimulator.v1.Replay] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.policysimulator.v1.CreateReplayRequest]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L234}
  /// [google.cloud.policysimulator.v1.Replay]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
  /// [google.cloud.policysimulator.v1.ReplayConfig]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L321}
  ///
  // clang-format on
  future<StatusOr<google::cloud::policysimulator::v1::Replay>> CreateReplay(
      std::string const& parent,
      google::cloud::policysimulator::v1::Replay const& replay,
      Options opts = {});

  // clang-format off
  ///
  /// Creates and starts a [Replay][google.cloud.policysimulator.v1.Replay] using
  /// the given [ReplayConfig][google.cloud.policysimulator.v1.ReplayConfig].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.policysimulator.v1.CreateReplayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.policysimulator.v1.Replay] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.policysimulator.v1.CreateReplayRequest]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L234}
  /// [google.cloud.policysimulator.v1.Replay]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
  /// [google.cloud.policysimulator.v1.ReplayConfig]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L321}
  ///
  // clang-format on
  future<StatusOr<google::cloud::policysimulator::v1::Replay>> CreateReplay(
      google::cloud::policysimulator::v1::CreateReplayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the results of running a
  /// [Replay][google.cloud.policysimulator.v1.Replay].
  ///
  /// @param parent  Required. The [Replay][google.cloud.policysimulator.v1.Replay] whose
  ///  results are listed, in the following format:
  ///  @n
  ///  `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}`
  ///  @n
  ///  Example:
  ///  `projects/my-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.policysimulator.v1.ReplayResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.policysimulator.v1.ListReplayResultsRequest]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L275}
  /// [google.cloud.policysimulator.v1.Replay]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
  /// [google.cloud.policysimulator.v1.ReplayResult]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L181}
  ///
  // clang-format on
  StreamRange<google::cloud::policysimulator::v1::ReplayResult>
  ListReplayResults(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the results of running a
  /// [Replay][google.cloud.policysimulator.v1.Replay].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.policysimulator.v1.ListReplayResultsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.policysimulator.v1.ReplayResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.policysimulator.v1.ListReplayResultsRequest]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L275}
  /// [google.cloud.policysimulator.v1.Replay]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L109}
  /// [google.cloud.policysimulator.v1.ReplayResult]: @googleapis_reference_link{google/cloud/policysimulator/v1/simulator.proto#L181}
  ///
  // clang-format on
  StreamRange<google::cloud::policysimulator::v1::ReplayResult>
  ListReplayResults(
      google::cloud::policysimulator::v1::ListReplayResultsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<SimulatorConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policysimulator_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYSIMULATOR_V1_SIMULATOR_CLIENT_H
