// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

#include "google/cloud/securesourcemanager/v1/internal/secure_source_manager_option_defaults.h"
#include "google/cloud/securesourcemanager/v1/secure_source_manager_connection.h"
#include "google/cloud/securesourcemanager/v1/secure_source_manager_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace securesourcemanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options SecureSourceManagerDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_SECURE_SOURCE_MANAGER_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_SECURE_SOURCE_MANAGER_AUTHORITY",
      "securesourcemanager.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<
          securesourcemanager_v1::SecureSourceManagerRetryPolicyOption>()) {
    options.set<securesourcemanager_v1::SecureSourceManagerRetryPolicyOption>(
        securesourcemanager_v1::SecureSourceManagerLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<
          securesourcemanager_v1::SecureSourceManagerBackoffPolicyOption>()) {
    options.set<securesourcemanager_v1::SecureSourceManagerBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<
          securesourcemanager_v1::SecureSourceManagerPollingPolicyOption>()) {
    options.set<securesourcemanager_v1::SecureSourceManagerPollingPolicyOption>(
        GenericPollingPolicy<
            securesourcemanager_v1::SecureSourceManagerRetryPolicyOption::Type,
            securesourcemanager_v1::SecureSourceManagerBackoffPolicyOption::
                Type>(
            options
                .get<securesourcemanager_v1::
                         SecureSourceManagerRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<securesourcemanager_v1::
                    SecureSourceManagerConnectionIdempotencyPolicyOption>()) {
    options.set<securesourcemanager_v1::
                    SecureSourceManagerConnectionIdempotencyPolicyOption>(
        securesourcemanager_v1::
            MakeDefaultSecureSourceManagerConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securesourcemanager_v1_internal
}  // namespace cloud
}  // namespace google
