// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_ADAPTATION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_ADAPTATION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/speech/v1/cloud_speech_adaptation.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AdaptationConnectionIdempotencyPolicy {
 public:
  virtual ~AdaptationConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<AdaptationConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency CreatePhraseSet(
      google::cloud::speech::v1::CreatePhraseSetRequest const& request);

  virtual google::cloud::Idempotency GetPhraseSet(
      google::cloud::speech::v1::GetPhraseSetRequest const& request);

  virtual google::cloud::Idempotency ListPhraseSet(
      google::cloud::speech::v1::ListPhraseSetRequest request);

  virtual google::cloud::Idempotency UpdatePhraseSet(
      google::cloud::speech::v1::UpdatePhraseSetRequest const& request);

  virtual google::cloud::Idempotency DeletePhraseSet(
      google::cloud::speech::v1::DeletePhraseSetRequest const& request);

  virtual google::cloud::Idempotency CreateCustomClass(
      google::cloud::speech::v1::CreateCustomClassRequest const& request);

  virtual google::cloud::Idempotency GetCustomClass(
      google::cloud::speech::v1::GetCustomClassRequest const& request);

  virtual google::cloud::Idempotency ListCustomClasses(
      google::cloud::speech::v1::ListCustomClassesRequest request);

  virtual google::cloud::Idempotency UpdateCustomClass(
      google::cloud::speech::v1::UpdateCustomClassRequest const& request);

  virtual google::cloud::Idempotency DeleteCustomClass(
      google::cloud::speech::v1::DeleteCustomClassRequest const& request);
};

std::unique_ptr<AdaptationConnectionIdempotencyPolicy>
MakeDefaultAdaptationConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SPEECH_V1_ADAPTATION_CONNECTION_IDEMPOTENCY_POLICY_H
