// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/internal/adaptation_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/speech/v1/cloud_speech_adaptation.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdaptationStub::~AdaptationStub() = default;

StatusOr<google::cloud::speech::v1::PhraseSet>
DefaultAdaptationStub::CreatePhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
  google::cloud::speech::v1::PhraseSet response;
  auto status = grpc_stub_->CreatePhraseSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::speech::v1::PhraseSet>
DefaultAdaptationStub::GetPhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::GetPhraseSetRequest const& request) {
  google::cloud::speech::v1::PhraseSet response;
  auto status = grpc_stub_->GetPhraseSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::speech::v1::ListPhraseSetResponse>
DefaultAdaptationStub::ListPhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::ListPhraseSetRequest const& request) {
  google::cloud::speech::v1::ListPhraseSetResponse response;
  auto status = grpc_stub_->ListPhraseSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::speech::v1::PhraseSet>
DefaultAdaptationStub::UpdatePhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
  google::cloud::speech::v1::PhraseSet response;
  auto status = grpc_stub_->UpdatePhraseSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultAdaptationStub::DeletePhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeletePhraseSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::speech::v1::CustomClass>
DefaultAdaptationStub::CreateCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::CreateCustomClassRequest const& request) {
  google::cloud::speech::v1::CustomClass response;
  auto status = grpc_stub_->CreateCustomClass(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::speech::v1::CustomClass>
DefaultAdaptationStub::GetCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::GetCustomClassRequest const& request) {
  google::cloud::speech::v1::CustomClass response;
  auto status = grpc_stub_->GetCustomClass(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::speech::v1::ListCustomClassesResponse>
DefaultAdaptationStub::ListCustomClasses(
    grpc::ClientContext& context,
    google::cloud::speech::v1::ListCustomClassesRequest const& request) {
  google::cloud::speech::v1::ListCustomClassesResponse response;
  auto status = grpc_stub_->ListCustomClasses(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::speech::v1::CustomClass>
DefaultAdaptationStub::UpdateCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
  google::cloud::speech::v1::CustomClass response;
  auto status = grpc_stub_->UpdateCustomClass(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultAdaptationStub::DeleteCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteCustomClass(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google
