/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.gcalc.calc.main.ExtensionFileFilter;
import net.gcalc.calc.main.HackHack;
import net.gcalc.calc.main.ImageSelection;
import net.gcalc.calc.main.PrintUtilities;
import net.gcalc.plugin.gui.BufferedCanvas;

public abstract class ExtendedBufferedCanvas
extends BufferedCanvas {
    protected ExtendedBufferedCanvas() {
        this(false);
    }

    protected ExtendedBufferedCanvas(boolean antialiased) {
        super(antialiased);
    }

    public void copyToClipboard() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new ImageSelection(this.image), null);
        }
        catch (AccessControlException w) {
            this.copyToClipboardJNLP();
        }
    }

    private void copyToClipboardJNLP() {
    }

    public void printImage() {
        try {
            PrintUtilities.printComponent(this);
        }
        catch (AccessControlException w) {
            this.printImageJNLP();
        }
    }

    private void printImageJNLP() {
    }

    public void saveImage() throws IOException {
        try {
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter filter = new ExtensionFileFilter("png", "Portable Network Graphics (png)");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                System.out.println(file.getAbsolutePath());
                if (!file.getName().endsWith(".png")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".png");
                }
                if (!file.exists()) {
                    this.writeImageToFile(file);
                } else if (JOptionPane.showConfirmDialog(this, "Do you want to overwrite?", "File " + file.getName() + " already exists!", 0) == 0) {
                    this.writeImageToFile(file);
                }
                System.out.println(file.getAbsolutePath());
            }
        }
        catch (AccessControlException w) {
            this.saveImageJNLP();
        }
    }

    private void writeImageToFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        ByteArrayInputStream bais = HackHack.getByteArrayInputStream(this.image);
        byte[] buf = new byte[4096];
        int read = 0;
        while ((read = bais.read(buf)) != -1) {
            os.write(buf, 0, read);
        }
        os.flush();
        os.close();
        bais.close();
    }

    private void saveImageJNLP() throws IOException {
    }
}

