/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Stack;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.graph.LayeredDrawingThread;
import net.gcalc.plugin.plane.graph.Rect;

class ImplicitFunctionDrawingThread
extends LayeredDrawingThread {
    private boolean DEBUG = false;
    private double[][] gridVal = null;
    private CartesianGraph graph;

    ImplicitFunctionDrawingThread(CartesianGraph parent, Graphics g, ModelList m) {
        super((Component)parent, g, m);
        this.graph = parent;
    }

    protected void render(int K, Graphics buffer, RenderableModel model) {
        buffer.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        buffer.fillRect(0, 0, this.graph.getWidth(), this.graph.getHeight());
        ValueTable vt = new ValueTable();
        Function f = model.getFunction();
        Function fx = f.derivative(VariableToken.X_VAR);
        Function fy = f.derivative(VariableToken.Y_VAR);
        Function fxx = fx.derivative(VariableToken.X_VAR);
        Function fyy = fy.derivative(VariableToken.Y_VAR);
        Function fxy = fx.derivative(VariableToken.Y_VAR);
        Stack<Rect> S = new Stack<Rect>();
        int D = 5;
        int height = this.graph.getHeight();
        int width = this.graph.getWidth();
        int hx = width / D;
        int hy = height / D;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                S.add(new Rect(i, j, Math.min(i + hx, width), Math.min(j + hy, height)));
                i += hx;
            }
            j += hy;
        }
        double dx = Math.abs(this.graph.screenXtoCartesian(2) - this.graph.screenXtoCartesian(1));
        double dy = Math.abs(this.graph.screenYtoCartesian(2) - this.graph.screenYtoCartesian(1));
        double epsilon = Math.min(dx, dy);
        Point[] P = new Point[4];
        Rect R = null;
        Color color = model.getColor();
        while (!S.isEmpty()) {
            R = (Rect)S.pop();
            double hess = Math.abs(this.hessianDeterminant(fxx, fyy, fxy, vt, R));
            vt.setValue(VariableToken.X_VAR, this.graph.screenXtoCartesian(R.xmid()));
            vt.setValue(VariableToken.Y_VAR, this.graph.screenYtoCartesian(R.ymid()));
            double grad = this.gradient(fx, fy, vt);
            double w = R.w() * Math.max(dx, dy);
            if (R.w() < 20.0 && (hess / grad * w * w < epsilon || R.w() < 3.0)) {
                float rnd;
                if (this.DEBUG) {
                    rnd = (float)(Math.random() / 5.0 + 0.66);
                    buffer.setColor(new Color(rnd, rnd, rnd));
                    buffer.fillRect(R.x1, R.y1, R.x2 - R.x1, R.y2 - R.y1);
                }
                int i = 0;
                double nw = this.getFunctionValue(f, vt, R.x1, R.y1);
                double sw = this.getFunctionValue(f, vt, R.x1, R.y2);
                double ne = this.getFunctionValue(f, vt, R.x2, R.y1);
                double se = this.getFunctionValue(f, vt, R.x2, R.y2);
                if (sw == 0.0 && ne == 0.0 && se == 0.0 && nw == 0.0) {
                    buffer.setColor(color);
                    buffer.fillRect(R.x1, R.y1, R.x2 - R.x1, R.y2 - R.y1);
                    i = -1;
                }
                if (nw == 0.0 && ne == 0.0) {
                    buffer.setColor(color);
                    buffer.drawLine(R.x1, R.y1, R.x2, R.y1);
                    i = -1;
                }
                if (nw == 0.0 && sw == 0.0) {
                    buffer.setColor(color);
                    buffer.drawLine(R.x1, R.y1, R.x1, R.y2);
                    i = -1;
                }
                if (ne == 0.0 && se == 0.0) {
                    buffer.setColor(color);
                    buffer.drawLine(R.x2, R.y1, R.x2, R.y2);
                    i = -1;
                }
                if (sw == 0.0 && se == 0.0) {
                    buffer.setColor(color);
                    buffer.drawLine(R.x1, R.y2, R.x2, R.y2);
                    i = -1;
                }
                if (nw == 0.0 && se == 0.0) {
                    buffer.setColor(color);
                    buffer.drawLine(R.x1, R.y1, R.x2, R.y2);
                    i = -1;
                }
                if (sw == 0.0 && ne == 0.0) {
                    buffer.setColor(color);
                    buffer.drawLine(R.x1, R.y2, R.x2, R.y1);
                    i = -1;
                }
                if (i != -1) {
                    double val;
                    if (nw * ne <= 0.0) {
                        val = (double)R.x1 + nw / (nw - ne) * (double)(R.x2 - R.x1);
                        P[i] = new Point((int)(val + 0.5), R.y1);
                        ++i;
                    }
                    if (nw * sw <= 0.0) {
                        val = (double)R.y1 + nw / (nw - sw) * (double)(R.y2 - R.y1);
                        P[i] = new Point(R.x1, (int)(val + 0.5));
                        ++i;
                    }
                    if (ne * se <= 0.0) {
                        val = (double)R.y1 + ne / (ne - se) * (double)(R.y2 - R.y1);
                        P[i] = new Point(R.x2, (int)(val + 0.5));
                        ++i;
                    }
                    if (sw * se <= 0.0) {
                        val = (double)R.x1 + sw / (sw - se) * (double)(R.x2 - R.x1);
                        P[i] = new Point((int)(val + 0.5), R.y2);
                        ++i;
                    }
                    if (i >= 2) {
                        if (this.DEBUG) {
                            rnd = (float)(Math.random() / 5.0 + 0.8);
                            buffer.setColor(new Color(rnd, 0.77f, 0.77f));
                            buffer.fillRect(R.x1, R.y1, R.x2 - R.x1, R.y2 - R.y1);
                        }
                        buffer.setColor(color);
                        int k = 0;
                        while (k < i) {
                            int j2 = k;
                            while (j2 < i) {
                                buffer.drawLine(P[j2].x, P[j2].y, P[k].x, P[k].y);
                                ++j2;
                            }
                            ++k;
                        }
                    }
                }
                if (!this.DEBUG || i != 0) continue;
                rnd = (float)(Math.random() / 5.0 + 0.8);
                buffer.setColor(new Color(0.77f, rnd, 0.77f));
                buffer.fillRect(R.x1, R.y1, R.x2 - R.x1, R.y2 - R.y1);
                continue;
            }
            this.addToStack(S, R, R.x1, R.y1, R.xmid(), R.ymid());
            this.addToStack(S, R, R.xmid(), R.y1, R.x2, R.ymid());
            this.addToStack(S, R, R.xmid(), R.ymid(), R.x2, R.y2);
            this.addToStack(S, R, R.x1, R.ymid(), R.xmid(), R.y2);
        }
    }

    private double getFunctionValue(Function F, ValueTable vt, int x, int y) {
        if (this.gridVal == null) {
            this.gridVal = new double[this.graph.getWidth()][this.graph.getHeight()];
            int i = 0;
            while (i < this.gridVal.length) {
                int j = 0;
                while (j < this.gridVal[i].length) {
                    this.gridVal[i][j] = Double.NaN;
                    ++j;
                }
                ++i;
            }
        }
        double val = 0.0;
        if (x < 0 || y < 0 || x >= this.gridVal.length || y >= this.gridVal[x].length || Double.isNaN(this.gridVal[x][y])) {
            vt.setValue(VariableToken.X_VAR, this.graph.screenXtoCartesian(x));
            vt.setValue(VariableToken.Y_VAR, this.graph.screenYtoCartesian(y));
            val = F.evaluate(vt);
        } else {
            val = this.gridVal[x][y];
        }
        return val;
    }

    private void addToStack(Stack S, Rect R, int u1, int v1, int u2, int v2) {
        if (R.x1 != u1 || R.y1 != v1 || R.x2 != u2 || R.y2 != v2) {
            S.add(new Rect(u1, v1, u2, v2));
        }
    }

    private double hessianDeterminant(Function fxx, Function fyy, Function fxy, ValueTable vt, Rect R) {
        double x1 = this.graph.screenXtoCartesian(R.x1);
        double x2 = this.graph.screenXtoCartesian(R.x2);
        double y1 = this.graph.screenXtoCartesian(R.y1);
        double y2 = this.graph.screenXtoCartesian(R.y2);
        double M = -1.0;
        vt.setValue(VariableToken.X_VAR, x1);
        vt.setValue(VariableToken.Y_VAR, y1);
        M = Math.max(Math.abs(this.hessian(fxx, fyy, fxy, vt)), M);
        vt.setValue(VariableToken.Y_VAR, y2);
        M = Math.max(Math.abs(this.hessian(fxx, fyy, fxy, vt)), M);
        vt.setValue(VariableToken.X_VAR, x2);
        M = Math.max(Math.abs(this.hessian(fxx, fyy, fxy, vt)), M);
        vt.setValue(VariableToken.Y_VAR, y1);
        M = Math.max(Math.abs(this.hessian(fxx, fyy, fxy, vt)), M);
        vt.setValue(VariableToken.X_VAR, R.xmid());
        vt.setValue(VariableToken.Y_VAR, R.ymid());
        M = Math.max(Math.abs(this.hessian(fxx, fyy, fxy, vt)), M);
        return M;
    }

    private double hessian(Function fxx, Function fyy, Function fxy, ValueTable vt) {
        double xx = fxx.evaluate(vt);
        double yy = fyy.evaluate(vt);
        double xy = fxy.evaluate(vt);
        return xx * yy - xy * xy;
    }

    private double gradient(Function fx, Function fy, ValueTable vt) {
        double x = fx.evaluate(vt);
        double y = fy.evaluate(vt);
        return Math.sqrt(x * x + y * y);
    }

    protected void finishRun() {
        this.graph.repaint();
    }
}

