/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.properties;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.gcalc.plugin.properties.Element;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Properties
extends Observable {
    private Hashtable table;
    private Hashtable defaultTable;

    public String toString() {
        Enumeration E = this.defaultTable.keys();
        String s = "*\n";
        while (E.hasMoreElements()) {
            String key = (String)E.nextElement();
            s = String.valueOf(s) + key + "=";
            s = String.valueOf(s) + this.defaultTable.get(key) + "\n";
        }
        return String.valueOf(s) + "*";
    }

    public Properties() {
        this.table = new Hashtable();
        this.defaultTable = new Hashtable();
    }

    public Properties(String filename) {
        try {
            this.init(filename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init(String filename) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource(new InputStreamReader(cl.getResourceAsStream(filename)));
            Document doc = db.parse(is);
            System.out.println(doc);
            this.defaultTable = new Hashtable();
            this.initProperty(this.defaultTable, doc.getFirstChild());
        }
        catch (ParserConfigurationException e1) {
            System.err.println(e1);
        }
        catch (SAXException e2) {
            System.err.println(e2);
        }
        this.notifyObservers();
    }

    private Object[] initChildElements(Node node, String[] childtypes) {
        Vector<Element> vector = new Vector<Element>();
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            String s = n.getNodeName();
            if (childtypes != null) {
                int j = 0;
                while (j < childtypes.length) {
                    if (s.equals(childtypes[j])) {
                        vector.add(this.initPropertyElement(n));
                    }
                    ++j;
                }
            } else if (!s.equals("#text")) {
                vector.add(this.initPropertyElement(n));
            }
            ++i;
        }
        return vector.toArray();
    }

    private String getAttributeValue(Node node, String attr) {
        NamedNodeMap nnm = node.getAttributes();
        Node n = nnm.getNamedItem(attr);
        String name = n == null ? "" : n.getNodeValue();
        return name;
    }

    private Element initPropertyElement(Node node) {
        String name = node.getNodeName();
        System.out.println("Processing " + name);
        Element element = null;
        if (name.equals("view")) {
            element = this.initViewNode(node);
        } else if (name.equals("range")) {
            element = this.initRangeNode(node);
        } else if (name.equals("boolean")) {
            element = this.initBooleanNode(node);
        } else if (name.equals("color")) {
            element = this.initColorNode(node);
        } else if (name.equals("string")) {
            element = this.initStringNode(node);
        } else if (name.equals("dimension")) {
            element = this.initDimensionNode(node);
        } else if (name.equals("double")) {
            element = this.initDoubleNode(node);
        }
        return element;
    }

    private void initProperty(Hashtable H, Node node) {
        Object[] list = this.initChildElements(node, null);
        int i = 0;
        while (i < list.length) {
            Element e = (Element)list[i];
            H.put(e.getName(), e.getContent());
            ++i;
        }
    }

    private Element initViewNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String[] tag = new String[]{"range"};
        Object[] list = this.initChildElements(node, tag);
        Range[] ranges = new Range[list.length];
        int i = 0;
        while (i < list.length) {
            Element e = (Element)list[i];
            ranges[i] = (Range)e.getContent();
            ++i;
        }
        return new Element(name, new View(ranges));
    }

    private Element initRangeNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String[] tag = new String[]{"double"};
        Object[] list = this.initChildElements(node, tag);
        double min = 0.0;
        double max = 0.0;
        double scale = 0.0;
        int i = 0;
        while (i < list.length) {
            Element e = (Element)list[i];
            String n = e.getName();
            double val = (Double)e.getContent();
            if (n.equals("min")) {
                min = val;
            } else if (n.equals("max")) {
                max = val;
            } else if (n.equals("scale")) {
                scale = val;
            }
            ++i;
        }
        return new Element(name, new Range(min, max, scale));
    }

    private Element initBooleanNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String bool = this.getAttributeValue(node, "value");
        return new Element(name, new Boolean(bool.equals("true")));
    }

    private float tryParseFloat(String s) {
        double n = 0.0;
        try {
            n = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return (float)n;
    }

    private int tryParseInt(String s) {
        int n = 0;
        try {
            n = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private Element initColorNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String red = this.getAttributeValue(node, "red");
        String green = this.getAttributeValue(node, "green");
        String blue = this.getAttributeValue(node, "blue");
        float r = this.tryParseFloat(red);
        float g = this.tryParseFloat(green);
        float b = this.tryParseFloat(blue);
        return new Element(name, new Color(r, g, b));
    }

    private Element initStringNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String str = this.getAttributeValue(node, "value");
        return new Element(name, str);
    }

    private Element initDimensionNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String width = this.getAttributeValue(node, "width");
        String height = this.getAttributeValue(node, "height");
        int w = this.tryParseInt(width);
        int h = this.tryParseInt(height);
        return new Element(name, new Dimension(w, h));
    }

    private Element initDoubleNode(Node node) {
        String name = this.getAttributeValue(node, "name");
        String num = this.getAttributeValue(node, "value");
        if (num != null) {
            return new Element(name, new Double(Double.parseDouble(num)));
        }
        return null;
    }

    public synchronized void put(String key, Object obj) {
        this.table.put(key, obj);
        this.setChanged();
        this.notifyObservers(key);
    }

    public void initDefault(String key, boolean b) {
        this.initDefault(key, new Boolean(b));
    }

    public synchronized void initDefault(String key, Object obj) {
        this.defaultTable.put(key, obj);
    }

    public synchronized Object get(String key) {
        return this.table.get(key);
    }

    public synchronized void revertToDefault() {
        Enumeration E = this.defaultTable.keys();
        while (E.hasMoreElements()) {
            this.revertToDefault((String)E.nextElement());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void revertToDefault(String key) {
        Object obj = this.defaultTable.get(key);
        if (obj != null) {
            this.table.put(key, obj);
            this.setChanged();
            this.notifyObservers(key);
        }
    }

    public Color getColorProperty(String key) {
        return (Color)this.get(key);
    }

    public String getStringProperty(String key) {
        return (String)this.get(key);
    }

    public View getViewProperty(String key) {
        return (View)this.get(key);
    }

    public boolean getBooleanProperty(String key) {
        Object o = this.get(key);
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    public void setPropertyChanged(Object key) {
        this.setChanged();
        this.notifyObservers(key);
    }
}

