/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin;

import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.proto.plugin.Formula;
import net.gcalc.proto.plugin.FormulaField;
import net.gcalc.proto.plugin.Spreadsheet;
import net.gcalc.proto.plugin.SpreadsheetModel;

public class SpreadsheetPlugin
extends AbstractPlugin {
    private FormulaField textfield;
    private Spreadsheet sheet = new Spreadsheet();
    private Listener columnListener;
    private Listener rowListener;

    public SpreadsheetPlugin() {
        JScrollPane jsp = new JScrollPane(this.sheet, 20, 30);
        this.textfield = new FormulaField((SpreadsheetModel)this.sheet.getModel());
        this.getContentPane().add("North", this.textfield);
        this.getContentPane().add("Center", jsp);
        this.columnListener = new Listener();
        this.rowListener = new Listener();
        this.sheet.getSelectionModel().addListSelectionListener(this.rowListener);
        this.sheet.getColumnModel().getSelectionModel().addListSelectionListener(this.columnListener);
    }

    public void init() {
        this.setSize(400, 500);
        this.setResizable(true);
    }

    public String getPluginName() {
        return "Spreadsheet Plugin";
    }

    public String getCreatorName() {
        return "Jiho Kim (jiho@gcalc.net)";
    }

    public String getDescription() {
        return "<p>Spreadsheet prototype</p>";
    }

    private void changeSelection() {
        int row = this.rowListener.getIndex();
        int col = this.columnListener.getIndex();
        Object value = null;
        if (row >= 0 && col >= 0) {
            value = this.sheet.getValueAt(row, col);
            if (value != null && value instanceof Formula) {
                this.textfield.setFormula(row, col, (Formula)value);
            } else if (value != null) {
                this.textfield.setText(value.toString());
            } else {
                this.textfield.setText("");
            }
        }
    }

    class Listener
    implements ListSelectionListener {
        private int k = -1;

        Listener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            this.k = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
            SpreadsheetPlugin.this.changeSelection();
        }

        public int getIndex() {
            return this.k;
        }
    }
}

