/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.example;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JTextField;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.AbstractPlugin;

public class UnitConversionPlugin
extends AbstractPlugin {
    private JTextField input;
    private JTextField output;

    public UnitConversionPlugin() {
        this.setResizable(true);
    }

    public void init() {
        if (this.isInitialized()) {
            return;
        }
        this.input = new JTextField(12);
        this.output = new JTextField(12);
        JButton convertButton = new JButton("Convert!");
        Box mainBox = Box.createVerticalBox();
        mainBox.add(SwingGUI.wrapTitledBorder(this.input, "Fahrenheit Input"));
        mainBox.add(SwingGUI.wrapTitledBorder(this.output, "Celsius Output"));
        mainBox.add(convertButton);
        convertButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                UnitConversionPlugin.this.performConversion();
            }
        });
        this.getContentPane().add(mainBox);
        this.setTitle(this.getPluginName());
        this.pack();
        this.setInitialized(true);
    }

    protected void performConversion() {
        try {
            double x = Double.parseDouble(this.input.getText());
            this.output.setText("" + (x - 32.0) * 5.0 / 9.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCreatorName() {
        return "Jiho Kim (jiho@gcalc.net)";
    }

    public String getDescription() {
        return "<p>Converts between common units.</p>  <p>This could use a lot more development.</p>";
    }

    public String getPluginName() {
        return "Unit Converter";
    }
}

